import { commonPlanModule } from 'common/js/modules';

var app = commonPlanModule;

/**
 * filter to represent 'planEntity' as a summary. Input: PlanEntity
 *
 * Necessary fields: rpoInMinutes, numCopies, numAssocEntities
 *
 * Returns a string in this format: RPO: 4 hours | Number of copies: 1 | Associated entities: 3
 *
 */

app.filter('cvPlanSummary', [
	'cvLoc',
	function(cvLoc) {
		return function(planEntity, customConfig) {
			if (!customConfig) {
				let rpoHours = Math.floor(_.get(planEntity, 'rpoInMinutes', 0) / 60);
				let numCopies = _.get(planEntity, 'numCopies', 0);
				let numAssocEntities = _.get(planEntity, 'numAssocEntities', 0);

				const propertiesArray = _.get(planEntity, 'planSummary', '').split(',');
				_.forEach(propertiesArray, property => {
					const propertyPair = property.split(':');
					if (!planEntity[propertyPair[0]]) {
						planEntity[propertyPair[0]] = propertyPair[1];
					}
				});
				const primaryStorageType = _.get(planEntity, 'PrimaryStorageType', undefined);
				const secondaryStorageType = _.get(planEntity, 'SecondaryStorageType', undefined);

				if (planEntity.type === 'Archiver') {
					let _rpoLabel = cvLoc('label.rpo');
					let _rpoTimeLabel =
						rpoHours % 24 === 0
							? cvLoc('label.rpoSummaryDays', rpoHours / 24)
							: cvLoc('label.rpoSummaryHours', rpoHours);
					return (
						_rpoLabel +
						': ' +
						_rpoTimeLabel +
						' | ' +
						planEntity.fileTimeStamp +
						' | ' +
						cvLoc('label.archivingRules.size') +
						': ' +
						planEntity.fileSize
					);
				}

				if (rpoHours % 24 === 0) {
					if (primaryStorageType) {
						return secondaryStorageType
							? cvLoc(
									'label.planSummaryDropdownDaysSecondaryCopy',
									rpoHours / 24,
									numCopies,
									primaryStorageType,
									secondaryStorageType,
									numAssocEntities
							  )
							: cvLoc(
									'label.planSummaryDropdownDaysPrimaryCopy',
									rpoHours / 24,
									numCopies,
									primaryStorageType,
									numAssocEntities
							  );
					} else {
						return cvLoc('label.planSummaryDropdownDays', rpoHours / 24, numCopies, numAssocEntities);
					}
				} else {
					if (primaryStorageType) {
						return secondaryStorageType
							? cvLoc(
									'label.planSummaryDropdownDaysSecondaryCopy',
									rpoHours,
									numCopies,
									primaryStorageType,
									secondaryStorageType,
									numAssocEntities
							  )
							: cvLoc(
									'label.planSummaryDropdownDaysPrimaryCopy',
									rpoHours,
									numCopies,
									primaryStorageType,
									numAssocEntities
							  );
					} else {
						return cvLoc('label.planSummaryDropdown', rpoHours, numCopies, numAssocEntities);
					}
				}
			}

			return cvLoc(customConfig.locVar, planEntity[customConfig.prop]);
		};
	}
]);

export default app;
