import 'storage/js/services/storage.svc.js';
import 'dlo/js/services/profile.svc.js';

import { commonPlanModule } from 'common/js/modules';

var planMod = commonPlanModule;

planMod.factory('planFactory', [
	'cvLoc',
	'cvUtil',
	'$log',
	'profileService',
	'storageService',
	function(cvLoc, cvUtil, $log, profileService, storageService) {
		var factory = {};

		factory.getMasterProfile = function(planType, planSubType) {
			return profileService
				.getMasterProfile(planType, planSubType)
				.success(function() {
					$log.debug('getting the master profile Successful');
				})
				.error(function(data) {
					$log.error('Error while getting the  master profile');
				});
		};

		factory.getTemplateProfile = function(planType, planSubType) {
			return profileService
				.getTemplateProfile(planType, planSubType)
				.success(function() {
					$log.debug('getting the template profile Successful');
				})
				.error(function(data) {
					$log.error('Error while getting the  template profile');
				});
		};

		factory.getAllStoragePools = function() {
			return storageService
				.getAllStoragePools()
				.success(function() {
					$log.debug('getting the all storage pools Successful');
				})
				.error(function(data) {
					$log.error('Error while getting all storage pools');
				});
		};

		factory.checkPlanName = function(name) {
			return profileService
				.checkPlanName(name)
				.success(function() {
					$log.debug('validate plan name is Successful');
				})
				.error(function(data) {
					$log.error('Error while validating the plan name');
				});
		};

		/* Updating the storage copy with default values and storage policy info
		 *
		 */
		factory.updateStoragePolicy = function(storageCopy, storagePoolEntity, storagepoolType) {
			var storageObject = new Object();
			storageObject.storagePolicyId = storagePoolEntity.storagePoolId;
			storageObject.storagePolicyName = storagePoolEntity.storagePoolName;
			//Updating the storage policy info of tape storage pool
			if (storagepoolType === 'SECONDARY_COPY') {
				storageCopy.globalAuxCopy = storageObject;
				storageCopy.dedupeFlags = {
					enableDeduplication: 'SET_FALSE'
				};
				storageCopy.extendedFlags = {
					useGlobalAuxCopyPolicy: 'SET_TRUE'
				};
			} else {
				storageCopy.useGlobalPolicy = storageObject;
				if (storageCopy.dedupeFlags) {
					storageCopy.dedupeFlags.useGlobalDedupStore = 1; // Updating the flag.
				} else {
					var dedupeFlags = {
						enableClientSideDedup: 1,
						enableDASHFull: 1,
						enableDeduplication: 1,
						useGlobalDedupStore: 1
					};
					storageCopy.dedupeFlags = dedupeFlags; // Updating the flag.
				}
			}
			return storageCopy;
		};

		//Utility method to validate the storage policy
		factory.isStorageValide = function(storageEntity) {
			if (
				storageEntity === null ||
				storageEntity === undefined ||
				storageEntity.storagePoolEntity === null ||
				storageEntity.storagePoolEntity === undefined ||
				storageEntity.storagePoolEntity.storagePoolId == undefined ||
				storageEntity.storagePoolEntity.storagePoolId == null ||
				storageEntity.storagePoolEntity.storagePoolId == ''
			) {
				return false;
			}
			return true;
		};

		//Utility method to validate the retention days
		factory.isRetentionDaysValide = function(retentionDays) {
			if (retentionDays === undefined || retentionDays > 9999) {
				return false;
			}
			return true;
		};

		/*
   * Creating the plan with planInfo object data.
   * /*return profileService.createPlan({
  		'planInfo' : JSON.stringify(planInfo)
  	}
   */
		factory.createPlan = function(planInfo) {
			//return null;
			return profileService
				.createVsaProfile(planInfo)
				.success(function() {
					$log.debug('create plan Successful');
				})
				.error(function(data) {
					$log.error('Error while creating the plan');
				});
		};

		return factory;
	}
]);

export default planMod;
