//import "vsa/js/directives/cv-amazon-buckets.js"
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'storage/js/services/storage.svc.js';
import 'dlo/js/services/profile.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/directives/cv-select-proxy-directive.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/factories/collections.factory.js';
import 'vsa/js/controllers/restoreOptions.ctrl.js';
import 'vsa/js/controllers/collections.ctrl.js';
import 'vsa/js/services/regions.svc.js';
import 'vsa/js/factories/regions.factory.js';
import 'vsa/js/factories/replicationGroups.factory.js';
import 'modules/plan/js/factory/storageRuleModel.factory.js';
import 'modules/plan/js/factory/storageCopy.factory.js';
import 'modules/plan/js/factory/planRule.factory.js';
import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'modules/plan/js/directives/cv-plan-storage-copies.js';
import 'modules/disasterRecovery/repGrp/js/controllers/repGrpParent.ctrl.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';
import 'webScale/js/constants/storagePool.constant.js';
import 'vsa/js/constants/servers.constants.js';
import 'modules/servers/js/services/servers.svc.js';
import 'adminConsole/js/directives/cv-replication-frequency-directive.js';
import * as getStorageCopyColumnTemplate from '../columnTemplates/storageCopy.column.template.js';

import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.directive('cvStorageScheduleComponent', [
	function() {
		return {
			replace: true,
			transclude: true,
			restrict: 'EA',
			scope: {
				title: '@',
				type: '@',
				model: '='
			},
			templateUrl: appUtil.appRoot + 'modules/plan/partials/storageScheduleTemplate.jsp',
			controller: [
				'$scope',
				'cvUtil',
				'storageService',
				'scheduleUIFactory',
				'SCHEDULE_PROPERTY',
				'$rootScope',
				function($scope, cvUtil, storageService, scheduleUIFactory, SCHEDULE_PROPERTY, $rootScope) {
					$scope.storagePools = [];
					$scope.secondaryStoragePools = [];
					$scope.auxCopySchedule = [];
					$scope.enableSecondaryStorage = cvConfig.showSecondaryStorage;
					$scope.slaFlag = SCHEDULE_PROPERTY.SLA_FLAG;

					$scope.changeSecondaryStorageList = function(storagePool) {
						$scope.secondaryStoragePools = [];
						if (storagePool) {
							for (var i = 0; i < $scope.allStoragePools.length; i++) {
								if (
									storagePool.storagePoolEntity.storagePoolId !==
									$scope.allStoragePools[i].storagePoolEntity.storagePoolId
								) {
									$scope.secondaryStoragePools.push($scope.allStoragePools[i]);
								}
							}
						} else {
							$scope.secondaryStoragePools = $scope.allStoragePools;
						}
					};

					$scope.removeStorage = function() {
						$scope.model.showSecondaryStorage = false;
					};

					$scope.handleAuxCopySchedule = function(enableSecondaryStorage) {
						$scope.model.showSecondaryStorage = !enableSecondaryStorage;
						if ($scope.model.showSecondaryStorage && $scope.model.auxCopySchedule) {
							$scope.model.addedSchedules = $scope.model.addedSchedules.concat($scope.model.auxCopySchedule);
						} else {
							var addedSchedules = angular.copy($scope.model.addedSchedules);
							$scope.addedSchedules = [];
							for (var i = 0; i < addedSchedules.length; i++) {
								if (addedSchedules[i].operationType == 'BACKUP') {
									$scope.addedSchedules.push(addedSchedules[i]);
								}
							}
							$scope.model.addedSchedules = $scope.addedSchedules;
						}
					};

					var addScheduleEmitOn = 'scheduleAdded' + $scope.model.type;
					$scope.addSchedule = function() {
						scheduleUIFactory.addNewSchedule(null, $scope.model.planSubType, addScheduleEmitOn);
					};

					//Adding the new schedule to the list
					var scheduleAddedListener = $rootScope.$on(addScheduleEmitOn, function(evt, addedSchedule) {
						addedSchedule.id = Date.now() + $scope.model.type;
						addedSchedule.repeat = {
							enabled: addedSchedule.repeatEnabled,
							duration: addedSchedule.repeatDuration,
							hrs: addedSchedule.repeatHrs,
							mins: addedSchedule.repeatMins,
							time: addedSchedule.repeatTime
						};

						$scope.model.addedSchedules.push(addedSchedule);
					});

					var editScheduleEmitOn = 'scheduleEdited' + $scope.model.type;
					$scope.editSchedule = function(obj) {
						var hideDelete = false;
						if (obj.isLogSla) {
							obj.slaTime = $scope.model.slaTime;
							hideDelete = true;
						} else if (obj.flags == $scope.slaFlag) {
							obj.rpo = $scope.model.rpo;
							if ($scope.model.addedSchedules.length < 2) {
								hideDelete = true;
							}
						}
						obj.hideDelete = hideDelete;
						obj.scheduleType = $scope.model.type;
						scheduleUIFactory.addNewSchedule(obj, $scope.model.planSubType, editScheduleEmitOn);
					};
					var scheduleEditedListener = $rootScope.$on(editScheduleEmitOn, function(evt, addedSchedule) {
						var idToEdit = addedSchedule.id;
						for (var i = 0; i < $scope.model.addedSchedules.length; i++) {
							if ($scope.model.addedSchedules[i].id == idToEdit) {
								$scope.model.addedSchedules.splice(i, 1);
								$scope.model.addedSchedules.push(addedSchedule);
								return;
							}
						}
						$scope.model.addedSchedules.push(addedSchedule);
					});

					var scheduleDeleted = 'scheduleDeleted' + $scope.model.type;
					var scheduleDeletedListener = $rootScope.$on(scheduleDeleted, function(evt, addedSchedule) {
						var idToEdit = addedSchedule.id;
						for (var i = 0; i < $scope.model.addedSchedules.length; i++) {
							if ($scope.model.addedSchedules[i].id == idToEdit) {
								$scope.model.addedSchedules.splice(i, 1);
								continue;
							}
						}
						//For the data SLA we are allowing deletion of the schedule, then next schedule will be SLA schedule.
						if (addedSchedule.flags == $scope.slaFlag) {
							var scheduleObj = scheduleUIFactory.getNextSLASchedule($scope.model.addedSchedules);
							scheduleObj.schedule.flags = $scope.slaFlag;
							scheduleObj.schedule.sla = scheduleObj.slaInHours; // for one week.
							$scope.model.sla = scheduleObj.slaInHours; // for one week.
						}
					});

					$scope.$on('$destroy', function() {
						scheduleAddedListener();
						scheduleDeletedListener();
						scheduleEditedListener();
					});

					//storage pools
					$scope.storagePools = [];
					$scope.secondaryStoragePools = [];
					$scope.allStoragePools = [];
					storageService
						.getAllStoragePools()
						.success(function(data) {
							if (data.length) {
								$scope.serverMessage = cvUtil.emptyMsg();
							} else {
								$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageFound');
							}

							$scope.allStoragePools = cvUtil.sortAscending(data, 'storagePoolEntity.storagePoolName');
							$scope.allStoragePools.map(function(storagePool) {
								if (storagePool.storagePoolType != 'SECONDARY_COPY') {
									$scope.storagePools.push(storagePool);
								}
							});

							$scope.model.primaryStorage = $scope.storagePools[0];

							if ($scope.allStoragePools.length > 0) {
								$scope.secondaryStoragePools = angular.copy($scope.allStoragePools);
								for (var i = 0; i < $scope.secondaryStoragePools.length; i++) {
									if (
										$scope.model.primaryStorage.storagePoolEntity.storagePoolId ==
										$scope.secondaryStoragePools[i].storagePoolEntity.storagePoolId
									) {
										$scope.secondaryStoragePools.splice(i, 1);
									}
								}
							}
						})
						.error(function(e) {
							$scope.serverMessage = cvUtil.errMsg(e);
						});
				}
			]
		};
	}
]);

planModule.directive('cvVsaPlanStorageComponent', [
	function() {
		return {
			restrict: 'E',
			require: 'ngModel',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/vsaPlanStorageTemplate.jsp',
			scope: {
				ngModel: '=',
				initModel: '=',
				storages: '=',
				ctrl: '=',
				availableStoragePools: '=',
				allStoragePools: '=?',
				showSource: '=',
				planSubType: '=',
				isSnapshotCopy: '=',
				onInit: '=',
				storagePolicyId: '=',
				snapVendorsInfo: '=',
				parentServerMessage: '=',
				isDefaultVaultReplica: '='
			},
			controller: [
				'$scope',
				'$rootScope',
				'$state',
				'$uibModal',
				'$log',
				'storageService',
				'scheduleUIFactory',
				'snapArrayService',
				'cvUtil',
				'cvLoc',
				'storagePolicyService',
				'storageCopyFactory',
				'$timeout',
				'planRuleFactory',
				'$dialogs',
				function(
					$scope,
					$rootScope,
					$state,
					$modal,
					$log,
					storageService,
					scheduleUIFactory,
					snapArrayService,
					cvUtil,
					cvLoc,
					storagePolicyService,
					storageCopyFactory,
					$timeout,
					planRuleFactory,
					$dialogs
				) {
					$scope.storagePools = [];
					const NET_APP_VENDOR = storageCopyFactory.getNetAppVendor();
					const AMAZON_VENDOR = storageCopyFactory.getAmazonVendor();
					const NONE_VENDOR = storageCopyFactory.getNoVendor();
					const vendorLabelMap = storageCopyFactory.getVendorLabelMap();

					let defaultVendor = NET_APP_VENDOR.id;
					$scope.originalStorageList = [];

					if ($scope.storages) {
						$scope.originalStorageList = angular.copy($scope.storages);
						$scope.originalStorageList = _.filter($scope.originalStorageList, function(storage) {
							return storage.isSnapCopy === undefined || storage.isSnapCopy === 'SET_FALSE';
						});
					}

					$scope.getVendorLabel = vendor => {
						return vendorLabelMap[vendor];
					};

					$scope.updateVendorLabel = () => {
						$timeout(function() {
							let vendor = 'NONE';
							if ($scope.model.svmMapping.length) {
								if ($scope.currentCopyDefaultVaultReplica === true) {
									let hasNetApp =
										_.filter($scope.model.svmMapping, mapping => mapping.vendorType === 'NetApp').length > 0;
									let hasAmazon =
										_.filter($scope.model.svmMapping, mapping => mapping.vendorType === 'Amazon').length > 0;
									if (hasNetApp && hasAmazon) {
										vendor = 'MIXED';
									} else if (hasNetApp) {
										vendor = 'NETAPP';
									} else if (hasAmazon) {
										vendor = 'AMAZON';
									}
								} else {
									vendor = 'NETAPP';
								}
							}
							$scope.vendorLabel = $scope.getVendorLabel(vendor);
						}, 100);
					};

					$scope.getCopyTypeLabel = copyType => {
						if (copyType === 1) {
							return cvLoc('label.mirrorCopy');
						} else {
							return cvLoc('label.vaultCopy');
						}
					};

					$scope.model = {
						retentionPeriod: $scope.planSubType === 'Archiver' ? -1 : 30,
						source: $scope.storages.length ? $scope.storages[0].name : '',
						isSnapshotCopy: $scope.isSnapshotCopy,
						enableExtendedRetention: false,
						infiniteSelected: $scope.planSubType === 'Archiver',
						extendedErrors: {
							hasRetError: false,
							retentionError: ['', '', ''],
							hasTypError: false,
							typeError: ['', '', ''],
							hasMainRetError: false,
							hasMaxRetentionError: false,
							emptyError: ['', '', '']
						},
						svmMapping: [],
						selectedVendor: defaultVendor,
						deletedRegions: [],
						snapCopyType: 0,
						retentionMode: 'NON_JOBS',
						showRadioBtns: false,
						noOfSnapRecoveryPoints: 8,
						enableBackupsOnAndAfter: false
					};

					$scope.vendorLabel = 'Generic';
					$scope.localLang = cvUtil.getIStevenLocLabels();

					$scope.minRetentionPeriod = 1;
					$scope.retentionPeriodOptions = angular.copy(storageCopyFactory.retentionPeriodOptions);
					$scope.extendedRetentionCount = 0;

					let selectiveFreqs = storageCopyFactory.generalFreqs('SELECTIVE');
					let syncronousCopy = [
						{
							label: 'All Jobs',
							value: 'SYNCRONOUS'
						}
					];

					$scope.selectiveFreqs = _.concat(syncronousCopy, selectiveFreqs);
					$scope.extendedFreqs = storageCopyFactory.generalFreqs('EXTENDED');

					$scope.getAppropriateVendorInfo = function() {
						return $scope.snapVendorsInfo.svmMap[$scope.model.selectedVendor];
					};

					$scope.getAppropriateSVMList = function() {
						return $scope.getAppropriateVendorInfo()['svmList'];
					};

					$scope._onSVMGridDataBound = function(dataItem, row) {
						const svmPairDeleteAction = row.find('.k-grid-delete-svm-pair');
						svmPairDeleteAction.click(function() {
							deleteSVMMapping(dataItem);
						});
					};

					function setValueForVendor() {
						$scope.model.selectedVendor = NET_APP_VENDOR.id;
					}

					$scope.copyTypeChanged = function(value) {
						$scope.currentCopyDefaultVaultReplica = !$scope.isDefaultVaultReplica && value === 0;
						setValueForVendor();
						$scope.model.svmMapping = [];
						$scope.updateVendorLabel();
						$scope.updateSVMGrid();
					};

					$scope.setupSVMGridOptions = () => {
						let gridOptions = storageCopyFactory._setupMappingGridOptions({
							scope: $scope,
							currentCopyDefaultVaultReplica: $scope.currentCopyDefaultVaultReplica,
							deleteClass: 'k-grid-delete-svm-pair',
							fetchMappings: getSVMData,
							gridDataBound: $scope._onSVMGridDataBound,
							tableName: 'svmTable',
							vendorInfo: $scope.getAppropriateVendorInfo()
						});

						return {
							...gridOptions,
							gridToolbarMenu: [
								{
									id: 'AddSVMMapping',
									label: cvLoc('label.add'),
									onSelect: addSVMMapping.bind(this)
								}
							]
						};
					};

					function AddNetAppMapping(copyDetails, addVendorType) {
						_.get(copyDetails, 'replPairList', []).forEach(function(array) {
							let curElem = {
								srcArray: {
									id: _.get(array, 'srcArray.id'),
									name: _.get(array, 'srcArray.name', '')
								},
								tgtArray: {
									id: _.get(array, 'tgtArray.id'),
									name: _.get(array, 'tgtArray.name')
								}
							};

							if (addVendorType) {
								curElem.vendorType = 'NetApp';
							}

							$scope.model.svmMapping.push(curElem);
						});
					}

					function AddAmazonMapping(copyDetails, addVendorType) {
						_.get(copyDetails, 'regionMap', []).forEach(function(array) {
							let curElem = {
								srcArray: {
									name: _.get(array, 'sourceRegion', '')
								},
								tgtArray: {
									name: _.get(array, 'destinationRegion', '')
								}
							};

							if (addVendorType) {
								curElem.vendorType = 'Amazon';
							}
							$scope.model.svmMapping.push(curElem);
						});
					}

					$scope.populateSVMMappingsAndVendorInfo = function(copyDetails) {
						if (copyDetails) {
							if ($scope.currentCopyDefaultVaultReplica) {
								if (copyDetails.replPairList) {
									AddNetAppMapping(copyDetails, true);
								}

								if (copyDetails.regionMap && copyDetails.regionMap.length) {
									AddAmazonMapping(copyDetails, true);
								}
							} else {
								if (copyDetails.replPairList) {
									AddNetAppMapping(copyDetails);
								} else if (copyDetails.regionMap && copyDetails.regionMap.length) {
									$scope.model.selectedVendor = AMAZON_VENDOR.id;
									AddAmazonMapping(copyDetails);
								}
							}
						}
					};

					$scope.vendorTypeChanged = () => {
						if ($scope.model.selectedVendor === NONE_VENDOR.id) {
							var callBackFunctions = {
								noFunction: function() {
									$scope.model.selectedVendor = NET_APP_VENDOR.id;
								},
								yesFunction: function() {
									$scope.noneSelected = true;
									$scope.model.svmMapping = [];
									$scope.updateSVMGrid();
								}
							};
							$dialogs.confirm(cvLoc('heading.warning'), cvLoc('warn.removeMapping'), callBackFunctions);
						} else {
							if ($scope.noneSelected == true) {
								$scope.updateSVMGrid();
								$scope.noneSelected = false;
							}
						}
					};

					$scope.updateSVMGrid = () => {
						$scope.isSVMGridReinitialized = false;
						$timeout(function() {
							if ($scope.currentCopyDefaultVaultReplica === false) {
								if ($scope.model.selectedVendor === NET_APP_VENDOR.id) {
									$scope.model.deletedRegions = angular.copy($scope.model.svmMapping);
								} else {
									$scope.model.deletedRegions = [];
									$scope.model.snapCopyType = 0;
								}
								$scope.model.svmMapping = [];
							}
							$scope.svmGridOptions = $scope.setupSVMGridOptions();
							$scope.isSVMGridReinitialized = true;
						}, 100);
					};

					$scope.initializeSVMGrid = () => {
						if ($scope.snapVendorsInfo) {
							$scope.updateVendorLabel();
							$scope.svmGridOptions = $scope.setupSVMGridOptions();
							$scope.isSVMGridReinitialized = true;
						}
					};

					$scope.backupsToCopyChanged = function() {
						let prevVal = $scope.model.selectiveCopy;
						if ($scope.model.selectedSelectiveFreq === 'SYNCRONOUS') {
							$scope.model.selectiveCopy = false;
						} else {
							$scope.model.selectiveCopy = true;
							$scope.model.enableBackupsOnAndAfter = true;
						}

						if (prevVal !== $scope.model.selectiveCopy) {
							updateSourceCopyDropDown(true);
						}
					};

					$scope.model.selectedSelectiveFreq = $scope.selectiveFreqs[0].value;

					$scope.unitTypes = angular.copy(storageCopyFactory.getUnitTypes());

					$scope.retentionInfo =
						$scope.planSubType === 'Archiver'
							? {
									type: $scope.unitTypes[4].type,
									value: -1
							  }
							: {
									type: $scope.unitTypes[2].type,
									value: 1
							  };

					const unitsArr = storageCopyFactory.getUnitsArr();

					const maxRetentionErrorMap = {
						DAYS: cvLoc('error.maxRetentionError'),
						WEEKS: cvLoc('error.maxRetentionWeeksError'),
						MONTHS: cvLoc('error.maxRetentionMonthsError'),
						YEARS: cvLoc('error.maxRetentionYearsError')
					};

					$scope.model.extendedRetention = [];
					$scope.elemInfinite = false;

					$scope.toggleEnableExtendedRetentionRules = function() {
						$scope.model.enableExtendedRetention = !$scope.model.enableExtendedRetention;

						if (
							$scope.model.enableExtendedRetention &&
							(!$scope.model.extendedRetention || $scope.model.extendedRetention.length == 0)
						) {
							$scope.AddExtended('EXTENDED_WEEK');
							//						$scope.AddExtended("EXTENDED_MONTH");
							//						$scope.AddExtended("EXTENDED_YEAR");
						}
					};

					$scope.getAppropriateMaxError = function() {
						return maxRetentionErrorMap[$scope.retentionInfo.type];
					};

					$scope.retentionModeChanged = () => {
						if ($scope.model.retentionMode === 'JOBS') {
							$scope.model.extendedErrors.hasMainRetError = false;
						} else {
							$scope.changePolicyRetention();
						}
					};

					$scope.changePolicyRetention = () => {
						$scope.model.extendedErrors.hasMainRetError = false;
						$scope.model.extendedErrors.hasMaxRetentionError = false;

						if ($scope.model.retentionMode === 'NON_JOBS') {
							let retentionInfo = $scope.retentionInfo;

							if (retentionInfo.type === 'INFINITE') {
								$scope.model.infiniteSelected = true;
							} else {
								$scope.model.infiniteSelected = false;
								$scope.model.retentionPeriod = storageCopyFactory.getRetentionPeriodInDays(
									retentionInfo.type,
									retentionInfo.value
								);

								if ((retentionInfo.value == undefined || $scope.model.retentionPeriod > 9999) && !$scope.repGrp) {
									$scope.model.extendedErrors.hasMaxRetentionError = true;
									return;
								}

								if (retentionInfo.value === 0 && $scope.isSnapPrimary) {
									//if retention is 0 days , then clear extended retention rules.
									$scope.model.enableExtendedRetention = false;
								}

								$scope.model.extendedRetention.forEach(elem => {
									if (
										$scope.model.retentionPeriod >=
											storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.retention) &&
										!elem.isInfinite
									) {
										$scope.model.extendedErrors.hasMainRetError = true;
									}
								});
							}
						}
					};

					$scope.changeRetentionUnit = (index, ret) => {
						let isInfinite = false;
						if (ret.unitType === 'INFINITE') {
							isInfinite = true;
						}
						$scope.model.extendedRetention[index].isInfinite = isInfinite;
						$scope.changeRetention(index, ret.retention);
						$scope.changeRetInfinite(index);
					};

					$scope.changeRetention = (index, value) => {
						$scope.model.extendedRetention[index].retention = value;
						$scope.model.extendedRetention[index].result.endDays = value;
						$scope.checkRetentionValues(index, $scope.model.extendedRetention);
					};

					$scope.removeRetention = index => {
						if (index === $scope.extendedRetentionCount - 1) {
							$scope.model.extendedRetention.splice(index);
						}
						$scope.extendedRetentionCount = $scope.model.extendedRetention.filter(item => !item.isHide).length;
						$scope.model.extendedRetention.forEach((retention, index) => {
							$scope.checkRetentionValues(index, $scope.model.extendedRetention);
							$scope.checkRetentionType(index, $scope.model.extendedRetention);
						});
					};

					$scope.AddExtended = ruleName => {
						const lengthValue = $scope.model.extendedRetention.length;
						let days = 90;

						$scope.extendedRetentionCount = $scope.model.extendedRetention.filter(item => !item.isHide).length;

						if ($scope.extendedRetentionCount == 0) {
							$scope.model.extendedRetention = [];
						}

						if (lengthValue === 1) {
							days = 365;
							ruleName = 'EXTENDED_MONTH';
						} else if (lengthValue === 2) {
							days = 1825;
							ruleName = 'EXTENDED_YEAR';
						}

						let isInfinite = false;
						const unitInfo = storageCopyFactory.getAppropriateUnitType(days, isInfinite);
						const obj = {
							isInfinite: isInfinite,
							selected: '',
							retention: unitInfo.qty,
							isEnabled: true,
							isHide: false,
							label: '',
							result: {
								isEnabled: 1,
								endDays: unitInfo.qty,
								graceDays: unitInfo.qty,
								everyXHours: '',
								rule: ruleName ? ruleName : ''
							},
							selected: ruleName ? ruleName : '',
							unitType: unitInfo.type
						};
						$scope.model.extendedRetention.push(obj);
						$scope.extendedRetentionCount = $scope.model.extendedRetention.filter(item => !item.isHide).length;
						$scope.model.extendedErrors.emptyError[lengthValue] = '';
						$scope.checkRetentionType(lengthValue, $scope.model.extendedRetention);
						$scope.checkRetentionValues(lengthValue, $scope.model.extendedRetention);
					};

					$scope.checkMainRetentionValue = () => {
						let retentionInDays;
						if ($scope.model.retentionMode === 'NON_JOBS') {
							$scope.model.extendedErrors.hasMainRetError = $scope.model.retentionPeriod >= retentionInDays;

							_.forEach($scope.model.extendedRetention, function(elem) {
								retentionInDays = storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.retention);
								$scope.model.extendedErrors.hasMainRetError = $scope.model.retentionPeriod >= retentionInDays;

								if ($scope.model.extendedErrors.hasMainRetError) {
									return false;
								}
							});
						}
					};

					$scope.checkRetentionValues = (index, array) => {
						var retentionInDays = storageCopyFactory.getRetentionPeriodInDays(
							array[index].unitType,
							array[index].retention
						);

						if ($scope.model.retentionMode === 'NON_JOBS') {
							$scope.model.extendedErrors.hasMainRetError = $scope.model.retentionPeriod >= retentionInDays;
						}

						$scope.model.extendedErrors.hasRetError = false;
						$scope.model.extendedErrors.retentionError = ['', '', ''];
						array.forEach((elem, i) => {
							if (
								i < index &&
								storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.retention) >= retentionInDays &&
								!elem.isInfinite
							) {
								$scope.model.extendedErrors.hasRetError = true;
								$scope.model.extendedErrors.retentionError[i] = cvLoc('error.retentionLowerError');
							} else if (
								i > index &&
								storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.retention) <= retentionInDays &&
								!elem.isInfinite
							) {
								$scope.model.extendedErrors.hasRetError = true;
								$scope.model.extendedErrors.retentionError[i] = cvLoc('error.retentionGreaterError');
							}
						});

						$scope.checkMainRetentionValue();
					};

					$scope.changeSelection = (index, result) => {
						const elem = $scope.extendedFreqs.find(ex => ex.value === result);
						$scope.model.extendedRetention[index].selected = result;
						$scope.model.extendedRetention[index].label = cvLoc('label.days') + ' ' + elem.label;
						$scope.model.extendedRetention[index].result.rule = result;
						$scope.model.extendedErrors.emptyError[index] = '';
						$scope.checkRetentionType(index, $scope.model.extendedRetention);
					};

					$scope.checkRetentionType = (index, array) => {
						$scope.model.extendedErrors.hasTypError = false;
						$scope.model.extendedErrors.typeError = ['', '', ''];

						const index1 = $scope.extendedFreqs.findIndex(elem => elem.value === array[index].result.rule);
						let index2;
						array.forEach((elem, i) => {
							index2 = $scope.extendedFreqs.findIndex(elem2 => elem2.value === elem.result.rule);
							if (i < index && index2 >= index1 && index2 !== -1) {
								$scope.model.extendedErrors.hasTypError = true;
								$scope.model.extendedErrors.typeError[i] = cvLoc('error.retentionTypeLowerError');
							} else if (i > index && index2 <= index1 && index2 !== -1) {
								$scope.model.extendedErrors.hasTypError = true;
								$scope.model.extendedErrors.typeError[i] = cvLoc('error.retentionTypeGreaterError');
							}
						});
					};

					$scope.changeRetInfinite = index => {
						if ($scope.model.extendedRetention[index].isEnabled) {
							$scope.model.extendedRetention[index].result.endDays = $scope.model.extendedRetention[index].isInfinite
								? -1
								: $scope.model.extendedRetention[index].retention;
							$scope.checkDisabled(index, $scope.model.extendedRetention);
						}
					};

					$scope.checkDisabled = (index, array) => {
						let isInfinite = array[index].isInfinite;
						$scope.elemInfinite = isInfinite;
						array.forEach((elem, i) => {
							if (i > index) {
								elem.isEnabled = !isInfinite;
								elem.result.isEnabled = isInfinite ? 0 : 1;
								if (!isInfinite) {
									isInfinite = elem.isInfinite;
								}
								if (!$scope.elemInfinite && isInfinite) {
									$scope.elemInfinite = isInfinite;
								}
							}
						});
					};

					$scope.changeDate = date => {
						$scope.model.datepicker.value = date;
						$scope.model.datepicker.value.setHours(0, 0, 0, 0);
					};

					function setNewDateCVStandard() {
						var d = new Date();
						d.setHours(0, 0, 0, 0);
						return d;
					}

					$scope.openDateModal = () => {
						$scope.model.datepicker.open = !$scope.model.datepicker.open;
					};

					$scope.fetchCopyDetails = function(storagePoolResp) {
						if ($scope.initModel) {
							if (
								($scope.initModel.isDerivePlanReq === undefined || !$scope.initModel.isDerivePlanReq) &&
								$scope.initModel.copyId &&
								$scope.initModel.storagePolicyId
							) {
								storagePolicyService
									.getStoragePolicyCopyDetails($scope.initModel.storagePolicyId, $scope.initModel.copyId)
									.then(
										function(data) {
											if (data && data.status === 200 && data.data && data.data.copy) {
												data = data.data.copy;
												$scope.initModel = {
													...$scope.initModel,
													copyId: data.StoragePolicyCopy.copyId,
													copyName: data.StoragePolicyCopy.copyName,
													retentionPeriod: data.retentionRules.retainBackupDataForDays,
													source: data.sourceCopy ? data.sourceCopy.copyName : '',
													infiniteSelected: data.retentionRules.retainBackupDataForDays === -1 ? true : false,
													overrideRetention: data.extendedFlags.overRideGACPRetention === 1 ? true : false,
													isDefault: data.isDefault,
													copyType: data.copyType,
													retentionRules: data.retentionRules,
													selectiveCopyRules: data.selectiveCopyRules,
													startTime: data.startTime,
													editMode: $scope.initModel.editMode,
													isPrimary: data.isDefault === 1 ? true : false
												};

												if (data.storagePool) {
													$scope.initModel.storagePool = {
														...$scope.initModel.storagePool,
														storagePoolEntity: {
															storagePoolId: data.storagePool.storagePoolId,
															storagePoolName: data.storagePool.storagePoolName
														}
													};
												}

												if (angular.isFunction($scope.onInit)) {
													$scope.onInit(data);
												}

												if ($scope.isSnapshotCopy) {
													if (
														data.retentionRules &&
														data.retentionRules.retentionFlags &&
														data.retentionRules.retentionFlags.jobBasedRetention &&
														(data.retentionRules.retentionFlags.jobBasedRetention === 'SET_TRUE' ||
															data.retentionRules.retentionFlags.jobBasedRetention === 1) &&
														data.retentionRules.jobs &&
														data.retentionRules.jobs > 0
													) {
														$scope.model.retentionMode = 'JOBS';
														$scope.model.noOfSnapRecoveryPoints = data.retentionRules.jobs;
													} else {
														$scope.model.retentionMode = 'NON_JOBS';
														$scope.model.noOfSnapRecoveryPoints = 8;
													}

													$scope.model.snapCopyType = planRuleFactory.isMirror(data) ? 1 : 0;

													$scope.isSVMGridReinitialized = false;
													$scope.currentCopyDefaultVaultReplica =
														$scope.model.snapCopyType !== 1 && planRuleFactory.isDefaultVaultReplica(data);

													if (data.replPairList && data.replPairList.length) {
														$scope.model.selectedVendor = NET_APP_VENDOR.id;
													} else if (data.regionMap && data.regionMap.length) {
														$scope.model.selectedVendor = AMAZON_VENDOR.id;
													} else {
														$scope.model.selectedVendor = NONE_VENDOR.id;
														$scope.noneSelected = true;
													}

													$timeout(function() {
														$scope.populateSVMMappingsAndVendorInfo(data);
														$scope.initializeSVMGrid();
													}, 100);
												}

												$scope.initialize(storagePoolResp);
											}
										},
										function() {
											$scope.serverMessage = cvUtil.errMsgLoc('error.storageCopyDetailsFailure');
										}
									);
							} else {
								if ($scope.isSnapshotCopy) {
									if (
										$scope.initModel.retentionRules &&
										$scope.initModel.retentionRules.retentionFlags &&
										$scope.initModel.retentionRules.retentionFlags.jobBasedRetention &&
										($scope.initModel.retentionRules.retentionFlags.jobBasedRetention === 'SET_TRUE' ||
											$scope.initModel.retentionRules.retentionFlags.jobBasedRetention === 1) &&
										$scope.initModel.retentionRules.jobs &&
										$scope.initModel.retentionRules.jobs > 0
									) {
										$scope.model.retentionMode = 'JOBS';
										$scope.model.noOfSnapRecoveryPoints = $scope.initModel.retentionRules.jobs;
									} else {
										$scope.model.retentionMode = 'NON_JOBS';
										$scope.model.noOfSnapRecoveryPoints = 8;
									}

									$scope.model.snapCopyType = $scope.initModel.snapCopyType;

									$scope.isSVMGridReinitialized = false;
									$scope.currentCopyDefaultVaultReplica = $scope.initModel.currentCopyDefaultVaultReplica;

									if ($scope.initModel.replPairList && $scope.initModel.replPairList.length) {
										$scope.model.selectedVendor = NET_APP_VENDOR.id;
									} else if ($scope.initModel.regionMap && $scope.initModel.regionMap.length) {
										$scope.model.selectedVendor = AMAZON_VENDOR.id;
									} else {
										$scope.model.selectedVendor = NONE_VENDOR.id;
										$scope.noneSelected = true;
									}

									$timeout(function() {
										$scope.populateSVMMappingsAndVendorInfo($scope.initModel);
										$scope.initializeSVMGrid();
									}, 100);
								}

								$scope.initialize(storagePoolResp);
							}
						} else {
							$scope.initializeDatePicker();
							/*
							 * If this is a add snapshot copy and if there is no snap primary, the current
							 * copy being added will be a snap primary
							 */
							$scope.currentCopyDefaultVaultReplica = !$scope.isDefaultVaultReplica && $scope.model.snapCopyType === 0;

							if ($scope.isSnapshotCopy) {
								$scope.initializeSVMGrid();
							}

							$scope.model.selectedVendor = NET_APP_VENDOR.id;
							$scope.isSnapPrimary =
								$scope.isSnapshotCopy && _.filter($scope.storages, storage => storage.isSnapPrimary).length == 0;
							$scope.model.storageName = $scope.storages.length === 0 ? 'Primary' : '';
							if ($state.current.name === 'replicationGroupsDetailConfiguration') {
								$scope.repGrp = true;
								$scope.model.retentionPeriod = 14;
							}

							updateSourceCopyDropDown(true);
						}
					};

					$scope.initializeDatePicker = () => {
						let val = setNewDateCVStandard();
						if ($scope.initModel && $scope.initModel.startTime && $scope.initModel.startTime.time) {
							if ($scope.initModel.startTime.time !== -1) {
								val = new Date($scope.initModel.startTime.time * 1000);
								$scope.model.enableBackupsOnAndAfter = true;
							} else {
								$scope.model.enableBackupsOnAndAfter = false;
							}
						}

						$scope.model.datepicker = {
							open: false,
							dateOptions: {
								dateFormat: 'YYYY-MM-DD',
								showWeeks: false
							},
							value: val
						};
					};

					$scope.initialize = function(storagePoolResp) {
						$scope.model.storageName = $scope.initModel.copyName;
						$scope.model.copyId = $scope.initModel.copyId;

						$scope.model.infiniteSelected = $scope.initModel.infiniteSelected;
						$scope.model.retentionPeriod = $scope.initModel.infiniteSelected
							? 30
							: $scope.initModel.retentionPeriod != undefined
							? $scope.initModel.retentionPeriod
							: 30;
						let unitInfo = storageCopyFactory.getAppropriateUnitType(
							$scope.model.retentionPeriod,
							$scope.model.infiniteSelected
						);

						if (_.get($scope.initModel, 'optimizeForInstantClone', undefined) !== undefined && $scope.isPrimaryCopy()) {
							$scope.setOptimizeForInstantClone(_.get($scope.initModel, 'optimizeForInstantClone', undefined));
						}

						$scope.retentionInfo = {
							type: unitInfo.type,
							value: unitInfo.qty
						};
						if ($state.current.name === 'replicationGroupsDetailConfiguration') {
							$scope.repGrp = true;
						}
						if ($scope.repGrp) {
							switch ($scope.retentionInfo.type) {
								case 'DAYS':
									$scope.enableRetention = $scope.retentionInfo.value > 14;
									break;
								case 'WEEKS':
									$scope.enableRetention = $scope.retentionInfo.value > 2;
									break;
								default:
									$scope.enableRetention = true;
									break;
							}
						} else {
							$scope.enableRetention = true;
						}

						$scope.model.overrideRetention = $scope.initModel.overrideRetention || false;
						$scope.model.isDefault = $scope.initModel.isDefault;
						$scope.model.selectiveCopy =
							($scope.initModel.copyType && $scope.initModel.copyType === 2) ||
							$scope.initModel.copyType === 'SELECTIVE'
								? true
								: false;

						if ($scope.initModel.selectiveCopyRules && $scope.initModel.selectiveCopyRules.selectiveRule) {
							$scope.model.selectedSelectiveFreq = storageCopyFactory.getSelectiveType(
								$scope.initModel.selectiveCopyRules.selectiveRule
							).value;
						}

						$scope.model.startTime = $scope.initModel.startTime;

						const retentionOne = angular.copy($scope.initModel.retentionRules.extendedRetentionRuleOne);

						if (retentionOne) {
							const obj1 = storageCopyFactory.getRetentionRule(
								retentionOne,
								$scope.initModel.retentionRules.extendedRetentionRuleOne
							);
							$scope.elemInfinite = !$scope.elemInfinite ? obj1.isInfinite : false;
							$scope.model.extendedRetention.push(obj1);

							const retentionTwo = angular.copy($scope.initModel.retentionRules.extendedRetentionRuleTwo);
							if (retentionTwo) {
								const obj2 = storageCopyFactory.getRetentionRule(
									retentionTwo,
									$scope.initModel.retentionRules.extendedRetentionRuleTwo
								);
								$scope.elemInfinite = !$scope.elemInfinite ? obj2.isInfinite : false;
								$scope.model.extendedRetention.push(obj2);

								const retentionThree = angular.copy($scope.initModel.retentionRules.extendedRetentionRuleThree);

								if (retentionThree) {
									const obj3 = storageCopyFactory.getRetentionRule(
										retentionThree,
										$scope.initModel.retentionRules.extendedRetentionRuleThree
									);
									$scope.elemInfinite = !$scope.elemInfinite ? obj3.isInfinite : false;
									$scope.model.extendedRetention.push(obj3);
								}
							}
						}

						$scope.extendedRetentionCount = $scope.model.extendedRetention.length;
						$scope.model.initialRetention = $scope.extendedRetentionCount;
						$scope.model.enableExtendedRetention =
							$scope.initModel.retentionRules && $scope.initModel.retentionRules.extendedRetentionRuleOne
								? true
								: false;

						if ($scope.model.selectiveCopy) {
							if ($scope.model.selectiveCopyRules && $scope.model.selectiveCopyRules.selectiveRule) {
								$scope.selectedSelectiveFreq = storageCopyFactory.getSelectiveType(
									$scope.model.selectiveCopyRules.selectiveRule
								);
							}
						}

						$scope.initializeDatePicker();

						if ($scope.initModel.source) {
							$scope.model.source = $scope.initModel.source;
						} else {
							$scope.model.source = '';
						}
						$scope.model.storagePool = {
							...$scope.model.storagePool,
							storagePoolEntity: $scope.initModel.storagePool.storagePoolEntity
						};
						$scope.model.copyType = $scope.initModel.isMirrorCopy === 'SET_TRUE' ? 1 : 0;
						$scope.isSnapPrimary = $scope.initModel.isSnapPrimary;
						$scope.minRetentionPeriod = $scope.isSnapPrimary || $scope.repGrp ? 0 : 1;
						if ($scope.sourceCopyList) {
							let sourceCopy = $scope.sourceCopyList.filter(
								src => src.id === _.get($scope, 'initModel.sourceCopy.copyId', 0)
							);
							$scope.model.sourceCopy = sourceCopy && sourceCopy.length > 0 ? sourceCopy[0] : {};
						}
						$scope.editMode = true;

						updateSourceCopyDropDown(true);
					};

					if ($scope.isSnapshotCopy) {
						$scope.model.showRadioBtns = true;
						$scope.copyTypeRadioObj = getCopyTypeRadioObject();
						$scope.snapVendors = $scope.snapVendorsInfo.snapVendors;
						$scope.minRetentionPeriod = 1;
						storageService.getSourceCopiesForSnapCopies($scope.storagePolicyId).then(function(data) {
							if (data && data.data && data.data.copy) {
								$scope.sourceCopyList = data.data.copy;
								$scope.model.snapSourceCopy = _.get($scope, 'sourceCopyList[0]', []);
							}
						});
					}

					function updateSourceCopyDropDown(changeDefault) {
						if ($scope.showSource) {
							// remove the current storage from list of storages as a copy cannot have itself as a source or cannot have snap copies.
							if ($scope.model.selectedSelectiveFreq !== 'SYNCRONOUS') {
								$scope.storages = _.filter($scope.originalStorageList, function(storage) {
									return storage.name !== $scope.model.storageName;
								});
							} else {
								$scope.storages = _.filter($scope.originalStorageList, function(storage) {
									return storage.name !== $scope.model.storageName && storage.copyType === 'SYNCHRONOUS';
								});
							}
							if (changeDefault === true) {
								if (
									$scope.storages &&
									$scope.storages.length &&
									$scope.storages.findIndex(copy => copy.name === $scope.model.source) == -1
								) {
									let primaryCopy = planRuleFactory.getPrimaryCopy($scope.originalStorageList);
									if (primaryCopy && primaryCopy.name) {
										$scope.model.source = primaryCopy.name;
									}
								}
							}
						}
					}

					function getCopyTypeRadioObject() {
						return [
							{
								name: 'VaultReplica',
								value: 0,
								label: 'label.vaultCopy'
							},
							{
								name: 'Mirror',
								value: 1,
								label: 'label.mirrorCopy'
							}
						];
					}

					function getSnapVendorList() {
						return [
							{
								name: 'NetApp',
								value: 1
							}
						];
					}

					function getSourceCopyList() {
						return $scope.storages.filter(storage => storage.isSnapCopy === 'SET_TRUE') || [];
					}

					function getNetAppArrays() {
						return snapArrayService.getAllArrays().then(
							function(data) {
								let netAppArrays = [];
								_.get(data, 'data.arrayList', []).forEach(function(array) {
									array.name = array.arrayName.name;
									if (array.vendor.name.toLowerCase() === 'netapp') {
										netAppArrays.push(array);
									}
								});
								netAppArrays = _.sortBy(netAppArrays, [array => array.name]);
								return netAppArrays;
							},
							function(e) {
								$log.error(e && e.errMsg ? e.errMsg : 'Error fetching the arrays');
								return [];
							}
						);
					}

					/*
					 * If data.hardRefresh property is available, it indicates this function is called as a
					 * result of Add / Delete SVM operation. If not available, fetch the list of all the SVM
					 * Mapping for the copyid
					 */
					function getSVMData(options) {
						options.success($scope.model.svmMapping);
					}

					function addSVMMapping() {
						var svmModal = $modal.open({
							templateUrl: appUtil.appRoot + 'modules/plan/partials/svmMappingModal.jsp',
							isBackdrop: false,
							controllerAs: 'svmMappingCtrl',
							controller: [
								'$uibModalInstance',
								'svmMapping',
								'snapVendorsInfo',
								'isAmazonVendor',
								'currentCopyDefaultVaultReplica',
								function($modalInstance, svmMapping, snapVendorsInfo, isAmazonVendor, currentCopyDefaultVaultReplica) {
									var self = this;
									self.snapVendors = snapVendorsInfo.snapVendors;
									self.selectedVendor = self.snapVendors[0].id;

									let vendorInfo = getAppropriateVendorInfo();
									self.vendorInfo = vendorInfo;
									self.svmMapping = svmMapping;
									self.currentCopyDefaultVaultReplica = currentCopyDefaultVaultReplica;

									self.sourceSVM = angular.copy(vendorInfo.svmList);
									self.targetSVM = angular.copy(vendorInfo.svmList);

									self.modalTitle = currentCopyDefaultVaultReplica
										? cvLoc('label.button.addMappings')
										: 'Add ' + vendorInfo.mapHeadingLabel;
									self.sourceLabel = vendorInfo.sourceLabel;
									self.destLabel = vendorInfo.destLabel;

									self.vendorTypeChanged = function() {
										self.vendorInfo = getAppropriateVendorInfo();
										self.sourceLabel = self.vendorInfo.sourceLabel;
										self.destLabel = self.vendorInfo.destLabel;
										self.sourceSVM = angular.copy(self.vendorInfo.svmList);
										self.targetSVM = angular.copy(self.vendorInfo.svmList);

										updateSourceRegionDropdown();
									};

									self.mappingInfo = {
										pairs: svmMapping ? angular.copy(svmMapping) : [],
										deletedRegions: []
									};

									self._onMappingsGridDataBound = function(dataItem, row) {
										const svmPairDeleteAction = row.find('.k-grid-delete-mapping-pair');
										svmPairDeleteAction.click(function() {
											deleteSVMMapping(dataItem);
										});
									};

									function getAppropriateVendorInfo() {
										return snapVendorsInfo.svmMap[self.selectedVendor];
									}

									function deleteSVMMapping(row) {
										let deletedRegion = _.remove(
											self.mappingInfo.pairs,
											svm => svm.srcArray.name == row.srcArray.name && svm.tgtArray.name == row.tgtArray.name
										)[0];
										if (deletedRegion.vendorType === 'Amazon') {
											self.mappingInfo.deletedRegions.push(deletedRegion);
										}
										updateSourceRegionDropdown();
										self.svmGrid.refreshData();
									}

									function getMappingPair(sourceEntity, targetEntity, vendorTypeLbl) {
										return {
											srcArray: {
												name: _.get(sourceEntity, 'name', ''),
												id: _.get(sourceEntity, 'id', '')
											},
											tgtArray: {
												name: _.get(targetEntity, 'name', ''),
												id: _.get(targetEntity, 'id', '')
											},
											vendorType: vendorTypeLbl
										};
									}

									function fetchMappings(options) {
										options.success(self.mappingInfo.pairs);
									}

									function updateSourceRegionDropdown() {
										self.sourceSVM = angular.copy(self.vendorInfo.svmList);
										self.targetSVM = angular.copy(self.vendorInfo.svmList);
										if (self.selectedVendor === 28 && self.mappingInfo.pairs.length === 0) {
											self.sourceSVM.unshift({
												id: 'ALL_REGIONS',
												name: cvLoc('label.option.allRegions')
											});
										}
									}

									self.cancel = function() {
										$modalInstance.dismiss('Cancel');
									};

									self.saveMappings = function() {
										$modalInstance.close(self.mappingInfo);
									};

									self.mappingGridInfo = storageCopyFactory._setupMappingGridOptions({
										scope: self,
										currentCopyDefaultVaultReplica: currentCopyDefaultVaultReplica,
										deleteClass: 'k-grid-delete-mapping-pair',
										fetchMappings: fetchMappings,
										gridDataBound: self._onMappingsGridDataBound,
										tableName: 'svmMappingTable',
										vendorInfo: self.vendorInfo
									});

									self.addMappingPair = function() {
										self.serverMessage = undefined;

										let isAmazonVendor = self.selectedVendor === 28 ? true : false;

										if (self.sourceSVMSelected.length === 0 || self.targetSVMSelected.length === 0) {
											return;
										}

										let vendorTypeLbl = isAmazonVendor ? 'Amazon' : 'NetApp';
										//self.serverMessage = cvUtil.emptyMsg();
										if (isAmazonVendor && self.sourceSVMSelected[0].id === 'ALL_REGIONS') {
											let svmList = snapVendorsInfo.svmMap[28].svmList;
											svmList.forEach(function(item) {
												self.mappingInfo.pairs.push(getMappingPair(item, self.targetSVMSelected[0], vendorTypeLbl));
											});
										} else {
											if (isAmazonVendor) {
												let duplicateSourceRegionIndex = self.mappingInfo.pairs.findIndex(svm => {
													return svm.srcArray.name === self.sourceSVMSelected[0].name;
												});

												if (duplicateSourceRegionIndex >= 0) {
													self.serverMessage = cvUtil.errMsgLoc('error.duplicateSourceRegion');
													return;
												}
											}
											// check for duplicate entries
											let duplicateEntryIndex = self.mappingInfo.pairs.findIndex(svm => {
												return (
													svm.srcArray.name === self.sourceSVMSelected[0].name &&
													svm.tgtArray.name === self.targetSVMSelected[0].name
												);
											});

											if (duplicateEntryIndex >= 0) {
												self.serverMessage = isAmazonVendor
													? cvUtil.errMsgLoc('error.duplicateRegionEntry')
													: cvUtil.errMsgLoc('error.duplicateSVMEntry');
												return;
											}
											self.mappingInfo.pairs.push(
												getMappingPair(self.sourceSVMSelected[0], self.targetSVMSelected[0], vendorTypeLbl)
											);
										}
										updateSourceRegionDropdown();
										self.svmGrid.refreshData();
									};
								}
							],
							resolve: {
								svmMapping: () => $scope.model.svmMapping,
								snapVendorsInfo: () => $scope.snapVendorsInfo,
								isAmazonVendor: () => storageCopyFactory.isAmazonVendor($scope.model.selectedVendor),
								currentCopyDefaultVaultReplica: () => $scope.currentCopyDefaultVaultReplica
							}
						});
						svmModal.result.then(
							function(data) {
								if (data.pairs) {
									$scope.parentServerMessage = cvUtil.emptyMsg();
									$scope.model.svmMapping = data.pairs;
								}

								if (data.deletedRegions) {
									$scope.model.deletedRegions = _.concat($scope.model.deletedRegions, data.deletedRegions);
								}
								$scope.updateVendorLabel();
								$scope.svmGrid.refreshData();
							},
							function(data) {}
						);
					}

					function deleteSVMMapping(row) {
						let deletedRegion = _.remove(
							$scope.model.svmMapping,
							svm => svm.srcArray.name == row.srcArray.name && svm.tgtArray.name == row.tgtArray.name
						)[0];
						if (
							($scope.currentCopyDefaultVaultReplica === true && deletedRegion.vendorType === 'Amazon') ||
							storageCopyFactory.isAmazonVendor($scope.model)
						) {
							$scope.model.deletedRegions.push(deletedRegion);
						}
						$scope.updateVendorLabel();
						$scope.svmGrid.refreshData();
					}

					$scope.showRetention = function() {
						if ($scope.isSnapshotCopy) {
							return false;
						} else {
							return (
								$scope.planSubType != 'Laptop' &&
								_.get($scope, 'model.storagePool.storagePoolType', false) === 'SECONDARY_COPY'
							);
						}
					};

					$scope.isPrimaryCopy = function() {
						return (
							(!$scope.initModel && (!$scope.storages || !$scope.storages.length)) ||
							($scope.initModel && $scope.initModel.isPrimary)
						);
					};

					$scope.showRetentionOverrideTitle = function() {
						return $scope.showRetentionOverride();
					};

					$scope.showRetentionOverrideContent = function() {
						if ($scope.repGrp) {
							if ($scope.enableRetention) {
								return $scope.showRetentionOverride();
							} else {
								return false;
							}
						}
						return $scope.showRetentionOverride();
					};

					$scope.showRetentionOverride = function() {
						if ($scope.isSnapshotCopy) {
							return $scope.model.snapCopyType === 0;
						} else {
							return (
								($scope.planSubType != 'Laptop' &&
									_.get($scope, 'model.storagePool.storagePoolType', false) != 'SECONDARY_COPY') ||
								(_.get($scope, 'model.storagePool.storagePoolType', false) === 'SECONDARY_COPY' &&
									($scope.isPrimaryCopy() || $scope.model.overrideRetention))
							);
						}
					};

					$scope.onEnableRetentionClick = function() {
						$scope.enableRetention = !$scope.enableRetention;
						$scope.retentionInfo.value = $scope.enableRetention ? 30 : 14;
						$scope.retentionInfo.type = 'DAYS';

						$scope.changePolicyRetention();
					};

					/**
					 * This function is called when a custom retention is selected from isteven
					 */
					$scope.valueSelected = function(data) {
						let categoryName = data.parentCategory.trim();
						switch (categoryName) {
							case 'days':
							case 'day': {
								$scope.model.retentionPeriod = data.value;
								break;
							}
							case 'months':
							case 'month': {
								$scope.model.retentionPeriod = Math.floor(data.value * 30.41);
								break;
							}
							case 'years':
							case 'year': {
								$scope.model.retentionPeriod = data.value * 365;
								break;
							}
						}
					};
					/**
					 * This Map holds the information of storagePools and their custom retention information
					 */
					let storagePoolToCustomRetentionMap = new Map();

					/**
					 * This is the information of storagePools and customRetentions available from
					 * GxGlobalParam
					 */
					let storagePoolCustomRetentionJson = cvUtil.objectContainsNestedProperty(
						'cvApp.globalParams.customRetentionPeriodForStoragePools',
						cvApp
					)
						? JSON.parse(cvApp.globalParams.customRetentionPeriodForStoragePools)
						: {};

					if (
						cvUtil.objectContainsNestedProperty(
							'storagePoolCustomRetentionJson.storageInfoList',
							storagePoolCustomRetentionJson
						)
					) {
						storagePoolCustomRetentionJson.storageInfoList.forEach(function(storageInfo) {
							storagePoolToCustomRetentionMap.set(storageInfo.storageName, storageInfo.customRetentionObject);
						});
					}
					/**
					 *
					 * @param {string}
					 *            stPoolName takes in storagePoolName returns array of Isteven for storage
					 *            pool
					 */
					let _computeRetentionPeriodArray = function(stPoolName) {
						//check for null or non-empty string
						if (
							stPoolName &&
							angular.isDefined(stPoolName) &&
							stPoolName !== '' &&
							storagePoolToCustomRetentionMap != null &&
							angular.isDefined(storagePoolToCustomRetentionMap) &&
							storagePoolToCustomRetentionMap.get(stPoolName) != null &&
							angular.isDefined(storagePoolToCustomRetentionMap.get(stPoolName))
						) {
							let oStoragePoolInfoInSPtoCustomRetentionMap = storagePoolToCustomRetentionMap.get(stPoolName);

							let istevenArray = [];

							/**
							 *
							 * @param {string}
							 *            categoryName returns Parent Category object in array of isteven
							 */
							let _getCategoryObject = function(categoryName) {
								return {
									value: categoryName,
									category: true
								};
							};
							/**
							 * return object to end one category in isteven
							 */
							let _getCategoryFooter = function() {
								return {
									category: false
								};
							};

							/**
							 * takes in values array and returns parent category
							 */
							let _getCategoryChildren = function(childrenArray, parentCategory) {
								if (angular.isArray(childrenArray)) {
									childrenArray.forEach(function(child) {
										istevenArray.push({
											parentCategory:
												child === 1 ? parentCategory.substring(0, parentCategory.length - 1) : parentCategory,
											value: child,
											ticked: false
										});
									});
								}
							};

							let _updateIstevensArrayFor = function(categoryName, categoryValues) {
								let categoryValuesArray = categoryValues.split(',').map(function(item) {
									return parseInt(item, 10);
								});
								// if (categoryName === "Days" && $scope.initModel && $scope.initModel.retentionPeriod && !categoryValuesArray.includes($scope.initModel.retentionPeriod)){
								// 	categoryValuesArray.push(parseInt($scope.initModel.retentionPeriod));
								// }

								categoryValuesArray.sort(function(a, b) {
									return a - b;
								});
								if (categoryValuesArray && angular.isArray(categoryValuesArray)) {
									istevenArray.push(_getCategoryObject(categoryName));
									_getCategoryChildren(categoryValuesArray, ' ' + categoryName.toLowerCase());
									istevenArray.push(_getCategoryFooter());
								}
							};

							if (oStoragePoolInfoInSPtoCustomRetentionMap.hasOwnProperty('Days')) {
								_updateIstevensArrayFor('Days', oStoragePoolInfoInSPtoCustomRetentionMap.Days);
							}
							if (oStoragePoolInfoInSPtoCustomRetentionMap.hasOwnProperty('Months')) {
								_updateIstevensArrayFor('Months', oStoragePoolInfoInSPtoCustomRetentionMap.Months);
							}
							if (oStoragePoolInfoInSPtoCustomRetentionMap.hasOwnProperty('Years')) {
								_updateIstevensArrayFor('Years', oStoragePoolInfoInSPtoCustomRetentionMap.Years);
							}

							return istevenArray;
						}
						return [];
					};

					$scope.setAvailableStoragePools = function() {
						// remove the storage pools used so far and push only which are remaining
						$scope.storagePools = [];
						for (var i = 0; i < $scope.allStoragePools.length; i++) {
							var poolExists = false;
							// check pool is used in any of the previous storages
							for (var k = 0; k < $scope.storages.length; k++) {
								var storagePoolEntity = $scope.storages[k].storagePool.storagePoolEntity;
								let storagePoolType = $scope.storages[k].storagePoolType
									? $scope.storages[k].storagePoolType
									: $scope.storages[k].storagePool.storagePoolType;
								let isNonSnapCopy = $scope.storages[k].isSnapCopy !== 'SET_TRUE';
								var storagePoolId = storagePoolEntity
									? storagePoolEntity.storagePoolId
										? storagePoolEntity.storagePoolId
										: storagePoolEntity.storagePolicyId
									: undefined;
								var existingPoolId =
									$scope.initModel && $scope.initModel.storagePool
										? $scope.initModel.storagePool.storagePoolEntity.storagePoolId
										: undefined;
								if (
									$scope.isSnapshotCopy === false &&
									storagePoolType != 'NON_DEDUPLICATION' &&
									isNonSnapCopy &&
									storagePoolId === $scope.allStoragePools[i].storagePoolEntity.storagePoolId &&
									existingPoolId != storagePoolId
								) {
									poolExists = true;
									break;
								}
							}
							if (!poolExists) {
								let oStoragePoolInfoInSPtoCustomRetentionMap =
									storagePoolToCustomRetentionMap != null &&
									angular.isDefined(storagePoolToCustomRetentionMap) &&
									storagePoolToCustomRetentionMap.get($scope.allStoragePools[i].storagePoolEntity.storagePoolName);
								if (
									oStoragePoolInfoInSPtoCustomRetentionMap != null &&
									angular.isDefined(oStoragePoolInfoInSPtoCustomRetentionMap)
								) {
									$scope.allStoragePools[i].oCustomRetentionInformation = {};
									/**
									 * Setting customRetentionInformation
									 * {showInfiniteRetention,aRetentionPeriodArray}
									 */
									$scope.allStoragePools[i].oCustomRetentionInformation.showInfiniteRetention = angular.isDefined(
										oStoragePoolInfoInSPtoCustomRetentionMap.showInfiniteRetention
									)
										? oStoragePoolInfoInSPtoCustomRetentionMap.showInfiniteRetention
										: false;
									$scope.allStoragePools[
										i
									].oCustomRetentionInformation.aRetentionPeriodArray = _computeRetentionPeriodArray(
										$scope.allStoragePools[i].storagePoolEntity.storagePoolName
									);
								}

								$scope.storagePools.push($scope.allStoragePools[i]);
							}
						}
						if (angular.isDefined($scope.availableStoragePools)) {
							$scope.availableStoragePools.length = $scope.storagePools.length;
						}
						if ($scope.storagePools.length) {
							if (!$scope.initModel) {
								//$scope.model.storagePool = $scope.storagePools[0];
							}
							$scope.serverMessage = cvUtil.emptyMsg();
						} else {
							$scope.serverMessage = cvUtil.infoMsgLoc('error.noStorageAvailable');
						}

						if ($scope.isSnapshotCopy) {
							$scope.storages = $scope.storages.filter(storage => storage.isSnapCopy === 'SET_TRUE');
						}

						$scope.inputStoragePoolsModel = storageCopyFactory.getInputStoragePoolModel(
							angular.copy($scope.storagePools),
							$scope.model
						);
					};

					$scope.setOptimizeForInstantClone = function(value) {
						$scope.model.optimizeForInstantClone = value;
						$scope.model.optimizeForInstantCloneClass = $scope.model.optimizeForInstantClone
							? 'enabled-activity'
							: 'disabled-activity';
					};

					$scope.toggleOptimizeInstantClone = function() {
						$scope.setOptimizeForInstantClone(!$scope.model.optimizeForInstantClone);
					};

					$scope.isNotPrimaryCopy = function() {
						return (
							(!$scope.initModel && $scope.storages && $scope.storages.length) ||
							($scope.initModel && !$scope.initModel.isPrimary)
						);
					};

					$scope.updateModelWithStoragePool = function(value) {
						if (value) {
							if (value.storagePoolType && value.storagePoolType === 'SECONDARY_COPY') {
								if ($scope.isNotPrimaryCopy()) {
									$scope.model.selectiveCopy = true;
									$scope.model.selectedSelectiveFreq = $scope.selectiveFreqs[5].value;
								}
							}
							$scope.model.storagePool = value;
							//$scope.model.storagePool.storageSubType = 'HEDVIG';
							if (_.get($scope.model.storagePool, 'storageSubType', undefined) === 'HEDVIG') {
								$scope.setOptimizeForInstantClone(true);
							} else {
								// Clear the optimize for instant clone field
								$scope.setOptimizeForInstantClone(undefined);
							}
						}
					};

					//storage pools
					// If allStoragePools is already defined or initial storage is defined, populate the
					// dropdown with those storage pools. Otherwise, load the storage pools from the server:
					if (angular.isArray($scope.allStoragePools)) {
						if ($scope.initModel && $scope.initModel.storagePool) {
							// If initial storage is given, add it to allStoragePools if it is not present
							// and select it:
							if (
								!$scope.allStoragePools.some(
									storagePool =>
										$scope.initModel.storagePool.storagePoolEntity.storagePoolId ===
										storagePool.storagePoolEntity.storagePoolId
								)
							) {
								$scope.allStoragePools.push($scope.initModel.storagePool);
							}
							$scope.model.storagePool = $scope.initModel.storagePool;
						}
						$scope.setAvailableStoragePools();
					} else if ($scope.initModel && $scope.initModel.storagePool) {
						$scope.allStoragePools = [$scope.initModel.storagePool];
						$scope.model.storagePool = $scope.allStoragePools[0];
						$scope.setAvailableStoragePools();
					} else {
						let storageSubType = 'ALL_EXCEPT_IBMi_VTL';
						if ($scope.planSubType === 'FSIBMiVTL') {
							storageSubType = 'IBMi_VTL';
						}
						storageService
							.getStoragePools(null, storageSubType)
							.success(function(data) {
								if (data.length) {
									$scope.serverMessage = cvUtil.emptyMsg();
									$scope.allStoragePools = cvUtil.sortAscending(data, 'storagePoolEntity.storagePoolName');
									// default to first storage pool
									//$scope.model.storagePool = $scope.allStoragePools[0];
									// set initial value
									if ($scope.initModel && $scope.initModel.storagePool) {
										$scope.model.storagePool = getSelectOption(
											$scope.allStoragePools,
											function(obj) {
												return obj.storagePoolEntity.storagePoolId;
											},
											$scope.initModel.storagePool.storagePoolEntity.storagePoolId
										);
									}
									$scope.setAvailableStoragePools();
								} else {
									$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageFound');
								}
							})
							.error(function(e) {
								$scope.serverMessage = cvUtil.errMsg(e);
							});
					}

					var getSelectOption = function(arr, getField, valueToSelect, returnField) {
						for (var i = 0; i < arr.length; i++) {
							if (getField(arr[i]) === valueToSelect) {
								return returnField ? returnField(arr[i]) : arr[i];
							}
						}
					};

					$scope.fetchCopyDetails();

					if ($scope.ctrl) {
						$scope.ctrl.refresh = function() {
							$scope.setAvailableStoragePools();
						};

						$scope.ctrl.refreshError = function() {
							$scope.serverMessage = cvUtil.emptyMsg();
						};
					}
				}
			],
			link: function(scope, element, attrs, ngModelCtrl) {
				scope.$watch(
					'model',
					function(newValue) {
						ngModelCtrl.$setViewValue(newValue);
					},
					true
				);
			}
		};
	}
]);
// Used to add storage rule from create profile page
planModule.directive('cvVsaPlanStorageRuleComponent', [
	function() {
		return {
			restrict: 'E',
			require: 'ngModel',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/vsaPlanStorageRuleTemplate.jsp',
			scope: {
				ngModel: '=',
				initModel: '=',
				storages: '=',
				ctrl: '=',
				availableStoragePools: '=',
				allStoragePools: '=?',
				showSource: '=',
				planSubType: '=',
				rules: '='
			},
			controller: [
				'$scope',
				'$rootScope',
				'storageService',
				'scheduleUIFactory',
				'cvUtil',
				'cvLoc',
				function($scope, $rootScope, storageService, scheduleUIFactory, cvUtil, cvLoc) {
					$scope.storagePools = [];
					$scope.model = {
						retentionDays: 30,
						source: '',
						rule: {
							ruleName: '',
							ruleId: ''
						}
					};

					if ($scope.initModel) {
						var getSelectOption = function(arr, getField, valueToSelect, returnField) {
							for (var i = 0; i < arr.length; i++) {
								if (getField(arr[i]) === valueToSelect) {
									return returnField ? returnField(arr[i]) : arr[i];
								}
							}
						};
						$scope.initModel.retentionDays = parseInt($scope.initModel.retentionDays);
						$scope.model = angular.copy($scope.initModel);
					}
					if ($scope.initModel && $scope.initModel.storagePool) {
						$scope.storagePools = [$scope.initModel.storagePool];
						$scope.model.storagePool = $scope.storagePools[0];
					}

					if ($scope.ctrl) {
						$scope.ctrl.refreshError = function() {
							$scope.serverMessage = cvUtil.emptyMsg();
						};
					}
				}
			],
			link: function(scope, element, attrs, ngModelCtrl) {
				scope.$watch(
					'model',
					function(newValue) {
						ngModelCtrl.$setViewValue(newValue);
					},
					true
				);
			}
		};
	}
]);
planModule.directive('cvVsaPlanReplicationComponent', [
	function() {
		return {
			restrict: 'E',
			require: 'ngModel',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/vsaPlanReplicationTemplate.jsp',
			scope: {
				ngModel: '=',
				initModel: '=',
				storages: '=',
				replicationSchedules: '=',
				replications: '=',
				ctrl: '=',
				copyDetails: '=',
				replicationType: '=',
				disabledTarget: '=?',
				sourceHyperV: '=',
				replicationGroup: '=?'
			},
			controller: [
				'$scope',
				'$rootScope',
				'restoreService',
				'scheduleUIFactory',
				'cvUtil',
				'cvLoc',
				'replicationFactory',
				'collectionFactory',
				'restoreOptionFactory',
				'replicationGroupFactory',
				'cvReplicationFrequencyFactory',
				'$dialogs',
				'$uibModal',
				'VENDORS',
				'REP_TYPES',
				'POLICY_APP_TYPE',
				'VSA_VENDOR',
				'serverService',
				'CREDENTIAL_TYPE',
				function(
					$scope,
					$rootScope,
					restoreService,
					scheduleUIFactory,
					cvUtil,
					cvLoc,
					replicationFactory,
					collectionFactory,
					restoreOptionFactory,
					replicationGroupFactory,
					cvReplicationFrequencyFactory,
					$dialogs,
					$modal,
					VENDORS,
					REP_TYPES,
					POLICY_APP_TYPE,
					VSA_VENDOR,
					serverService,
					CREDENTIAL_TYPE
				) {
					// set default value
					if (!cv.isTenantAdmin) {
						$scope.targets = [];
					}
					$scope.distributeWorkload =
						$scope.replicationGroup.selectedHypervisor.type === VSA_VENDOR.VMWARE
							? _.get(cvConfig, 'bEnableDistributeWorkload', true)
							: _.get(cvConfig, 'bEnableDistributeWorkload', false);
					$scope.distributeWorkloadSupportedVendor = false;
					$scope.showPowerOnOption = false;
					$scope.showDeployVmWhenFailover = false;
					$scope.model = {
						diskRestoreOption: {}
					};
					$scope.showBLRInfoMessage = cvConfig.enableBLR;
					$scope.showProxySelect = false;
					$scope.hideAccessNode = !cv.isTenantAdmin;
					$scope.REP_TYPES = REP_TYPES;
					const enableSimplifiedLiveSync = replicationGroupFactory.simplifiedLiveSyncUI;
					const enableCreateVMDuringFailover = _.get(
						cv,
						'additionalSettings.AdminConsole.enableCreateVMDuringFailover',
						false
					);

					const distributeWorklaodVendors = [
						VSA_VENDOR.VMWARE,
						VSA_VENDOR.AMAZON,
						VSA_VENDOR.AZURERM,
						VSA_VENDOR.GOOGLECLOUD
					];
					if (distributeWorklaodVendors.includes($scope.replicationGroup.selectedHypervisor.type)) {
						$scope.distributeWorkloadSupportedVendor = true;
					}

					$scope.replicationGroup.availableRPOFreq = cvReplicationFrequencyFactory.getAvailableRPOFreq();

					if (!$scope.replicationGroup.rpo) {
						$scope.replicationGroup.rpo = {
							count: 4,
							freq: $scope.replicationGroup.availableRPOFreq[1],
							inMinutes: 4 * $scope.replicationGroup.availableRPOFreq[1].value
						};
					}

					if (!$scope.replicationGroup.credentialsModel) {
						$scope.replicationGroup.credentialsModel = {
							selectedCredential: [],
							createAccountType: ['WINDOWSACCOUNT', 'LINUXACCOUNT'],
							accountType: [CREDENTIAL_TYPE.WINDOWSACCOUNT, CREDENTIAL_TYPE.LINUXACCOUNT],
							credType: 'user',
							inputName: ['userName', 'password'],
							sourceLabel: cvLoc('label.guestCredentials'),
							sourceLabelHelpText: cvLoc('label.guestCredentialsHelp'),
							labelClass: 'col-xs-12 col-sm-5',
							inputClass: 'col-xs-12 col-sm-7 padding-left-0'
						};
					}

					let self = this;
					this.$onInit = () => {
						$scope.showAdvancedOptions =
							$scope.replicationType !== 'LiveSyncIO' &&
							$scope.onReplicationTypeSelect($scope.replicationGroup.replicationType);
					};

					$scope.onReplicationTypeSelect = function(replicationType) {
						$scope.showAdvancedOptions =
							replicationType === REP_TYPES.CONTINUOUS
								? replicationGroupFactory.enableGuestCredentialsContinuous
								: true;
						return $scope.showAdvancedOptions;
					};

					$scope.onRPOChange = function() {
						let rpo = $scope.replicationGroup.rpo;
						$scope.replicationGroup.rpo.errorMessage = cvReplicationFrequencyFactory.isFrequencyValid(
							rpo.count,
							rpo.freq.value
						);
						if ($scope.replicationGroup.rpo.errorMessage == '') {
							$scope.replicationGroup.rpo.inMinutes =
								$scope.replicationGroup.rpo.count * $scope.replicationGroup.rpo.freq.value;
						}
					};

					var showDeployVmWhenFailover = function(policyType) {
						if (policyType === VENDORS.AZURE_V2.policyType || policyType === VENDORS.AZURE_STACK.policyType) {
							$scope.showDeployVmWhenFailover = true;
							if ($scope.replicationGroup && !$scope.replicationGroup.editMode) {
								$scope.model.diskRestoreOption.deployVmWhenFailover = true;
							} else {
								$scope.model.diskRestoreOption.deployVmWhenFailover = !!$scope.model.diskRestoreOption
									.deployVmWhenFailover;
							}
						} else if (policyType === VENDORS.OPENSTACK.policyType) {
							$scope.showDeployVmWhenFailover = false;
							$scope.model.diskRestoreOption.deployVmWhenFailover = true;
							$scope.model.diskRestoreOption.powerOnVmAfterRestore = false;
						} else if (policyType === VENDORS.GOOGLE_CLOUD.policyType) {
							$scope.showDeployVmWhenFailover = true;
							$scope.model.diskRestoreOption.deployVmWhenFailover = false;
						} else {
							$scope.showDeployVmWhenFailover = false;
							$scope.model.diskRestoreOption.deployVmWhenFailover = undefined;
						}
					};

					var showPowerOnOption = function(policyType) {
						if (
							policyType === VENDORS.AZURE_V2.policyType ||
							policyType === VENDORS.ORACLE_CLOUD_INFRASTRUCTURE.policyType ||
							policyType === VENDORS.OPENSTACK.policyType ||
							policyType === VENDORS.GOOGLE_CLOUD.policyType ||
							policyType === VENDORS.AZURE_STACK.policyType
						) {
							$scope.showPowerOnOption = false;
						} else {
							$scope.showPowerOnOption = $scope.model.diskRestoreOption.powerOnVmAfterRestore = true;
						}
					};

					var setRestoreToDefaultFolder = function() {
						$scope.model.diskRestoreOption.restoreToDefaultHost =
							$scope.selectedTargets &&
							$scope.selectedTargets.length &&
							$scope.selectedTargets[0].dataStores.dataStoreName === '';
					};

					const isVMWareType = function(type) {
						if (!type) {
							return false;
						}

						return VENDORS.VMW.policyTypes.includes(type);
					};

					var showAdvanceOptionsBasedOnTarget = function(target, destinationVendor) {
						var targetPolicyType = target ? target.vmAllocPolicyType : destinationVendor;
						showPowerOnOption(targetPolicyType);
						showDeployVmWhenFailover(targetPolicyType);
						if (targetPolicyType === VENDORS.MICROSOFT.policyType) {
							setRestoreToDefaultFolder();
						}

						if ($scope.selectedTargets && $scope.selectedTargets[0] && $scope.selectedTargets[0].vmAllocPolicyType) {
							targetPolicyType = $scope.selectedTargets[0].vmAllocPolicyType;
						}

						$scope.showAdvanceOptionsVMWare = isVMWareType(targetPolicyType);
						$scope.showAdvanceOptionsAmazon =
							targetPolicyType === VENDORS.AMAZON.policyType ||
							($scope.model.target &&
								$scope.model.target.entity &&
								$scope.model.target.entity.vmAllocPolicyType === VENDORS.AMAZON.policyType);
						$scope.isSimplifiedLiveSync =
							enableSimplifiedLiveSync && isSimplifiedLiveSyncSupportedPolicyType(targetPolicyType);
						$scope.enableContinuousReplication =
							replicationGroupFactory.enableContinuousReplication &&
							$scope.showAdvanceOptionsVMWare &&
							VENDORS.VMW.type === _.get($scope, 'replicationGroup.selectedHypervisors[0].type');
						$scope.showCreateVMDuringFailover = $scope.isSimplifiedLiveSync && enableCreateVMDuringFailover;
					};

					var getSelectedTarget = function(newTargetId) {
						if (!$scope.targets) {
							return;
						}

						// select the target when go back and forth or Edit mode
						for (var i = 0; i < $scope.targets.length; i++) {
							var checkingSelectTarget = angular.isDefined(newTargetId)
								? $scope.targets[i].vmAllocPolicyId === newTargetId
								: $scope.targets[i].vmAllocPolicyId === $scope.initModel.targetId;

							if (angular.isDefined($scope.targets[i].vmAllocPolicyId) && checkingSelectTarget) {
								$scope.targets[i].selected = true;
								$scope.selectedTargets = [$scope.targets[i]];
								$scope.model.target = {
									entity: {
										vmAllocPolicyName: $scope.targets[i].vmAllocPolicyName,
										vmAllocPolicyId: $scope.targets[i].vmAllocPolicyId,
										vmAllocPolicyType: $scope.targets[i].vmAllocPolicyType
									},
									targetInfo: {
										destinationHyperV: $scope.targets[i].destinationHyperV
									},
									destinationHyperV: $scope.selectedTargets[0].destinationHyperV,
									isDestinationSameAsSource: isDestinationVMOneOfSourceVMs(
										$scope.targets[i].destinationHyperV,
										$scope.targets[i].vmNameEditString
									)
								};

								//remove bucket usage from configuring replication group on target selection tab
								if ($scope.model.target.entity.vmAllocPolicyType === VENDORS.AMAZON.policyType) {
									$scope.model.target.entity.selectedAvailabilityZone = $scope.targets[i].availabiltyZone
										? $scope.targets[i].availabiltyZone
										: '';
									//								var targetAmazonBucket = $scope.replicationGroup.target.target ? (($scope.replicationGroup.target.target.entity && $scope.replicationGroup.target.target.entity.selectedAmazonBucket) ? ($scope.replicationGroup.target.target.entity.selectedAmazonBucket) : ($scope.replicationGroup.target.target.dataStores ? $scope.replicationGroup.target.target.dataStores[0] : "")) : ($scope.targets[i].dataStores?$scope.targets[i].dataStores:'');
									//
									//								// Pick the bucket selected from the groups or pick from the target
									//								if ($scope.replicationGroup && ($scope.replicationGroup.selectedAmazonBucket)) {
									//									// Pick from group. (edit mode / cannot change)
									//									$scope.model.target.entity.selectedAmazonBucket = $scope.replicationGroup.selectedAmazonBucket;
									//								} else {
									//									// Pick from target.
									//									$scope.model.target.entity.selectedAmazonBucket = targetAmazonBucket;
									//								}
									//
									//								$scope.$broadcast('loadAmazonBuckets', editMode, $scope.selectedTargets[0].destinationHyperV, null, $scope.selectedTargets[0].availabiltyZone,null,$scope.model.target.entity.selectedAmazonBucket);
								}

								showAdvanceOptionsBasedOnTarget($scope.model.target.entity);
								$scope.confirmSelectNewTarget();
								// Check for pre-selected when go back, if not get the default one.
								if (
									$scope.replicationGroup &&
									(!$scope.replicationGroup.selectedProxy ||
										!$scope.replicationGroup.selectedProxy.length ||
										!$scope.replicationGroup.selectedProxy[0])
								) {
									$scope.replicationGroup.selectedProxy = [$scope.selectedTargets[0].proxyClientEntity];
								}
								$scope.filterCopyDetails($scope.model.target);
								$scope.initModel.targetErrorMessage = null;
								break;
							}
						}
					};

					var filterTarget = function(allTargets) {
						var destinationSources = [];

						/** Filter based on Hypervisor selected * */
						if ($scope.replicationGroup && $scope.replicationGroup.selectedHypervisor) {
							var sourceVendor = $scope.replicationGroup.selectedHypervisor.type;
							var filterType = $scope.replicationGroup.useAllocationPolicyForRestore
								? 'autoUpdateSupport'
								: 'repGroupSupport';
							if (
								sourceVendor == VENDORS.VMW.type &&
								cvConfig.showVMWGCPReplication &&
								filterType == 'repGroupSupport'
							) {
								VENDORS[sourceVendor][filterType].push(VENDORS.GOOGLE_CLOUD.type);
							}
							if (
								sourceVendor == VENDORS.GOOGLE_CLOUD.type &&
								cvConfig.showGCPVMWReplication &&
								filterType == 'repGroupSupport'
							) {
								VENDORS[sourceVendor][filterType].push(VENDORS.VMW.type);
							}
							if (VENDORS[sourceVendor]) {
								if (
									replicationGroupFactory.enableSimplifiedLiveSync &&
									replicationGroupFactory.simplifiedLiveSyncUI &&
									!replicationGroupFactory.enableNonVMWReplication
								) {
									VENDORS[sourceVendor][filterType].forEach(function(type) {
										// if there is Vendor type, get its policyType, otherwise use as VMAllocationPolicyType
										if (VENDORS[type].policyType === VENDORS.VMW.policyType && !!VENDORS[type].policyTypes) {
											//VMW has multiple policType
											destinationSources = destinationSources.concat(VENDORS[type].policyTypes);
										} else if (isSimplifiedLiveSyncSupportedPolicyType(VENDORS[type].policyType)) {
											destinationSources.push(VENDORS[type] ? VENDORS[type].policyType : type);
										}
									});
								} else {
									VENDORS[sourceVendor][filterType].forEach(function(type) {
										// if there is Vendor type, get its policyType, otherwise use as VMAllocationPolicyType
										if (VENDORS[type].policyType === VENDORS.VMW.policyType && !!VENDORS[type].policyTypes) {
											//VMW has multiple policType
											destinationSources = destinationSources.concat(VENDORS[type].policyTypes);
										} else {
											destinationSources.push(VENDORS[type] ? VENDORS[type].policyType : type);
										}
									});
								}
								if (
									(cvConfig.bShowVMWareToAzureStackReplication && sourceVendor == VENDORS.VMW.type) ||
									(cvConfig.bEnableAzureStackReplication && sourceVendor == VENDORS.AZURE_STACK.type)
								) {
									destinationSources.push(VENDORS.AZURE_STACK.policyType);
								}
							}

							return allTargets.filter(function(target) {
								if (target.entity && !target.entity.policyType) {
									target.entity.policyType = VENDORS.VMW.policyType;
								}

								// Creation mode
								if ($scope.replicationType === 'LiveSync') {
									return target.entity && destinationSources.includes(target.entity.policyType);
								} else if ($scope.replicationType === 'LiveSyncDirect') {
									// LiveSyncDirect only support VMW-VMW, VMW has multiple policType
									return target.entity && VENDORS[VENDORS.VMW.type].policyTypes.includes(target.entity.policyType);
								} else {
									//for other replication types return all targets
									return allTargets;
								}
							});
						}

						return allTargets;
					};

					var isDestinationVMOneOfSourceVMs = function(destination, vmNameEditString) {
						if ($scope.replicationType === 'LiveSyncIO' && !vmNameEditString) {
							var sourceHyperV = $scope.sourceHyperV;
							var destHyperV = destination ? destination.clientName : null;
							return sourceHyperV && destHyperV && sourceHyperV === destHyperV;
						}
						return false;
					};

					// Broadcast proxy selection helper
					var broadcastProxy = function(policyType, hyperV) {
						var destinationVendor;
						var destinationHyperV;

						// GET Proxy API need source vendor type
						switch (policyType) {
							case VENDORS.VMW.policyType:
								destinationVendor = VENDORS.VMW.type;
								break;
							case VENDORS.AZURE_V2.policyType:
								destinationHyperV = hyperV;
								break;
							case VENDORS.MICROSOFT.policyType:
								destinationHyperV = hyperV;
								break;
							case 'VMW_LIVEMOUNT':
								destinationVendor = VENDORS.VMW.type;
								break;
							default:
								break;
						}

						if ($scope.ctrl && $scope.ctrl.loadDestinationProxies) {
							$scope.ctrl.loadDestinationProxies(destinationVendor, destinationHyperV);
						}
					};

					$scope.filterCopyDetails = function(target) {
						const notSupportCopy = {
							AMAZON: [100, 163]
						};

						$scope.filteredCopyDetails = angular.copy($scope.copyDetails);

						if (
							$scope.filteredCopyDetails &&
							$scope.filteredCopyDetails.storage &&
							$scope.filteredCopyDetails.storage.copy
						) {
							var copyDetails = angular.copy($scope.filteredCopyDetails.storage.copy);
							var filterCopies = [];

							// Filter out Primary snap copy only for amazon target
							for (var idx = 0; idx < copyDetails.length; idx++) {
								if (
									target &&
									target.entity &&
									target.entity.vmAllocPolicyType === VENDORS.AMAZON.policyType &&
									copyDetails &&
									copyDetails.length
								) {
									if (
										copyDetails[idx] &&
										copyDetails[idx].StoragePolicyCopy &&
										notSupportCopy.AMAZON.includes(copyDetails[idx].StoragePolicyCopy.copyId)
									) {
										continue;
									}
								}

								filterCopies.push(copyDetails[idx]);
							}

							$scope.filteredCopyDetails.storage.copy = filterCopies;
							var existingCopyPrecedence = $scope.model.diskRestoreOption.copyPrecedence;
							$scope.model.diskRestoreOption.copyPrecedence =
								existingCopyPrecedence !== null && angular.isDefined(existingCopyPrecedence)
									? existingCopyPrecedence
									: $scope.filteredCopyDetails.storage.copy[0].copyPrecedence;
						}
					};

					// Moving these code to the top since they are their definitions.
					$scope.resetDefaultVMWAdvanceOptions = function() {
						$scope.model.diskRestoreOption.powerOnVmAfterRestore = $scope.showPowerOnOption;

						if ($scope.showDeployVmWhenFailover) {
							$scope.model.diskRestoreOption.deployVmWhenFailover = false;
						} else {
							$scope.model.diskRestoreOption.deployVmWhenFailover = undefined;
						}

						if ($scope.showAdvanceOptionsVMWare) {
							$scope.model.diskRestoreOption.nMaxSnapshotsPerDRVM = 0;
							$scope.model.diskRestoreOption.transportMode = 0;
							$scope.model.diskRestoreOption.diskOption = 0;
							$scope.model.diskRestoreOption.passUnconditionalOverride = false;
						}
					};

					$scope.maxSnapshotChanged = function(value) {
						$scope.nMaxSnapshotsError = _.isNil(value)
							? cvUtil.errMsg(cvLoc('error.maximumSnapshot'))
							: cvUtil.emptyMsg();

						$scope.replicationGroup.targetStepNotReady = _.isNil(value);

						handleSANTransportModeVisibility(value);
					};

					$scope.setDefaultRestoreOptions = function(reset) {
						if (reset) {
							$scope.resetDefaultVMWAdvanceOptions();
						} else {
							if ($scope.initModel && $scope.initModel.diskRestoreOption) {
								$scope.model.diskRestoreOption = $scope.initModel.diskRestoreOption;

								if (
									$scope.showDeployVmWhenFailover &&
									!angular.isDefined($scope.initModel.diskRestoreOption.deployVmWhenFailover)
								) {
									$scope.model.diskRestoreOption.deployVmWhenFailover = false;
								}

								if (
									!$scope.model.diskRestoreOption.nMaxSnapshotsPerDRVM ||
									$scope.model.diskRestoreOption.nMaxSnapshotsPerDRVM === 0
								) {
									$scope.model.diskRestoreOption.nMaxSnapshotsPerDRVM =
										$scope.initModel.diskRestoreOption.advancedRestoreOptions &&
										$scope.initModel.diskRestoreOption.advancedRestoreOptions.length > 0
											? $scope.initModel.diskRestoreOption.advancedRestoreOptions[0].nMaxSnapshotsPerDRVM
											: 0;
								}

								// convert enums to numbers
								if (
									$scope.model.diskRestoreOption &&
									$scope.model.diskRestoreOption.transportMode &&
									$scope.model.diskRestoreOption.transportMode.length > 1
								) {
									$scope.model.diskRestoreOption.transportMode = parseInt(
										cvUtil.lookupEnumConstant($scope.initModel.diskRestoreOption.transportMode.toUpperCase(), 'value')
									);
									$scope.model.diskRestoreOption.diskOption = parseInt(
										cvUtil.lookupEnumConstant($scope.initModel.diskRestoreOption.diskOption, 'value')
									);
								}
							} else {
								$scope.resetDefaultVMWAdvanceOptions();
							}
						}
					};

					// User need to confirm when they are changing new target which can cause override options being reseted SP13
					$scope.confirmSelectNewTarget = function() {
						if (!$scope.model.target) {
							return; // User select nothing!
						}

						// Select new target when user choose to continue. Reset override options based on new target
						if ($scope.ctrl && $scope.ctrl.newTargetSelected) {
							$scope.ctrl.newTargetSelected($scope.model.target);
						}
						if ($scope.newTargetCreated) {
							$scope.showProxySelect = $scope.replicationType !== 'LiveSyncIO';
							$scope.newTargetCreated = false;
						} else if (enableSimplifiedLiveSync) {
							$scope.showProxySelect = !['LiveSync'].includes($scope.replicationType);
						} else {
							$scope.showProxySelect = $scope.replicationType !== 'LiveSyncIO';
						}

						if (
							!$scope.preSelectTarget ||
							($scope.preSelectTarget &&
								$scope.preSelectTarget.entity.vmAllocPolicyId &&
								$scope.preSelectTarget.entity.vmAllocPolicyId != $scope.model.target.entity.vmAllocPolicyId)
						) {
							// If user select new target
							broadcastProxy($scope.model.target.entity.vmAllocPolicyType, $scope.model.target.destinationHyperV);
							$scope.preSelectTarget = $scope.model.target;
							if ($scope.showAdvanceOptionsVMWare) {
								$scope.setDefaultRestoreOptions(!!($scope.replicationGroup && !$scope.replicationGroup.editMode));
							}
						}
					};

					if ($scope.initModel) {
						// When it is in Edit mode and Going Back
						var destinationVendor = $scope.initModel.destinationVendor;
						$scope.showAdvanceOptionsVMWare = $scope.initModel ? $scope.initModel.showVMWareAdvanceOptions : false;
						if (!angular.isDefined($scope.initModel.targetId)) {
							$scope.initModel.targetId = $scope.initModel.allocationPolicy
								? $scope.initModel.allocationPolicy.vmAllocPolicyId
								: null;
						}
						if (
							$scope.initModel.target &&
							$scope.initModel.target.entity &&
							$scope.initModel.target.entity.vmAllocPolicyType
						) {
							showAdvanceOptionsBasedOnTarget($scope.initModel.target.entity);
						} else if (destinationVendor) {
							showAdvanceOptionsBasedOnTarget(null, destinationVendor);
						}
					} else {
						$scope.initModel = {
							showTarget: true
						};
					}

					if (
						!$scope.replicationGroup ||
						!$scope.replicationGroup.allTargets ||
						!$scope.replicationGroup.allTargets.length
					) {
						// fetch replication targets when it first load the screen
						$scope.serverMessage = cvUtil.emptyMsg();
						$scope.targets = [
							{
								vmAllocPolicyName: cvLoc('Loading'),
								disableSelection: true,
								loading: true
							}
						];
						restoreService
							.getReplicationTargets(POLICY_APP_TYPE.REPLICATION, $scope.replicationType)
							.success(function(data) {
								if (data.length) {
									$scope.allTargets = filterTarget(data);
									$scope.setAvailableTargets();

									// set initial value
									if ($scope.initModel) {
										// set initial value
										if (angular.isDefined($scope.initModel.targetId)) {
											getSelectedTarget();
										}
									} else {
										// 0 for create target and 1 for group
										if ($scope.targets.length > 2) {
											$scope.targets[2].selected = true;
											$scope.model.target = {
												entity: {
													vmAllocPolicyName: $scope.targets[2].vmAllocPolicyName,
													vmAllocPolicyId: $scope.targets[2].vmAllocPolicyId,
													vmAllocPolicyType: $scope.targets[2].vmAllocPolicyType
												},
												targetInfo: {
													destinationHyperV: $scope.targets[2].destinationHyperV
												}
											};
											$scope.model.target.isDestinationSameAsSource = isDestinationVMOneOfSourceVMs(
												$scope.targets[2].destinationHyperV,
												$scope.targets[2].vmNameEditString
											);
										}
									}
								} else {
									$scope.targets = [];
								}
							})
							.error(function(err) {
								$scope.serverMessage = cvUtil.errMsg(err ? err : cvLoc('generic_error'));
								$scope.targets = [
									{
										vmAllocPolicyName: cvLoc('label.noDataAvailable'),
										selected: false,
										disabled: true
									}
								];
							});
					} else {
						$scope.targets = $scope.replicationGroup.allTargets;
						getSelectedTarget();
					}

					/**
					 * isteven code
					 */
					$scope.localLang = cvUtil.getIStevenLocLabels();
					$scope.loadLibraries = function(serverId) {
						$scope.selectedTargets = [];

						$scope.parseIStevenOutput = function() {
							$scope.validateISteven();
							$scope.selectedTargets = $scope.targets.filter(function(el) {
								return el.selected;
							});

							if ($scope.selectedTargets.length) {
								$scope.model.target = {
									entity: {
										vmAllocPolicyName: $scope.selectedTargets[0].vmAllocPolicyName,
										vmAllocPolicyId: $scope.selectedTargets[0].vmAllocPolicyId,
										vmAllocPolicyType: $scope.selectedTargets[0].vmAllocPolicyType
									},
									destinationHyperV: $scope.selectedTargets[0].destinationHyperV,
									isDestinationSameAsSource: isDestinationVMOneOfSourceVMs(
										$scope.selectedTargets[0].destinationHyperV,
										$scope.selectedTargets[0].vmNameEditString
									),
									targetInfo: {
										destinationHyperV: $scope.selectedTargets[0].destinationHyperV
									}
								};

								if ($scope.model.target.entity.vmAllocPolicyType === VENDORS.AMAZON.policyType) {
									$scope.model.target.entity.selectedAvailabilityZone = $scope.selectedTargets[0].availabiltyZone
										? $scope.selectedTargets[0].availabiltyZone
										: '';
									//								$scope.model.target.entity.selectedAmazonBucket = $scope.selectedTargets[0].dataStores?$scope.selectedTargets[0].dataStores:'';
									//								$scope.$broadcast('loadAmazonBuckets', editMode, $scope.selectedTargets[0].destinationHyperV, null, $scope.selectedTargets[0].availabiltyZone, null, $scope.selectedTargets[0].dataStores);
								}

								if ($scope.replicationGroup) {
									$scope.replicationGroup.selectedProxy = [$scope.selectedTargets[0].proxyClientEntity];
								}
								showAdvanceOptionsBasedOnTarget($scope.model.target.entity);
								$scope.initModel.targetErrorMessage = null;
								$scope.filterCopyDetails($scope.model.target);
							} else {
								$scope.model.target = null;
							}
							$scope.confirmSelectNewTarget();
						};

						$scope.validateISteven = function() {
							return $scope.selectedTargets.length > 0;
						};
					};
					$scope.loadLibraries();
					$scope.showAddReplicationTarget = function() {
						var vendor =
							$scope.replicationGroup && $scope.replicationGroup.selectedHypervisor
								? $scope.replicationGroup.selectedHypervisor.type
								: null;
						var useAllocationPolicyForRestore = $scope.replicationGroup
							? $scope.replicationGroup.useAllocationPolicyForRestore
							: false;

						var restoreModal = replicationFactory.showAddReplicationTarget(
							null,
							$scope.initModel.destinationVendor,
							$scope.initModel.destinationHypervisor,
							$scope.replicationType,
							vendor,
							useAllocationPolicyForRestore
						);
						restoreModal.result.then(
							function(vmAllocPolicyId) {
								if ($scope.selectedTargets && $scope.selectedTargets[0]) {
									$scope.selectedTargets[0].selected = false;
									$scope.selectedTargets = [];
								}

								$scope.preSelectTarget = null;

								restoreService
									.getReplicationTargets(POLICY_APP_TYPE.REPLICATION, $scope.replicationType)
									.success(function(data) {
										$scope.allTargets = filterTarget(data);
										$scope.setAvailableTargets();
										$scope.newTargetCreated = true;
										// select the latest available target
										getSelectedTarget(vmAllocPolicyId);
									})
									.error(function(err) {
										$scope.serverMessage = cvUtil.errMsg(err ? err : cvLoc('generic_error'));
										$scope.targets = [
											{
												vmAllocPolicyName: cvLoc('label.noDataAvailable'),
												selected: false,
												disabled: true
											}
										];
									});
							},
							function() {
								// Cancel create new target
								$scope.targets[0].selected = false;
							}
						);
					};

					/**
					 * isteven code end
					 */

					$scope.setAvailableTargets = function() {
						// remove the storage pools used so far and push only which are remaining
						if (!$scope.targets) {
							$scope.targets = [];
						}

						let targetsMap = new Map();
						for (var i = 0; i < $scope.allTargets.length; i++) {
							var targetExists = false;
							// check target is used in any of the previous replication settings
							for (var k = 0; k < $scope.replications.length; k++) {
								var vmAllocPolicyId = $scope.replications[k].target
									? $scope.replications[k].target.entity.vmAllocPolicyId
									: $scope.replications[k].subTasks && $scope.replications[k].subTasks.length
									? $scope.replications[k].subTasks[0].options.restoreOptions.virtualServerRstOption.allocationPolicy
											.vmAllocPolicyId
									: 0;

								//check if the target is already assigned and it is not the same while editing
								if (
									vmAllocPolicyId === $scope.allTargets[i].entity.vmAllocPolicyId &&
									(!$scope.initModel || $scope.initModel.targetId != vmAllocPolicyId)
								) {
									targetExists = true;
									break;
								}
							}

							var restoreTargetModel = {
								restoreData: {}
							};

							restoreTargetModel.restoreData.datacenter = {
								dataCenterName: $scope.allTargets[i].dataCenter ? $scope.allTargets[i].dataCenter.dataCenterName : ''
							};
							if ($scope.allTargets[i].dataStores) {
								if ($scope.allTargets[i].dataStores[0].dataStoreName) {
									restoreTargetModel.restoreData.dataStores = [];
									restoreTargetModel.restoreData.dataStores.push({
										dataStoreName: $scope.allTargets[i].dataStores[0].dataStoreName
									});
								}
							}

							self.selectedAvailabilityZone = {
								displayName: $scope.allTargets[i].amazonPolicy
									? $scope.allTargets[i].amazonPolicy.availabilityZones
										? $scope.allTargets[i].amazonPolicy.availabilityZones[0].availabilityZoneName
										: ''
									: '',
								entity: {
									name: $scope.allTargets[i].amazonPolicy
										? $scope.allTargets[i].amazonPolicy.availabilityZones
											? $scope.allTargets[i].amazonPolicy.availabilityZones[0].availabilityZoneName
											: ''
										: ''
								}
							};
							if (!targetExists) {
								// When there is no replication group - it is plan creation - filter out AWS
								if (
									$scope.replicationGroup ||
									(!$scope.replicationGroup && $scope.allTargets[i].entity.policyType != VENDORS.AMAZON.policyType)
								) {
									self.editMode = true;
									let target = {
										vmAllocPolicyName: $scope.allTargets[i].entity.vmAllocPolicyName,
										vmAllocPolicyId: $scope.allTargets[i].entity.vmAllocPolicyId,
										vmAllocPolicyType: $scope.allTargets[i].entity.policyType
											? $scope.allTargets[i].entity.policyType
											: VENDORS.VMW.policyType,
										destinationHyperV: $scope.allTargets[i].destinationHyperV,
										vmNameEditString: $scope.allTargets[i].vmNameEditString,
										proxyClientEntity: $scope.allTargets[i].proxyClientEntity,
										availabiltyZone: self.selectedAvailabilityZone,
										dataStores: $scope.allTargets[i].dataStores
											? $scope.allTargets[i].dataStores[0]
											: { dataStoreName: '' },
										restoreTargetModel: restoreTargetModel,
										selected: false
									};
									let vendorTargets = [];
									let vmAllocPolicyType = isVMWareType(target.vmAllocPolicyType)
										? VENDORS.VMW.policyType
										: target.vmAllocPolicyType;
									if (targetsMap.has(vmAllocPolicyType)) {
										vendorTargets = targetsMap.get(vmAllocPolicyType);
									}
									vendorTargets.push(target);
									targetsMap.set(vmAllocPolicyType, vendorTargets);
								}
							}
						}

						if (targetsMap.size === 0) {
							$scope.targets = [
								{
									vmAllocPolicyName: cvLoc('label.noTargets'),
									disabled: true
								}
							];
						} else {
							$scope.targets = [];
							targetsMap.forEach((value, key, map) => {
								let targets = categorizeTargets(value, key);
								$scope.targets.push(...targets);
							});
						}

						if ($scope.replicationGroup) {
							$scope.replicationGroup.allTargets = $scope.targets; // Save all the targets loaded to the replication group parent
						}
					};

					function removeLoader(arrayObj) {
						let loadingIndex = arrayObj.findIndex(obj => (obj.loading = true));
						if (loadingIndex >= 0) {
							arrayObj.splice(loadingIndex, 1);
						}
					}

					function getVendorLabel(vendor) {
						var vendorLabel;
						if (VENDORS.MICROSOFT.type === vendor.toUpperCase()) {
							vendorLabel = 'ms';
						} else if (VENDORS.VMW.policyTypes.indexOf(vendor.toUpperCase()) >= 0) {
							vendorLabel = 'vmware';
						} else if (VENDORS.AZURE_V2.policyType === vendor) {
							vendorLabel = 'azure_v2';
						} else {
							vendorLabel = vendor.toLowerCase();
						}

						return cvLoc(`label.vendor.${vendorLabel}`);
					}

					function categorizeTargets(value, key) {
						var header = {
							vmAllocPolicyName: getVendorLabel(key),
							msGroup: true
						};
						var end = {
							msGroup: false
						};
						let targets = [];
						targets = targets.concat(header);
						targets = targets.concat(_.sortBy(value, 'vmAllocPolicyName'));
						targets = targets.concat(end);

						return targets;
					}

					if ($scope.ctrl) {
						$scope.ctrl.refresh = function() {
							$scope.setAvailableTargets();
							$scope.setDefaultRestoreOptions();
						};

						$scope.ctrl.refreshError = function() {
							$scope.serverMessage = cvUtil.emptyMsg();
						};

						$scope.ctrl.refreshCopyPrecedence = function(copyDetails) {
							$scope.copyDetails = angular.copy(copyDetails);
							if (copyDetails && copyDetails.storage) {
								// Set the model filteredCopyDetails to the drop down.
								$scope.filteredCopyDetails = angular.copy(copyDetails);
								if (!angular.isDefined($scope.initModel.copyPrecedence)) {
									// If no thing selected, choose the first one
									$scope.model.diskRestoreOption.copyPrecedence =
										$scope.filteredCopyDetails.storage.copy[0].copyPrecedence;
								} else {
									// choose the pre-selected when going back to Target
									$scope.model.diskRestoreOption.copyPrecedence = $scope.initModel.copyPrecedence;
								}

								$scope.initModel.copyPrecedence = $scope.model.diskRestoreOption.copyPrecedence;
							}
						};
					}

					//add transport modes
					$scope.transportModeTypes = collectionFactory.getTransportModeTypes();

					//add disk provision options
					$scope.diskProvisionOptions = restoreOptionFactory.getDiskProvisionOptions();

					//										// add custom option for schedules
					//										$scope.replicationSchedules.push({
					//											subTask : {
					//												subTaskName : cvLoc('label.custom'),
					//												subTaskId : -1
					//											}
					//										});

					if ($scope.storages.length) {
						$scope.model.source = $scope.storages[0].name;
					}

					if ($scope.replicationSchedules && $scope.replicationSchedules.length) {
						$scope.replicationScheduleUI = '';
						if (
							$scope.initModel &&
							$scope.initModel.replicationSchedule &&
							$scope.initModel.replicationSchedule.pattern.freq_type != 'After_Job_Completes'
						) {
							$scope.model.replicationSchedule = $scope.initModel.replicationSchedule;
							$scope.replicationScheduleUI = $scope.model.replicationSchedule.pattern.description;
							$scope.disableSchedule = true;
						} else {
							$scope.model.replicationSchedule = $scope.replicationSchedules[0];
							$scope.replicationScheduleUI = $scope.model.replicationSchedule.subTask.subTaskName;
						}
					}

					if ($scope.initModel) {
						var getSelectOption = function(arr, getField, valueToSelect, returnField) {
							for (var i = 0; i < arr.length; i++) {
								if (getField(arr[i]) === valueToSelect) {
									return returnField ? returnField(arr[i]) : arr[i];
								}
							}
						};

						// set initial value
						if ($scope.initModel.copyName) {
							$scope.model.source = getSelectOption(
								$scope.storages,
								function(obj) {
									return obj.id;
								},
								$scope.initModel.copyName,
								function(obj) {
									return obj.name;
								}
							);
						}

						// set initial value
						if ($scope.initModel.replicationScheduleId) {
							$scope.model.replicationSchedule = getSelectOption(
								$scope.replicationSchedules,
								function(obj) {
									return obj.subTask.subTaskId;
								},
								$scope.initModel.replicationScheduleId
							);
						}
					}

					//set default values for disk restore options
					$scope.setDefaultRestoreOptions();

					$scope.changeReplicationSchedule = function(selectedSchedule) {
						if (selectedSchedule.subTask.subTaskId == -1) {
							// custom
							scheduleUIFactory.addSchedule(
								{
									source: 'createProfile'
								},
								false,
								$scope.planSubType
							);
						}
					};

					var scheduleAddedDereg = $rootScope.$on('scheduleAdded', function(evt, addedSchedule, planId) {
						addedSchedule.repeat = {
							enabled: addedSchedule.repeatEnabled,
							duration: addedSchedule.repeatDuration,
							hrs: addedSchedule.repeatHrs,
							mins: addedSchedule.repeatMins,
							time: addedSchedule.repeatTime
						};

						var subTaskInfo = scheduleUIFactory.convertScheduleToSubTaskInfo(addedSchedule);

						// changing below values as required by backend
						subTaskInfo.subTask.operationType = 'SITE_REPLICATION';
						subTaskInfo.subTask.subTaskType = 'RESTORE';

						$scope.replicationSchedules.push(subTaskInfo);
						$scope.model.replicationSchedule = subTaskInfo;
					});

					/*
					 * Checks if the target policy type should be enabled by default. All the remaining are
					 * behind regkey.
					 */
					function isSimplifiedLiveSyncSupportedPolicyType(targetPolicyType) {
						return (
							targetPolicyType &&
							(isVMWareType(targetPolicyType) ||
								targetPolicyType === VENDORS.AMAZON.policyType ||
								targetPolicyType === VENDORS.AZURE_V2.policyType ||
								targetPolicyType === VENDORS.GOOGLE_CLOUD.policyType ||
								targetPolicyType === VENDORS.AZURE_STACK.policyType ||
								targetPolicyType === VENDORS.MICROSOFT.policyType)
						);
					}

					/*
					 * For PIT replications, SAN transport mode needs backend fix and the fix is not straight
					 * forward. Removing it from the UI, till the backend can handle it.
					 */
					function handleSANTransportModeVisibility(nMaxSnapshotsPerDRVM) {
						let sanTransportMode = collectionFactory.getSANTransportModeType() || {};
						if (nMaxSnapshotsPerDRVM > 0) {
							collectionFactory.splice($scope.transportModeTypes, sanTransportMode.id);
							if ($scope.model.diskRestoreOption.transportMode == sanTransportMode.id) {
								$scope.model.diskRestoreOption.transportMode = 0;
							}
						} else {
							let insertAt = 1;
							let valueToInert = sanTransportMode;
							collectionFactory.splice($scope.transportModeTypes, null, insertAt, valueToInert);
						}
					}
				}
			],
			link: function(scope, element, attrs, ngModelCtrl) {
				scope.$watch(
					'model',
					function(newValue) {
						ngModelCtrl.$setViewValue(newValue);
					},
					true
				);
			}
		};
	}
]);

// cvDeriveSettings wraps cvDeriveSelect elements binds the selects to a single object model
planModule.directive('cvDeriveSettings', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/deriveSettingsTemplate.jsp',
			transclude: true,
			scope: {
				disableSealInput: '=?',
				sealed: '=', // If sealed is true, the plan cannot be derived. The setting select elements will be hidden.
				model: '=',
				tooltipClass: '@?', // Allow css class to be passed because different plan pages use different css classes for page layout
				tooltipPlacement: '@?' // Corresponds to uib-tooltip setting: https://angular-ui.github.io/bootstrap/
			},
			controller: [
				'$scope',
				function($scope) {
					this.scope = $scope; // Expose scope so it is accessible by cvDeriveSelect

					// Wrap and negate $scope.sealed for binding to template
					$scope.unsealedObj = {
						value: !$scope.sealed
					};
					$scope.$watch('unsealedObj.value', function(value) {
						$scope.sealed = !value;
					});
					$scope.$watch('sealed', function(value) {
						$scope.unsealedObj.value = !value;
					});
				}
			]
		};
	}
]);

// Should be placed inside cvDeriveSettings.
planModule.directive('cvDeriveSelect', [
	function() {
		return {
			require: '^^cvDeriveSettings',
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/deriveSelectTemplate.jsp',
			transclude: true,
			scope: {
				name: '@', // The name of this select. Used to bind select to corresponding object in cvDeriveSettings model
				// Should correspond to a value in PlanEntities enum in Api.x
				groupWith: '@?', // The name of another cvDeriveSelect.
				// This will bind this select's value to the select specified by groupWith.
				// If groupWith is defined, this select will be hidden.
				label: '@?',
				labelHtml: '=?',
				labelClass: '@?', // Allow css classes to be passed because different plan pages use different css classes for page layout
				selectClass: '@?',
				class: '@?',
				editMode: '=?' // When in edit mode, 'Override required' option is disabled if the initial value is not 'Override required'
			},
			controller: [
				'$scope',
				'cvLoc',
				'OVERRIDE_OPTIONS',
				function($scope, cvLoc, OVERRIDE_OPTIONS) {
					const mustOption = {
						value: OVERRIDE_OPTIONS.MUST,
						label: cvLoc('label.overrideOptions.must'),
						disabled: false
					};
					const optionalOption = {
						value: OVERRIDE_OPTIONS.OPTIONAL,
						label: cvLoc('label.overrideOptions.optional'),
						disabled: false
					};
					const notAllowedOption = {
						value: OVERRIDE_OPTIONS.NOT_ALLOWED,
						label: cvLoc('label.overrideOptions.notAllowed'),
						disabled: false
					};
					$scope.overrideOptions = [mustOption, optionalOption, notAllowedOption];
					$scope.overrideOptionLabels = {};
					$scope.overrideOptionLabels[OVERRIDE_OPTIONS.MUST] = cvLoc('label.overrideOptions.must');
					$scope.overrideOptionLabels[OVERRIDE_OPTIONS.OPTIONAL] = cvLoc('label.overrideOptions.optional');
					$scope.overrideOptionLabels[OVERRIDE_OPTIONS.NOT_ALLOWED] = cvLoc('label.overrideOptions.notAllowed');

					/**
					 * @param {string}
					 *            val
					 * @returns {boolean} true if val is a valid override option. false otherwise
					 */
					$scope.isValidOverrideOption = function(val) {
						return $scope.overrideOptions.some(function(option) {
							return option.value === val;
						});
					};

					/**
					 * Gets the object in the parentScope.model that corresponds to the select's name and
					 * returns its overrideEntity property.
					 *
					 * @return {(string|undefined)} This select's value.
					 */
					$scope.getValue = function() {
						if ($scope.parentScope.model === undefined) {
							return undefined;
						}
						if ($scope.parentScope.model[$scope.name] === undefined) {
							// Initialize property if it is undefined
							$scope.parentScope.model[$scope.name] = {};
						}
						return $scope.parentScope.model[$scope.name].overrideEntity;
					};

					/**
					 * Gets the object in the parentScope.model that corresponds to the select's name and sets
					 * its overrideEntity property to value.
					 *
					 * @param {string}
					 *            value - The derive setting
					 */
					$scope.setValue = function(value) {
						if ($scope.parentScope.model === undefined) {
							return;
						}
						if ($scope.parentScope.model[$scope.name] === undefined) {
							// Initialize property if it is undefined
							$scope.parentScope.model[$scope.name] = {};
						}
						$scope.parentScope.model[$scope.name].overrideEntity = value;
					};

					$scope.initialize = function() {
						if (!$scope.isValidOverrideOption($scope.getValue())) {
							// If the value of this select is invalid, default to 'Optional'
							$scope.setValue(OVERRIDE_OPTIONS.OPTIONAL);
						}
						$scope.overrideOptions.forEach(option => {
							option.disabled = false;
						});
						if ($scope.editMode) {
							const currentValue = $scope.getValue();
							// While editing, override restriction may not be changed to 'Override required' from a different value:
							if (currentValue === OVERRIDE_OPTIONS.OPTIONAL || currentValue === OVERRIDE_OPTIONS.NOT_ALLOWED) {
								mustOption.disabled = true;
							}
						}
						if ($scope.groupWith) {
							// Hide this select and bind its value to the select specified by groupWith
							$scope.hidden = true;
							if ($scope.parentScope.model !== undefined) {
								if ($scope.parentScope.model[$scope.groupWith] === undefined) {
									// Initialize the parent model if it is undefined
									$scope.parentScope.model[$scope.groupWith] = {};
								}
								$scope.setValue($scope.parentScope.model[$scope.groupWith].overrideEntity);
							}
						}
					};

					$scope.$watch('parentScope.model', function() {
						$scope.initialize();
					});
					if ($scope.groupWith) {
						$scope.$watch('parentScope.model["' + $scope.groupWith + '"].overrideEntity', function(value) {
							$scope.setValue(value);
						});
					}
				}
			],
			link: {
				pre: function(scope, elem, attr, parentCtrl) {
					// Attach parent scope to current scope
					scope.parentScope = parentCtrl.scope;
				}
			}
		};
	}
]);

// Derive tile for profileDetails
planModule.directive('cvDeriveComponent', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/deriveComponentTemplate.jsp',
			scope: {
				sealed: '=', // If sealed is true, the plan cannot be derived.
				settings: '=',
				showEdit: '=',
				planId: '=',
				basePlan: '=?', // Base plan object containing name and url of the base plan
				onEdit: '=?',
				onOverrideUpdate: '=?'
			},
			controller: [
				'$scope',
				'$uibModal',
				'profileService',
				function($scope, $modal, profileService) {
					$scope.isDerived = !!$scope.basePlan; // If basePlan is defined, isDerived is true
					$scope.$watch('basePlan', function(value) {
						$scope.isDerived = !!value; // If basePlan is defined, isDerived is true
					});

					function refreshBasePlanLink() {
						if ($scope.basePlan) {
							profileService.getProfileDetails($scope.basePlan.id).then(
								function() {
									$scope.basePlan.url = '#profileDetails/' + $scope.basePlan.id;
									$scope.basePlan.viewable = true;
								},
								function() {
									$scope.basePlan.url = '';
									$scope.basePlan.viewable = false;
								}
							);
						}
					}
					$scope.$watch('basePlan.id', refreshBasePlanLink);
					if ($scope.isDerived) {
						refreshBasePlanLink();
					}

					/**
					 * Opens a modal to modify the override restrictions
					 */
					$scope.modifyOverrideRestrictions = function() {
						$modal
							.open({
								templateUrl: appUtil.appRoot + 'modules/plan/partials/editDeriveSettings.jsp',
								backdrop: 'static',
								resolve: {
									isSealed: () => $scope.sealed,
									settings: () => $scope.settings,
									planId: () => $scope.planId,
									onOverrideUpdate: () => $scope.onOverrideUpdate
								},
								controller: [
									'$scope',
									'$uibModalInstance',
									'profileService',
									'OVERRIDE_OPTIONS',
									'planId',
									'isSealed',
									'settings',
									'onOverrideUpdate',
									(
										$scope,
										$modalInstance,
										profileService,
										OVERRIDE_OPTIONS,
										planId,
										isSealed,
										settings,
										onOverrideUpdate
									) => {
										// Copy settings so that they are unchanged if the user cancels
										$scope.model = {
											sealed: isSealed,
											settingsList: angular.copy(settings),
											settingsObj: {}
										};

										$scope.disableSealInput = !isSealed; // If already unsealed, the plan cannot be resealed

										// Convert settingsList to an object for use with cvDeriveSettings
										$scope.model.settingsList.forEach(function(setting) {
											$scope.model.settingsObj[setting.deriveKey] = setting.model;
										});

										$scope.saveDeriveSettings = function() {
											// Format data for api:
											const inheritanceRules = {
												isSealed: $scope.model.sealed,
												enforcedEntities: [],
												enforcedEntitiesOperationType: 'OVERWRITE',
												privateEntities: [],
												privateEntitiesOperationType: 'OVERWRITE'
											};

											if (inheritanceRules.isSealed) {
												// Plans cannot be resealed, do nothing
												$modalInstance.dismiss();
												return;
											}

											$scope.model.settingsList.forEach(function(setting) {
												if (setting.model.overrideEntity === OVERRIDE_OPTIONS.NOT_ALLOWED) {
													// Enforced entities are entities that cannot be overridden by derived plans
													inheritanceRules.enforcedEntities.push(setting.deriveKey);
													if (setting.deriveKey === 'SubclientArcRulesWin') {
														inheritanceRules.enforcedEntities.push('SubclientArcRulesLin');
													}
												} else if (setting.model.overrideEntity === OVERRIDE_OPTIONS.MUST) {
													// Private entities are entities that must be overridden by derived plans
													inheritanceRules.privateEntities.push(setting.deriveKey);
													if (setting.deriveKey === 'SubclientArcRulesWin') {
														inheritanceRules.privateEntities.push('SubclientArcRulesLin');
													}
												}
											});
											// If the list is empty, use CLEAR instead:
											if (inheritanceRules.enforcedEntities.length === 0) {
												inheritanceRules.enforcedEntitiesOperationType = 'CLEAR';
											}
											if (inheritanceRules.privateEntities.length === 0) {
												inheritanceRules.privateEntitiesOperationType = 'CLEAR';
											}

											profileService.editInheritanceRules(planId, JSON.stringify(inheritanceRules)).then(
												data => {
													$modalInstance.close({ model: $scope.model, plan: _.get(data, 'data.plan') });
												},
												e => {
													$scope.editDeriveSettingsMessage = {
														message: e.data,
														type: 'error'
													};
												}
											);
										};

										$scope.cancel = function() {
											$modalInstance.dismiss();
										};
									}
								]
							})
							.result.then(result => {
								$scope.sealed = _.get(result, 'model.sealed');
								let showDerived = true;
								const planRestrictions = _.get(result, 'plan.summary.restrictions');
								$scope.settings.forEach(setting => {
									setting.model.overrideEntity = _.get(result, 'model.settingsObj[setting.deriveKey].overrideEntity');
								});
								if ($scope.settings.every(ele => ele.model.overrideEntity === 'NotAllowed')) showDerived = false;
								if (_.isFunction($scope.onOverrideUpdate)) {
									$scope.onOverrideUpdate(showDerived, planRestrictions);
								}

								if (_.isFunction($scope.onEdit)) {
									$scope.onEdit({
										sealed: $scope.sealed,
										settings: $scope.settings
									});
								}
							});
					};

					/**
					 * Opens a modal to modify the derive settings
					 */
					$scope.modifyDeriveSettings = function() {
						$modal.open({
							templateUrl: appUtil.appRoot + 'modules/plan/partials/editOverrideSettings.jsp',
							backdrop: 'static',
							controller: [
								'$scope',
								'$q',
								'$uibModalInstance',
								'profileService',
								'OVERRIDE_OPTIONS',
								'parentScope',
								function($scope, $q, $modalInstance, profileService, OVERRIDE_OPTIONS, parentScope) {
									$scope.messages = []; // Used for display server messages
									$scope.model = {
										settingsList: angular.copy(parentScope.settings),
										settingsObj: {}
									};
									// Convert settingsList to an object
									$scope.model.settingsList.forEach(function(setting) {
										$scope.model.settingsObj[setting.overrideKey] = setting.model;
									});

									// Convert original settings array into an object:
									$scope.originalObj = {};
									parentScope.settings.forEach(function(setting) {
										$scope.originalObj[setting.overrideKey] = setting.model;
									});

									$scope.model.settingsList.forEach(function(setting) {
										if (
											setting.model.overrideEntity === OVERRIDE_OPTIONS.NOT_ALLOWED ||
											setting.model.overrideEntity === OVERRIDE_OPTIONS.MUST
										) {
											// Disable checkboxes for settings whose overrideEntity property
											// is 'NotAllowed' or 'Must'
											setting.disabled = true;
										} else {
											setting.disabled = false;
										}
									});

									$scope.saveOverrideSettings = function() {
										var requests = [];
										var errors = [];
										$scope.model.settingsList.forEach(function(setting) {
											if ($scope.originalObj[setting.overrideKey].definesEntity === setting.model.definesEntity) {
												// No change in seting, do nothing
												return;
											}
											var request;
											if (setting.model.definesEntity) {
												// No longer inheriting entity. Create it
												// TODO nsicoco define new entity. Implement when api is ready
												request = null;
											} else {
												// No longer defining entity. Delete it
												request = profileService.deleteEntity(parentScope.planId, setting.deriveKey).then(
													function() {
														// On success, save
														$scope.originalObj[setting.overrideKey].definesEntity = setting.model.definesEntity;
													},
													function(e) {
														// On error, revert
														setting.model.definesEntity = $scope.originalObj[setting.overrideKey].definesEntity;
														errors.push({
															setting: setting,
															error: e
														});
													}
												);
											}
											requests.push(request);
										});
										$q.all(requests).then(function() {
											if (errors.length > 0) {
												// Display errors
												$scope.messages = errors;
											} else {
												// Dismiss modal only if there are no errors
												$modalInstance.dismiss();
											}
										});

										// var obj = {};
										// $scope.model.settingsList.forEach(function(setting) {
										// 	obj[setting.overrideKey] = setting.model;
										// });

										// profileService.editDefinesEntities({
										// 	planId : parentScope.planId,
										// 	overrideSettings : JSON.stringify(obj)
										// }).success(function() {
										// 	// On success, copy new settings back to ui
										// 	parentScope.settings.forEach(function(parentSetting) {
										// 		parentSetting.model.definesEntity = $scope.model.settingsObj[parentSetting.overrideKey].definesEntity;
										// 	});
										// 	$modalInstance.dismiss();
										// }).error(function(e) {
										// 	$scope.editOverrideSettingsMessage = {
										// 		message : e,
										// 		type : 'error'
										// 	};
										// });
									};

									$scope.cancel = function() {
										$modalInstance.dismiss();
									};
								}
							],
							resolve: {
								parentScope: function() {
									return $scope;
								}
							}
						});
					};
				}
			]
		};
	}
]);

planModule.directive('cvDerivableInputToggle', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/derivableInputToggle.jsp',
			replace: true,
			scope: {
				deriveSetting: '=', // Must be equal to 'Must', 'Optional', or 'NotAllowed'. Defaults to 'Optional' otherwise
				model: '=',
				toggleClass: '@?', // Allow css class to be passed because different plan pages use different css classes for page layout
				helpTextClass: '@?'
			},
			controller: [
				'$scope',
				'OVERRIDE_OPTIONS',
				function($scope, OVERRIDE_OPTIONS) {
					function initialize() {
						if ($scope.deriveSetting === OVERRIDE_OPTIONS.MUST) {
							// If derive setting is 'Must', the toggle is always checked
							$scope.model = true;
						} else if ($scope.deriveSetting === OVERRIDE_OPTIONS.NOT_ALLOWED) {
							// If derive setting is 'NotAllowed', the toggle is always unchecked
							$scope.model = false;
						} else {
							$scope.model = !!$scope.model; // Convert to boolean
						}

						// Toggle should be disabled if the derive setting is 'Must' or 'NotAllowed'
						$scope.disableToggle =
							$scope.deriveSetting === OVERRIDE_OPTIONS.MUST || $scope.deriveSetting === OVERRIDE_OPTIONS.NOT_ALLOWED;
					}
					initialize();
					$scope.$watch('deriveSetting', initialize); // Reinitialize if the setting changes

					// Wrap $scope.model for two-way binding
					$scope.modelWrapper = {
						value: $scope.model
					};
					$scope.$watch('modelWrapper.value', function(value) {
						$scope.model = value;
					});
					$scope.$watch('model', function(value) {
						$scope.modelWrapper.value = value;
					});
				}
			]
		};
	}
]);

// Any element wrapped by cvDerivableInput will become disabled/enabled according to overrideBase.
// Should be used in conjunction with cvDerivableInputToggle.
// Any <a> elements that should remain enabled must be given the class 'always-enabled'
planModule.directive('cvDerivableInput', [
	function() {
		return {
			restrict: 'AE',
			transclude: true,
			template: '<fieldset class="toggle-inner-links" data-ng-disabled="!overrideBase" data-ng-transclude></fieldset>',
			scope: {
				overrideBase: '='
			}
		};
	}
]);

planModule.directive('cvPlanStoragePool', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'common/partials/cvPlanStoragePoolTile.jsp',
			scope: {
				profileDetails: '=',
				masterProfile: '=',
				planSubType: '=',
				overrideText: '=?',
				storageType: '@', // used for log storage in database plan
				showEdit: '=',
				isTabSet: '=?',
				allowRuleEdit: '=?',
				allowManyStorages: '=?', // if showSource is true then this is true
				showSource: '@', // only VSA plan need to show source column
				title: '=?',
				repGrp: '=?',
				ctrl: '=?'
			},
			controller: [
				'$scope',
				'$uibModal',
				'storageService',
				'cvTableOptions',
				'cvLoc',
				'cvUtil',
				'restoreService',
				'$state',
				'$dialogs',
				'cvToaster',
				function(
					$scope,
					$modal,
					storageService,
					cvTableOptions,
					cvLoc,
					cvUtil,
					restoreService,
					$state,
					$dialogs,
					cvToaster
				) {
					var parentScope = $scope.$parent;
					$scope.showSource = angular.isDefined($scope.showSource) ? true : false;
					$scope.title = $scope.title || cvLoc('label.plan.storageAndRetention');
					$scope.retentionLabel = cvLoc('label.retentionDays');
					$scope.isTabSet = $scope.isTabSet ? $scope.isTabSet : false;
					$scope.showSnapshotCopy = _.get(cv, 'additionalSettings.AdminConsole.showSnapshotCopy', false);
					$scope.storagePoolTemplatePath = appUtil.appRoot + 'common/partials/cvPlanStoragePoolTemplate.jsp';
					if ($state.current.name === 'replicationGroupsDetailConfiguration') {
						$scope.repGrp = true;
						$scope.retentionLabel = cvLoc('label.longTermRetention');
					}

					if ($scope.showSnapshotCopy) {
						$scope.storageList = $scope.profileDetails.storage.copy;
					} else {
						$scope.storageList = $scope.profileDetails.storage.copy.filter(function(storageCopy) {
							if (storageCopy && storageCopy.isSnapCopy) {
								return storageCopy.isSnapCopy === 'SET_FALSE';
							} else {
								return true;
							}
						});
					}
					storageService
						.getAllStoragePools()
						.success(function(data) {
							$scope.storagePools = cvUtil.sortAscending(data, 'storagePoolEntity.storagePoolName');

							// Build up the map
							var storagePoolMap = {};
							var storagePolicyId =
								$scope.profileDetails &&
								$scope.profileDetails.storage &&
								$scope.profileDetails.storage.storagePolicy &&
								$scope.profileDetails.storage.storagePolicy.storagePolicyId
									? $scope.profileDetails.storage.storagePolicy.storagePolicyId
									: undefined;

							for (var i = 0; i < $scope.storageList.length; i++) {
								$scope.storageList[i].storagePolicyId = storagePolicyId;
								$scope.storageList[i].disabled = 'disabled';
								$scope.storageList[i].toolTipMSG = cvLoc('label.noStorageViewPermission');
								storagePoolMap[$scope.storageList[i].useGlobalPolicy.storagePolicyName] = $scope.storageList[i];
							}
							for (var j = 0; j < $scope.storagePools.length; j++) {
								var current_pool = $scope.storagePools[j].storagePoolEntity.storagePoolName;
								if (storagePoolMap[current_pool] != undefined) {
									storagePoolMap[current_pool].disabled = '';
									storagePoolMap[current_pool].toolTipMSG = '';
									storagePoolMap[current_pool].poolType = $scope.storagePools[j].storagePoolType;
									if (storagePoolMap[current_pool].poolType == 'SECONDARY_COPY') {
										storagePoolMap[current_pool].poolURL = 'tapeStoragePoolInfo';
									} else {
										storagePoolMap[current_pool].poolURL = 'diskStoragePoolInfo';
									}
								}
							}
						})
						.error(function(e) {
							$scope.serverMessage = cvUtil.errMsg(e);
						});

					if ($scope.planSubType) {
						if ($scope.planSubType === 'Laptop') {
							$scope.retentionLabel = cvLoc('label.retentionPeriod');
						} else if ($scope.planSubType === 'Database') {
							$scope.title = cvLoc('label.dataStoragePool');
						}
					}

					if ($scope.storageType && $scope.storageType === 'Log') {
						$scope.storageList = $scope.profileDetails.database.storageLog.copy;
						$scope.title = cvLoc('label.logStoragePool');
					}

					//assign index for edit and delete
					$scope.storageList.forEach(function(storage, index) {
						storage.index = index;

						//convert storage pool property for tape storage pool
						if (storage.globalAuxCopy) {
							storage.useGlobalPolicy = storage.globalAuxCopy;
						}
					});

					$scope.enableDisableRules = function() {
						$scope.allowRuleEdit = !$scope.allowRuleEdit;
						$scope.ruleStatus = $scope.allowRuleEdit ? 'enabled-activity' : 'disabled-activity';
						parentScope.toggleRuleEdit(); // using function because because could not get hold of parent scope variable because of transclusion
					};

					/* GRID CONTSTRUCTION */
					var globalStorageGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

					// If target copy has been referenced in any other copy.
					var alreadySourceExists = function(target) {
						for (var i = 0; i < $scope.profileDetails.storage.copy.length; i++) {
							var sourceCopy = $scope.profileDetails.storage.copy[i].sourceCopy;
							var storagePolicyCopy = $scope.profileDetails.storage.copy[i].StoragePolicyCopy;
							if (
								sourceCopy &&
								target.StoragePolicyCopy.copyId !== storagePolicyCopy.copyId &&
								target.StoragePolicyCopy.copyName === sourceCopy.copyName
							) {
								return true;
							}
						}
						return false;
					};

					// When :  we click on delete storage
					// Result: Storage target linked to a replication will also be removed
					var _taskInfo = null;
					var _target = null;
					var replicationTargetExists = function(target) {
						var taskInfo = $scope.profileDetails.replicationTargets.taskInfo;
						if (taskInfo) {
							for (var i = 0; i < taskInfo.length; i++) {
								if (taskInfo[i].subTasks) {
									for (var j = 0; j < taskInfo[i].subTasks.length; j++) {
										var subTask = taskInfo[i].subTasks[j];
										var restoreOptions = subTask.options.restoreOptions;
										var copyName = restoreOptions.storagePolicy.copyName;
										if (copyName === target.StoragePolicyCopy.copyName) {
											_taskInfo = taskInfo[i];
											return true;
										}
									}
								}
							}
						}
						return false;
					};

					var callbackFunctions = {
						noFunction: function() {
							return;
						},
						yesFunction: function() {
							$scope.listOperation = 'DELETE';
							if ($scope.repGrp && _target.isDefault !== 'SET_TRUE') {
								/* 
									If this step has reached, it implies that the Secondary copy is the replication copy, in which case, perform the following:
									- Change the replication copy to Primary
									- Delete the Secondary copy
								 */
								$scope.ctrl.updateReplicationCopyToPrimary().then(function() {
									_deleteStorage(_target);
								});
								return;
							} else if (!_deleteStorage(_target)) {
								return;
							}
							restoreService
								.addReplication({
									taskInfoList: angular.toJson([_taskInfo]),
									planId: $scope.profileDetails.summary.plan.planId,
									operation: $scope.listOperation
								})
								.success(function(data) {
									//$state.forceReload();
								})
								.error(function(e) {
									$scope.serverMessage = cvUtil.errMsg(e);
								});
						}
					};

					var delteStorageCallbackFunctions = {
						noFunction: function() {
							return;
						},
						yesFunction: function() {
							_deleteStorage(_target);
						}
					};

					var _deleteStorage = function(target) {
						if (alreadySourceExists(target)) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: cvLoc('error.alreadySourceStorageExists')
							});
							return false;
						} else if ($scope.storageList.length <= 1) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: cvLoc('error.lastStorage')
							});
							return false;
						} else {
							$scope.listOperation = 'DELETE';

							if (target.StoragePolicyCopy) {
								target.StoragePolicyCopy.storagePolicyId =
									$scope.storageType && $scope.storageType === 'Log'
										? $scope.profileDetails.database.storageLog.storagePolicy.storagePolicyId
										: $scope.profileDetails.storage.storagePolicy.storagePolicyId;
							}

							restoreService
								.addStorage({
									policyCopy: angular.toJson(target),
									operation: $scope.listOperation
								})
								.success(function(data) {
									$state.forceReload();
								})
								.error(function(e) {
									cvToaster.showErrorMessage({
										ttl: '10000', //10 sec
										message: e
									});
								});
							return true;
						}
					};

					$scope.deleteStorage = function(target) {
						if ($scope.profileDetails.replicationTargets && replicationTargetExists(target)) {
							let warning = cvLoc('warn.deletingReplication');
							/* If the secondary copy is the replication copy when deleting from the replication group page, show a more relevant warning. */
							if ($scope.repGrp && target.isDefault !== 'SET_TRUE') {
								warning = cvLoc('warn.deleteSecondaryReplicationCopyInRepGrp');
							}
							$dialogs.confirm(cvLoc('action.delete'), warning, callbackFunctions);
							_target = target;
						} else {
							_target = target;
							$dialogs.confirm(cvLoc('action.delete'), cvLoc('warn.deleteStorage'), delteStorageCallbackFunctions);
						}
					};
					if (!$scope.profileDetails.storage) {
						$scope.profileDetails.storage = {
							copy: []
						};
					}
					angular.extend(globalStorageGridOptions, {
						data: $scope.storageList,
						enableGridMenu: false,
						columnDefs: [
							{
								field: 'StoragePolicyCopy.copyName',
								displayName: cvLoc('label.name'),
								enableHiding: false,
								cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
							},
							{
								field: 'useGlobalPolicy.storagePolicyName',
								displayName: cvLoc('label.storagePool'),
								cellTemplate:
									'<span data-uib-tooltip="{{row.entity.toolTipMSG}}"><a class="{{row.entity.disabled}} crop" href="#{{row.entity.poolURL}}?storagePoolName={{row.entity.useGlobalPolicy.storagePolicyName | encodeParam}}&storagePoolId={{row.entity.useGlobalPolicy.storagePolicyId}}&storagePoolType={{row.entity.poolType}}">{{row.entity.useGlobalPolicy.storagePolicyName}}</a></span>'
							},
							{
								field: 'retentionRules.retainBackupDataForDays',
								displayName: $scope.retentionLabel,
								cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}} days</span>',
								cellTemplate:
									'<span class="crop" title="{{COL_FIELD}}" data-ng-if="row.entity.retentionRules.retainBackupDataForDays > 0 ">' +
									cvLoc('label.retentionPeriodDays', '{{COL_FIELD}}') +
									'</span>' +
									'<span data-ng-if="row.entity.retentionRules.retainBackupDataForDays === 0">' +
									cvLoc('label.notSet') +
									'</span>' +
									'<span data-ng-if="row.entity.retentionRules.retainBackupDataForDays === -1">' +
									cvLoc('label.infinite') +
									'</span>',
								visible: $scope.planSubType != 'Laptop'
							},
							{
								field: 'sourceCopy.copyName',
								displayName: cvLoc('label.source'),
								cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>',
								visible: $scope.showSource
							},
							{
								name: 'action',
								displayName: cvLoc('label.actions'),
								enableHiding: false,
								enableFiltering: false,
								visible: $scope.showEdit,
								enableSorting: false,
								cellTemplate:
									'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>\
																<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
																<li><a class="ui-grid-action-items" ng-click="grid.appScope.editStorage(row.entity, grid.appScope.showSource,row.entity.index)">' +
									cvLoc('action.edit') +
									'</a></li>\
																<li><a class="ui-grid-action-items" ng-click="grid.appScope.deleteStorage(row.entity)">' +
									cvLoc('action.delete') +
									'</a></li></ul></div>',
								width: '20%'
							}
						]
					});

					if ($scope.showSnapshotCopy) {
						globalStorageGridOptions.columnDefs.splice(1, 0, {
							field: 'copyTypeName',
							displayName: cvLoc('label.copyType'),
							cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
						});
					}

					$scope.storageGridOptions = {
						cvHasTitle: false,
						cvTableName: 'vsaPlanStorageTable',
						cvIsSearchable: false,
						cvHasViews: false,
						cvServerMessage: 'storageGridServerMessage',
						gridOptions: globalStorageGridOptions
					};

					$scope.addStorageCopy = function() {
						$scope.addStorage(null, $scope.showSource);
					};

					$scope.editStorage = function(existingStorage, showSource, index) {
						$scope.addStorage(existingStorage, showSource).result.then(function(data) {
							$scope.storageList[index] = data;
						});
					};
					$scope.addStorage = function(existingStorage, showSource) {
						return $modal.open({
							templateUrl: appUtil.appRoot + 'modules/plan/partials/editVsaPlanStorage.jsp',
							backdrop: 'static',
							controller: [
								'$scope',
								'$uibModalInstance',
								'$state',
								'profileService',
								'cvUtil',
								'cvLoc',
								'restoreService',
								'profileDetails',
								'masterProfile',
								'storageType',
								'storageCopyFactory',
								function(
									$scope,
									$modalInstance,
									$state,
									profileService,
									cvUtil,
									cvLoc,
									restoreService,
									profileDetails,
									masterProfile,
									storageType,
									storageCopyFactory
								) {
									$scope.planSubtype = profileDetails.summary.subtype;
									$scope.storageList =
										storageType && storageType === 'Log'
											? profileDetails.database.storageLog.copy
											: profileDetails.storage.copy;
									$scope.showSource = showSource;
									$scope.profileDetails = profileDetails;
									$scope.model = {};
									$scope.storagePolicy =
										storageType && storageType === 'Log'
											? profileDetails.database.storageLog.storagePolicy
											: profileDetails.storage.storagePolicy;
									$scope.storages = [];
									if ($scope.storageList && $scope.storageList.length > 0) {
										$scope.storages = $scope.storageList.map(function(obj) {
											return {
												name: obj.StoragePolicyCopy.copyName,
												id: obj.StoragePolicyCopy.copyId,
												storagePool: {
													storagePoolEntity: obj.useGlobalPolicy
												},
												retentionPeriod: obj.retentionRules.retainBackupDataForDays,
												copyType: obj.copyType
											};
										});
									}

									$scope.storagePolicyCopyInfo = existingStorage;
									$scope.listOperation = 'ADD';
									if (existingStorage) {
										$scope.editMode = true;
										$scope.listOperation = 'OVERWRITE';

										$scope.initModel = {
											copyId: existingStorage.StoragePolicyCopy.copyId,
											storagePolicyId: existingStorage.storagePolicyId,
											overrideRetention: true,
											editMode: $scope.editMode,
											storagePool: {
												storagePoolEntity: {
													storagePoolId: existingStorage.useGlobalPolicy.storagePolicyId,
													storagePoolName: existingStorage.useGlobalPolicy.storagePolicyName
												},
												storagePoolType: existingStorage.poolType
											},
											isMirrorCopy: existingStorage.isMirrorCopy
										};
									}

									$scope.onCopyDetailsInit = function(data) {
										if ($scope.storageList && data.isDefault === 'SET_TRUE') {
											$scope.isPrimary = true;
										}
									};

									$scope.cancel = function() {
										$modalInstance.dismiss();
									};

									$scope.getSourceCopyId = function() {
										for (var i in $scope.storages) {
											if ($scope.storages[i].name === $scope.model.source) {
												return $scope.storages[i].id;
											}
										}
										return null;
									};

									$scope.saveStorage = function() {
										$scope.storagePolicyCopyInfo = {
											StoragePolicyCopy: {
												storagePolicyId: $scope.storagePolicy.storagePolicyId,
												copyName: $scope.model.storageName,
												storagePolicyName: $scope.storagePolicy.storagePolicyName,
												copyId: $scope.model.copyId
											},
											retentionRules: {
												retainBackupDataForDays: $scope.model.retentionPeriod
											},
											sourceCopy: {
												copyName: $scope.model.source
											},
											isDefault: $scope.model.isDefault
										};

										if ($scope.model.isSnapshotCopy) {
											$scope.storagePolicyCopyInfo.isSnapCopy = $scope.model.copyType == 0;
											$scope.storagePolicyCopyInfo.isMirrorCopy = $scope.model.copyType == 1;
										}

										// check if storagePoolType is tape
										//set retention as null if storage pool is tape
										if ($scope.model.storagePool.storagePoolType === 'SECONDARY_COPY') {
											$scope.storagePolicyCopyInfo.globalAuxCopy = {
												storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
												storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
											};

											if ($scope.model.overrideRetention) {
												$scope.storagePolicyCopyInfo.extendedFlags = {
													overRideGACPRetention: 'SET_TRUE'
												};
												//set infinite retention as -1
												if ($scope.model.infiniteSelected) {
													$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = -1;
												}
											} else {
												$scope.storagePolicyCopyInfo.extendedFlags = {
													overRideGACPRetention: 'SET_FALSE'
												};
												//$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = null;
											}
										} else {
											//set infinite retention as -1
											if ($scope.model.infiniteSelected) {
												$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = -1;
											}
											$scope.storagePolicyCopyInfo.useGlobalPolicy = {
												storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
												storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
											};
										}

										// do not populate id for primary copy as empty value cannot be parsed by server
										if (_.get($scope.storagePolicyCopyInfo, 'sourceCopy.copyName')) {
											$scope.storagePolicyCopyInfo.sourceCopy.copyId = $scope.getSourceCopyId();
										}

										storageCopyFactory.updateSelectiveCopyInfo($scope.model, $scope.storagePolicyCopyInfo);

										if (!storageCopyFactory.isExtendedRetentionValid($scope.model)) {
											return;
										} else {
											$scope.storagePolicyCopyInfo.retentionRules = Object.assign(
												$scope.storagePolicyCopyInfo.retentionRules,
												storageCopyFactory.getExtendedRetentionRules($scope.model)
											);
										}

										var request;
										var objToSend;
										if ($scope.isPrimary && $scope.planSubtype === 'Laptop') {
											// If plan type is laptop, FS, or Server, use the modify plan storage api instead of the edit storage policy api
											// in order to check plan inheritance rules properly
											objToSend = {
												id: $scope.profileDetails.summary.plan.planId,
												planType: $scope.planSubtype,
												isLogStorage: false,
												policyCopy: angular.toJson($scope.storagePolicyCopyInfo)
											};
											if ($scope.isPrimary) {
												objToSend.storage = JSON.stringify({
													primaryRetentionInDays: $scope.model.retentionPeriod
												});
											} else {
												objToSend.storage = JSON.stringify({
													primaryRetentionInDays: $scope.storageList[0].retentionRules.retainBackupDataForDays,
													secondaryRetentionInDays: $scope.model.retentionPeriod
												});
											}
											request = profileService.editPlanStorage(objToSend);
										} else {
											objToSend = {
												policyCopy: angular.toJson($scope.storagePolicyCopyInfo),
												operation: $scope.listOperation,
												storagePolicyId: 0,
												isLog: storageType && storageType === 'Log' ? true : false
											};
											if (objToSend.operation === 'ADD') {
												objToSend.storagePolicyId = $scope.storagePolicy.storagePolicyId;
												objToSend.storagePolicyName = $scope.storagePolicy.storagePolicyName;
											}

											request = restoreService.addStorage(objToSend);
										}

										request
											.success(function(data) {
												if ($scope.editMode) {
													existingStorage.StoragePolicyCopy.copyName =
														$scope.storagePolicyCopyInfo.StoragePolicyCopy.copyName;
													existingStorage.retentionRules.retainBackupDataForDays =
														$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays;
													// Update copyName in sourceCopies in other storages:
													angular.forEach($scope.storageList, storage => {
														if (
															storage.sourceCopy &&
															storage.sourceCopy.copyId === $scope.storagePolicyCopyInfo.StoragePolicyCopy.copyId
														) {
															storage.sourceCopy.copyName = $scope.storagePolicyCopyInfo.StoragePolicyCopy.copyName;
														}
													});
													if ($scope.showSource) {
														existingStorage.sourceCopy = $scope.storagePolicyCopyInfo.sourceCopy;
													}
													$modalInstance.close(existingStorage);
													$state.forceReload();
													/*
													 * if(existingStorage.retentionRules.retainBackupDataForDays
													 * === null) { $state.reload(); }
													 */
												}
												if (objToSend.operation === 'ADD') {
													$modalInstance.dismiss();
													$state.forceReload();
												}
											})
											.error(function(e) {
												$scope.serverMessage = cvUtil.errMsg(e);
											});
									};
								}
							],
							resolve: {
								profileDetails: function() {
									return $scope.profileDetails;
								},
								masterProfile: function() {
									return $scope.masterProfile;
								},
								storageType: function() {
									return $scope.storageType;
								}
							}
						});
					};
				}
			]
		};
	}
]);

planModule.directive('cvRuleStoragePool', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'dlo/partials/cvRuleStoragePoolTile.jsp',
			scope: {
				profileDetails: '=',
				masterProfile: '=?',
				planSubType: '=',
				overrideText: '=?',
				storageType: '@', // used for log storage in database plan
				showEdit: '=',
				isTabSet: '=?',
				allowRuleEdit: '=',
				allowManyStorages: '=', // if showSource is true then this is true
				showSource: '@', // only VSA plan need to show source column
				storagePools: '='
			},
			controller: [
				'$scope',
				'$uibModal',
				'storageService',
				'cvTableOptions',
				'cvLoc',
				'cvUtil',
				'restoreService',
				'$state',
				'$dialogs',
				'cvToaster',
				'planRuleFactory',
				'storagePoolTypesConstants',
				function(
					$scope,
					$modal,
					storageService,
					cvTableOptions,
					cvLoc,
					cvUtil,
					restoreService,
					$state,
					$dialogs,
					cvToaster,
					planRuleFactory,
					storagePoolTypesConstants
				) {
					var parentScope = $scope.$parent;
					$scope.showSource = angular.isDefined($scope.showSource) ? true : false;
					$scope.title = cvLoc('label.plan.storage');
					$scope.retentionLabel = cvLoc('label.retentionDays');
					$scope.isTabSet = $scope.isTabSet ? $scope.isTabSet : false;
					$scope.showSnapshotCopy = cvConfig.enableSnapCopy;
					let optimizeForInstantClone = _.get($scope.profileDetails, 'options.optimizeForInstantClone', undefined);
					let isDefaultCopyDistributedStorage = _.get(
						$scope.profileDetails,
						'storage.isDefaultCopyDistributedStorage',
						undefined
					);
					let storageList = [];
					$scope.showSource = true;

					if ($scope.showSnapshotCopy && $scope.planSubType !== 'Archiver') {
						storageList = $scope.profileDetails.storage.copy.filter(function(storageCopy) {
							return (
								_.get(storageCopy, 'useGlobalPolicy.storagePolicyName') ||
								_.get(storageCopy, 'globalAuxCopy.storagePolicyName')
							);
						});
					} else {
						storageList = $scope.profileDetails.storage.copy.filter(function(storageCopy) {
							if (storageCopy && storageCopy.isSnapCopy) {
								return (
									storageCopy.isSnapCopy === 'SET_FALSE' &&
									(_.get(storageCopy, 'useGlobalPolicy.storagePolicyName') ||
										_.get(storageCopy, 'globalAuxCopy.storagePolicyName'))
								);
							} else {
								return (
									_.get(storageCopy, 'useGlobalPolicy.storagePolicyName') ||
									_.get(storageCopy, 'globalAuxCopy.storagePolicyName')
								);
							}
						});
					}

					// Build up the map
					var storagePoolMap = {};
					for (var j = 0; j < $scope.storagePools.length; j++) {
						var current_pool = $scope.storagePools[j].storagePoolEntity.storagePoolName;
						storagePoolMap[current_pool] = {};
						if (storagePoolMap[current_pool] != undefined) {
							storagePoolMap[current_pool].disabled = '';
							storagePoolMap[current_pool].toolTipMSG = '';
							storagePoolMap[current_pool].poolType = $scope.storagePools[j].storagePoolType;
							storagePoolMap[current_pool].poolTypeForUrl =
								storagePoolTypesConstants[$scope.storagePools[j].storagePoolType];
							if (
								storagePoolMap[current_pool].poolType === 'SECONDARY_COPY' ||
								(storagePoolMap[current_pool].poolType === 'NON_DEDUPLICATION' &&
									$scope.storagePools[j].storageSubType === 'IBMi_VTL')
							) {
								storagePoolMap[current_pool].poolURL = 'tapeStoragePoolInfo';
							} else {
								if ($scope.storagePools[j].storageType === 'CLOUD') {
									storagePoolMap[current_pool].poolURL = 'cloudStoragePoolInfo';
								} else if ($scope.storagePools[j].storageType === 'HYPERSCALE') {
									storagePoolMap[current_pool].poolURL = 'storage/hyperscale/overview';
								} else {
									storagePoolMap[current_pool].poolURL = 'diskStoragePoolInfo';
								}
							}
						}
					}

					for (var i = 0; i < storageList.length; i++) {
						storageList[i].storagePolicyId = $scope.profileDetails.storage.storagePolicy.storagePolicyId;
						storageList[i].disabled = 'disabled';
						storageList[i].poolURL = '';
						storageList[i].poolType = '';
						storageList[i].showEdit = $scope.showEdit;
						storageList[i].toolTipMSG = cvLoc('label.noStorageViewPermission');
						storageList[i].copyTypeName = planRuleFactory.getCopyTypeName(storageList[i]);
						storageList[i].isSnapPrimary = planRuleFactory.isSnapPrimaryStorage(storageList[i]);
						let storagePoolName = storageList[i].useGlobalPolicy
							? storageList[i].useGlobalPolicy.storagePolicyName
							: storageList[i].globalAuxCopy
							? storageList[i].globalAuxCopy.storagePolicyName
							: '';
						if (storagePoolName != '' && storagePoolMap[storagePoolName]) {
							let storagePoolInfo = storagePoolMap[storagePoolName];
							storageList[i].poolType = storagePoolInfo.poolType;
							storageList[i].poolTypeForUrl = storagePoolInfo.poolTypeForUrl;
							storageList[i].poolURL = storagePoolInfo.poolURL;
							storageList[i].disabled = '';
							storageList[i].toolTipMSG = '';
						}
						let isPrimary =
							_.get(storageList[i], 'isDefault', undefined) === 'SET_TRUE' &&
							_.get(storageList[i], 'isSnapCopy', undefined) == 'SET_FALSE';
						// Poulate optimizeForInstantClone property for Primary copy that is of hedvig type
						if (isPrimary && isDefaultCopyDistributedStorage) {
							storageList[i].optimizeForInstantClone = optimizeForInstantClone;
							storageList[i].storageSubType = 'HEDVIG';
						}
					}

					$scope.storageList = storageList;

					if ($scope.planSubType) {
						if ($scope.planSubType === 'Laptop') {
							$scope.retentionLabel = cvLoc('label.retentionPeriod');
						} else if ($scope.planSubType === 'Database') {
							$scope.title = cvLoc('label.dataStoragePool');
						}
					}

					if ($scope.storageType && $scope.storageType === 'Log') {
						$scope.storageList = $scope.profileDetails.database.storageLog.copy;
						$scope.title = cvLoc('label.logStoragePool');
					}

					//assign index for edit and delete
					$scope.storageList.forEach(function(storage, index) {
						storage.index = index;

						//convert storage pool property for tape storage pool
						if (storage.globalAuxCopy) {
							storage.useGlobalPolicy = storage.globalAuxCopy;
						}
					});

					$scope.enableDisableRules = function() {
						$scope.allowRuleEdit = !$scope.allowRuleEdit;
						$scope.ruleStatus = $scope.allowRuleEdit ? 'enabled-activity' : 'disabled-activity';
						parentScope.toggleRuleEdit(); // using function because because could not get hold of parent scope variable because of transclusion
					};

					/* GRID CONTSTRUCTION */
					var globalStorageGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

					// If target copy has been referenced in any other copy.
					var alreadySourceExists = function(target) {
						for (var i = 0; i < $scope.profileDetails.storage.copy.length; i++) {
							var sourceCopy = $scope.profileDetails.storage.copy[i].sourceCopy;
							var storagePolicyCopy = $scope.profileDetails.storage.copy[i].StoragePolicyCopy;
							if (
								sourceCopy &&
								target.StoragePolicyCopy.copyId !== storagePolicyCopy.copyId &&
								target.StoragePolicyCopy.copyName === sourceCopy.copyName
							) {
								return true;
							}
						}
						return false;
					};

					// When :  we click on delete storage
					// Result: Storage target linked to a replication will also be removed
					var _taskInfo = null;
					var _target = null;
					var replicationTargetExists = function(target) {
						var taskInfo = $scope.profileDetails.replicationTargets.taskInfo;
						if (taskInfo) {
							for (var i = 0; i < taskInfo.length; i++) {
								if (taskInfo[i].subTasks) {
									for (var j = 0; j < taskInfo[i].subTasks.length; j++) {
										var subTask = taskInfo[i].subTasks[j];
										var restoreOptions = subTask.options.restoreOptions;
										var copyName = restoreOptions.storagePolicy.copyName;
										if (copyName === target.StoragePolicyCopy.copyName) {
											_taskInfo = taskInfo[i];
											return true;
										}
									}
								}
							}
						}
						return false;
					};

					var callbackFunctions = {
						noFunction: function() {
							return;
						},
						yesFunction: function() {
							$scope.listOperation = 'DELETE';
							if (!_deleteStorage(_target)) {
								return;
							}
							restoreService
								.addReplication({
									taskInfoList: angular.toJson([_taskInfo]),
									planId: $scope.profileDetails.summary.plan.planId,
									operation: $scope.listOperation
								})
								.success(function(data) {
									//$state.forceReload();
								})
								.error(function(e) {
									$scope.serverMessage = cvUtil.errMsg(e);
								});
						}
					};

					var delteStorageCallbackFunctions = {
						noFunction: function() {
							return;
						},
						yesFunction: function() {
							_deleteStorage(_target);
						}
					};

					var _deleteStorage = function(target) {
						if (alreadySourceExists(target)) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: cvLoc('error.alreadySourceStorageExists')
							});
							return false;
						} else if ($scope.storageList.length <= 1) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: cvLoc('error.lastStorage')
							});
							return false;
						} else {
							$scope.listOperation = 'DELETE';

							if (target.StoragePolicyCopy) {
								target.StoragePolicyCopy.storagePolicyId =
									$scope.storageType && $scope.storageType === 'Log'
										? $scope.profileDetails.database.storageLog.storagePolicy.storagePolicyId
										: $scope.profileDetails.storage.storagePolicy.storagePolicyId;
							}

							restoreService
								.addStorage({
									policyCopy: angular.toJson(target),
									operation: $scope.listOperation
								})
								.success(function(data) {
									$state.forceReload();
								})
								.error(function(e) {
									cvToaster.showErrorMessage({
										ttl: '10000', //10 sec
										message: e
									});
								});
							return true;
						}
					};

					/*
					 * Rules for setting the copy type name: <ul> <li>isMirrorCopy &&
					 * extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy -> Default Mirror</li>
					 * <li>isSnapCopy && extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy ->
					 * Default selective Vault/Repica</li> <li>isMirrorCopy &&
					 * extendedFlags.arrayReplicaCopy -> Mirror</li> <li>isSnapCopy &&
					 * extendedFlags.arrayReplicaCopy -> Selective vault/replica</li> <li>isSnap -> Snap
					 * Primary</li> <li>!isDefault -> Synchronous</li> <li>isDefault -> Primary</li>
					 * </ul>
					 */
					function getCopyTypeName(storage) {
						if (
							booleanOf(storage.isMirrorCopy) &&
							booleanOf(storage.extendedFlags.arrayReplicaCopy) &&
							booleanOf(storage.extendedFlags.defaultReplicaCopy)
						) {
							return cvLoc('label.defaultMirrorCopy');
						} else if (
							booleanOf(storage.isSnapCopy) &&
							booleanOf(storage.extendedFlags.arrayReplicaCopy) &&
							booleanOf(storage.extendedFlags.defaultReplicaCopy)
						) {
							return cvLoc('label.defaultVaultCopy');
						} else if (booleanOf(storage.isMirrorCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy)) {
							return cvLoc('label.mirrorCopy');
						} else if (booleanOf(storage.isSnapCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy)) {
							return cvLoc('label.selectiveVaultCopy');
						} else if (booleanOf(storage.isSnapCopy)) {
							return cvLoc('label.snapPrimary');
						} else if (!booleanOf(storage.isDefault)) {
							return cvLoc('label.synchronous');
						} else if (booleanOf(storage.isDefault)) {
							return cvLoc('label.primary');
						}
					}

					/* returns the boolean value of the FlagEnum property */
					function booleanOf(prop) {
						return !!(prop === 'SET_TRUE');
					}

					$scope.deleteStorage = function(target) {
						if ($scope.profileDetails.replicationTargets && replicationTargetExists(target)) {
							$dialogs.confirm(cvLoc('action.delete'), cvLoc('warn.deletingReplication'), callbackFunctions);
							_target = target;
						} else {
							_target = target;
							$dialogs.confirm(cvLoc('action.delete'), cvLoc('warn.deleteStorage'), delteStorageCallbackFunctions);
						}
					};
					if (!$scope.profileDetails.storage) {
						$scope.profileDetails.storage = {
							copy: []
						};
					}

					$scope.gridColumnOptions = {
						angularLibs: {
							cvLoc: cvLoc
						},
						retentionLabel: $scope.retentionLabel,
						planSubType: $scope.planSubType,
						showSource: $scope.showSource,
						showSnapShotCopy: $scope.showSnapshotCopy,
						showToolBar:
							$scope.showSnapshotCopy &&
							$scope.showEdit &&
							($scope.storageList.length <= 1 || $scope.showSource || $scope.allowManyStorages)
								? true
								: false
					};

					$scope.onGridInit = function(grid) {
						$scope.grid = grid;
					};

					$scope.editStorage = function(existingStorage, showSource, index) {
						$scope.addStorage(existingStorage, showSource).result.then(function(data) {
							$scope.storageList[index] = data;
						});
					};

					$scope.displayCopyDialog = function(existingStorage, showSource, isSnapshotCopy, snapVendorsInfo) {
						return $modal.open({
							templateUrl: appUtil.appRoot + 'modules/plan/partials/editVsaPlanStorage.jsp',
							backdrop: 'static',
							controller: [
								'$scope',
								'$uibModalInstance',
								'$state',
								'$log',
								'profileService',
								'cvUtil',
								'cvLoc',
								'restoreService',
								'profileDetails',
								'masterProfile',
								'storageType',
								'planRuleFactory',
								'storagePolicyService',
								'storageCopyFactory',
								function(
									$scope,
									$modalInstance,
									$state,
									$log,
									profileService,
									cvUtil,
									cvLoc,
									restoreService,
									profileDetails,
									masterProfile,
									storageType,
									planRuleFactory,
									storagePolicyService,
									storageCopyFactory
								) {
									$scope.planSubtype = profileDetails.summary.subtype;
									$scope.storageList =
										storageType && storageType === 'Log'
											? profileDetails.database.storageLog.copy
											: profileDetails.storage.copy;
									$scope.showSource = showSource;
									$scope.isSnapshotCopy = isSnapshotCopy;
									$scope.snapVendorsInfo = snapVendorsInfo;
									$scope.profileDetails = profileDetails;
									$scope.storagePolicy =
										storageType && storageType === 'Log'
											? profileDetails.database.storageLog.storagePolicy
											: profileDetails.storage.storagePolicy;
									$scope.storages = [];
									$scope.model = {};
									if ($scope.storageList && $scope.storageList.length > 0) {
										$scope.storages = $scope.storageList.map(function(obj) {
											return {
												name: obj.StoragePolicyCopy.copyName,
												id: obj.StoragePolicyCopy.copyId,
												isSnapCopy: obj.isSnapCopy,
												isSnapPrimary: planRuleFactory.isSnapPrimaryStorage(obj),
												storagePool: {
													storagePoolType: obj.poolType,
													storagePoolEntity: obj.useGlobalPolicy,
													storageSubType: obj.storageSubType
												},
												retentionPeriod: _.get(obj, 'retentionRules.retainBackupDataForDays', {}),
												sourceCopy: obj.sourceCopy,
												copyType: obj.copyType,
												isDefault: obj.isDefault,
												optimizeForInstantClone: _.get(obj, 'optimizeForInstantClone', undefined)
											};
										});
									}

									$scope.storagePolicyCopyInfo = existingStorage;
									$scope.listOperation = 'ADD';

									if (existingStorage) {
										$scope.editMode = true;
										$scope.listOperation = 'OVERWRITE';

										$scope.initModel = {
											copyId: existingStorage.StoragePolicyCopy.copyId,
											storagePolicyId: existingStorage.storagePolicyId,
											source: existingStorage.sourceCopy ? existingStorage.sourceCopy.copyName : '',
											overrideRetention: true,
											editMode: $scope.editMode,
											isMirrorCopy: existingStorage.isMirrorCopy,
											isSnapPrimary: planRuleFactory.isSnapPrimaryStorage(existingStorage),
											sourceCopy: existingStorage.sourceCopy,
											index: existingStorage.index,
											isPrimary: planRuleFactory.isPrimary(existingStorage),
											optimizeForInstantClone: existingStorage.optimizeForInstantClone
										};

										if (existingStorage.useGlobalPolicy) {
											$scope.initModel.storagePool = {
												storagePoolEntity: {
													storagePoolId: existingStorage.useGlobalPolicy.storagePolicyId,
													storagePoolName: existingStorage.useGlobalPolicy.storagePolicyName
												},
												storagePoolType: existingStorage.poolType,
												storageSubType: existingStorage.storageSubType
											};
										}
										$scope.isSnapPrimary = $scope.initModel.isSnapPrimary;
									} else {
										/*
										 * If this is a add snapshot copy and if there is no snap primary, the
										 * current copy being added will be a snap primary
										 */
										$scope.isDefaultVaultReplica = planRuleFactory.isDefaultVaultReplicaCopyExists($scope.storageList);

										$scope.isSnapPrimary =
											$scope.isSnapshotCopy && _.filter($scope.storages, storage => storage.isSnapPrimary).length == 0;
									}

									$scope.onCopyDetailsInit = function(data) {
										if ($scope.storageList && data.isDefault === 'SET_TRUE') {
											$scope.isPrimary = true;
										}
									};

									$scope.cancel = function() {
										$modalInstance.dismiss();
									};
									$scope.getSourceCopyId = function() {
										for (var i in $scope.storages) {
											if ($scope.storages[i].name === $scope.model.source) {
												return $scope.storages[i].id;
											}
										}
										return '';
									};

									$scope.saveStorage = function() {
										$scope.storagePolicyCopyInfo = {
											StoragePolicyCopy: {
												storagePolicyId: $scope.storagePolicy.storagePolicyId,
												copyName: $scope.model.storageName,
												storagePolicyName: $scope.storagePolicy.storagePolicyName,
												copyId: $scope.model.copyId
											},
											retentionRules: {
												retainBackupDataForDays: $scope.model.retentionPeriod
											},
											isDefault: $scope.model.isDefault
										};
										if ($scope.showSource) {
											$scope.storagePolicyCopyInfo.sourceCopy = {
												copyName: $scope.model.source
											};
										}
										// check if storagePoolType is tape
										//set retention as null if storage pool is tape
										if (
											$scope.isSnapshotCopy === false &&
											$scope.model.storagePool.storagePoolType === 'SECONDARY_COPY'
										) {
											$scope.storagePolicyCopyInfo.globalAuxCopy = {
												storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
												storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
											};

											if ($scope.model.overrideRetention) {
												$scope.storagePolicyCopyInfo.extendedFlags = {
													overRideGACPRetention: 'SET_TRUE'
												};
												//set infinite retention as -1
												if ($scope.model.infiniteSelected) {
													$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = -1;
												}
											} else {
												$scope.storagePolicyCopyInfo.extendedFlags = {
													overRideGACPRetention: 'SET_FALSE'
												};
												//$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = null;
											}
										} else {
											if ($scope.model.storagePool.storagePoolType === 'NON_DEDUPLICATION') {
												$scope.storagePolicyCopyInfo.extendedFlags = {
													useGlobalStoragePolicy: 'SET_TRUE'
												};
											}
											//set infinite retention as -1
											if ($scope.model.infiniteSelected) {
												$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays = -1;
											}
											$scope.storagePolicyCopyInfo.useGlobalPolicy = {
												storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
												storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
											};
										}

										// do not populate id for primary copy as empty value cannot be parsed by server
										if (_.get($scope.storagePolicyCopyInfo, 'sourceCopy.copyName')) {
											$scope.storagePolicyCopyInfo.sourceCopy.copyId = $scope.getSourceCopyId();
										}

										storageCopyFactory.updateSelectiveCopyInfo($scope.model, $scope.storagePolicyCopyInfo);

										if (!storageCopyFactory.isExtendedRetentionValid($scope.model)) {
											return;
										} else {
											$scope.storagePolicyCopyInfo.retentionRules = Object.assign(
												$scope.storagePolicyCopyInfo.retentionRules,
												storageCopyFactory.getExtendedRetentionRules($scope.model)
											);
										}

										storageCopyFactory.updateSecondaryCopyCycles(
											$scope.model,
											$scope.storageList,
											$scope.storagePolicyCopyInfo
										);

										if ($scope.isSnapshotCopy) {
											/* Atleast 1 SVM Mapping is mandatory for Mirror copy */
											if (!storageCopyFactory.isSVMValid($scope.model, $scope.storageList, $scope)) {
												return;
											} else {
												storageCopyFactory.updateSnapCopySVM(
													$scope.model,
													$scope.storagePolicyCopyInfo,
													$scope.storageList
												);
											}

											$scope.storagePolicyCopyInfo.useGlobalPolicy = {
												storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
												storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
											};

											storageCopyFactory.updateSnapCopyDetails(
												$scope.isSnapPrimary,
												$scope.model,
												$scope.storagePolicyCopyInfo,
												$scope.storageList
											);
										}

										var request;
										var objToSend;
										if ($scope.isPrimary && $scope.planSubtype === 'Laptop') {
											// If plan type is laptop, FS, or Server, use the modify plan storage api instead of the edit storage policy api
											// in order to check plan inheritance rules properly
											objToSend = {
												id: $scope.profileDetails.summary.plan.planId,
												planType: $scope.planSubtype,
												isLogStorage: false,
												policyCopy: angular.toJson($scope.storagePolicyCopyInfo)
											};
											if ($scope.isPrimary) {
												objToSend.storage = JSON.stringify({
													primaryRetentionInDays: $scope.model.retentionPeriod
												});
											} else {
												objToSend.storage = JSON.stringify({
													primaryRetentionInDays: $scope.storageList[0].retentionRules.retainBackupDataForDays,
													secondaryRetentionInDays: $scope.model.retentionPeriod
												});
											}
											request = profileService.editPlanStorage(objToSend);
										} else {
											objToSend = {
												policyCopy: angular.toJson($scope.storagePolicyCopyInfo),
												operation: $scope.listOperation,
												storagePolicyId: 0,
												isLog: storageType && storageType === 'Log' ? true : false
											};
											if (objToSend.operation === 'ADD') {
												objToSend.storagePolicyId = $scope.storagePolicy.storagePolicyId;
												objToSend.storagePolicyName = $scope.storagePolicy.storagePolicyName;
											}

											request = restoreService.addStorage(objToSend);
										}

										request
											.success(function(data) {
												if ($scope.editMode) {
													existingStorage.StoragePolicyCopy.copyName =
														$scope.storagePolicyCopyInfo.StoragePolicyCopy.copyName;
													existingStorage.retentionRules.retainBackupDataForDays =
														$scope.storagePolicyCopyInfo.retentionRules.retainBackupDataForDays;
													// Update copyName in sourceCopies in other storages:
													angular.forEach($scope.storageList, storage => {
														if (
															storage.sourceCopy &&
															storage.sourceCopy.copyId === $scope.storagePolicyCopyInfo.StoragePolicyCopy.copyId
														) {
															storage.sourceCopy.copyName = $scope.storagePolicyCopyInfo.StoragePolicyCopy.copyName;
														}
													});
													if ($scope.showSource) {
														existingStorage.sourceCopy = $scope.storagePolicyCopyInfo.sourceCopy;
													}

													if (
														_.get($scope, 'initModel.optimizeForInstantClone', undefined) !==
														_.get($scope, 'model.optimizeForInstantClone', undefined)
													) {
														let optimizeForInstantClone = _.get($scope, 'model.optimizeForInstantClone', undefined);
														let planId = _.get($scope, 'profileDetails.summary.plan.planId', 0);
														profileService
															.updatePlanOptions(
																planId,
																JSON.stringify({
																	optimizeForInstantClone: optimizeForInstantClone
																})
															)
															.success(function(response) {
																$modalInstance.close(existingStorage);
																$state.forceReload();
															})
															.error(function(e) {
																$scope.serverMessage = cvUtil.errMsg(e);
															});
													} else {
														$modalInstance.close(existingStorage);
														$state.forceReload();
													}

													/*
													 * if(existingStorage.retentionRules.retainBackupDataForDays
													 * === null) { $state.reload(); }
													 */
												}
												if (objToSend.operation === 'ADD') {
													$modalInstance.dismiss();
													$state.forceReload();
												}
											})
											.error(function(e) {
												$scope.serverMessage = cvUtil.errMsg(e);
											});
									};
								}
							],
							resolve: {
								profileDetails: function() {
									return $scope.profileDetails;
								},
								masterProfile: function() {
									return $scope.masterProfile;
								},
								storageType: function() {
									return $scope.storageType;
								}
							}
						});
					};

					$scope.addStorage = function(existingStorage, showSource, isSnapshotCopy) {
						isSnapshotCopy = isSnapshotCopy || _.get(existingStorage, 'isSnapCopy', false) === 'SET_TRUE';

						if (isSnapshotCopy === true) {
							if ($scope.snapVendorsInfo) {
								$scope.displayCopyDialog(existingStorage, showSource, isSnapshotCopy, $scope.snapVendorsInfo);
							} else {
								storageService.getSnapVendors().then(function(data) {
									if (data && data.data) {
										let snapVendorsInfo = {};
										let snapVendors = [];
										let svmMap = {};
										_.get(data.data, 'replicationVendor', []).forEach(function(array) {
											snapVendors.push(array.vendor);
											svmMap[array.vendor.id] = {
												svmList: array.replicationEntity,
												sourceLabel: _.get(array, 'sourceLabel', ''),
												destLabel: _.get(array, 'destLabel', ''),
												mapHeadingLabel: _.get(array, 'mapHeadingLabel', '')
											};
										});
										snapVendorsInfo.snapVendors = snapVendors;
										snapVendorsInfo.svmMap = svmMap;
										$scope.snapVendorsInfo = snapVendorsInfo;
										$scope.displayCopyDialog(existingStorage, showSource, isSnapshotCopy, $scope.snapVendorsInfo);
									}
								});
							}
						} else {
							$scope.displayCopyDialog(existingStorage, showSource, isSnapshotCopy, undefined);
						}
					};
				}
			]
		};
	}
]);

//Add/edit or view all rules created for the plan
planModule.directive('cvRulesSet', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'common/partials/cvRulesSetTile.jsp',
			scope: {
				profileDetails: '=',
				masterProfile: '=',
				showEdit: '=',
				isTabSet: '=',
				isNewPlan: '=',
				allowManyStorages: '=',
				onRegisterApi: '=cvOnRegisterApi',
				onRuleAdded: '=cvOnRuleAdded',
				onStorageAdded: '=?cvOnStorageAdded',
				onStorageDeleted: '=?cvOnStorageDeleted',
				onStorageUpdated: '=?cvOnStorageUpdated',
				planSubType: '=cvPlanSubType',
				allowManyRules: '=' // if showSource is true then this is true
			},
			controller: [
				'$scope',
				'$uibModal',
				'storageService',
				'cvLoc',
				'cvUtil',
				'$state',
				'cvToaster',
				'profileService',
				'storageRuleModel',
				'clientGroupService',
				'planRuleFactory',
				'restoreService',
				'regionsService',
				function(
					$scope,
					$modal,
					storageService,
					cvLoc,
					cvUtil,
					$state,
					cvToaster,
					profileService,
					storageRuleModel,
					clientGroupService,
					planRuleFactory,
					restoreService,
					regionsService
				) {
					$scope.showSnapshotCopy = cvConfig.enableSnapCopy;
					const agentList = planRuleFactory.agents;
					var existingModel = {};
					$scope.notAvailableStorages = [];
					$scope.showSource = angular.isDefined($scope.showSource) ? true : false;
					//$scope.isTabSet = $scope.isTabSet ? $scope.isTabSet : false;
					//$scope.rearrangeEnabled = false;
					$scope.ruleList = [];
					const mapToActiveInt = {
						SET_TRUE: 1,
						SET_FALSE: 0
					};
					if ($scope.profileDetails && $scope.profileDetails.storageRules.rules) {
						$scope.ruleList = $scope.profileDetails.storageRules.rules;
					}

					// Adding storage subtype for retrieving only IBMi VTL storage for FSIBMiVTL plans
					var storageSubType = 'ALL_EXCEPT_IBMi_VTL';

					if ($scope.planSubType === 'FSIBMiVTL') {
						storageSubType = 'IBMi_VTL';
					}

					storageService
						.getStoragePools(null, storageSubType)
						.success(function(data) {
							$scope.storagePools = cvUtil.sortAscending(data, 'storagePoolEntity.storagePoolName');
							$scope.selectedRuleItemObj = cvUtil.sortAscending($scope.ruleList, 'rank');
							//assign index for edit and delete
							$scope.selectedRuleItemObj.forEach(function(rule, index) {
								rule.index = index;
								$scope.selectedRuleItemObj[index].notAvailableStorages = [];
								let source = $scope.selectedRuleItemObj[index].storage.copy
									? $scope.selectedRuleItemObj[index].storage.copy[0].StoragePolicyCopy
									: undefined;
								angular.forEach(rule.storage.copy, storageCopy => {
									if (
										!mapToActiveInt[storageCopy.isSnapCopy] ||
										($scope.planSubType !== 'Archiver' &&
											((storageCopy.useGlobalPolicy && storageCopy.useGlobalPolicy.storagePolicyName) ||
												(storageCopy.globalAuxCopy && storageCopy.globalAuxCopy.storagePolicyName)))
									) {
										$scope.selectedRuleItemObj[index].notAvailableStorages.push({
											name: storageCopy.StoragePolicyCopy.copyName,
											enableStoragePool: false,
											isDefault: storageCopy.isDefault,
											isActive: storageCopy.active,
											copyType: storageCopy.copyType,
											copyTypeName: planRuleFactory.getCopyTypeName(storageCopy),
											copyId: storageCopy.StoragePolicyCopy.copyId,
											overrideRetention: true,
											source:
												storageCopy.isDefault === 'SET_TRUE'
													? undefined
													: storageCopy.sourceCopy
													? storageCopy.sourceCopy
													: source,
											retentionPeriod:
												storageCopy.retentionRules && storageCopy.retentionRules.retainBackupDataForDays
													? storageCopy.retentionRules.retainBackupDataForDays
													: undefined,
											storagePool: convertStorageCopy(storageCopy),
											retentionRules: storageCopy.retentionRules,
											isSnapCopy: storageCopy.isSnapCopy,
											isMirrorCopy: storageCopy.isMirrorCopy,
											isSnapPrimary: planRuleFactory.isSnapPrimaryStorage(storageCopy),
											extendedFlags: storageCopy.extendedFlags || {},
											useGlobalPolicy: storageCopy.useGlobalPolicy || {},
											selectiveCopyRules: storageCopy.selectiveCopyRules || {},
											globalAuxCopy: storageCopy.globalAuxCopy || {}
										});
										$scope.notAvailableStorages.push(...$scope.selectedRuleItemObj[index].notAvailableStorages);
									}
								});
							});
							setAvailableStoragePools();
						})
						.error(function(e) {
							$scope.serverMessage = cvUtil.errMsg(e);
						});

					var convertStorageCopy = function(copy) {
						if (copy.useGlobalPolicy) {
							return {
								storagePoolEntity: {
									storagePoolId: copy.useGlobalPolicy.storagePolicyId,
									storagePoolName: copy.useGlobalPolicy.storagePolicyName
								}
							};
						} else if (copy.globalAuxCopy) {
							return {
								storagePoolEntity: {
									storagePoolId: copy.globalAuxCopy.storagePolicyId,
									storagePoolName: copy.globalAuxCopy.storagePolicyName
								}
							};
						}
					};
					/*
					 * Rules for setting the copy type name: <ul> <li>isMirrorCopy &&
					 * extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy -> Default Mirror</li>
					 * <li>isSnapCopy && extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy ->
					 * Default selective Vault/Repica</li> <li>isMirrorCopy &&
					 * extendedFlags.arrayReplicaCopy -> Mirror</li> <li>isSnapCopy &&
					 * extendedFlags.arrayReplicaCopy -> Selective vault/replica</li> <li>isSnap -> Snap
					 * Primary</li> <li>!isDefault -> Synchronous</li> <li>isDefault -> Primary</li>
					 * </ul>
					 */
					function getCopyTypeName(storage) {
						if (
							booleanOf(storage.isMirrorCopy) &&
							booleanOf(storage.extendedFlags.arrayReplicaCopy) &&
							booleanOf(storage.extendedFlags.defaultReplicaCopy)
						) {
							return cvLoc('label.defaultMirrorCopy');
						} else if (
							booleanOf(storage.isSnapCopy) &&
							booleanOf(storage.extendedFlags.arrayReplicaCopy) &&
							booleanOf(storage.extendedFlags.defaultReplicaCopy)
						) {
							return cvLoc('label.defaultVaultCopy');
						} else if (booleanOf(storage.isMirrorCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy)) {
							return cvLoc('label.mirrorCopy');
						} else if (booleanOf(storage.isSnapCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy)) {
							return cvLoc('label.selectiveVaultCopy');
						} else if (booleanOf(storage.isSnapCopy)) {
							return cvLoc('label.snapPrimary');
						} else if (!booleanOf(storage.isDefault)) {
							return cvLoc('label.synchronous');
						} else if (booleanOf(storage.isDefault)) {
							return cvLoc('label.primary');
						}
					}

					/* returns the boolean value of the FlagEnum property */
					function booleanOf(prop) {
						return !!(prop === 'SET_TRUE');
					}

					/**
					 * Callback function for cv-plan-storage-component.
					 */
					$scope.onStorageAdded = function(newStorage, existingStorages) {
						$scope.updatedStorage = [...existingStorages, newStorage];
						var storageObj = updateStorageRuleCopies($scope.updatedStorage, 'ADD');
						addStorageToRule(storageObj, 'ADD');
					};
					$scope.onStorageDeleted = function(deletedStorage, addedStorages) {
						var storageObj = updateStorageRuleCopies([deletedStorage]);
						var copiesToEdit = [
							{
								StoragePolicyCopy: {
									copyName: deletedStorage.name,
									copyId: deletedStorage.copyId,
									storagePolicyId: existingModel.storage.storagePolicy.storagePolicyId
								},
								retentionRules: existingModel.storage.copy[deletedStorage.index].retentionRules,
								sourceCopy: existingModel.storage.copy[deletedStorage.index].sourceCopy,
								useGlobalPolicy: existingModel.storage.copy[deletedStorage.index].useGlobalPolicy,
								isSnapCopy: deletedStorage.isSnapCopy
							}
						];
						updateStorage(copiesToEdit, storageObj, 'DELETE');
					};

					/** Add copy functionality *** */
					function updateStorageRuleCopies(addedStorages, operation) {
						if (addedStorages.length > 0) {
							var primaryStorage = {};
							var retentionDays = 30;
							var newStorage = angular.copy(addedStorages);
							$scope.notAvailableStorages = newStorage;
							var copies = [];
							for (var i = 0; i < newStorage.length; i++) {
								if (operation !== 'ADD' && addedStorages[i].source) {
									primaryStorage = {
										storagePoolEntity: addedStorages[i].storagePool.storagePoolEntity,
										id: addedStorages[i].source.copyId,
										name: addedStorages[i].source.copyName
									};
									retentionDays = addedStorages[i].retentionPeriod;
								}
								let isSource =
									newStorage[i].source == '' ||
									newStorage[i].source === null ||
									!angular.isDefined(newStorage[i].source);
								if (isSource) {
									retentionDays = newStorage[i].retentionPeriod;
									primaryStorage = {
										storagePoolEntity: newStorage[i].storagePool.storagePoolEntity,
										id: newStorage[i].copyId,
										name: newStorage[i].name
									};
								}

								if (newStorage[i].sourceAuxCopy) {
									retentionDays = newStorage[i].retentionPeriod;
									primaryStorage = {
										storagePoolEntity: newStorage[i].storagePool.storagePoolEntity,
										id: newStorage[i].sourceAuxCopy.copyId,
										name: newStorage[i].sourceAuxCopy.copyName
									};
								}

								let copyInfo = {
									retentionDays: addedStorages[i].retentionPeriod,
									copyId: addedStorages[i].copyId,
									isActive: addedStorages[i].isActive ? mapToActiveInt[addedStorages[i].isActive] : isSource ? 1 : 0,
									name: addedStorages[i].name,
									isDefault: addedStorages[i].isDefault ? mapToActiveInt[addedStorages[i].isDefault] : isSource ? 1 : 0,
									copyType: addedStorages[i].copyType ? 1 : isSource ? 0 : 1,
									storagePool: addedStorages[i].storagePool.storagePoolEntity,
									storagePoolType: addedStorages[i].poolType
										? addedStorages[i].poolType
										: addedStorages[i].storagePool.storagePoolType
								};

								copyInfo.startTime = addedStorages[i].startTime;

								if (addedStorages[i].copyType && addedStorages[i].copyType === 'SELECTIVE') {
									copyInfo.selectiveCopyRules = addedStorages[i].selectiveCopyRules;
									copyInfo.copyType = 2;
								}

								if (addedStorages[i].retentionRules) {
									if (!copyInfo.retentionRules) {
										copyInfo.retentionRules = {};
									}

									angular.merge(copyInfo.retentionRules, addedStorages[i].retentionRules);
								}

								copyInfo.extendedFlags = addedStorages[i].extendedFlags;

								if (addedStorages[i].isSnapCopy === 'SET_TRUE') {
									copyInfo.regionMap = addedStorages[i].regionMap;
									copyInfo.replPairList = addedStorages[i].replPairList;
									copyInfo.sourceCopy = addedStorages[i].sourceCopy;
									copyInfo.isSnapCopy = addedStorages[i].isSnapCopy;
									copyInfo.isMirrorCopy = addedStorages[i].isMirrorCopy;
								}

								copies.push(copyInfo);
							}
						}
						return {
							retentionDays: retentionDays,
							copies: copies,
							primaryStorage: primaryStorage
						};
					}
					function addStorageToRule(storageObj, editOperation) {
						let firstTimeRun = {
							isFirstTime: true
						};
						let storageRuleReq = {
							rules: [
								{
									retentionDays: storageObj.retentionDays,
									rank: existingModel.rank,
									regions: existingModel.regions,
									rule: existingModel.rule,
									agents: existingModel.agents,
									copies: storageObj.copies,
									storagePool: storageObj.primaryStorage.storagePoolEntity
								}
							]
						};
						//pass storage policy id for storage policy copy edit
						storageRuleReq.rules[0].storagePolicy = existingModel.storage.storagePolicy;
						if ($scope.profileDetails.summary) {
							storageRuleReq.summary = { plan: $scope.profileDetails.summary.plan };
						}
						let storageRuleRequestObj = storageRuleModel.apiRequestTransformer(storageRuleReq, firstTimeRun);
						//form edit obj
						let storagePolicyCopyInfo = storageRuleRequestObj.storageRules.rules[0].storage.copy;
						//filter edit /add copies
						if (editOperation == 'ADD') {
							var copiesToEdit = storagePolicyCopyInfo.filter(copy => !copy.StoragePolicyCopy.copyId);
						} else {
							var copiesToEdit = storagePolicyCopyInfo;
						}

						updateStorage(copiesToEdit, storageObj, editOperation);
					}

					function updateStorage(copiesToEdit, storageObj, editOperation) {
						var promiseArray = new Array();
						for (var i = 0; i < copiesToEdit.length; i++) {
							var policyCopy = {
								StoragePolicyCopy: copiesToEdit[i].StoragePolicyCopy,
								retentionRules: copiesToEdit[i].retentionRules,
								sourceCopy: {
									copyName: storageObj.primaryStorage.name,
									copyId: storageObj.primaryStorage.id
								},
								useGlobalPolicy: copiesToEdit[i].useGlobalPolicy,
								copyType: copiesToEdit[i].copyType
							};

							if (copiesToEdit[i].globalAuxCopy) {
								policyCopy.globalAuxCopy = copiesToEdit[i].globalAuxCopy;
							}

							if (copiesToEdit[i].extendedFlags) {
								policyCopy.extendedFlags = copiesToEdit[i].extendedFlags;
							}

							policyCopy.startTime = copiesToEdit[i].startTime;

							if (copiesToEdit[i].copyType && copiesToEdit[i].copyType === 2) {
								policyCopy.selectiveCopyRules = copiesToEdit[i].selectiveCopyRules;
							}
							if (copiesToEdit[i].isSnapCopy && copiesToEdit[i].isSnapCopy === 'SET_TRUE') {
								policyCopy.replPairList = copiesToEdit[i].replPairList;
								policyCopy.regionMap = copiesToEdit[i].regionMap;
								policyCopy.isSnapCopy = copiesToEdit[i].isSnapCopy;

								if (copiesToEdit[i].isMirrorCopy) {
									policyCopy.isMirrorCopy = copiesToEdit[i].isMirrorCopy;
								}

								if (copiesToEdit[i].sourceCopy) {
									policyCopy.sourceCopy = copiesToEdit[i].sourceCopy;
								}
							}

							let objToSend = {
								policyCopy: angular.toJson(policyCopy),
								operation: editOperation,
								storagePolicyId: copiesToEdit[i].StoragePolicyCopy.storagePolicyId,
								isLog: false,
								storagePolicyName: copiesToEdit[i].StoragePolicyCopy.storagePolicyName
							};
							promiseArray[i] = new Promise(function(resolve, reject) {
								restoreService
									.addStorage(objToSend)
									.success(function() {
										resolve();
									})
									.error(e => {
										cvToaster.showErrorMessage({
											ttl: '10000', //10 sec
											message: e
										});
										$state.forceReload();
									});
							});
						}
						Promise.all(promiseArray).then(function(values) {
							cvToaster.showSuccessMessage({
								ttl: '10000', //10 sec
								message: cvLoc('label.storageUpdateSuccess')
							});
							$state.forceReload();
						});
					}

					$scope.registerRuleIndex = function(index) {
						existingModel = $scope.selectedRuleItemObj[index];
					};
					$scope.onStorageUpdated = function(newStorage, updatedStorage) {
						var storageObj = updateStorageRuleCopies([newStorage], 'OVERWRITE');
						addStorageToRule(storageObj, 'OVERWRITE');
					};
					$scope.onRegisterPlanStorageApi = function(planStorageApi) {
						$scope.addStorage = function(index, data) {
							return planStorageApi.addStorage(undefined, undefined, data);
						};
						$scope.addSnapshotStorage = function(index, data) {
							const isSnapshotCopy = true;
							return planStorageApi.addStorage(undefined, undefined, data, isSnapshotCopy);
						};
					};

					function setAvailableStoragePools() {
						//var storagesInUse = [];
						//storagesInUse = $scope.notAvailableStorages;
						// remove the storage pools used so far and push only which are remaining
						var storagePoolList = $scope.storagePools.filter(function(storagePool) {
							// check pool is used in any of the previous storages
							// for (let k = 0; k < storagesInUse.length; k++) {
							// 	let ruleStoragePool = storagesInUse[k].storagePool.storagePoolEntity.storagePoolId;
							// 	let checkStoragePool = storagePool.storagePoolEntity.storagePoolId;
							// 	if (checkStoragePool == ruleStoragePool) {
							// 		return false;
							// 	}
							// }
							return storagePool;
						});
						$scope.allStoragePools = storagePoolList;
					}

					function setSelectedRegions(resolve) {
						regionsService.getRegionList().success(function(data) {
							allRegions = data.regions;
							resolve();
						});
					}

					/** ***** ADD RULE ******* */

					$scope.addRule = function(existingRules) {
						return $modal
							.open({
								templateUrl: appUtil.appRoot + 'modules/plan/partials/addVsaPlanRule.jsp',
								backdrop: 'static',

								controller: [
									'$scope',
									'$uibModalInstance',
									'$state',
									'profileService',
									'cvUtil',
									'cvLoc',
									'regionsUIFactory',
									'profileDetails',
									'storageRuleModel',
									'addRuleToPlan',
									'gridRuleList',
									'allStoragePools',
									'restoreService',
									'planRuleFactory',
									'masterProfile',
									'storageCopyFactory',
									function(
										$scope,
										$modalInstance,
										$state,
										profileService,
										cvUtil,
										cvLoc,
										regionsUIFactory,
										profileDetails,
										storageRuleModel,
										addRuleToPlan,
										gridRuleList,
										allStoragePools,
										restoreService,
										planRuleFactory,
										masterProfile,
										storageCopyFactory
									) {
										/** ** INIT ***** */
										const mapToActiveInt = {
											SET_TRUE: 1,
											SET_FALSE: 0,
											SYNCHRONOUS: 1
										};
										$scope.isNewRule = true;
										$scope.firstTime = true;
										$scope.rules = [];
										$scope.profileDetails = profileDetails;
										$scope.masterProfile = masterProfile;
										$scope.planSubType = profileDetails.summary.subtype;
										$scope.notAvailableStorages = [];
										$scope.storagePools = [];
										$scope.selectedRegion = [];
										$scope.selectedClientGroup = [];
										$scope.copies = [];
										$scope.ruleList = profileDetails.storageRules.rules ? profileDetails.storageRules.rules : [];
										$scope.rank = $scope.ruleList.length + 1;
										$scope.model = {
											selectedAgentsAsReceived: [],
											agentSelectionTree: {},
											selectedRuleValue: {
												value: '',
												label: ''
											}
										};

										let editMode = false;
										let existingModel = {};
										/** ** END INIT ***** */

										if ($scope.ruleList && $scope.ruleList.length > 0) {
											$scope.firstTime = false;
											$scope.rules = $scope.ruleList.map(obj => {
												return {
													name: obj.ruleName,
													id: obj.ruleId
												};
											});
										}
										$scope.listOperation = 'ADD';
										if (existingRules) {
											$scope.editMode = true;
											editMode = true;
											$scope.listOperation = 'OVERWRITE';
											existingModel = $scope.ruleList[existingRules.index];
											$scope.rank = existingModel.rank;
										}

										//filter editMode data
										function filterSelectedOption(list, model, key) {
											return list.filter(function(data) {
												return model.some(function(output) {
													let isSelected = data.id === output[key];
													if (isSelected) {
														data.selected = true;
													}
													return isSelected;
												});
											});
										}
										//fetch regions
										$scope.regionList = [];
										$scope.serverMessage = '';
										regionsUIFactory.getGroupedRegionList().then(
											regions => {
												$scope.regionList = regions;
												if (editMode) {
													$scope.selectedRegion = filterSelectedOption(
														$scope.regionList,
														existingModel.regions.region,
														'regionId'
													);
												} else {
													$scope.selectedRegion = new Array($scope.regionList[1]);
													$scope.selectedRegion[0].selected = true;
												}
											},
											function(e) {
												$scope.serverMessage = cvUtil.errMsg(e);
											}
										);

										var convertStorageCopy = function(copy) {
											if (copy.useGlobalPolicy) {
												return {
													storagePoolEntity: {
														storagePoolId: copy.useGlobalPolicy.storagePolicyId,
														storagePoolName: copy.useGlobalPolicy.storagePolicyName
													}
												};
											}
										};
										//form available storage objects for grid display
										if (allStoragePools && allStoragePools.length > 0) {
											$scope.storagePoolsLoaded = true;
											$scope.allStoragePools = allStoragePools;

											if ($scope.firstTime) {
												let source = $scope.profileDetails.storage.copy
													? $scope.profileDetails.storage.copy[0].StoragePolicyCopy
													: undefined;

												angular.forEach($scope.profileDetails.storage.copy, storageCopy => {
													if (
														!mapToActiveInt[storageCopy.isSnapCopy] ||
														($scope.planSubType !== 'Archiver' &&
															((storageCopy.useGlobalPolicy && storageCopy.useGlobalPolicy.storagePolicyName) ||
																(storageCopy.globalAuxCopy && storageCopy.globalAuxCopy.storagePolicyName)))
													) {
														$scope.notAvailableStorages.push({
															name: storageCopy.StoragePolicyCopy.copyName,
															enableStoragePool: false,
															isDefault: storageCopy.isDefault,
															isActive: storageCopy.active,
															copyType: storageCopy.copyType,
															copyTypeName: planRuleFactory.getCopyTypeName(storageCopy),
															overrideRetention: true,
															source:
																storageCopy.isDefault === 'SET_TRUE'
																	? undefined
																	: storageCopy.sourceCopy
																	? storageCopy.sourceCopy
																	: source,
															retentionPeriod:
																storageCopy.retentionRules && storageCopy.retentionRules.retainBackupDataForDays
																	? storageCopy.retentionRules.retainBackupDataForDays
																	: undefined,
															storagePool: convertStorageCopy(storageCopy),
															retentionRules: storageCopy.retentionRules,
															isSnapCopy: storageCopy.isSnapCopy,
															isMirrorCopy: storageCopy.isMirrorCopy,
															isSnapPrimary: planRuleFactory.isSnapPrimaryStorage(storageCopy),
															extendedFlags: storageCopy.extendedFlags || {},
															useGlobalPolicy: storageCopy.useGlobalPolicy || {},
															selectiveCopyRules: storageCopy.selectiveCopyRules || {},
															globalAuxCopy: storageCopy.globalAuxCopy || {}
														});
													}
												});
											} else if (editMode) {
												//form existing storage template
												angular.forEach(existingRules.storage.copy, storageCopy => {
													$scope.notAvailableStorages.push({
														name: storageCopy.StoragePolicyCopy.copyName,
														enableStoragePool: false,
														isDefault: storageCopy.isDefault,
														isActive: storageCopy.active,
														copyType: storageCopy.copyType,
														copyId: storageCopy.StoragePolicyCopy.copyId,
														retentionPeriod: storageCopy.retentionRules.retainBackupDataForDays,
														storagePool: convertStorageCopy(storageCopy)
													});
												});
											} else {
												let primaryIndex = setAvailableStoragePools(true);
												//if there is any pool available
												//TODO: exit modal with a message if all primary storages got exhausted
												if ($scope.storagePools && $scope.storagePools.length > 0) {
													//set default storage
													$scope.notAvailableStorages = [
														{
															name: 'Primary',
															retentionPeriod: 30,
															storagePool: $scope.storagePools[primaryIndex],
															retentionRules: {
																retainBackupDataForDays: 30
															},
															isPrimary: true
														}
													];
												} else {
													$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageAvailable');
												}
											}
											updateStorageRuleCopies($scope.notAvailableStorages);
											setAvailableStoragePools();
										} else {
											$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageFound');
										}

										$scope.addStorageRules = function() {
											//selected region
											let firstTimeRun = {
												isFirstTime: true,
												policyId: $scope.profileDetails.storage.storagePolicy.storagePolicyId
											};
											let regions = $scope.selectedRegion.map(regionVal => {
												return {
													regionId: regionVal.id,
													regionName: regionVal.name
												};
											});

											//update copies
											for (var i = 0; i < $scope.notAvailableStorages.length; i++) {
												$scope.copies.map(copyObj => {
													if (copyObj.name == $scope.notAvailableStorages[i].name) {
														copyObj.retentionDays = $scope.notAvailableStorages[i].retentionPeriod;
													}
												});
											}

											/** ** validations ** */

											if ($scope.selectedRegion.length < 1) {
												$scope.serverMessage = cvUtil.errMsg(cvLoc('error.selectRegion'));
												return;
											}

											if ($scope.copies.length < 1 || Object.keys($scope.primaryStorage).length == 0) {
												$scope.serverMessage = cvUtil.errMsg(cvLoc('error.addCopy'));
												return;
											}
											//check if rule with same region name is already there, donot allow rule creation
											if (regions.length > 0) {
												let redundantRule = _.filter($scope.ruleList, function(rule, index) {
													return rule.regions.region[0].regionId == regions[0].regionId;
												});
												if (redundantRule.length > 0) {
													$scope.serverMessage = cvUtil.errMsg(cvLoc('error.ruleExists'));
													return;
												}
											}
											/** *** END validation ***** */
											$scope.model.storagePool = $scope.primaryStorage;
											let storageRuleReq = {
												rules: [
													{
														retentionDays: $scope.model.retentionDays,
														rank: $scope.rank,
														regions: { region: regions },
														rule: existingModel.rule,
														copies: $scope.copies,
														storagePool: $scope.model.storagePool.storagePoolEntity
													}
												]
											};
											//pass storage policy id for storage policy copy edit
											if (editMode) {
												storageRuleReq.rules[0].storagePolicy = existingModel.storage.storagePolicy;
											}
											if ($scope.profileDetails.summary) {
												storageRuleReq.summary = { plan: $scope.profileDetails.summary.plan };
											}
											if (_.has($scope, 'ruleList[0].regions')) {
												firstTimeRun.isFirstTime = false;
											}
											let storageRuleRequestObj = storageRuleModel.apiRequestTransformer(storageRuleReq, firstTimeRun);

											if (
												$scope.planSubType === 'Server' ||
												$scope.planSubType === 'Archiver' ||
												$scope.planSubType === 'FSIBMiVTL'
											) {
												let snapToTapeCopy = _.get($scope.masterProfile.storage, 'copy', []).find(
													x => x.isSnapCopy === 'SET_TRUE'
												);
												if (snapToTapeCopy) {
													if (snapToTapeCopy.retentionRules && snapToTapeCopy.retentionRules.jobs) {
														delete snapToTapeCopy.retentionRules.jobs;
													}
													if (snapToTapeCopy.retentionRules && snapToTapeCopy.retentionRules.retentionFlags) {
														delete snapToTapeCopy.retentionRules.retentionFlags.jobBasedRetention;
													}

													const retentionDays = storageCopyFactory.getRetentionPeriodInDays('DAYS', 30);
													_.set(snapToTapeCopy, 'retentionRules.retainBackupDataForCycles', 0);
													_.set(snapToTapeCopy, 'retentionRules.retainBackupDataForDays', retentionDays);
													_.set(snapToTapeCopy, 'retentionRules.retentionFlags.ignoreJobDependencyCheck', 'SET_TRUE');
													_.set(snapToTapeCopy, 'retentionRules.retentionFlags.jobBasedRetention', 'SET_FALSE');
													_.set(
														snapToTapeCopy,
														'useGlobalPolicy',
														storageRuleRequestObj.storageRules.rules[0].storage.copy[0].useGlobalPolicy
													);
													_.set(snapToTapeCopy, 'extendedFlags.useGlobalStoragePolicy', 'SET_TRUE');
													storageRuleRequestObj.storageRules.rules[0].storage.copy.push(snapToTapeCopy);
													storageRuleRequestObj.storageRules.rules[0].storage.enableBackupCopy = true;
												}
											}

											updateRule(storageRuleRequestObj);
											function updateRule() {
												//pass storage policy name
												/*
												 * if (_.has($scope, 'ruleList[0].regions')) {
												 * storageRuleRequestObj.storageRules.rules[0].storage.storagePolicy = {
												 * storagePolicyName: $scope.selectedRegion[0].name }; } else {
												 * storageRuleRequestObj.storageRules.rules[0].storage.storagePolicy = {
												 * storagePolicyName: $scope.selectedRegion[0].name,
												 * storagePolicyId:
												 * $scope.profileDetails.storage.storagePolicy.storagePolicyId }; }
												 */

												let planId = $scope.profileDetails.summary.plan.planId;
												profileService
													.addRules(planId, storageRuleRequestObj)
													.success(function(res) {
														$modalInstance.dismiss();
														$state.forceReload();
														let msg = profileService.handlePlanErrors(res.errors);
														if (_.isEmpty(msg)) {
															cvToaster.showSuccessMessage({
																ttl: '10000', //10 sec
																message: cvLoc('label.addRuleSuccess')
															});
														} else {
															cvToaster.showErrorMessage({
																ttl: '10000', //10 sec
																message: msg
															});
														}
													})
													.error(function(e) {
														$scope.serverMessage = cvUtil.errMsg(e);
													});
											}
										};

										$scope.cancel = function() {
											$modalInstance.dismiss();
										};

										$scope.saveRule = function() {
											$modalInstance.close($scope.model);
										};
										function getStoragePoolId() {
											const getDefaultCopy = $scope.profileDetails.storage.copy.find(
												copy => copy.isDefault === 'SET_TRUE'
											);
											return getDefaultCopy.useGlobalPolicy.storagePolicyId;
										}
										function setAvailableStoragePools(isNewRule) {
											// remove the storage pools used so far and push only which are remaining
											// go through all pools and create hash of primary pools
											let storageInUse = new Map();
											let secondaryIndex = null;
											if ($scope.ruleList.length === 0) {
												secondaryIndex = 0;
												if ($scope.profileDetails.storage.storagePolicy.storagePolicyId) {
													const storageProfilePolicyId = getStoragePoolId();
													secondaryIndex = $scope.allStoragePools.indexOf(
														$scope.allStoragePools.find(
															storage => storage.storagePoolEntity.storagePoolId == storageProfilePolicyId
														)
													);
												}
											} else {
												for (var i = 0; i < $scope.ruleList.length; i++) {
													let storageCopy = $scope.ruleList[i].storage.copy;
													for (var j = 0; j < storageCopy.length; j++) {
														if (storageCopy[j].isDefault === 'SET_TRUE') {
															storageInUse.set(
																storageCopy[j].useGlobalPolicy.storagePolicyId,
																storageCopy[j].useGlobalPolicy.storagePolicyName
															);
														}
													}
												}
												// if all storage pools have laredy been used as primary storages, do not allow add operation
												if (storageInUse.size > 0) {
													for (var k = 0; k < $scope.allStoragePools.length; k++) {
														let poolId = $scope.allStoragePools[k].storagePoolEntity.storagePoolId;
														if (storageInUse.has(poolId)) {
															$scope.allStoragePools[k].isPrimary = true;
														} else {
															if (!isNewRule || $scope.allStoragePools[k].storagePoolType !== 'SECONDARY_COPY')
																secondaryIndex = k;
														}
													}
												}
											}

											if (secondaryIndex !== null) {
												$scope.storagePools = $scope.allStoragePools;
											}
											return secondaryIndex;
										}

										/** Add copy functionality *** */
										function updateStorageRuleCopies(addedStorages, storagePool) {
											//TODO if isPrimary set to true, donot allow this storage to be added
											if (addedStorages.length > 0) {
												var newStorage = angular.copy(addedStorages);
												$scope.notAvailableStorages = addedStorages;
												$scope.copies = [];
												for (var i = 0; i < newStorage.length; i++) {
													let isSource = (newStorage[i].source && newStorage[i].source.length) > 0 ? false : true;
													if (isSource) {
														$scope.model.retentionDays = newStorage[i].retentionPeriod;
														$scope.primaryStorage = {
															storagePoolEntity: newStorage[i].storagePool.storagePoolEntity
														};
													}

													let copyInfo = {
														retentionDays: addedStorages[i].retentionPeriod,
														copyId: addedStorages[i].copyId,
														isActive: addedStorages[i].isActive
															? mapToActiveInt[addedStorages[i].isActive]
															: isSource
															? 1
															: 0,
														name: addedStorages[i].name,
														isDefault: addedStorages[i].isDefault
															? mapToActiveInt[addedStorages[i].isDefault]
															: isSource
															? 1
															: 0,
														copyType: addedStorages[i].copyType ? 1 : isSource ? 0 : 1,
														storagePool: addedStorages[i].storagePool.storagePoolEntity,
														storagePoolType: addedStorages[i].poolType
															? addedStorages[i].poolType
															: addedStorages[i].storagePool.storagePoolType
													};

													if (addedStorages[i].copyType && addedStorages[i].copyType === 'SELECTIVE') {
														copyInfo.startTime = addedStorages[i].startTime;
														copyInfo.selectiveCopyRules = addedStorages[i].selectiveCopyRules;
														copyInfo.copyType = 2;
													}

													if (addedStorages[i].retentionRules) {
														if (!copyInfo.retentionRules) {
															copyInfo.retentionRules = {};
														}

														angular.merge(copyInfo.retentionRules, addedStorages[i].retentionRules);
													}

													if (addedStorages[i].extendedFlags) {
														if (!copyInfo.extendedFlags) {
															copyInfo.extendedFlags = {};
														}
														angular.merge(copyInfo.extendedFlags, addedStorages[i].extendedFlags);
													}

													$scope.copies.push(copyInfo);
												}
											} else {
												$scope.primaryStorage = {};
											}
										}

										/**
										 * Callback function for cv-plan-storage-component.
										 */
										$scope.onStorageAdded = function(newStorage, addedStorages) {
											updateStorageRuleCopies(addedStorages);
										};
										//when single storage is updated, it is not returned as an array
										$scope.onStorageUpdated = function(newStorage, updatedStorage) {
											updateStorageRuleCopies(updatedStorage, 'OVERWRITE');
										};

										/**
										 * Callback function for cv-plan-storage-component.
										 */
										$scope.onStorageDeleted = function(deletedStorage, addedStorages) {
											updateStorageRuleCopies(addedStorages);
										};

										$scope.onRegisterPlanStorageApi = function(planStorageApi) {
											$scope.addStorage = function() {
												return planStorageApi.addStorage();
											};
										};
										/** End copy functionality ** */
									}
								],
								resolve: {
									profileDetails: function() {
										return $scope.profileDetails;
									},
									addRuleToPlan: function() {
										return $scope.onRuleAdded;
									},
									gridRuleList: function() {
										return $scope.ruleList;
									},
									allStoragePools: function() {
										return $scope.storagePools;
									},
									masterProfile: function() {
										return $scope.masterProfile;
									}
								}
							})
							.result.then(function(newStorageRule) {
								$scope.onRuleAddSuccess(newStorageRule);
							});
					};
					$scope.planRuleApi = {
						addRule: $scope.addRule
					};

					if (angular.isFunction($scope.onRegisterApi)) {
						$scope.onRegisterApi($scope.planRuleApi);
					}
				}
			]
		};
	}
]);

export default planModule;
