import 'vsa/js/controllers/collections.ctrl.js';
import 'modules/plan/js/directives/cv-plan-dcpolicy-entities.js';
import 'common/js/cv-time-relative-picker.js';
import { acAppExchangeModule } from 'common/js/modules';

var module = acAppExchangeModule;

/**
 * A directive used for editing the mailbox types to be included for the different exchange policies that make
 * up the exchange plans.
 */
module.directive('cvExchangePlanMailboxTypes', [
	function() {
		return {
			restrict: 'E',
			scope: {
				mailboxTypes: '=',
				isEdit: '=',
				idName: '='
			},
			templateUrl: 'modules/plan/partials/exchange/mailboxTypesForm.jsp',
			controller: [
				'$scope',
				'cvLoc',
				function($scope, cvLoc) {
					if (angular.isUndefined($scope.isEdit)) {
						$scope.isEdit = true;
					}
					$scope.mailboxCheckBox = [];
					$scope.mailboxOutputModel = [];
					$scope.mailboxCheckBox = $scope.isEdit
						? [
								{
									label: cvLoc('label.primaryMailbox'),
									key: 'primaryMailbox',
									model: $scope.mailboxTypes.primaryMailbox,
									id: `${$scope.idName}primaryMailbox`
								},
								{
									label: cvLoc('label.archiveMailbox'),
									key: 'archiveMailbox',
									model: $scope.mailboxTypes.archiveMailbox,
									id: `${$scope.idName}archiveMailbox`
								},
								{
									label: cvLoc('label.disabledMailbox'),
									key: 'disabledMailbox',
									model: $scope.mailboxTypes.disabledMailbox,
									id: `${$scope.idName}disabledMailbox`
								}
						  ]
						: [
								{
									label: cvLoc('label.archiveMailbox'),
									key: 'archiveMailbox',
									model: $scope.mailboxTypes.archiveMailbox,
									id: `${$scope.idName}archiveMailbox`
								}
						  ];

					$scope.onClickCheckbox = function() {
						_.forEach($scope.mailboxCheckBox, mbxType => {
							$scope.mailboxTypes[mbxType.key] = mbxType.model;
						});
					};
				}
			]
		};
	}
]);

/**
 * A directive used for editing the content indexing information for the different exchange policies that make
 * up the exchange plans.
 */
module.directive('cvExchangePlanContentIndexing', [
	function() {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form', 'cvExchangePlanContentIndexing'],
			scope: {
				contentIndexProps: '=',
				eePolicy: '=',
				isEdit: '=',
				showData: '='
			},
			templateUrl: 'modules/plan/partials/exchange/contentIndexingForm.jsp',
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];

				if (elem.parents('.modal-content').length > 0) {
					controllers[2].inModal = true;
				}
			},
			controllerAs: 'exchangePlanContentIndexingController',
			controller: [
				'$scope',
				'$uibModal',
				'REGEX',
				function($scope, $uibModal, REGEX) {
					var self = this;
					self.REGEX = REGEX;

					self.dateOptions = {
						dateFormat: 'yyyy-MM-dd',
						showWeeks: false
					};
					self.timeOptions = {
						min: null
					};
					if (angular.isUndefined($scope.isEdit)) {
						$scope.isEdit = true;
					}
					$scope.contentIndexProps = $scope.contentIndexProps;
					self.alreadyHasCredentials =
						_.get($scope.contentIndexProps, 'previewPathDir.userAccount.userName', '').length > 0 ? true : false;

					$scope.showData.modalWindowType = _.has($scope.showData, 'modalWindowType')
						? $scope.showData.modalWindowType
						: '';
					/*
					 * Set contentIndexProps value(stringStartTime, enableBackupsOnAndAfter) depending on exsistig
					 * value
					 */
					self.openAdvancedOptions =
						$scope.contentIndexProps.enableDeferredDays ||
						$scope.contentIndexProps.enableBackupsOnAndAfter ||
						$scope.contentIndexProps.syncronizeOn;
					$scope.contentIndexProps.enableBackupsOnAndAfter =
						$scope.contentIndexProps.startTime != 0 && angular.isDefined($scope.contentIndexProps.startTime)
							? true
							: false;

					//prevent dateobject from setting fake data value (12/31/1969)
					if ($scope.contentIndexProps.startTime != 0 && angular.isDefined($scope.contentIndexProps.startTime)) {
						$scope.contentIndexProps.stringStartTime = new Date($scope.contentIndexProps.startTime * 1000);
					}
					//set starttime value from date Obj (stringStartTime) after datetimepicker is close
					self.setStartTime = function(value) {
						//remove milliseconds
						if (
							angular.isDefined($scope.contentIndexProps.stringStartTime) &&
							$scope.contentIndexProps.stringStartTime !== null
						) {
							$scope.contentIndexProps.stringStartTime.setMilliseconds(0);
							$scope.contentIndexProps.startTime = $scope.contentIndexProps.stringStartTime.getTime() / 1000;
						}
					};

					//reset startTime value dependin on enableBackupsOnAndAfter value
					self.resetStartTime = function() {
						if (!$scope.contentIndexProps.enableBackupsOnAndAfter) {
							$scope.contentIndexProps.startTime = 0;
							delete $scope.contentIndexProps.stringStartTime;
						}
					};

					self.onContentSearch = function() {
						if ($scope.contentIndexProps.enableContentIndex === false) {
							$scope.contentIndexProps.enablePreviewGeneration = false;
						}
					};

					/**
					 * Opens the modal for editing the preview generation credentials. If the user successfully saves
					 * his/her credentials after entering them in, they will be copied over to the
					 */
					self.openEditPreviewGenerationCredentials = function() {
						$uibModal
							.open({
								templateUrl: 'modules/plan/partials/exchange/previewGenerationCredentialsModal.jsp',
								backdrop: 'static',
								windowClass: $scope.showData.modalWindowType,
								controllerAs: 'exchangePlanContentIndexingController',
								controller: [
									'$scope',
									'$uibModalInstance',
									'cvLoc',
									'contentIndexProps',
									'REGEX',
									function($scope, $uibModalInstance, cvLoc, contentIndexProps, REGEX) {
										var self = this;
										self.REGEX = REGEX;
										self.modalTitle = cvLoc('label.previewGenerationCredentials');
										self.inModal = true;
										self.templateUrl = 'modules/plan/partials/exchange/previewGenerationCredentials.jsp';
										$scope.contentIndexProps = angular.copy(contentIndexProps);

										/**
										 * When the cancel button is pressed.
										 */
										self.cancel = function() {
											$uibModalInstance.dismiss();
											$scope.contentIndexProps = angular.copy(contentIndexProps);
										};

										/**
										 * When the save button is pressed.
										 */
										self.save = function() {
											$uibModalInstance.close($scope.contentIndexProps);
										};
									}
								],
								resolve: {
									contentIndexProps: $scope.contentIndexProps
								}
							})
							.result.then(function(contentIndexProps) {
								angular.extend(
									$scope.contentIndexProps.previewPathDir.userAccount,
									contentIndexProps.previewPathDir.userAccount
								);
							});
					};
				}
			]
		};
	}
]);

/**
 * A directive used for displaying the details tile for the content indexing information for both types of
 * exchange plans.
 */
module.directive('cvExchangePlanContentIndexingTile', [
	function() {
		return {
			restrict: 'E',
			scope: {
				contentIndexProps: '=',
				onEdit: '&',
				canEdit: '='
			},
			templateUrl: 'modules/plan/partials/exchange/contentIndexingTile.jsp',
			controller: [
				'$scope',
				function($scope) {
					//set stringstarttime (Date Object) from starttime (timestamp)
					if ($scope.contentIndexProps.startTime != 0) {
						$scope.contentIndexProps.stringStartTime = new Date($scope.contentIndexProps.startTime * 1000);
					}
				}
			]
		};
	}
]);

/**
 * A directive used for editing the retention rules for both types of exchange plans.
 */
module.directive('cvExchangePlanRetention', [
	function() {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			scope: {
				retentionPolicy: '=',
				isArchivingMailbox: '=',
				isOffice365Plan: '='
			},
			templateUrl: 'modules/plan/partials/exchange/retentionRulesForm.jsp',
			controller: [
				'$scope',
				'cvLoc',
				'$dialogs',
				function($scope, cvLoc, $dialogs) {
					$scope.timeValues = [
						{
							// See Period.java
							value: 1,
							label: cvLoc('label.retention.days'),
							unit: 0
						},
						{
							value: 30.41,
							label: cvLoc('label.retention.months'),
							unit: 1
						},
						{
							value: 365,
							label: cvLoc('label.retention.years'),
							unit: 2
						}
					];

					$scope.retentionPolicyDays = [1825, 0]; // Default input to 1825 days
					$scope.retentionDeletedMsgPolicyDays = [365, 0]; // Default input to 1825 days

					$scope.retentionSelection = {
						select:
							$scope.retentionPolicy.numOfDaysForMediaPruning >= 1
								? 1
								: $scope.retentionPolicy.numOfDaysForDeletedMediaPruning > 0
								? 2
								: 0
					};

					if ($scope.retentionPolicy.numOfDaysForMediaPruning >= 1) {
						// If retention is not infinite, update the input
						$scope.retentionPolicyDays[0] = $scope.retentionPolicy.numOfDaysForMediaPruning;
					} else if ($scope.retentionPolicy.numOfDaysForDeletedMediaPruning >= 1) {
						// If retention is not infinite, update the input
						$scope.retentionDeletedMsgPolicyDays[0] = $scope.retentionPolicy.numOfDaysForDeletedMediaPruning;
					} else {
						$scope.retentionPolicy.numOfDaysForMediaPruning = -1;
						$scope.retentionPolicy.numOfDaysForDeletedMediaPruning = -1;
					}

					$scope.onRetentionPolicyDaysChange = function(id, seconds, selectedValues) {
						$scope.retentionPolicyDays[0] = selectedValues.value;
						$scope.retentionPolicyDays[1] = selectedValues.label.unit;
						$scope.retentionPolicy.numOfDaysForMediaPruning = Math.floor(
							selectedValues.value * selectedValues.label.value
						);
					};

					$scope.onRetentionDeletedMsgPolicyDaysChange = function(id, seconds, selectedValues) {
						$scope.retentionDeletedMsgPolicyDays[0] = selectedValues.value;
						$scope.retentionDeletedMsgPolicyDays[1] = selectedValues.label.unit;
						$scope.retentionPolicy.numOfDaysForDeletedMediaPruning = Math.floor(
							selectedValues.value * selectedValues.label.value
						);
					};

					$scope.retainIndefinitely = function() {
						$scope.retentionPolicy.numOfDaysForMediaPruning = -1;
						$scope.retentionPolicy.numOfDaysForDeletedMediaPruning = -1;
					};

					$scope.setRetention = function(msgType) {
						if (msgType === 'received' || msgType === 'deleted') {
							$scope.retentionPolicy.numOfDaysForMediaPruning =
								msgType === 'received'
									? Math.floor($scope.retentionPolicyDays[0] * $scope.timeValues[$scope.retentionPolicyDays[1]].value)
									: -1;
							$scope.retentionPolicy.numOfDaysForDeletedMediaPruning =
								msgType === 'received'
									? -1
									: Math.floor(
											$scope.retentionDeletedMsgPolicyDays[0] *
												$scope.timeValues[$scope.retentionDeletedMsgPolicyDays[1]].value
									  );
							$scope.retentionSelection.select = msgType === 'received' ? 1 : 2;
						}
					};

					$scope.retainReceivedMessages = function() {
						if (
							$scope.retentionPolicy.numOfDaysForMediaPruning == -1 &&
							$scope.retentionPolicy.numOfDaysForDeletedMediaPruning == -1
						) {
							$dialogs.confirm(cvLoc('label.warningTitle'), cvLoc('warning.retentionWarning', ''), {
								noFunction: function() {
									$scope.retentionSelection.select = 0;
								},
								yesFunction: function() {
									$scope.setRetention('received');
								}
							});
						} else {
							$scope.setRetention('received');
						}
					};

					$scope.retainDeletedMessages = function() {
						if (
							$scope.retentionPolicy.numOfDaysForMediaPruning == -1 &&
							$scope.retentionPolicy.numOfDaysForDeletedMediaPruning == -1
						) {
							$dialogs.confirm(cvLoc('label.warningTitle'), cvLoc('warning.retentionWarning', ''), {
								noFunction: function() {
									$scope.retentionSelection.select = 0;
								},
								yesFunction: function() {
									$scope.setRetention('deleted');
								}
							});
						} else {
							$scope.setRetention('deleted');
						}
					};
				}
			],
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];

				if (elem.parents('.modal-content').length > 0) {
					scope.inModal = true;
				}
			}
		};
	}
]);

/**
 * A directive used for displaying the details tile for the retention rules for the different types of
 * exchange plans.
 */
module.directive('cvExchangePlanRetentionTile', [
	function() {
		return {
			restrict: 'E',
			scope: {
				plan: '=',
				canEdit: '=',
				isArchiveMailbox: '='
			},
			templateUrl: 'modules/plan/partials/exchange/retentionRulesTile.jsp'
		};
	}
]);

/**
 * A directive used for editing the Cleanup Messages rules for the Cleanup policy.
 */
module.directive('cvExchangePlanCleanupMessages', [
	function() {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			scope: {
				cleanupPolicy: '=',
				archivePolicy: '=',
				isEdit: '='
			},
			templateUrl: 'modules/plan/partials/exchange/cleanupMessagesForm.jsp',
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];

				if (elem.parents('.modal-content').length > 0) {
					scope.inModal = true;
				}
			},
			controller: [
				'$scope',
				'cvLoc',
				function($scope, cvLoc) {
					if (angular.isUndefined($scope.isEdit)) {
						$scope.isEdit = true;
					}
					if (angular.isUndefined($scope.archivePolicy)) {
						$scope.archivePolicy = false;
					}
					if ($scope.archivePolicy === true) {
						$scope.cleanupPolicy.archiveMailbox = true;
					}
					$scope.defaultObj = [
						{ label: cvLoc('label.replaceAllMessagesWithAStub'), value: true },
						{ label: cvLoc('label.deleteAllMessages'), value: false }
					];
					$scope.clickMailboxType = function(data) {
						if (data === false) {
							$scope.cleanupPolicy.addRecallLink = false;
							$scope.cleanupPolicy.truncateBody = false;
							$scope.cleanupPolicy.leaveMsgBody = false;
						} else {
							$scope.cleanupPolicy.addRecallLink = true;
							$scope.cleanupPolicy.truncateBody = true;
							$scope.cleanupPolicy.leaveMsgBody = true;
						}
					};
				}
			]
		};
	}
]);

export default module;
