/**
 *
 */
import { acAppExchangeModule } from 'common/js/modules';

var module = acAppExchangeModule;
/**
 * A directive used for edit Journal options for Archive/Cleanup/Journal policy.
 */
module.directive('cvExchangeJournalOptions', [
	function() {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			scope: {
				journalPolicy: '=',
				mailboxOptions: '=',
				showJournalOptions: '='
			},
			templateUrl: appUtil.appRoot + 'modules/plan/partials/exchange/journalOptionsForm.jsp',
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];

				if (elem.parents('.modal-content').length > 0) {
					scope.inModal = true;
				}
			}
		};
	}
]);
export default module;
