import * as getStorageCopyColumnTemplate from '../columnTemplates/storageCopy.column.template.js';
import 'modules/plan/js/factory/storageCopy.factory.js';
import 'modules/plan/js/factory/planRule.factory.js';
import { commonPlanModule } from 'common/js/modules';

export class CvPlanStorageCopies {
	constructor($modal, cvUtil, cvLoc, cvTableOptions, storageCopyFactory, planRuleFactory, cvToaster) {
		this.restrict = 'E';
		this.scope = {
			/**
			 * An array of the storage objects that have already been added. Will be updated as storages are
			 * added or removed by this directive. The storage objects have the following properties: {string}
			 * name {number} retentionPeriod {Object} storagePool - See StoragePoolInfo.java
			 */
			addedStorages: '=cvModel',

			onAddCopy: '=cvOnCopyAdded',
			/**
			 * A callback that is called whenever this directive deletes a storage from the model. Takes 2
			 * arguments: the deleted storage, and the list of added storages (the model)
			 */
			onDeleteCopy: '=cvOnCopyDeleted',
			/**
			 * Show pool name as a url if compoennet is part of elastic plan UI
			 */
			isElastic: '=cvIsElastic',
			/**
			 * Show different edit components based on the plan sub type
			 */
			planSubType: '=cvPlanSubType',
			/**
			 * Show/hide edit option for storage and rule
			 */
			showEdit: '=',

			ruleIndex: '=cvRuleIndex',

			isRuleBasedView: '=cvIsRuleBasedView',

			gridColumnOptions: '=cvGridColumnOptions',

			onGridInit: '=cvOnGridInit',

			isFirstTime: '=cvIsFirstTime',

			showSource: '=cvShowSource'
		};
		this.templateUrl = appUtil.appRoot + 'modules/plan/partials/planStorageCopyTemplate.jsp';
		this.$modal = $modal;
		this.cvUtil = cvUtil;
		this.cvLoc = cvLoc;
		this.cvTableOptions = cvTableOptions;
		this.storageCopyFactory = storageCopyFactory;
		this.planRuleFactory = planRuleFactory;
		this.cvToaster = cvToaster;
	}

	link(scope, element, attrs) {
		const self = this;
		self.__scope = scope;
		scope.showEdit = scope.showEdit == false ? scope.showEdit : true;
		scope.isFirstTime = scope.isFirstTime == true ? scope.isFirstTime : false;
		scope.kendoId = 'copyList_' + cvUtil.generateUUID();

		scope.AddCopy = function() {
			if (scope.gridColumnOptions && scope.gridColumnOptions.isRuleBasedEdit) {
				scope.onAddCopy(undefined, undefined, scope.addedStorages);
			} else {
				scope.onAddCopy(null, scope.showSource);
			}
		};

		scope.AddSnapCopy = function() {
			if (scope.gridColumnOptions && scope.gridColumnOptions.isRuleBasedEdit) {
				scope.onAddCopy(undefined, undefined, scope.addedStorages, true);
			} else {
				scope.onAddCopy(null, true, true);
			}
		};

		scope._setupGridOptions = function(cvBreadcrumbsTabsFactory) {
			let gridOptions = {};
			gridOptions.columns = scope._initColumnDefs();
			gridOptions.tableName = 'planStorageComponentTable' + '_' + cvUtil.generateUUID();
			gridOptions.gridEmptyMessage = self.cvLoc('error.noCopiesConfigured');
			gridOptions.onGridDataBound = scope._onGridDataBound;
			gridOptions.data = scope.addedStorages;
			gridOptions.enableFiltering = false;
			gridOptions.enableColumnMenu = false;
			gridOptions.enableColumnResizing = false;
			gridOptions.hasViews = false;
			gridOptions.hasDefaultView = false;
			gridOptions.gridToolbarMenu = [];
			gridOptions.beforeGridInitialize = ({ grid }) => {
				scope.grid = grid;
				if (scope.onGridInit) {
					scope.onGridInit(grid);
				}

				$('.storage-derive-checkbox input').change(function() {
					if ($(this).prop('checked')) {
						scope.grid.gridDataSrc.dataSource.filter({
							logic: 'or',
							filters: [
								{ field: 'isSnapCopy', operator: 'eq', value: 'SET_FALSE' },
								{ field: 'isSnapshotCopy', operator: 'eq', value: false },
								{ field: 'isSnapPrimary', operator: 'eq', value: true }
							]
						});
					} else {
						scope.grid.gridDataSrc.dataSource.filter({});
					}
				});
			};

			if (scope.gridColumnOptions.showToolBar != undefined && scope.gridColumnOptions.showToolBar === true) {
				gridOptions.gridToolbarMenu = [
					{
						id: 'addCopy' + cvUtil.generateUUID(),
						disableOnDeselect: false,
						label: 'Add',
						subOptions: scope.getToolbarSubOptions()
						/*
						 * , hidden :
						 * !this.cvPermissionFactory.userHasPermissions([this.PERMISSIONS.CREATE_PLAN],cv.userPermissions) //
						 * Checking the permission at parent level since all plan creation should atleast have
						 * plan creation permission
						 */
					}
				];
			}

			scope.gridOptions = gridOptions;
		};

		scope.getToolbarSubOptions = function() {
			let subOptions = [];
			let subOption = {
				id: 'AddCopy' + cvUtil.generateUUID(),
				label: 'Copy',
				onSelect: scope.AddCopy
			};
			subOptions.push(subOption);

			if (!scope.planSubType || scope.planSubType !== 'Archiver') {
				subOption = {
					id: 'AddSnapCopy' + cvUtil.generateUUID(),
					label: 'Snap copy',
					onSelect: scope.AddSnapCopy
				};
				subOptions.push(subOption);
			}
			return subOptions;
		};

		scope._onGridDataBound = function(dataItem, row) {
			if (scope.showEdit) {
				const storageCopyLink = row.find('.k-grid-copyName');
				storageCopyLink.click(function() {
					scope.onAddCopy(dataItem, dataItem.index);
				});
				const storageDeleteAction = row.find('.k-grid-delete-copy');
				storageDeleteAction.click(function() {
					scope.onDeleteCopy(dataItem);
				});
			}
		};

		scope._initColumnDefs = function() {
			return getStorageCopyColumnTemplate.getStorageCopyColumnTemplate({
				...scope.gridColumnOptions,
				showEdit: scope.showEdit,
				disabled: 'disabled',
				storageCopyFactory: self.storageCopyFactory,
				planRuleFactory: self.planRuleFactory,
				isFirstTime: scope.isFirstTime
			});
		};

		scope._setupGridOptions();
	}
}

commonPlanModule.directive('cvPlanStorageCopies', [
	'$uibModal',
	'cvUtil',
	'cvLoc',
	'cvTableOptions',
	'storageCopyFactory',
	'planRuleFactory',
	'cvToaster',
	($modal, cvUtil, cvLoc, cvTableOptions, storageCopyFactory, planRuleFactory, cvToaster) =>
		new CvPlanStorageCopies($modal, cvUtil, cvLoc, cvTableOptions, storageCopyFactory, planRuleFactory, cvToaster)
]);
