import 'modules/plan/js/directives/planDirectives.js';

import { commonPlanModule } from 'common/js/modules';
import 'modules/plan/js/directives/planDirectives.js';
import * as getStorageCopyColumnTemplate from '../columnTemplates/storageCopy.column.template.js';
import 'modules/plan/js/factory/storageCopy.factory.js';

commonPlanModule.directive('cvPlanStorageComponent', [
	function() {
		return {
			restrict: 'E',
			scope: {
				/**
				 * An array of the storage objects that have already been added. Will be updated as storages
				 * are added or removed by this directive. The storage objects have the following properties:
				 * {string} name {number} retentionPeriod {Object} storagePool - See StoragePoolInfo.java
				 */
				addedStorages: '=cvModel',
				/**
				 * The list of all available storage pools. Objects in the list should match
				 * StoragePoolInfo.java
				 */
				storagePools: '=cvStoragePools',
				/**
				 * Callback function that is called whenever this directive adds a storage to the model. Takes
				 * 2 arguments: the new storage, and the list of added storages (the model)
				 */
				onStorageAdded: '=cvOnStorageAdded',
				/**
				 * A callback that is called whenever this directive deletes a storage from the model. Takes 2
				 * arguments: the deleted storage, and the list of added storages (the model)
				 */
				onStorageDeleted: '=cvOnStorageDeleted',
				/**
				 * A callback that returns the planStorageApi once the directive is instantiated, which can be
				 * used to interact with the directive programatically.
				 */
				onRegisterApi: '=cvOnRegisterApi',
				/**
				 * Callback function that is called whenever this directive updates a storage to the model.
				 * Takes 2 arguments: the new storage, and the list of updated storages (the model)
				 */
				onStorageUpdated: '=cvOnStorageUpdated',
				/**
				 * Show pool name as a url if compoennet is part of elastic plan UI
				 */
				isElastic: '=cvIsElastic',
				/**
				 * Show different edit components based on the plan sub type
				 */
				planSubType: '=cvPlanSubType',

				ruleStoragePolicy: '=cvRuleStoragePolicy',

				showEdit: '=?',

				ruleIndex: '=cvRuleIndex',

				isFirstTime: '=cvIsFirstTime',

				isDerivePlanReq: '=cvIsDerivePlanReq',

				isNewRule: '=cvNewRule'
			},
			templateUrl: appUtil.appRoot + 'modules/plan/partials/planStorageTemplate.jsp',
			link: function(scope, element, attrs) {
				// console.log("scope.addedStorages",scope.addedStorages);
			},
			controllerAs: 'ctrl',
			controller: [
				'$scope',
				'$uibModal',
				'cvUtil',
				'cvLoc',
				'cvTableOptions',
				'$dialogs',
				'storageService',
				'storagePoolTypesConstants',
				'planRuleFactory',
				function(
					$scope,
					$modal,
					cvUtil,
					cvLoc,
					cvTableOptions,
					$dialogs,
					storageService,
					storagePoolTypesConstants,
					planRuleFactory
				) {
					$scope.showEdit = $scope.showEdit == false ? $scope.showEdit : true;

					$scope.planStorageCopyListId = 'copyListParent_' + cvUtil.generateUUID();
					$scope.isRuleBasedView = true;
					// Build up the map
					var storagePoolMap = {};
					// Build up the map
					var storagePoolMap = {};
					for (var j = 0; j < $scope.storagePools.length; j++) {
						var current_pool = $scope.storagePools[j].storagePoolEntity.storagePoolName;
						storagePoolMap[current_pool] = {};
						if (storagePoolMap[current_pool] != undefined) {
							storagePoolMap[current_pool].disabled = '';
							storagePoolMap[current_pool].toolTipMSG = '';
							storagePoolMap[current_pool].poolType = $scope.storagePools[j].storagePoolType;
							storagePoolMap[current_pool].poolTypeForUrl =
								storagePoolTypesConstants[$scope.storagePools[j].storagePoolType];
							if (
								storagePoolMap[current_pool].poolType === 'SECONDARY_COPY' ||
								(storagePoolMap[current_pool].poolType === 'NON_DEDUPLICATION' &&
									$scope.storagePools[j].storageSubType === 'IBMi_VTL')
							) {
								storagePoolMap[current_pool].poolURL = 'tapeStoragePoolInfo';
							} else {
								storagePoolMap[current_pool].poolURL = 'diskStoragePoolInfo';
							}
						}
					}

					for (var i = 0; i < $scope.addedStorages.length; i++) {
						let storage = $scope.addedStorages[i];
						storage.index = i;
						storage.disabled = 'disabled';
						storage.poolURL = '';
						storage.poolType = '';
						storage.showEdit = $scope.showEdit;
						storage.toolTipMSG = cvLoc('label.noStorageViewPermission');
						storage.copyTypeName = planRuleFactory.getCopyTypeName(storage);
						storage.isSnapPrimary = planRuleFactory.isSnapPrimaryStorage(storage);
						storage.StoragePolicyCopy = {};
						storage.StoragePolicyCopy['copyName'] = storage.name;
						storage.StoragePolicyCopy['copyId'] = storage.copyId;

						if (!storage.retentionRules) {
							storage.retentionRules = {};
							storage.retentionRules.retainBackupDataForDays = storage.retentionPeriod ? storage.retentionPeriod : 30;
						}

						let storagePoolName =
							storage.useGlobalPolicy && storage.useGlobalPolicy.storagePolicyName
								? storage.useGlobalPolicy.storagePolicyName
								: storage.globalAuxCopy && storage.globalAuxCopy.storagePolicyName
								? storage.globalAuxCopy.storagePolicyName
								: storage.storagePool &&
								  storage.storagePool.storagePoolEntity &&
								  storage.storagePool.storagePoolEntity.storagePoolName
								? storage.storagePool.storagePoolEntity.storagePoolName
								: '';
						if (storagePoolName != '' && storagePoolMap[storagePoolName]) {
							let storagePoolInfo = storagePoolMap[storagePoolName];
							storage.poolType = storagePoolInfo.poolType;
							storage.poolTypeForUrl = storagePoolInfo.poolTypeForUrl;
							storage.poolURL = storagePoolInfo.poolURL;
							storage.disabled = '';
							storage.toolTipMSG = '';
							storage.storagePoolType = storage.poolType;
						}
					}

					$scope.gridColumnOptions = {
						angularLibs: {
							cvLoc: cvLoc
						},
						retentionLabel: cvLoc('label.retentionDays'),
						isRuleBasedStorage: true,
						isRuleBasedEdit: $scope.ruleStoragePolicy ? true : false,
						isElastic: $scope.isElastic,
						planSubType: $scope.planSubType,
						showSnapShotCopy: $scope.ruleStoragePolicy ? true : false,
						showToolBar:
							$scope.ruleStoragePolicy && $scope.showEdit && $scope.addedStorages && $scope.addedStorages.length
								? true
								: false
					};

					$scope.onGridInit = function(grid) {
						$scope.grid = grid;
					};

					$scope.deleteStorageCopy = function(storage) {
						var delteStorageCallbackFunctions = {
							noFunction: function() {
								return;
							},
							yesFunction: function() {
								$scope.deleteStorage(storage);
							}
						};

						$dialogs.confirm(cvLoc('action.delete'), cvLoc('warn.deleteStorageCopy'), delteStorageCallbackFunctions);
					};
					/**
					 * Removes the given storage object from the model.
					 *
					 * @param {Object}
					 *            storage - Must be a storage object in the model.
					 */
					$scope.deleteStorage = function(storage) {
						//if(storage.rowValue){storage = storage.rowValue;}
						$scope.gridServerMessage = cvUtil.emptyMsg();
						for (let i = 0; i < $scope.addedStorages.length; i++) {
							if (
								(storage.copyId &&
									$scope.addedStorages[i].copyId &&
									storage.copyId === $scope.addedStorages[i].copyId) ||
								storage.StoragePolicyCopy.copyName === $scope.addedStorages[i].StoragePolicyCopy.copyName
							) {
								// delete storage
								let deletedStorage = $scope.addedStorages[i];
								$scope.addedStorages.splice(i, 1);

								if (angular.isFunction($scope.onStorageDeleted)) {
									$scope.onStorageDeleted(deletedStorage, $scope.addedStorages);
								}
								$scope.grid.refreshData();
								return;
							}
						}
					};

					$scope.addStorage = function(existingStorage, index, addedStorage, isSnapshotCopy) {
						isSnapshotCopy = isSnapshotCopy || _.get(existingStorage, 'isSnapCopy', false) === 'SET_TRUE';

						if (isSnapshotCopy === true) {
							if ($scope.snapVendorsInfo) {
								$scope.displayCopyDialog(existingStorage, index, addedStorage, isSnapshotCopy, $scope.snapVendorsInfo);
							} else {
								storageService.getSnapVendors().then(function(data) {
									if (data && data.data) {
										let snapVendorsInfo = {};
										let snapVendors = [];
										let svmMap = {};
										_.get(data.data, 'replicationVendor', []).forEach(function(array) {
											snapVendors.push(array.vendor);
											svmMap[array.vendor.id] = {
												svmList: array.replicationEntity,
												sourceLabel: _.get(array, 'sourceLabel', ''),
												destLabel: _.get(array, 'destLabel', ''),
												mapHeadingLabel: _.get(array, 'mapHeadingLabel', '')
											};
										});
										snapVendorsInfo.snapVendors = snapVendors;
										snapVendorsInfo.svmMap = svmMap;
										$scope.snapVendorsInfo = snapVendorsInfo;
										$scope.displayCopyDialog(
											existingStorage,
											index,
											addedStorage,
											isSnapshotCopy,
											$scope.snapVendorsInfo
										);
									}
								});
							}
						} else {
							$scope.displayCopyDialog(existingStorage, index, addedStorage, isSnapshotCopy, undefined);
						}
					};

					/**
					 * Opens a modal to add a storage to the model.
					 *
					 * @param {Object=}
					 *            initialStorage - Optional. Must be a storage in the model. If given, will
					 *            edit this storage instead of adding a new one.
					 * @return {Promise}
					 */
					$scope.displayCopyDialog = function(initialStorage, index, addedStorage, isSnapshotCopy, snapVendorsInfo) {
						$scope.indexOfEditStorage = index;
						return $modal
							.open({
								templateUrl: appUtil.appRoot + 'modules/plan/partials/editPlanStorage.jsp',
								backdrop: 'static',
								resolve: {
									addedStorages: function() {
										return $scope.addedStorages;
									},
									storagePools: function() {
										return $scope.storagePools;
									},
									initialStorage: function() {
										return initialStorage;
									},
									planSubType: function() {
										return $scope.planSubType;
									},
									isElastic: function() {
										return $scope.isElastic;
									},
									ruleStoragePolicy: function() {
										return $scope.ruleStoragePolicy;
									},
									isFirstTime: function() {
										return $scope.isFirstTime;
									},
									isDerivePlanReq: function() {
										return $scope.isDerivePlanReq;
									},
									isNewRule: function() {
										return $scope.isNewRule;
									}
								},
								controller: [
									'$scope',
									'$uibModalInstance',
									'cvUtil',
									'addedStorages',
									'storagePools',
									'initialStorage',
									'planSubType',
									'isElastic',
									'ruleStoragePolicy',
									'storagePolicyService',
									'storageCopyFactory',
									'isFirstTime',
									'planRuleFactory',
									'isDerivePlanReq',
									'isNewRule',
									function(
										$scope,
										$modalInstance,
										cvUtil,
										addedStorages,
										storagePools,
										initialStorage,
										planSubType,
										isElastic,
										ruleStoragePolicy,
										storagePolicyService,
										storageCopyFactory,
										isFirstTime,
										planRuleFactory,
										isDerivePlanReq,
										isNewRule
									) {
										$scope.availableStoragePools = [];
										$scope.storagePools = storagePools;
										$scope.planSubType = planSubType;
										$scope.initModel = initialStorage;
										$scope.editMode = !!initialStorage;
										$scope.isElastic = isElastic;
										$scope.isSnapshotCopy = isSnapshotCopy;
										$scope.snapVendorsInfo = snapVendorsInfo;
										$scope.storages = angular.copy(addedStorages);

										let showSource = false;

										if (ruleStoragePolicy && ruleStoragePolicy.storagePolicyId) {
											$scope.storagePolicy = ruleStoragePolicy;
											showSource = true;
										}

										$scope.showSource = showSource;

										if (!$scope.editMode && addedStorage) {
											addedStorages = addedStorage;
											$scope.storages = angular.copy(addedStorages);
											$scope.isDefaultVaultReplica = planRuleFactory.isDefaultVaultReplicaCopyExists($scope.storages);
											$scope.isSnapPrimary =
												$scope.isSnapshotCopy &&
												_.filter($scope.storages, storage => storage.isSnapPrimary).length == 0;
										}
										if ($scope.editMode) {
											let initModel = {
												copyId: initialStorage.copyId,
												editMode: $scope.editMode,
												storagePool: initialStorage.storagePool,
												index: initialStorage.index,
												enableStoragePool: initialStorage.enableStoragePool == false ? false : true
											};

											if (initialStorage.poolType) {
												initModel.storagePool.storagePoolType = initialStorage.poolType;
											}

											if (isDerivePlanReq === false && initialStorage.storagePolicyId && initialStorage.copyId) {
												$scope.initModel = { ...initModel, storagePolicyId: initialStorage.storagePolicyId };
											} else if (ruleStoragePolicy && ruleStoragePolicy.storagePolicyId && initialStorage.copyId) {
												$scope.initModel = { ...initModel, storagePolicyId: ruleStoragePolicy.storagePolicyId };
												$scope.initModel.isMirrorCopy = initialStorage.isMirrorCopy;
												$scope.initModel.isSnapPrimary = planRuleFactory.isSnapPrimaryStorage(initialStorage);
												$scope.isSnapPrimary = $scope.initModel.isSnapPrimary;
												$scope.storagePolicy = ruleStoragePolicy;
											} else {
												let isMirrorCopy = planRuleFactory.isMirror(initialStorage);

												$scope.initModel = {
													storagePolicyId: initialStorage.storagePolicyId,
													copyName: initialStorage.name,
													copyId: initialStorage.copyId,
													isDefault: initialStorage.isDefault,
													retentionPeriod: initialStorage.retentionPeriod,
													storagePool: initialStorage.storagePool,
													enableStoragePool: initialStorage.enableStoragePool == false ? false : true,
													infiniteSelected: initialStorage.retentionPeriod === -1 ? true : false,
													overrideRetention: initialStorage.overrideRetention || false,
													source: initialStorage.source,
													isPrimary: initialStorage.isPrimary === true ? true : false,
													copyType: initialStorage.copyType,
													startTime: initialStorage.startTime,
													retentionRules: initialStorage.retentionRules,
													selectiveCopyRules: initialStorage.selectiveCopyRules,
													editMode: $scope.editMode,
													index: initialStorage.index,
													replPairList: initialStorage.replPairList,
													regionMap: initialStorage.regionMap,
													isMirrorCopy: isMirrorCopy,
													snapCopyType: isMirrorCopy ? 1 : 0,
													currentCopyDefaultVaultReplica:
														!isMirrorCopy && planRuleFactory.isDefaultVaultReplica(initialStorage),
													isDerivePlanReq: isDerivePlanReq === true ? true : false,
													isSnapPrimary: planRuleFactory.isSnapPrimaryStorage(initialStorage),
													extendedFlags: initialStorage.extendedFlags || {}
												};

												$scope.storagePolicy = {
													storagePolicyId: initialStorage.storagePolicyId
												};

												$scope.isSnapPrimary = $scope.initModel.isSnapPrimary;
											}
											$scope.initModel.optimizeForInstantClone = initialStorage.optimizeForInstantClone;
										}

										if (addedStorages.length === 0) {
											$scope.isPrimary = true;
										}

										$scope.cancel = function() {
											$modalInstance.dismiss();
										};

										$scope.getSourceCopyId = function() {
											for (var i in addedStorages) {
												if (addedStorages[i].name === $scope.model.source) {
													return addedStorages[i].copyId;
												}
											}
											return '';
										};

										var isPrimaryCopy = function() {
											return (
												(!$scope.initModel && (!$scope.storages || !$scope.storages.length)) ||
												($scope.initModel && $scope.initModel.isPrimary)
											);
										};

										$scope.saveStorage = function() {
											$scope.serverMessage = cvUtil.emptyMsg();
											$scope.model.name = $scope.model.storageName;

											//set retention as null if storage pool is tape
											if (
												$scope.isSnapshotCopy === false &&
												$scope.model.storagePool.storagePoolType === 'SECONDARY_COPY'
											) {
												$scope.model.globalAuxCopy = {
													storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
													storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
												};

												if ($scope.model.overrideRetention) {
													$scope.model.extendedFlags = {
														overRideGACPRetention: 'SET_TRUE'
													};
													//set infinite retention as -1
													if ($scope.model.infiniteSelected) {
														$scope.model.retentionPeriod = -1;
													}
												} else {
													//for primary regular copy do not send overidegacp retention for secondary copy storage pool. hence removing it here.
													if (!isPrimaryCopy()) {
														$scope.model.extendedFlags = {
															overRideGACPRetention: 'SET_FALSE'
														};
														if (!isNewRule) {
															$scope.model.retentionPeriod = null;
														}
													}
												}
											} else {
												if ($scope.model.infiniteSelected) {
													$scope.model.retentionPeriod = -1;
												}
											}
											if (!$scope.editMode) {
												for (let i = 0; i < addedStorages.length; i++) {
													if ($scope.model.name === addedStorages[i].name) {
														$scope.serverMessage = cvUtil.errMsgLoc('error.storageCopyNameTaken');
														return;
													}
												}
											}
											if (
												$scope.model.storagePool.storagePoolType != 'SECONDARY_COPY' &&
												!$scope.model.infiniteSelected &&
												($scope.model.retentionPeriod < 1 || $scope.model.retentionPeriod > 9999)
											) {
												$scope.serverMessage = cvUtil.errMsgLoc('error.retentionPeriod');
												return;
											}
											if ($scope.model.storagePool.isPrimary && $scope.model.source === '' && !isNewRule) {
												$scope.serverMessage = cvUtil.errMsgLoc('error.primaryCopyAlreadyTaken');
												return;
											}

											if (!storageCopyFactory.isExtendedRetentionValid($scope.model)) {
												return;
											} else {
												$scope.model.retentionRules = $scope.model.retentionRules || {};
												$scope.model.retentionRules.retainBackupDataForDays = $scope.model.retentionPeriod;
												$scope.model.retentionRules = Object.assign(
													$scope.model.retentionRules,
													storageCopyFactory.getExtendedRetentionRules($scope.model)
												);
											}

											storageCopyFactory.updateSecondaryCopyCycles($scope.model, addedStorages, $scope.model);

											$scope.model.StoragePolicyCopy = {};
											$scope.model.StoragePolicyCopy['copyName'] = $scope.model.name;
											if ($scope.model.copyId) {
												$scope.model.StoragePolicyCopy['copyId'] = $scope.model.copyId;
											}

											if ($scope.isSnapshotCopy) {
												/* Atleast 1 SVM Mapping is mandatory for Mirror copy */
												if (!storageCopyFactory.isSVMValid($scope.model, addedStorages, $scope)) {
													return;
												} else {
													storageCopyFactory.updateSnapCopySVM($scope.model, $scope.model, addedStorages);
												}

												$scope.model.useGlobalPolicy = {
													storagePolicyId: $scope.model.storagePool.storagePoolEntity.storagePoolId,
													storagePolicyName: $scope.model.storagePool.storagePoolEntity.storagePoolName
												};

												storageCopyFactory.updateSnapCopyDetails(
													$scope.isSnapPrimary,
													$scope.model,
													$scope.model,
													addedStorages
												);
											}

											if ($scope.initModel) {
												if (isDerivePlanReq === true) {
													if ($scope.isSnapPrimary) {
														$scope.model.extendedFlags = $scope.initModel.extendedFlags;
														$scope.model.isSnapPrimary = true;
													}
													$scope.model.isPrimary = $scope.initModel.isPrimary;
												}
												$scope.model.storagePolicyId = $scope.initModel.storagePolicyId;
												$scope.model.isPrimary = $scope.initModel.isPrimary === true ? true : false;
											}

											storageCopyFactory.updateSelectiveCopyInfo($scope.model, $scope.model);

											if ($scope.showSource) {
												// do not populate id for primary copy as empty value cannot be parsed by server
												if ($scope.model.source) {
													let sourceCopyId = $scope.getSourceCopyId();
													if (sourceCopyId) {
														$scope.model.sourceAuxCopy = {
															copyId: sourceCopyId,
															copyName: $scope.model.source
														};
													}
												}
											}

											$modalInstance.close({ model: $scope.model, addedStorage: addedStorage });
										};
									}
								]
							})
							.result.then(function(storage) {
								var newStorage = storage.model;
								if (storage.addedStorage) {
									$scope.addedStorages = storage.addedStorage;
								}
								if (angular.isDefined($scope.indexOfEditStorage)) {
									$scope.addedStorages[$scope.indexOfEditStorage] = newStorage;
									if (angular.isFunction($scope.onStorageUpdated)) {
										$scope.onStorageUpdated(newStorage, $scope.addedStorages);
									}
								} else {
									if (!$scope.isElastic) {
										if ($scope.addedStorages.length === 0) {
											newStorage.isPrimary = true;
										}
										$scope.addedStorages.push(newStorage);
									}
									if (angular.isFunction($scope.onStorageAdded)) {
										$scope.onStorageAdded(newStorage, $scope.addedStorages);
									}
								}
								//assign index for edit and delete
								$scope.addedStorages.forEach(function(storage, index) {
									storage.index = index;
								});

								if ($scope.grid && (!$scope.isElastic || !newStorage.copyId)) {
									$scope.grid.refreshData();
								}
							});
					};

					$scope.planStorageApi = {
						addStorage: $scope.addStorage
					};

					if (angular.isFunction($scope.onRegisterApi)) {
						$scope.onRegisterApi($scope.planStorageApi);
					}

					$scope._cvOptions = {
						_onAddedStorage: $scope.addStorage
					};
				}
			]
		};
	}
]);

export default commonPlanModule;
