import 'ediscovery/common/js/services/ediscovery.svc.js';

import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.directive('cvPlanDcpolicyEntities', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/dcPolicyEntitiesTemplate.jsp',
			controllerAs: 'model',
			require: ['?^^cvSubmit', '?^^form'],
			scope: {
				dcPolicy: '=',
				readOnly: '@',
				labelPosition: '@', // css class for position of label
				controlPosition: '@' // css class for position of multiselect
			},
			link: function(scope, elem, attr, controllers) {
				scope.submitCtrl = controllers[0];
				scope.formCtrl = controllers[1];
			},
			controller: [
				'$scope',
				'$log',
				'cvLoc',
				'cvUtil',
				'ediscoveryService',
				function($scope, $log, cvLoc, cvUtil, ediscoveryService) {
					var self = this;
					self.eePolicy = $scope.dcPolicy;
					self.readOnly = angular.isUndefined($scope.readOnly) ? false : $scope.readOnly === 'true';
					self.labelPosition = angular.isUndefined($scope.labelPosition)
						? 'col-xs-12 col-md-5 col-lg-5 margin-top-10'
						: $scope.labelPosition;
					self.controlPosition = angular.isUndefined($scope.controlPosition)
						? 'col-xs-12 col-md-7 col-lg-7'
						: $scope.controlPosition;
					// Flag to determine if the output model has changed
					self.isDirty = false;
					self.entitiesText = cvUtil.getIStevenLocLabels();
					self.entitiesText.nothingSelected = cvLoc('label.noneSelected');
					self.helperElements = self.readOnly ? 'filter' : 'all none reset filter';
					self.styleClass = self.readOnly ? 'entity-select-readonly' : '';
					self.entities = [];

					self.setSelectedEntities = function(entityList) {
						self.multiSelectEntities = [];
						if (entityList.length === 0) {
							if (angular.isUndefined($scope.dcPolicy.detail.eePolicy.extractionPolicy.selectedEntities))
								$scope.dcPolicy.detail.eePolicy.extractionPolicy.selectedEntities = [];
							return;
						}

						let selectedEntities = [];
						entityList.forEach(category => {
							if (angular.isDefined(category.tagSetsAndItems) && category.tagSetsAndItems.length > 0) {
								category.tagSetsAndItems.forEach(subCategory => {
									(subCategory.tags || []).forEach(entity => {
										selectedEntities.push(entity.entityDetail.entityId);
										if (entity.entityDetail.entityType !== 'ML_MODEL' && entity.entityDetail.entityType !== 4) {
											self.multiSelectEntities.push(entity.entityDetail.entityId);
										}
									});
								});
							} else {
								//For upgrade cases
								(category.tags || []).forEach(entity => {
									selectedEntities.push(entity.entityDetail.entityId);
									if (entity.entityDetail.entityType !== 4 && entity.entityDetail.entityType !== 'ML_MODEL') {
										self.multiSelectEntities.push(entity.entityDetail.entityId);
									}
								});
							}
						});
						$scope.dcPolicy.detail.eePolicy.extractionPolicy.selectedEntities = selectedEntities;
					};
					self.formEntityListForMultiselect = function() {
						const selectedEntities = $scope.dcPolicy.detail.eePolicy.extractionPolicy.selectedEntities || [];
						self.classifiersList = [];
						const classifierContainer = _.find(self.entityList, entity => {
							return _.get(entity, 'container.containerGuid', '') === 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27';
						});
						if (!_.isUndefined(classifierContainer)) {
							_.forEach(classifierContainer.tagSetsAndItems, subContainer => {
								if (!_.isUndefined(subContainer.tags) && !_.isUndefined(subContainer.container)) {
									let displayName = subContainer.container.containerFullName;
									if (displayName === 'Custom Entity') {
										displayName = 'Custom';
									}
									self.classifiersList.push({
										entityName: subContainer.container.containerFullName,
										entityId: subContainer.container.containerGuid,
										displayName: displayName,
										msGroup: true
									});
									_.forEach(subContainer.tags || [], tag => {
										if (!_.isUndefined(tag.entityDetail)) {
											const isSelected =
												_.findIndex(selectedEntities, entityId => {
													return entityId === tag.entityDetail.entityId;
												}) !== -1;
											self.classifiersList.push({
												entityName: tag.entityDetail.entityName,
												entityId: tag.entityDetail.entityId,
												displayName: tag.entityDetail.entityName,
												selected: isSelected
											});
										}
									});
									self.classifiersList.push({
										msGroup: false
									});
								}
							});
						}

						if (self.readOnly) {
							const entities = [];
							_.forEach(self.entityList, categoryDetails => {
								if (_.get(categoryDetails, 'container.containerGuid', '') !== 'C99E55EF-5875-425C-98A9-8DF5F5F0DF27') {
									entities.push({
										entityName: categoryDetails.container.containerFullName,
										entityId: categoryDetails.container.containerGuid,
										displayName: categoryDetails.container.containerFullName,
										container: categoryDetails.container,
										disabled: self.readOnly,
										msGroup: true
									});
									categoryDetails.tagSetsAndItems.forEach(subCategoryDetails => {
										if (angular.isDefined(subCategoryDetails.tags) && angular.isDefined(subCategoryDetails.container)) {
											entities.push({
												entityName: subCategoryDetails.container.containerFullName,
												entityId: subCategoryDetails.container.containerGuid,
												displayName: subCategoryDetails.container.containerFullName,
												container: subCategoryDetails.container,
												disabled: self.readOnly,
												msGroup: true
											});

											(subCategoryDetails.tags || []).forEach(tag => {
												if (angular.isDefined(tag.entityDetail)) {
													let displayName = cvLoc('entities.' + tag.entityDetail.entityKey, true);
													if (displayName === null) {
														displayName = tag.description;
													}
													entities.push({
														entityName: tag.entityDetail.entityName,
														entityId: tag.entityDetail.entityId,
														displayName: displayName,
														selected: selectedEntities.indexOf(tag.entityDetail.entityId) !== -1,
														container: subCategoryDetails.container,
														disabled: self.readOnly,
														tag: tag
													});
												}
											});

											entities.push({
												msGroup: false
											});
										}
									});
									entities.push({
										msGroup: false
									});
								}
							});
							self.entityList = entities;
						}
					};
					self.initialize = function() {
						if (angular.isUndefined($scope.dcPolicy) || angular.isUndefined($scope.dcPolicy.policyType)) {
							if (angular.isUndefined($scope.dcPolicy)) $scope.dcPolicy = {};
							$scope.dcPolicy.policyType = 'EXTRACTION_POLICY_TYPE';
							$scope.dcPolicy.flags = 8;
							$scope.dcPolicy.agentType = {};
							$scope.dcPolicy.agentType.appTypeId = 0;
							$scope.dcPolicy.detail = {};
							$scope.dcPolicy.detail.eePolicy = {};
							$scope.dcPolicy.detail.eePolicy.extractionPolicyType = 'CONTAINERS';
							$scope.dcPolicy.detail.eePolicy.extractionPolicy = {};
							$scope.dcPolicy.detail.eePolicy.extractionPolicy.extractionPolicyList = [];
							$scope.dcPolicy.detail.eePolicy.extractionPolicy.selectedEntities = [];
							self.eePolicy = $scope.dcPolicy;
						}

						self.entityListLoader = false;
						self.classifiersSelected = [];
						ediscoveryService.getCategorizedEntities().success(function(response) {
							self.entityListLoader = true;
							self.entityList = [];
							if (angular.isDefined(response)) {
								if (angular.isDefined(response.containerTypesList)) {
									self.entityList = response.containerTypesList;
									$scope.dcPolicy.detail.eePolicy.extractionPolicy.entityList = self.entityList;
									if (
										angular.isDefined(self.eePolicy) &&
										angular.isDefined(self.eePolicy.detail) &&
										angular.isDefined(self.eePolicy.detail.eePolicy) &&
										angular.isDefined(self.eePolicy.detail.eePolicy.extractionPolicy) &&
										angular.isDefined(self.eePolicy.detail.eePolicy.extractionPolicy.extractionPolicyList)
									) {
										self.setSelectedEntities(self.eePolicy.detail.eePolicy.extractionPolicy.extractionPolicyList);
									} else {
										self.eePolicy.detail.eePolicy.extractionPolicy.extractionPolicyList = [];
									}
									self.formEntityListForMultiselect();
								}
							}
						});
					};

					// Do we really need this?
					$scope.$watch('dcPolicy', function(newValue, oldValue) {
						if (!angular.equals(newValue, oldValue)) {
							if (
								angular.isDefined(newValue) &&
								angular.isDefined(newValue.detail) &&
								angular.isDefined(newValue.detail.eePolicy)
							) {
								self.setSelectedEntities(newValue.detail.eePolicy.extractionPolicy.extractionPolicyList);
							}
						}
					});

					self.onClassifiersClosed = () => {
						this.onSelectedEntitiesModified();
					};

					self.onEntitiesSelected = entities => {
						this.onSelectedEntitiesModified();
					};

					self.onSelectedEntitiesModified = () => {
						if (!this.readOnly) {
							this.eePolicy.detail.eePolicy.extractionPolicy.selectedEntities = _.concat(
								this.multiSelectEntities,
								_.map(this.classifiersSelected, classifier => {
									return classifier.entityId;
								})
							);
						}
					};

					self.initialize();
				}
			]
		};
	}
]);

export default planModule;
