import { commonPlanModule } from 'common/js/modules';

commonPlanModule.directive('cvPlanDayInput', [
	function() {
		return {
			restrict: 'E',
			transclude: true,
			templateUrl: appUtil.appRoot + 'modules/plan/partials/planDayInput.jsp',
			scope: {
				id: '@cvId',
				name: '@cvName',
				model: '=cvModel',
				class: '=?cvClass',
				disabled: '=?cvDisabled',
				required: '=?cvRequired',
				min: '=?cvMin',
				initialValue: '=?cvInitialValue',
				onChange: '=?cvOnChange'
			},
			bindToController: true,
			controllerAs: 'ctrl',
			controller: [
				'$scope',
				'cvLoc',
				function($scope, cvLoc) {
					const self = this;
					this.$onInit = function() {
						self.units = [
							{
								// See Period.java
								value: 1,
								label: cvLoc('label.retention.days')
							},
							{
								value: 30.41,
								label: cvLoc('label.retention.months')
							},
							{
								value: 365,
								label: cvLoc('label.retention.years')
							}
						];
						self.unit = self.units[0]; // Day is default unit
						self.days = self.model;
						if (angular.isDefined(self.initialValue)) {
							self.days = self.initialValue;
							self.model = self.initialValue;
						}

						self.updateModel = function() {
							if (angular.isNumber(self.days)) {
								self.model = Math.floor(self.days * self.unit.value);
							} else {
								self.model = null;
							}
							if (angular.isFunction(self.onChange)) {
								self.onChange(self.model);
							}
						};

						$scope.$on('cvPlanDayInputSet', function(event, id, days) {
							if (id === self.id) {
								self.days = days;
								self.unit = self.units[0];
								self.updateModel();
							}
						});
					};
				}
			]
		};
	}
]);

export default commonPlanModule;
