import 'dlo/js/controllers/profile.ctrl.js';

import { commonPlanModule } from 'common/js/modules';

commonPlanModule.directive('cvBackupWindowList', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/backupWindowList.jsp',
			scope: {
				model: '=cvModel',
				disabled: '=?cvDisabled',
				editModalTitle: '=?cvEditModalTitle',
				noEdit: '=?cvNoEdit',
				onEdit: '=?cvOnEdit'
			},
			// controllerAs : 'ctrl',
			controller: [
				'$scope',
				'profileUIFactory',
				'cvLoc',
				function($scope, profileUIFactory, cvLoc) {
					var getDayNumber = function(val) {
						switch (val.toUpperCase()) {
							case 'MONDAY':
							case cvLoc('label.day.mon').toUpperCase():
								return 0;
							case 'TUESDAY':
							case cvLoc('label.day.tue').toUpperCase():
								return 1;
							case 'WEDNESDAY':
							case cvLoc('label.day.wed').toUpperCase():
								return 2;
							case 'THURSDAY':
							case cvLoc('label.day.thu').toUpperCase():
								return 3;
							case 'FRIDAY':
							case cvLoc('label.day.fri').toUpperCase():
								return 4;
							case 'SATURDAY':
							case cvLoc('label.day.sat').toUpperCase():
								return 5;
							case 'SUNDAY':
							case cvLoc('label.day.sun').toUpperCase():
								return 6;
						}
					};

					var initializeModel = function() {
						if (!$scope.model) {
							return;
						}

						$scope.model.isRPStore = Boolean($scope.model.isRPStore); //We are reusing this component for rpstore peak window, need a flag to distinguish from the plan

						if ($scope.model.isRPStore) {
							$scope.disabledMessage = cvLoc('label.notEnabled');
						} else {
							$scope.disabledMessage = `${cvLoc(
								'label.backupWindowDayRange',
								cvLoc('label.day.mon'),
								cvLoc('label.day.sun')
							)} : ${cvLoc('label.allDay')}`;
						}

						if (!$scope.model.scheduleObj) {
							$scope.model.scheduleObj = [];
							if ($scope.model.dayTime) {
								// dayTime is always inverted from user selection in UI, so we must
								// uninvert it:
								var invertedScheduleObj = [];
								$scope.model.dayTime.forEach(function(dayTime) {
									dayTime.dayOfWeek.forEach(function(dayOfWeek) {
										var day = getDayNumber(dayOfWeek);
										var startTime = dayTime.startTime / 3600;
										var endTime;
										if (dayTime.endTime === 86340) {
											endTime = 24;
										} else {
											endTime = dayTime.endTime / 3600;
										}
										if (!invertedScheduleObj[day]) {
											invertedScheduleObj[day] = [];
										}
										invertedScheduleObj[day].push([startTime, endTime]);
									});
								});
								// Uninvert scheduleObj:
								$scope.model.scheduleObj = profileUIFactory.invertScheduleObj(invertedScheduleObj);
								$scope.model.ruleEnabled = $scope.model.dayTime.length > 0;
							}
						}
					};

					var refreshSentences = function() {
						$scope.scheduleSentences = profileUIFactory.makeScheduleSentenceList(
							$scope.model.scheduleObj,
							$scope.model.isRPStore
						);
						if (
							$scope.model.isRPStore &&
							(!$scope.scheduleSentences || Object.keys($scope.scheduleSentences).length === 0)
						) {
							$scope.scheduleSentences = null;
						}
					};

					$scope.editBackupWindow = function() {
						if (!$scope.disabled) {
							return profileUIFactory
								.editBackupSchedule($scope.model, $scope.editModalTitle, function(newBackupWindow) {
									$scope.editResult = newBackupWindow;
									if (typeof $scope.onEdit === 'function') {
										return $scope.onEdit(newBackupWindow);
									}
								})
								.then(function() {
									angular.extend($scope.model, $scope.editResult);
									refreshSentences();
								});
						}
					};

					$scope.$watch(
						'model',
						function() {
							initializeModel();
							refreshSentences();
						},
						true
					);
					initializeModel();
					refreshSentences();

					$scope.getDisplayName = profileUIFactory.getDisplayName;
				}
			]
		};
	}
]);

export default commonPlanModule;
