import 'modules/plan/js/directives/exchCleanupQuotaDirective.js';
import 'modules/plan/js/directives/exchJournalJobOptions.js';
import 'modules/plan/js/directives/exchangePlanDirectives.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'dlo/js/services/profile.svc.js';
import 'setup/js/directives/setup-steps.js';
import { acAppExchangeModule } from 'common/js/modules';
import { office365PlanFactory } from 'modules/plan/js/factory/office365Plan.factory.js';
import { exchangeConstants } from 'exchangeV2/js/constants/exchangeConstants.js';
import 'ediscovery/common/js/services/ediscovery.util.svc.js';

class office365PlanDetailsController {
	constructor(
		$state,
		$stateParams,
		cvLoc,
		cvUtil,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		$q,
		$modal,
		$dialogs,
		$timeout,
		profileService,
		securityFactory,
		ediscoveryUtility,
		tabService,
		profileUIFactory
	) {
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.exchangeConstants = exchangeConstants;
		this.securityFactory = securityFactory;
		this.profileService = profileService;
		this.cvToaster = cvToaster;
		this.$dialogs = $dialogs;
		this.$timeout = $timeout;
		this.$state = $state;
		this.cvUtil = cvUtil;
		this.cvLoc = cvLoc;
		this.tabService = tabService;
		this.profileUIFactory = profileUIFactory;
		this.isArchiveMailbox = true;
		this.isTenantAdmin = cv.isTenantAdmin;
		this.enableOneNoteBackup = _.get(cv, 'additionalSettings.Console.enableOneNoteBackup', false);
		this.enableOneDriveBackupVersions = _.get(cv, 'additionalSettings.Console.enableOneDriveBackupVersions', false);
		this.showExactSearch = _.get(cv, 'additionalSettings.Console.showExactSearch', false);
		this.plan = new office365PlanFactory(
			$q,
			$timeout,
			cvLoc,
			cvUtil,
			profileService,
			'',
			this.exchangeConstants.plan.SUBTYPE.OFFICE365,
			exchangeConstants,
			ediscoveryUtility,
			$modal,
			$dialogs
		);
		this.genericEntity = {
			entityId: $stateParams.planId
		};
		this.entityType = this.exchangeConstants.entityTypes.PLAN_ENTITY;
		this.mailboxTypes = [
			{
				displayName: this.cvLoc('label.primaryMailbox'),
				key: 'primaryMailbox'
			},
			{
				displayName: this.cvLoc('label.archiveMailbox'),
				key: 'archiveMailbox'
			}
		];

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: this.cvLoc('label.nav.profile'),
				link: '#profile'
			}
		]);
		this.getInitData($stateParams.planId);
		let stateType = 'OFFICE365';
		if (this.$state.current.name === this.exchangeConstants.navigationStateNames.O365.DYNAMICS36_PLAN_DETAILS_VIEW) {
			stateType = 'DYNAMICS365';
		}
		this.getAppBasedModes = this.exchangeConstants.plan.APP_BASED_MODES[stateType];
	}

	getInitData(planId) {
		this.plan.load(planId).then(
			response => {
				this.formattedSecurityAssociations = this.securityFactory.formatSecurityAssociationsObject(
					response.data.profile.securityAssociations
				);
				this.associationsLoaded = true;
				this.planLoaded = true;
				this.canEdit = _.get(this.plan, 'permissions.Plan_Edit', false);
				this.canDelete = _.get(this.plan, 'permissions.Plan_Delete', false);
				this.changeNameObj = {
					id: this.plan.originalPlanInfo.summary.plan.planId,
					name: this.plan.originalPlanInfo.summary.plan.planName
				};
				if (
					this.canEdit &&
					(this.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy
						.contentIndexProps.enableEntitySearch ||
						this.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy
							.contentIndexProps.enableContentIndex ||
						this.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy
							.contentIndexProps.enablePreviewGeneration)
				) {
					this.canEditSearchSettings = true;
				} else {
					this.canEditSearchSettings = false;
				}
				this.initTabs(_.get(response, 'data.profile.summary'));
			},
			() => {
				this.$state.go('profile');
				this.cvToaster.showErrorMessage({
					message: this.cvLoc('error.planNotFound')
				});
			}
		);
	}

	initTabs(planSummary) {
		const tabs = this.profileUIFactory.getProfileDetailsTabs(planSummary, false);
		if (tabs.length > 1) {
			this.hasTabs = true;
			this.tabService.init({ tabs: tabs, hasParent: true });
		}
	}

	/**
	 * Deletes the current plan being viewed, and redirects the user back to the list of existing plans.
	 */
	deletePlan() {
		this.$dialogs.confirm(
			this.cvLoc('label.confirmDeleteProfile'),
			this.cvLoc('label.confirmMessageProfile', '<strong>' + this.plan.planInfo.summary.plan.planName + '</strong>'),
			{
				noFunction: () => {},
				yesFunction: () => {
					this.profileService.deleteProfile(this.plan.planInfo.summary.plan.planId).then(
						() => {
							this.$state.go('profile');
							this.cvToaster.showSuccessMessage({
								message: this.cvLoc('label.deleteSuccess')
							});
						},
						resp => {
							this.cvToaster.showErrorMessage({
								ttl: '10000',
								message: _.get(resp, 'data', this.cvLoc('generic_error'))
							});
						}
					);
				}
			}
		);
	}

	openEditSearchSettingsModal(data, showContent) {
		_.set(
			this.plan.planInfo,
			'office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps',
			_.get(
				this.plan.planInfo,
				'office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps',
				{}
			)
		);
		this.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps[
			showContent
		] = data;
		if (
			(data === true &&
				(showContent === this.exchangeConstants.plan.SEARCHSETTINGS.ENABLEPREVIEWGENERATION ||
					showContent === this.exchangeConstants.plan.SEARCHSETTINGS.ENABLEENTITYSEARCH)) ||
			_.isUndefined(showContent)
		) {
			this.plan.openEditSearchSettingsModal(showContent, this.showExactSearch);
		} else {
			this.plan.save();
		}
	}

	saveArchiveData(data, archiveDataName) {
		_.set(
			this.plan.planInfo,
			'office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy',
			_.get(this.plan.planInfo, 'office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy', {})
		);
		this.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy[archiveDataName] = data;
		this.plan.save();
	}

	oneDrivePropUpdate(data, oneDriveProp) {
		_.set(
			this.plan.planInfo,
			'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy',
			_.get(
				this.plan.planInfo,
				'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy',
				{}
			)
		);
		this.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy[
			oneDriveProp
		] = data;
		this.plan.save();
	}

	sharepointPropUpdate(data, sharepointProp) {
		_.set(
			this.plan.planInfo,
			'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.spbackupPolicy',
			_.get(
				this.plan.planInfo,
				'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.spbackupPolicy',
				{}
			)
		);
		this.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.spbackupPolicy[
			sharepointProp
		] = data;
		this.plan.save();
	}
}

office365PlanDetailsController.$inject = [
	'$state',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'$q',
	'$uibModal',
	'$dialogs',
	'$timeout',
	'profileService',
	'securityFactory',
	'ediscoveryUtility',
	'tabService',
	'profileUIFactory'
];
acAppExchangeModule.controller('office365PlanDetailsController', office365PlanDetailsController);
export default acAppExchangeModule;
