import 'modules/plan/js/directives/planDirectives.js';
import 'dlo/js/controllers/createProfile.ctrl.js';
import 'vsa/js/services/restore.svc.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'dlo/js/services/profile.svc.js';
import 'vsa/js/controllers/collections.ctrl.js';

import { dloAppProfileModule } from 'common/js/modules';

var profileMod = dloAppProfileModule;

profileMod.factory('vsaProfileFactory', [
	'cvLoc',
	'cvUtil',
	'PLAN_DEFAULTS',
	function(cvLoc, cvUtil, PLAN_DEFAULTS) {
		var factory = {};

		var globalTemplate = null;

		factory.resetTemplate = function() {
			globalTemplate = {
				storages: [],
				replication: [],
				schedules: [],
				backupWindow: angular.copy(PLAN_DEFAULTS.BACKUP_WINDOW)
			};
		};

		factory.getGlobalTemplate = function() {
			if (globalTemplate === null) {
				factory.resetTemplate();
			}
			return globalTemplate;
		};

		factory.setGlobalTemplate = function(template) {
			globalTemplate = template;
		};

		factory.getVSAPlanPolicyCopy = function(storage) {
			var policyCopy = {
				StoragePolicyCopy: {
					copyName: storage.name
				},
				sourceCopy: {
					copyName: storage.source
				},
				retentionRules: {
					retainBackupDataForDays: storage.retentionPeriod
				}
			};
			if (storage.storagePool.storagePoolType === 'SECONDARY_COPY') {
				policyCopy.globalAuxCopy = {
					storagePolicyId: storage.storagePool.storagePoolEntity.storagePoolId,
					storagePolicyName: storage.storagePool.storagePoolEntity.storagePoolName
				};
			} else {
				policyCopy.useGlobalPolicy = {
					storagePolicyId: storage.storagePool.storagePoolEntity.storagePoolId,
					storagePolicyName: storage.storagePool.storagePoolEntity.storagePoolName
				};
			}
			return policyCopy;
		};
		return factory;
	}
]);

var controllers = {};

controllers.selectVsaProfileController = [
	'$scope',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	function($scope, cvLoc, cvUtil, cvBreadcrumbsTabsFactory) {
		var breadCrumbs = [
			{
				title: cvLoc('label.nav.profile'),
				link: '#/profile'
			}
		];
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		$scope.planTypes = [
			{
				heading: cvLoc('label.backup'),
				description: cvLoc('label.vsaPlan.backupHelp'),
				link: '#/createBackupPlan'
			},
			{
				heading: cvLoc('label.backupAndReplication'),
				description: cvLoc('label.vsaPlan.backupAndReplicationHelp'),
				link: '#/createVsaReplicationPlan',
				disabled: !cvConfig.enableReplication
			}
		];
	}
];

controllers.createVsaBackupProfileController = [
	'$scope',
	'$rootScope',
	'$state',
	'profileService',
	'cvLoc',
	'cvUtil',
	'$window',
	'$location',
	'$dialogs',
	'cvBreadcrumbsTabsFactory',
	'vsaProfileFactory',
	function(
		$scope,
		$rootScope,
		$state,
		profileService,
		cvLoc,
		cvUtil,
		$window,
		$location,
		$dialogs,
		cvBreadcrumbsTabsFactory,
		vsaProfileFactory
	) {
		var breadCrumbs = [
			{
				title: cvLoc('label.nav.profile'),
				link: '#/profile'
			}
		];

		function formatBackupWindow(backupWindow) {
			if (
				!backupWindow.ruleEnabled ||
				!backupWindow.dayTime ||
				backupWindow.dayTime.length === 0 ||
				angular.equals(backupWindow.dayTime, PLAN_DEFAULTS.EMPTY_BACKUP_WINDOW.dayTime)
			) {
				// User has selected all or none for backup window, do not send any window
				return null;
			}
			return backupWindow;
		}

		/*
		 * if (cvConfig.enableReplication) { breadCrumbs.push({ title: cvLoc('label.virtualization'), link:
		 * '#/selectVsaPlan' }); }
		 */

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		$scope.planType = 'VSA';
		$scope.planSubType = 'VSAServer';
		$scope.associatedSchedulesEnabled =
			cv.additionalSettings &&
			cv.additionalSettings.AdminConsole &&
			cv.additionalSettings.AdminConsole.showAssociatedSchedules;

		profileService
			.getMasterProfile($scope.planType, $scope.planSubType)
			.success(function(data) {
				// set granular recovery to false. Once this value is updated in backend, remove this.
				// This is current set to true in daily incremental sla schedule
				data.profile.schedule.subTasks[0].options.backupOpts.collectMetaInfo = false;

				$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
				$scope.globalTemplate.masterTemplate = data;
				// Schedules are used in Backup tab (createVsaProfileBackupTabController)
				$scope.globalTemplate.schedules = data.profile.schedule.subTasks.slice();

				vsaProfileFactory.setGlobalTemplate($scope.globalTemplate);
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsg(e);
			});

		var deregBackupTabListener = $rootScope.$on('backupTabSaved', function() {
			// save plan for now
			$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
			// delete existing schedules from master profile
			$scope.globalTemplate.masterTemplate.profile.schedule.subTasks.length = 0;
			// merge master template with new values
			$scope.createdTemplate = angular.merge({}, $scope.globalTemplate.masterTemplate.profile, {
				summary: {
					plan: {
						planName: $scope.globalTemplate.name
					},
					type: $scope.planType,
					subtype: $scope.planSubType,
					rpoInMinutes: $scope.globalTemplate.rpo * 60,
					// slaInterval : $scope.globalTemplate.slaInterval,
					restrictions: 1
					// Setting restrictions to 1 disables deriving for Backup plans. This is temporary since deriving is not implemented for backup plans.
				},
				storage: {
					copy: $scope.globalTemplate.storages.map(function(storage) {
						return vsaProfileFactory.getVSAPlanPolicyCopy(storage);
					})
				},
				schedule: {
					subTasks: $scope.globalTemplate.schedules
				},
				operationWindow: formatBackupWindow($scope.globalTemplate.backupWindow)
			});
			profileService
				.createVsaProfile($scope.createdTemplate)
				.success(function(data) {
					if ($state.includes('vsaSetup')) {
						isLeaving = true;
						$scope.handleNext();
					} else {
						$location.path('/profileDetails/' + data.plan.summary.plan.planId);
					}
				})
				.error(function(e) {
					$scope.retentionPoliciesServerMessage = {
						message: cvLoc('error.createPlanFailed') + e,
						type: 'error'
					};
				});
		});

		var isLeaving = false;

		// to stop navigation in case of unsaved changes
		$scope.$on('$locationChangeStart', function(event, next, current) {
			if (!isLeaving && $scope.globalTemplate.name) {
				if (next.indexOf('profileDetails') === -1) {
					$dialogs.confirm(cvLoc('label.confirmNavigation'), cvLoc('label.confirmVsaPlanNavigationDetails'), {
						yesFunction: function() {
							isLeaving = true;
							$window.location.href = next;
						},
						noFunction: function() {
							event.preventDefault();
						}
					});
					event.preventDefault();
					return;
				} else {
					$window.location.href = next;
				}
			}
		});

		$scope.$on('$destroy', function() {
			deregBackupTabListener();
			vsaProfileFactory.resetTemplate();
		});
	}
];

controllers.createVsaReplicationProfileController = [
	'$scope',
	'$rootScope',
	'profileService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$window',
	'$dialogs',
	'vsaProfileFactory',
	function(
		$scope,
		$rootScope,
		profileService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$window,
		$dialogs,
		vsaProfileFactory
	) {
		var breadCrumbs = [
			{
				title: cvLoc('label.nav.profile'),
				link: '#/profile'
			}
			/*
			 * , { title: cvLoc('label.virtualization'), link: '#/selectVsaPlan' }
			 */
		];
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		$scope.steps = [
			{
				template: appUtil.appRoot + 'modules/plan/partials/createVsaPlanBackup.jsp',
				name: cvLoc('label.backup')
			},
			{
				template: appUtil.appRoot + 'modules/plan/partials/createVsaPlanReplication.jsp',
				name: cvLoc('label.replication')
			},
			{
				template: appUtil.appRoot + 'modules/plan/partials/createVsaPlanSummary.jsp',
				name: cvLoc('label.summary')
			}
		];

		$scope.loadTab = function(idx) {
			$scope.currentStep = idx;
		};

		$scope.currentStep = 0;
		$scope.planType = 'VSA';
		$scope.planSubType = 'VSAReplication';

		profileService
			.getMasterProfile($scope.planType, $scope.planSubType)
			.success(function(data) {
				// set granular recovery to false. Once this value is updated in backend, remove this.
				// This is current set to true in daily incremental sla schedule
				data.profile.schedule.subTasks[0].options.backupOpts.collectMetaInfo = false;

				$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
				$scope.globalTemplate.masterTemplate = data;
				// Schedules are used in Backup tab (createVsaProfileBackupTabController)
				$scope.globalTemplate.schedules = data.profile.schedule.subTasks.slice();

				// replicationSchedules are used in Replication tab (createVsaProfileReplicationTabController)
				$scope.globalTemplate.replicationSchedules = data.profile.replicationTargets.taskInfo[0].subTasks.slice();
				vsaProfileFactory.setGlobalTemplate($scope.globalTemplate);
			})
			.error(function(e) {
				$scope.serverMessage = cvUtil.errMsg(e);
			});

		var deregBackupTabListener = $rootScope.$on('backupTabSaved', function() {
			$scope.currentStep = 1; // replication
		});

		var deregReplicationTabListener = $rootScope.$on('replicationTabSaved', function() {
			$scope.currentStep = 2; // summary
		});

		var isLeaving = false;

		// to stop navigation in case of unsaved changes
		$scope.$on('$locationChangeStart', function(event, next, current) {
			if (!isLeaving && $scope.globalTemplate.name) {
				if (next.indexOf('profileDetails') === -1) {
					$dialogs.confirm(cvLoc('label.confirmNavigation'), cvLoc('label.confirmVsaPlanNavigationDetails'), {
						yesFunction: function() {
							isLeaving = true;
							$window.location.href = next;
						},
						noFunction: function() {
							event.preventDefault();
						}
					});
					event.preventDefault();
					return;
				} else {
					$window.location.href = next;
				}
			}
		});

		$scope.$on('$destroy', function() {
			deregBackupTabListener();
			deregReplicationTabListener();
			vsaProfileFactory.resetTemplate();
		});
	}
];

controllers.createVsaProfileBackupTabController = [
	'$scope',
	'$rootScope',
	'$state',
	'profileService',
	'cvLoc',
	'cvUtil',
	'scheduleUIFactory',
	'SCHEDULE_PROPERTY',
	'vsaProfileFactory',
	'cvConfirmDialog',
	'cvTableOptions',
	function(
		$scope,
		$rootScope,
		$state,
		profileService,
		cvLoc,
		cvUtil,
		scheduleUIFactory,
		SCHEDULE_PROPERTY,
		vsaProfileFactory,
		cvConfirmDialog,
		cvTableOptions
	) {
		// $scope.slaIntervals = SCHEDULE_PROPERTY.SLA_INTERVALS;
		$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
		//set default plan name
		$scope.autoSelect = true;

		// if name already exists dont reset/change it.
		//passing planSubType as 'Server' like what gets passed in the server backup plan.
		if (!$scope.globalTemplate.name) {
			profileService
				.getProfiles('all', false, $scope.planSubType)
				.success(function(data) {
					// dont set any default name if you have atleast one of the same type
					if (data.length) {
						$scope.globalTemplate.name = '';
						$scope.autoSelect = false;
					} else {
						$scope.globalTemplate.name = 'Default Virtualization plan';
					}
				})
				.error(function() {
					// Do nothing as this error does not have any impact on the page
				});
		}

		if (!$scope.globalTemplate.rpo) {
			// this magic number is hardcoded in other plans as well. should come from backend
			$scope.globalTemplate.rpo = 4;
		}

		/*
		 * if (!$scope.globalTemplate.slaInterval) { // this magic number is hardcoded in other plans as well.
		 * should come from backend $scope.globalTemplate.slaInterval = 30; }
		 */

		if ($state.includes('vsaSetup')) {
			$scope.vsaSetupState = true;
			if (cv.sessionContext.setupStepsMap && cv.sessionContext.setupStepsMap[$scope.stepMap][$scope.setupStep]) {
				$scope.showPlanSkip = true;
				$scope.planExistedMessage = cvUtil.infoMsgLoc('label.planAlreadyCreated');
			} else {
				$scope.showPlanSkip = false;
			}
		} else {
			$scope.vsaSetupState = false;
		}

		$scope.goToCreatePlan = function() {
			$scope.showCreatePlanForm = true;
			$scope.planExistedMessage = cvUtil.emptyMsg();
		};

		$scope.slaFlag = SCHEDULE_PROPERTY.SLA_FLAG;

		$scope.storage = {
			model: {},
			ctrl: {},
			availableStoragePools: {}
		};
		if ($state.current.name == 'createVsaBackupPlan') {
			$scope.showFinish = true;
		}

		$scope.updateSla = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
			if ($scope.globalTemplate.rpo == null || $scope.globalTemplate.rpo < 1) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.rpoHours');
				return;
			}

			var slaScheduleIdx;
			for (var i = 0; i < $scope.globalTemplate.schedules.length; i++) {
				if ($scope.globalTemplate.schedules[i].subTask.flags == $scope.slaFlag) {
					slaScheduleIdx = i;
					break;
				}
			}

			var newSchedule = scheduleUIFactory.convertSubTaskInfoToSchedule(
				$scope.globalTemplate.schedules[slaScheduleIdx],
				$scope.planSubType
			);
			newSchedule.repeat = {
				enabled: true,
				duration: 1,
				hrs: $scope.globalTemplate.rpo,
				mins: 0,
				time: 86340
				/* 11:59pm */
			};
			var newSubTask = scheduleUIFactory.convertScheduleToSubTaskInfo(newSchedule);

			$scope.globalTemplate.schedules.splice(slaScheduleIdx, 1, newSubTask);
		};

		$scope.addSchedule = function() {
			scheduleUIFactory.addSchedule(
				{
					source: 'createProfile'
				},
				false,
				$scope.planSubType,
				false,
				'',
				'',
				'',
				undefined,
				undefined,
				$scope.globalTemplate.storages.length
					? $scope.globalTemplate.storages[0].retentionPeriod
					: $scope.storage.model.retentionPeriod,
				true
			);
		};

		$scope.editSchedule = function(st) {
			var newSchedule = scheduleUIFactory.convertSubTaskInfoToSchedule(st, $scope.planSubType);
			newSchedule.id = Date.now();

			$scope.scheduleCurrentlyEditing = st.subTask.subTaskName;

			if (newSchedule.operationType === 'AUX_COPY') {
				// hide delete if aux copy only if single aux copy plan is present
				newSchedule.hideDelete =
					$scope.globalTemplate.schedules.filter(function(stInfo) {
						return stInfo.subTask.operationType === 'AUX_COPY';
					}).length <= 1;

				//newSchedule.hideGranularRecovery = true;
			}

			if (newSchedule.flags == $scope.slaFlag) {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile',
						model: newSchedule
					},
					true,
					$scope.planSubType,
					false,
					'',
					'',
					'',
					$scope.globalTemplate.rpo
				);
			} else {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile',
						model: newSchedule
					},
					true,
					$scope.planSubType,
					false,
					'',
					'',
					'',
					undefined,
					undefined,
					$scope.globalTemplate.storages.length
						? $scope.globalTemplate.storages[0].retentionPeriod
						: $scope.storage.model.retentionPeriod,
					true
				);
			}
		};

		var scheduleAddedDereg = $rootScope.$on('scheduleAdded', function(evt, addedSchedule, planId) {
			addedSchedule.repeat = {
				enabled: addedSchedule.repeatEnabled,
				duration: addedSchedule.repeatDuration,
				hrs: addedSchedule.repeatHrs,
				mins: addedSchedule.repeatMins,
				time: addedSchedule.repeatTime
			};

			var subTaskInfo = scheduleUIFactory.convertScheduleToSubTaskInfo(addedSchedule);
			$scope.globalTemplate.schedules.push(subTaskInfo);
		});

		var scheduleEditedDereg = $rootScope.$on('scheduleEdited', function(evt, addedSchedule, planId) {
			addedSchedule.repeat = {
				enabled: addedSchedule.repeatEnabled,
				duration: addedSchedule.repeatDuration,
				hrs: addedSchedule.repeatHrs,
				mins: addedSchedule.repeatMins,
				time: addedSchedule.repeatTime
			};

			var subTaskInfo = scheduleUIFactory.convertScheduleToSubTaskInfo(addedSchedule);

			for (var i = 0; i < $scope.globalTemplate.schedules.length; i++) {
				if ($scope.globalTemplate.schedules[i].subTask.subTaskName == $scope.scheduleCurrentlyEditing) {
					$scope.globalTemplate.schedules.splice(i, 1, subTaskInfo);
					break;
				}
			}

			// reset value
			$scope.scheduleCurrentlyEditing = undefined;
		});

		var scheduleDeletedDereg = $rootScope.$on('scheduleDeleted', function(evt, addedSchedule) {
			var subTaskInfo = scheduleUIFactory.convertScheduleToSubTaskInfo(addedSchedule);

			var nameToEdit = subTaskInfo.subTask.subTaskName;
			for (var i = 0; i < $scope.globalTemplate.schedules.length; i++) {
				if ($scope.globalTemplate.schedules[i].subTask.subTaskName == nameToEdit) {
					$scope.globalTemplate.schedules.splice(i, 1);
					return;
				}
			}
		});

		$scope.clearStorageTile = function() {
			$scope.storage.model.storageName = '';
			$scope.storage.model.source = $scope.globalTemplate.storages.length
				? $scope.globalTemplate.storages[0].name
				: 'NA';
			$scope.storage.model.retentionPeriod = 30;
		};

		$scope.createAnotherCopy = function(isLast) {
			$scope.serverMessage = cvUtil.emptyMsg();

			var currentStorage = {
				name: $scope.storage.model.storageName,
				storagePool: $scope.storage.model.storagePool,
				retentionPeriod: $scope.storage.model.retentionPeriod,
				source:
					$scope.storage.model.source ||
					($scope.globalTemplate.storages.length ? $scope.globalTemplate.storages[0].name : 'NA')
			};

			if (currentStorage.name && currentStorage.storagePool) {
				if (
					currentStorage.retentionPeriod != null &&
					currentStorage.retentionPeriod <= 9999 &&
					currentStorage.retentionPeriod >= 1
				) {
					$scope.globalTemplate.storages.push(currentStorage);

					// dont update the fields if it is the last storage
					if (!isLast) {
						$scope.clearStorageTile();

						//if we have finished adding storage, then don't refresh the list of storage pools.
						//This causes a UI bug where the list of availbale storage pools is empty if you press finish
						//since this call includes logic to remove the already selected storage
						//only if we want to proceed adding more storage then refresh available storage pools
						$scope.storage.ctrl.refresh();
					}
				} else {
					$scope.serverMessage = cvUtil.errMsgLoc('error.retentionPeriod');
				}
			} else {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageConfigured');
			}

			// dont update the fields if it is the last storage
			if (!isLast) {
				$scope.showGrid = !!$scope.globalTemplate.storages.length;
			}
		};

		$scope.saveBackupTab = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
			if (!$scope.globalTemplate.name) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noProfileName');
				return;
			}

			if ($scope.globalTemplate.rpo == null || $scope.globalTemplate.rpo < 1) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.rpoHours');
				return;
			}

			// create storage copy from current unsaved data if available
			if ($scope.storage.model.storageName) {
				$scope.createAnotherCopy(true);
			}

			if (
				$scope.storage.model.retentionPeriod == null ||
				$scope.storage.model.retentionPeriod > 9999 ||
				$scope.storage.model.retentionPeriod < 1
			) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.retentionPeriod');
				return;
			}

			if (!$scope.globalTemplate.storages.length) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noStorageConfigured');
				return;
			}

			if ($scope.globalTemplate.storages.length == 1) {
				// remove aux copy
				var new_arr = [];
				for (var i = 0; i < $scope.globalTemplate.schedules.length; i++) {
					if ($scope.globalTemplate.schedules[i].subTask.operationType != 'AUX_COPY') {
						new_arr.push($scope.globalTemplate.schedules[i]);
					}
				}
				$scope.globalTemplate.schedules = new_arr;
			}

			//handle synthetic auto scheduleAutomatic_Schedule, if primary retention is more than 90, set synthetic full days to 90 as max
			var primaryRetentionDays = $scope.globalTemplate.storages.length
				? $scope.globalTemplate.storages[0].retentionPeriod
				: $scope.storage.model.retentionPeriod;
			$scope.globalTemplate.schedules.map(function(schedule) {
				if (
					schedule.options.backupOpts.backupLevel === 'SYNTHETIC_FULL' &&
					schedule.pattern.freq_type === 'Automatic_Schedule'
				) {
					schedule.options.backupOpts.dataOpt.daysBetweenSyntheticBackup =
						primaryRetentionDays > 90 ? 90 : primaryRetentionDays;
				}
			});
			vsaProfileFactory.setGlobalTemplate($scope.globalTemplate);
			$scope.storage.ctrl.refreshError();
			$scope.$emit('backupTabSaved');
		};

		var successCallbackProfileNameCheck = function() {
			var planType = $scope.globalTemplate.masterTemplate.profile.summary.subtype;

			cvConfirmDialog.openDialog({
				confirmationText: cvLoc('label.createAnotherCopy'),
				okText: planType === 'VSAServer' ? cvLoc('action.finish') : cvLoc('action.nextStep'),
				cancelText: cvLoc('label.yes'),
				cancelCallback: $scope.createAnotherCopy,
				okCallback: $scope.saveBackupTab
			});
		};

		//used to check plan name existed or not
		$scope.getPlanName = function(name) {
			// Dont make the call if name is null or empty string
			if (name) {
				var result = cvUtil.makeSynchronousCall('GET', 'checkPlanName.do?name=' + name);
				// if api calling success
				if (result.status === 200) {
					if (result.response && result.response.id) {
						// if plan name exists
						return {
							error: cvLoc('error.nameExisted')
						};
					} else {
						// success case: valid plan name
						return {};
					}
				} else {
					// api failed
					return {
						error: cvLoc('error.checkPlanName')
					};
				}
			} else {
				// plan name is empty
				return {
					error: cvLoc('error.noProfileName')
				};
			}
		};

		$scope.saveStorage = function() {
			$scope.serverMessage = cvUtil.emptyMsg();
			//check profile name existed or not
			if ($scope.getPlanName($scope.globalTemplate.name).error) {
				$scope.serverMessage = cvUtil.errMsg($scope.getPlanName($scope.globalTemplate.name).error);
			} else {
				//if this is the last storage pool, create plan directly
				if ($scope.storage.availableStoragePools.length === 1) {
					$scope.saveBackupTab();
				} else {
					successCallbackProfileNameCheck();
				}
			}
		};

		$scope.deleteStorage = function(name) {
			$scope.serverMessage = cvUtil.emptyMsg();
			for (var i = 0; i < $scope.globalTemplate.storages.length; i++) {
				if (name === $scope.globalTemplate.storages[i].name) {
					// check whether this storage is not acting as source for another storage
					for (var j = 0; j < $scope.globalTemplate.storages.length; j++) {
						if ($scope.globalTemplate.storages[j].source === name) {
							$scope.serverMessage = cvUtil.errMsgLoc('error.alreadySourceStorageExists');
							return;
						}
					}

					// check whether this storage is not acting as source for replication
					if ($scope.globalTemplate.replication.length) {
						for (var j = 0; j < $scope.globalTemplate.replication.length; j++) {
							if ($scope.globalTemplate.replication[j].source === name) {
								$scope.serverMessage = cvUtil.errMsgLoc('error.sourceUsedInReplication');
								return;
							}
						}
					}

					// delete storage
					$scope.globalTemplate.storages.splice(i, 1);
					break;
				}
			}
			$scope.storage.ctrl.refresh();
			$scope.showGrid = !!$scope.globalTemplate.storages.length;
		};

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: $scope.globalTemplate.storages,
			enableGridMenu: false,
			columnDefs: [
				{
					field: 'name',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('label.name'),
					enableHiding: false,
					cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				},
				{
					field: 'storagePool.storagePoolEntity.storagePoolName',
					displayName: cvLoc('label.storages'),
					cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				},
				{
					field: 'source',
					displayName: cvLoc('label.source'),
					cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				},
				{
					field: 'retentionPeriod',
					displayName: cvLoc('label.retentionDays'),
					cellTemplate: '<span>{{COL_FIELD}} days<span>'
				},
				{
					name: 'action',
					displayName: cvLoc('label.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>\
													<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
													<li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteStorage(row.entity.name)">' +
						cvLoc('action.delete') +
						'</a></li></ul></div>',
					width: '15%'
				}
			]
		});

		$scope.gridOptions = {
			cvTableName: 'vsaPlanBackupTable',
			cvIsSearchable: false,
			cvHasViews: false,
			cvServerMessage: 'gridServerMessage',
			gridOptions: globalGridOptions
		};

		$scope.showGrid = !!$scope.globalTemplate.storages.length;

		$scope.$on('$destroy', function() {
			scheduleAddedDereg();
			scheduleEditedDereg();
			scheduleDeletedDereg();
		});
	}
];

controllers.createVsaProfileReplicationTabController = [
	'$scope',
	'$http',
	'cvLoc',
	'cvUtil',
	'vsaProfileFactory',
	'cvConfirmDialog',
	'cvTableOptions',
	function($scope, $http, cvLoc, cvUtil, vsaProfileFactory, cvConfirmDialog, cvTableOptions) {
		$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
		$scope.storage = {
			model: {},
			ctrl: {}
		};

		$scope.clearReplicationTile = function() {
			$scope.storage.model.source = $scope.globalTemplate.storages[0].name;
			$scope.storage.model.target = null;
			$scope.storage.model.replicationSchedule = $scope.globalTemplate.replicationSchedules[0];
		};

		$scope.createAnotherReplication = function(isLast) {
			$scope.serverMessage = cvUtil.emptyMsg();

			var currentReplication = {
				source: $scope.storage.model.source,
				target: $scope.storage.model.target,
				replicationSchedule: $scope.storage.model.replicationSchedule,
				diskRestoreOption: angular.copy($scope.storage.model.diskRestoreOption)
			};

			if (
				currentReplication.source &&
				currentReplication.target &&
				$scope.storage.model.replicationSchedule.subTask.subTaskId !== -1
			) {
				$scope.globalTemplate.replication.push(currentReplication);
				$scope.storage.ctrl.refresh();
				// dont update the fields if it is the last replication
				if (!isLast) {
					$scope.clearReplicationTile();
				}
			} else {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noReplicationConfigured');
			}
			// dont update the fields if it is the last replication
			if (!isLast) {
				$scope.showGrid = !!$scope.globalTemplate.replication.length;
			}
		};

		$scope.saveReplicationTab = function() {
			$scope.serverMessage = cvUtil.emptyMsg();

			// create storage copy from current unsaved data if available
			if (
				$scope.storage.model.source &&
				$scope.storage.model.target &&
				$scope.storage.model.replicationSchedule.subTask.subTaskId !== -1
			) {
				$scope.createAnotherReplication(true);
			}

			if (!$scope.globalTemplate.replication.length) {
				$scope.serverMessage = cvUtil.errMsgLoc('error.noReplicationConfigured');
				return;
			}

			vsaProfileFactory.setGlobalTemplate($scope.globalTemplate);
			$scope.storage.ctrl.refreshError();
			$scope.$emit('replicationTabSaved');
		};

		$scope.saveReplication = function() {
			cvConfirmDialog.openDialog({
				confirmationText: cvLoc('label.createAnotherReplication'),
				okText: cvLoc('action.nextStep'),
				cancelText: cvLoc('label.yes'),
				cancelCallback: $scope.createAnotherReplication,
				okCallback: $scope.saveReplicationTab
			});
		};

		$scope.deleteReplication = function(target) {
			for (var i = 0; i < $scope.globalTemplate.replication.length; i++) {
				if (target === $scope.globalTemplate.replication[i].target) {
					$scope.globalTemplate.replication.splice(i, 1);
					break;
				}
			}
			$scope.storage.ctrl.refresh();
			$scope.showGrid = !!$scope.globalTemplate.replication.length;
		};

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: $scope.globalTemplate.replication,
			enableGridMenu: false,
			columnDefs: [
				{
					field: 'source',
					displayName: cvLoc('label.backupSource'),
					cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				},
				{
					field: 'target.entity.vmAllocPolicyName',
					displayName: cvLoc('label.target'),
					cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				},
				//											{
				//												field : 'replicationSchedule.name',
				//												displayName : cvLoc('label.replicationSchedule'),
				//												cellTemplate : '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
				//											},
				{
					name: 'action',
					displayName: cvLoc('label.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>\
													<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
													<li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteReplication(row.entity.target)">' +
						cvLoc('action.delete') +
						'</a></li></ul></div>',
					width: '15%'
				}
			]
		});

		$scope.gridOptions = {
			cvTableName: 'vsaPlanReplicationTable',
			cvIsSearchable: false,
			cvHasViews: false,
			cvServerMessage: 'gridServerMessage',
			gridOptions: globalGridOptions
		};

		$scope.showGrid = !!$scope.globalTemplate.replication.length;

		$scope.$on('$destory', function() {
			scheduleAddedDereg();
		});
	}
];

controllers.createVsaProfileSummaryTabController = [
	'$scope',
	'cvUtil',
	'cvLoc',
	'$location',
	'vsaProfileFactory',
	'profileService',
	function($scope, cvUtil, cvLoc, $location, vsaProfileFactory, profileService) {
		$scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();

		function formatBackupWindow(backupWindow) {
			if (
				!backupWindow.ruleEnabled ||
				!backupWindow.dayTime ||
				backupWindow.dayTime.length === 0 ||
				angular.equals(backupWindow.dayTime, PLAN_DEFAULTS.EMPTY_BACKUP_WINDOW.dayTime)
			) {
				// User has selected all or none for backup window, do not send any window
				return null;
			}
			return backupWindow;
		}

		// Add all the source nodes
		var nodeList = $scope.globalTemplate.storages.map(function(storage, idx) {
			return {
				key: 'storage_' + storage.name,
				name: storage.name,
				type: 'Database',
				loc: '-200 ' + (idx - 3) * 100
			};
		});
		var nodeConnectionList = [];

		$scope.globalTemplate.replication.forEach(function(repl) {
			// add replication target node
			nodeList.push({
				key: 'replication_' + repl.target.entity.vmAllocPolicyName,
				name: repl.target.entity.vmAllocPolicyName,
				type: 'RoundedRectangle',
				loc: '200 ' + (nodeList.length - $scope.globalTemplate.storages.length - 3) * 100
			});

			// make the connection
			nodeConnectionList.push({
				from: 'storage_' + repl.source, // source key
				to: 'replication_' + repl.target.entity.vmAllocPolicyName //- destination key
			});
		});

		// Add legend fields
		// Add legend fields
		nodeList.push({
			key: 'storage_legend',
			name: cvLoc('label.backupSource'),
			type: 'Rectangle',
			color: 'white',
			borderColor: 'white',
			loc: '-200 -400'
		});
		nodeList.push({
			key: 'replication_legend',
			name: cvLoc('label.replication'),
			type: 'Rectangle',
			color: 'white',
			borderColor: 'white',
			loc: '200 -400'
		});

		//$scope.model = new go.GraphLinksModel(nodeList, nodeConnectionList);
		//$scope.model.selectedNodeData = null;

		$scope.saveSummaryTab = function() {
			$scope.serverMessage = cvUtil.emptyMsg();

			// save plan
			// get latest plan object
			// $scope.globalTemplate = vsaProfileFactory.getGlobalTemplate();
			// delete existing schedules from master profile
			$scope.globalTemplate.masterTemplate.profile.schedule.subTasks.length = 0;

			// merge master template with new values
			$scope.createdTemplate = angular.merge({}, $scope.globalTemplate.masterTemplate.profile, {
				summary: {
					plan: {
						planName: $scope.globalTemplate.name
					},
					type: $scope.planType,
					subtype: $scope.planSubType,
					rpoInMinutes: $scope.globalTemplate.rpo * 60
					// slaInterval : $scope.globalTemplate.slaInterval
				},
				storage: {
					copy: $scope.globalTemplate.storages.map(function(storage) {
						return vsaProfileFactory.getVSAPlanPolicyCopy(storage);
					})
				},
				replicationTargets: {
					taskInfo: $scope.globalTemplate.replication.map(function(repl) {
						var subTaskInfo = angular.copy(repl.replicationSchedule);
						subTaskInfo.options.restoreOptions.virtualServerRstOption.allocationPolicy = repl.target.entity;
						subTaskInfo.options.restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption = repl.diskRestoreOption;
						subTaskInfo.options.restoreOptions.storagePolicy = {
							copyName: repl.source
						};
						return {
							subTasks: [subTaskInfo]
						};
					})
				},
				schedule: {
					subTasks: $scope.globalTemplate.schedules
				},
				operationWindow: formatBackupWindow($scope.globalTemplate.backupWindow)
			});
			profileService
				.createVsaProfile($scope.createdTemplate)
				.success(function(data) {
					$location.path('/profileDetails/' + data.plan.summary.plan.planId);
				})
				.error(function(e) {
					$scope.serverMessage = cvUtil.errMsg(cvLoc('error.createPlanFailed') + e);
				});
		};
	}
];

controllers.profilesDetailsVsaController = [
	'$scope',
	'$uibModal',
	'cvTableOptions',
	'cvLoc',
	'cvUtil',
	'restoreService',
	'$state',
	'$dialogs',
	'cvToaster',
	function($scope, $modal, cvTableOptions, cvLoc, cvUtil, restoreService, $state, $dialogs, cvToaster) {
		if ($scope.planSubType === 'VSAReplication') {
			$scope.addReplication = function(existingReplication) {
				$scope.serverMessage = cvUtil.emptyMsg();
				var modalInstance = $modal.open({
					templateUrl: appUtil.appRoot + 'modules/plan/partials/editVsaPlanReplication.jsp',
					backdrop: 'static',
					controller: [
						'$scope',
						'$uibModalInstance',
						'$state',
						'profileService',
						'cvUtil',
						'cvLoc',
						'replicationSchedules',
						'profileDetails',
						'restoreService',
						function(
							$scope,
							$modalInstance,
							$state,
							profileService,
							cvUtil,
							cvLoc,
							replicationSchedules,
							profileDetails,
							restoreService
						) {
							$scope.storages = profileDetails.storage.copy.map(function(obj) {
								return {
									name: obj.StoragePolicyCopy.copyName,
									id: obj.StoragePolicyCopy.copyId,
									storagePool: {
										storagePoolEntity: obj.useGlobalPolicy
									},
									retentionPeriod: obj.retentionRules.retainBackupDataForDays
									//'source' : obj.sourceCopy.copyName,
								};
							});
							$scope.replicationSchedules = replicationSchedules;
							$scope.replications = profileDetails.replicationTargets.taskInfo;
							$scope.model = {};
							$scope.taskInfo = existingReplication || {};
							$scope.plan = profileDetails.summary.plan;
							$scope.listOperation = 'ADD';
							$scope.profileDetails = profileDetails;
							if (existingReplication) {
								$scope.editMode = true;
								$scope.listOperation = 'OVERWRITE';
								$scope.initModel = {
									copyName: existingReplication.subTasks[0].options.restoreOptions.storagePolicy.copyId,
									targetId:
										existingReplication.subTasks[0].options.restoreOptions.virtualServerRstOption.allocationPolicy
											.vmAllocPolicyId,
									replicationScheduleId: existingReplication.subTasks[0].subTask.subTaskId,
									diskRestoreOption:
										existingReplication.subTasks[0].options.restoreOptions.virtualServerRstOption
											.diskLevelVMRestoreOption
								};
								// add the existing schedule to the replicationSchedule list
								$scope.replicationSchedules.push(existingReplication.subTasks[0]);

								var getSelectOption = function(arr, getField, valueToSelect, returnField) {
									for (var i = 0; i < arr.length; i++) {
										if (getField(arr[i]) === valueToSelect) {
											return returnField(arr[i]);
										}
									}
								};

								$scope.model.source = getSelectOption(
									$scope.storages,
									function(obj) {
										return obj.id;
									},
									existingReplication.subTasks[0].options.restoreOptions.storagePolicy.copyId,
									function(obj) {
										return obj.name;
									}
								);

								$scope.model.target =
									existingReplication.subTasks[0].options.restoreOptions.virtualServerRstOption.allocationPolicy;
								$scope.model.replicationSchedule = existingReplication.subTasks[0];
							}

							$scope.cancel = function() {
								$modalInstance.dismiss();
							};

							$scope.saveReplication = function() {
								$scope.taskInfo.subTasks = [$scope.model.replicationSchedule];
								$scope.taskInfo.subTasks[0].options.restoreOptions.virtualServerRstOption.allocationPolicy =
									$scope.model.target.entity;

								var objToSend = angular.copy($scope.model.diskRestoreOption);
								//change transport mode value to int from enum
								//objToSend.transportMode = cvUtil.lookupEnumConstant($scope.model.diskRestoreOption.transportMode,'value');
								$scope.taskInfo.subTasks[0].options.restoreOptions.virtualServerRstOption.diskLevelVMRestoreOption = objToSend;
								// get the storage copyId
								var copyId = undefined;
								for (var i = 0; i < $scope.storages.length; i++) {
									if ($scope.storages[i].name === $scope.model.source) {
										copyId = $scope.storages[i].id;
									}
								}
								$scope.taskInfo.subTasks[0].options.restoreOptions.storagePolicy = {
									copyId: copyId,
									copyName: $scope.model.source
								};

								restoreService
									.addReplication({
										taskInfoList: angular.toJson(
											$scope.editMode ? $scope.profileDetails.replicationTargets.taskInfo : [$scope.taskInfo]
										),
										planId: $scope.plan.planId,
										operation: $scope.listOperation
									})
									.success(function(data) {
										$modalInstance.dismiss();
										$state.forceReload();
									})
									.error(function(e) {
										$scope.serverMessage = cvUtil.errMsg(e);
									});
							};
						}
					],
					resolve: {
						replicationSchedules: function() {
							return $scope.masterProfile.replicationTargets.taskInfo[0].subTasks.slice();
						},
						profileDetails: function() {
							return $scope.profileDetails;
						}
					}
				});
			};

			$scope.deleteReplication = function(target) {
				$scope.serverMessage = cvUtil.emptyMsg();
				if ($scope.profileDetails.replicationTargets.taskInfo.length <= 1) {
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: cvLoc('error.lastReplication')
					});
				} else {
					$scope.listOperation = 'DELETE';
					restoreService
						.addReplication({
							taskInfoList: angular.toJson([target]),
							planId: $scope.profileDetails.summary.plan.planId,
							operation: $scope.listOperation
						})
						.success(function(data) {
							$state.forceReload();
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '10000', //10 sec
								message: e
							});
						});
				}
			};

			/* GRID CONTSTRUCTION */
			var globalReplicationGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

			angular.extend(globalReplicationGridOptions, {
				data: $scope.profileDetails.replicationTargets.taskInfo,
				enableGridMenu: false,
				columnDefs: [
					{
						field: 'subTasks[0].options.restoreOptions.storagePolicy.copyName',
						displayName: cvLoc('label.backupSource'),
						enableHiding: false,
						cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
					},
					{
						field: 'subTasks[0].options.restoreOptions.virtualServerRstOption.allocationPolicy.vmAllocPolicyName',
						displayName: cvLoc('label.target'),
						cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
					},
					{
						field: 'subTasks[0].subTask.subTaskName',
						displayName: cvLoc('label.schedule'),
						cellTemplate: '<span class="crop" title="{{COL_FIELD}}">{{COL_FIELD}}</span>'
					},
					{
						name: 'action',
						displayName: cvLoc('label.actions'),
						enableHiding: false,
						enableFiltering: false,
						enableSorting: false,
						cellTemplate:
							'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>\
																<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
																<li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.addReplication(row.entity)">' +
							cvLoc('action.edit') +
							'</a></li>\
																<li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deleteReplication(row.entity)">' +
							cvLoc('action.delete') +
							'</a></li></ul></div>',
						width: '10%'
					}
				]
			});
			$scope.replicationGridOptions = {
				cvHasTitle: false,
				cvTableName: 'vsaPlanReplicationTable',
				cvIsSearchable: false,
				cvHasViews: false,
				cvServerMessage: 'replicationGridServerMessage',
				gridOptions: globalReplicationGridOptions
			};
		}
	}
];

profileMod.controller(controllers);

export default profileMod;
