(function() {
	'use strict';

	var planMod = angular.module('dloApp.profile');

	var controllers = {};

	controllers.createPlanController = [
		'$scope',
		'$rootScope',
		'profileService',
		'cvLoc',
		'storageService',
		'cvUtil',
		'scheduleUIFactory',
		'alertDetailsService',
		'$state',
		'$location',
		'$dialogs',
		'$window',
		'$uibModal',
		'$log',
		function(
			$scope,
			$rootScope,
			profileService,
			cvLoc,
			storageService,
			cvUtil,
			scheduleUIFactory,
			alertDetailsService,
			$state,
			$location,
			$dialogs,
			$window,
			$modal,
			$log
		) {
			var self = this;
			self.planType;
			self.planSubType;
			//$scope.masterProfile;
			self.templateData;

			self.globalTemplate = {
				name: '',
				storageInfo: {
					storagePool: {},
					retentionInDays: 0
				}
			};
			self.addedSchedules = [];
			$scope.storagePools = [];

			self.generalSetupMessage = cvUtil.infoMsgLoc('Loading');

			//Loading master template data
			var loadMasterTemplate = function() {
				profileService
					.getMasterProfile(self.planType, self.planSubType)
					.success(function(masterTemplateData) {
						masterTemplateData = masterTemplateData.profile;
						//Loading the template data
						loadTemplate();
					})
					.error(function(e) {
						self.generalSetupMessage = {
							type: 'error',
							message: e
						};
					});
			};

			var loadTemplate = function() {
				profileService
					.getTemplateProfile(self.planType, self.planSubType)
					.success(function(templateData) {
						self.generalSetupMessage = cvUtil.emptyMsg();

						$scope.templateData = templateData.profile;
						self.globalTemplate.storageInfo.retentionInDays =
							$scope.templateData.storage.copy[0].retentionRules.retainBackupDataForDays;
						if ($scope.templateData.schedule) {
							var schedules = $scope.templateData.schedule;
							var counter = 0;
							schedules.subTasks.forEach(function(st) {
								var scheduleObje = scheduleUIFactory.createScheduleObject(st, self.planSubType);
								scheduleObje.id = Date.now() + ++counter;
								self.addedSchedules.push(scheduleObje);
							});
						}
					})
					.error(function(e) {
						self.generalSetupMessage = {
							type: 'error',
							message: e
						};
					});
			};

			self.init = function(parentCtrl) {
				self.planType = parentCtrl.planType;
				self.planSubType = parentCtrl.planSubType;
				loadTemplate();
				loadStoragePools();
			};

			//storage pools
			var loadStoragePools = function() {
				storageService
					.getAllStoragePools()
					.success(function(data) {
						$scope.storagePools = cvUtil.sortAscending(data, 'storagePoolEntity.storagePoolName');
						if ($scope.storagePools.length > 0) {
							self.globalTemplate.storageInfo.storagePool = $scope.storagePools[0].storagePoolEntity;
						}
						$scope.editStorageServerMessage = cvUtil.emptyMsg();
					})
					.error(function(e) {
						$scope.editStorageServerMessage = cvUtil.errMsg(e);
					});
			};

			//Checks the duplicate plan name
			self.checkPlaneName = function(name, type) {
				self.disableButtons = false;
				self.generalSetupMessage = cvUtil.emptyMsg();
				if (name) {
					profileService
						.checkPlanName(name)
						.success(function(data) {
							if (data && data.id) {
								self.disableButtons = true;
								self.generalSetupMessage = {
									message: cvLoc('error.nameExisted'),
									type: 'error'
								};
							}
						})
						.error(function(e) {
							self.generalSetupMessage = {
								message: e,
								type: 'error'
							};
						});
				}
			};

			self.addSchedule = function() {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile'
					},
					false,
					self.planSubType
				);
			};

			self.editSchedule = function(obj) {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile',
						model: obj
					},
					true,
					self.planSubType
				);
			};

			$rootScope.$on('scheduleAdded', function(evt, addedSchedule, planId) {
				if (planId == null) {
					addedSchedule.repeat = {
						enabled: addedSchedule.repeatEnabled,
						duration: addedSchedule.repeatDuration,
						hrs: addedSchedule.repeatHrs,
						mins: addedSchedule.repeatMins,
						time: addedSchedule.repeatTime
					};

					self.addedSchedules.push(addedSchedule);
				}
			});

			$rootScope.$on('scheduleEdited', function(evt, addedSchedule, planId) {
				if (planId == null) {
					var idToEdit = addedSchedule.id;
					for (var i = 0; i < self.addedSchedules.length; i++) {
						if (self.addedSchedules[i].id == idToEdit) {
							self.addedSchedules.splice(i, 1);
							self.addedSchedules.push(addedSchedule);
							return;
						}
					}
					self.addedSchedules.push(addedSchedule);
				}
			});

			$rootScope.$on('scheduleDeleted', function(evt, addedSchedule, planId) {
				if (planId == null) {
					var idToEdit = addedSchedule.id;
					for (var i = 0; i < self.addedSchedules.length; i++) {
						if (self.addedSchedules[i].id == idToEdit) {
							self.addedSchedules.splice(i, 1);
							return;
						}
					}
				}
			});

			self.createPlan = function(innerCtrl) {
				$scope.generalSetupMessage = cvUtil.emptyMsg();
				//Name validation, if special handling is need add isNameValid method in inner ctrl and do it.
				if (innerCtrl.isNameValid) {
					if (!innerCtrl.isNameValid()) {
						return;
					}
				} else if (!self.globalTemplate.name) {
					self.generalSetupMessage = {
						message: cvLoc('error.noProfileName'),
						type: 'error'
					};
					return;
				}

				if (innerCtrl.isStorageValid) {
					if (!innerCtrl.isStorageValid()) {
						return;
					}
				} else if (!self.globalTemplate.storageInfo.storagePool) {
					self.generalSetupMessage = {
						message: cvLoc('error.noStoragePolicy'),
						type: 'error'
					};
					return;
				}

				//Validate the other options specific to the plan
				if (innerCtrl.isUserInputValid) {
					if (!innerCtrl.isUserInputValid()) {
						return;
					}
				}

				self.planInfo = $scope.templateData;

				self.addedSchedules.map(function(schedule) {
					if (!schedule.repeat) {
						schedule.repeat = {
							enabled: schedule.repeatEnabled,
							duration: schedule.repeatDuration,
							hrs: schedule.repeatHrs,
							mins: schedule.repeatMins,
							time: schedule.repeatTime
						};
						delete schedule.repeatEnabled;
						delete schedule.repeatDuration;
						delete schedule.repeatHrs;
						delete schedule.repeatMins;
						delete schedule.repeatTime;
					}
					if (schedule.tempTimeConvert) {
						schedule.scheduleTime = schedule.tempTimeConvert;
					}
					if (schedule.tempRepeatTime != undefined) {
						schedule.repeat.time = schedule.tempRepeatTime;
					}
					schedule.operationType = 2; //Schedule type Backup
					schedule.subTaskType = 2; //Schedule type Backup
				});

				self.planInfo.schedules = self.addedSchedules;
				//delete self.planInfo.schedule;

				self.planInfo.summary.plan.planName = self.globalTemplate.name;
				self.planInfo.storage.copy[0].retentionRules.retainBackupDataForDays =
					self.globalTemplate.storageInfo.retentionInDays;

				self.planInfo.storage.copy[0].dedupeFlags.useGlobalDedupStore = 1;
				delete self.planInfo.storage.copy[0].DDBPartitionInfo;
				self.planInfo.storage.copy[0].useGlobalPolicy = {
					storagePolicyId: self.globalTemplate.storageInfo.storagePool.storagePoolId,
					storagePolicyName: self.globalTemplate.storageInfo.storagePool.storagePoolName
				};

				if (innerCtrl.updateCreateTemplate) {
					innerCtrl.updateCreateTemplate(self.planInfo, self.globalTemplate);
				}

				profileService
					.createPlan({
						planIfo: JSON.stringify(self.planInfo)
					})
					.success(function(data) {
						$scope.$emit('planAdded', data);
					})
					.error(function(e) {
						$scope.generalSetupMessage = {
							message: cvLoc('error.createPlanFailed') + e,
							type: 'error'
						};
					});
			};
		}
	];

	controllers.createDbPlanController = [
		'$scope',
		'$http',
		'$rootScope',
		'profileService',
		'definitionsService',
		'cvLoc',
		'storageService',
		'cvUtil',
		'scheduleUIFactory',
		'alertDetailsService',
		'$state',
		'$location',
		'$dialogs',
		'$window',
		'$uibModal',
		'$log',
		function(
			$scope,
			$http,
			$rootScope,
			profileService,
			definitionsService,
			cvLoc,
			storageService,
			cvUtil,
			scheduleUIFactory,
			alertDetailsService,
			$state,
			$location,
			$dialogs,
			$window,
			$modal,
			$log
		) {
			var self = this;
			self.planType;
			self.planSubType;
			self.globalTemplate;
			self.storagePools;
			self.addedLogSchedules = [];
			self.showAddDomainForm = true;
			if (
				$state.is('setup') &&
				cv.sessionContext.setupStepsMap &&
				cv.sessionContext.setupStepsMap[cvApp.acApp][$scope.setupStep]
			) {
				self.showAddDomainForm = false;
				self.plansPresentMessage = cvUtil.infoMsgLoc('info.dbPlanPresent');
				self.changeToAddDBPlan = function() {
					self.showAddDomainForm = true;
					self.plansPresentMessage = cvUtil.emptyMsg();
				};
			}

			self.init = function(parentCtrl) {
				self.planType = parentCtrl.planTyp;
				self.planSubType = parentCtrl.planSubType;
				self.globalTemplate = parentCtrl.globalTemplate;
				self.storagePools = parentCtrl.storagePools;
			};

			self.addSchedule = function() {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile'
					},
					false,
					self.planSubType,
					null,
					'logSchedule',
					null
				);
			};

			self.editSchedule = function(obj) {
				scheduleUIFactory.addSchedule(
					{
						source: 'createProfile',
						model: obj
					},
					true,
					self.planSubType,
					null,
					'logSchedule',
					null
				);
			};

			$rootScope.$on('scheduleAdded', function(evt, addedSchedule, planId) {
				if (planId) {
					addedSchedule.repeat = {
						enabled: addedSchedule.repeatEnabled,
						duration: addedSchedule.repeatDuration,
						hrs: addedSchedule.repeatHrs,
						mins: addedSchedule.repeatMins,
						time: addedSchedule.repeatTime
					};

					self.addedLogSchedules.push(addedSchedule);
				}
			});

			$rootScope.$on('scheduleEdited', function(evt, addedSchedule, planId) {
				if (planId) {
					var idToEdit = addedSchedule.id;
					for (var i = 0; i < self.addedLogSchedules.length; i++) {
						if (self.addedLogSchedules[i].id == idToEdit) {
							self.addedLogSchedules.splice(i, 1);
							self.addedLogSchedules.push(addedSchedule);
							return;
						}
					}
					self.addedLogSchedules.push(addedSchedule);
				}
			});

			$rootScope.$on('scheduleDeleted', function(evt, addedSchedule, planId) {
				if (planId) {
					var idToEdit = addedSchedule.id;
					for (var i = 0; i < self.addedLogSchedules.length; i++) {
						if (self.addedLogSchedules[i].id == idToEdit) {
							self.addedLogSchedules.splice(i, 1);
							return;
						}
					}
				}
			});

			$scope.$watch('storagePools', function(newValue, oldValue) {
				if (newValue != oldValue && newValue) {
					//this triggers even at page initialization so this check is required
					if (newValue.length > 0) {
						self.globalTemplate.storageInfo.logStoragePool = newValue[0].storagePoolEntity;
					}
				}
			});

			$scope.$watch('templateData', function(newValue, oldValue) {
				if (newValue != oldValue) {
					//this triggers even at page initialization so this check is required

					if ($scope.templateData.database && $scope.templateData.database.scheduleLog) {
						var schedules = $scope.templateData.database.scheduleLog;
						var counter = 0;
						schedules.subTasks.forEach(function(st) {
							st.id = Date.now() + ++counter;
							var scheduleObje = scheduleUIFactory.createScheduleObject(st, self.planSubType);
							self.addedLogSchedules.push(scheduleObje);
						});
					}
				}
			});

			self.isNameValid = function() {
				return true;
			};
			self.updateCreateTemplate = function(planInfo, globalTemplate) {
				self.addedLogSchedules.map(function(schedule) {
					if (!schedule.repeat) {
						schedule.repeat = {
							enabled: schedule.repeatEnabled,
							duration: schedule.repeatDuration,
							hrs: schedule.repeatHrs,
							mins: schedule.repeatMins,
							time: schedule.repeatTime
						};
						delete schedule.repeatEnabled;
						delete schedule.repeatDuration;
						delete schedule.repeatHrs;
						delete schedule.repeatMins;
						delete schedule.repeatTime;
					}
					if (schedule.tempTimeConvert) {
						schedule.scheduleTime = schedule.tempTimeConvert;
					}
					if (schedule.tempRepeatTime != undefined) {
						schedule.repeat.time = schedule.tempRepeatTime;
					}

					schedule.operationType = 2;
					schedule.subTaskType = 2;
				});
				planInfo.logSchedules = self.addedLogSchedules;

				planInfo.database.storageLog.copy[0].retentionRules.retainBackupDataForDays =
					self.globalTemplate.storageInfo.retentionInDays;
				planInfo.database.storageLog.copy[0].dedupeFlags.useGlobalDedupStore = 1;
				delete planInfo.database.storageLog.copy[0].DDBPartitionInfo;
				planInfo.database.storageLog.copy[0].useGlobalPolicy = {
					storagePolicyId: self.globalTemplate.storageInfo.logStoragePool.storagePoolId,
					storagePolicyName: self.globalTemplate.storageInfo.logStoragePool.storagePoolName
				};
			};

			$scope.isUserInputValid = function(globalTemplate) {};
		}
	];

	planMod.controller(controllers);
})();
