import { acAppExchangeModule } from 'common/js/modules';
import { office365PlanFactory } from 'modules/plan/js/factory/office365Plan.factory.js';
import { exchangeConstants } from 'exchangeV2/js/constants/exchangeConstants.js';
import 'dlo/js/services/profile.svc.js';
import 'common/js/cv-time-relative-picker.js';

class createOffice365PlanController {
	constructor(
		$modalInstance,
		$state,
		$q,
		$timeout,
		profileService,
		cvLoc,
		cvUtil,
		cvToaster,
		masterDetails,
		ediscoveryUtility,
		createNewPlanInline,
		office365Service,
		subType,
		appType
	) {
		this.cvLoc = cvLoc;
		this.$state = $state;
		this.profileService = profileService;
		this.$modalInstance = $modalInstance;
		this.office365Service = office365Service;
		this.exchangeConstants = exchangeConstants;
		this.createNewPlanInline = createNewPlanInline;
		this.cvToaster = cvToaster;
		this.returnPlanIdToModal = createNewPlanInline || false;

		// masterDetails = {
		// 	summary: {
		// 		plan: {
		// 			planName: ''
		// 		},
		// 		type: 'EXCHANGE',
		// 		subtype: 'Office365'
		// 	},
		// 	office365Info: {
		// 		o365Exchange: {
		// 			mbArchiving: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.EMAIL_POLICY_TYPE,
		// 				detail: {
		// 					emailPolicy: {
		// 						emailPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.ARCHIVE,
		// 						archivePolicy: {
		// 							primaryMailbox: true,
		// 							archiveMailbox: false,
		// 							disabledMailbox: true,
		// 							backupStubs: true,
		// 							includeMsgsLargerThan: 0,
		// 							includeMsgsOlderThan: 0,
		// 							contentIndexProps: {
		// 								deferredDays: 0,
		// 								enableContentIndex: false,
		// 								enablePreviewGeneration: false,
		// 								previewPathDir: {
		// 									userAccount: {
		// 										password: [],
		// 										confirmPassword: []
		// 									}
		// 								}
		// 							}
		// 						}
		// 					}
		// 				}
		// 			},
		// 			mbRetention: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.EMAIL_POLICY_TYPE,
		// 				detail: {
		// 					emailPolicy: {
		// 						emailPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.RETENTION,
		// 						retentionPolicy: {
		// 							type: '',
		// 							numOfDaysForMediaPruning: -1,
		// 							numOfDaysForDeletedMediaPruning: -1
		// 						}
		// 					}
		// 				}
		// 			},
		// 			mbCleanup: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.EMAIL_POLICY_TYPE,
		// 				detail: {
		// 					emailPolicy: {
		// 						emailPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.CLEANUP,
		// 						cleanupPolicy: {
		// 							primaryMailbox: true,
		// 							archiveMailbox: false,
		// 							disabledMailbox: true,
		// 							createStubs: true,
		// 							collectMsgsLargerThan: 0,
		// 							collectMsgsDaysAfter: 0,
		// 							numOfDaysForSourcePruning: 730,
		// 							truncateBody: false,
		// 							truncateBodyToBytes: 1024
		// 						}
		// 					}
		// 				}
		// 			}
		// 		},
		// 		o365CloudOffice: {
		// 			caBackup: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.CLOUD_APPS_POLICY_TYPE,
		// 				detail: {
		// 					cloudAppPolicy: {
		// 						cloudAppPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.ARCHIVE,
		// 						backupPolicy: {
		// 							enableRules: true,
		// 							ruleDetails: [
		// 								{
		// 									agentType: this.exchangeConstants.plan.AGENT_TYPE.ONEDRIVE,
		// 									ruleType: this.exchangeConstants.plan.RULE_TYPE.FILTER,
		// 									ruleEnabled: false,
		// 									filters: [
		// 										{
		// 											filterType: this.exchangeConstants.plan.FILTER_TYPE.FOLDER,
		// 											includeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											},
		// 											excludeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											}
		// 										},
		// 										{
		// 											filterType: this.exchangeConstants.plan.FILTER_TYPE.FILE,
		// 											includeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											},
		// 											excludeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											}
		// 										}
		// 									]
		// 								}
		// 								// {
		// 								// 	agentType: this.exchangeConstants.plan.AGENT_TYPE.SHAREPOINT,
		// 								// 	ruleType: this.exchangeConstants.plan.RULE_TYPE.FILTER,
		// 								// 	ruleEnabled: false,
		// 								// 	filters: [
		// 								// 		{
		// 								// 			filterType: this.exchangeConstants.plan.FILTER_TYPE.WEB,
		// 								// 			includeFilter: {
		// 								// 				patternsAvailable: [],
		// 								// 				patternsSelected: []
		// 								// 			},
		// 								// 			excludeFilter: {
		// 								// 				patternsAvailable: [],
		// 								// 				patternsSelected: []
		// 								// 			}
		// 								// 		}
		// 								// 	]
		// 								// }
		// 							],
		// 							spbackupPolicy: {
		// 								backupVersions: true
		// 							},
		// 							onedrivebackupPolicy: {
		// 								backupVersions: true
		// 							}
		// 						}
		// 					}
		// 				}
		// 			},
		// 			caRetention: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.CLOUD_APPS_POLICY_TYPE,
		// 				detail: {
		// 					cloudAppPolicy: {
		// 						cloudAppPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.RETENTION,
		// 						retentionPolicy: {
		// 							type: '',
		// 							numOfDaysForMediaPruning: -1
		// 						}
		// 					}
		// 				}
		// 			},
		// 			caCleanup: {
		// 				policyType: this.exchangeConstants.plan.POLICY_TYPE.OFFICE_365_POLICY_TYPE,
		// 				detail: {
		// 					cloudAppPolicy: {
		// 						cloudAppPolicyType: this.exchangeConstants.plan.EMAIL_POLICY_TYPES.CLEANUP,
		// 						cleanupPolicy: {
		// 							enableRules: true,
		// 							ruleDetails: [
		// 								{
		// 									ruleType: this.exchangeConstants.plan.RULE_TYPE.FILTER,
		// 									ruleEnabled: false,
		// 									filters: [
		// 										{
		// 											filterType: this.exchangeConstants.plan.FILTER_TYPE.FOLDER,
		// 											includeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											},
		// 											excludeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											}
		// 										},
		// 										{
		// 											filterType: this.exchangeConstants.plan.FILTER_TYPE.FILE,
		// 											includeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											},
		// 											excludeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											}
		// 										},
		// 										{
		// 											filterType: this.exchangeConstants.plan.FILTER_TYPE.MESSAGE,
		// 											includeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											},
		// 											excludeFilter: {
		// 												patternsAvailable: [],
		// 												patternsSelected: []
		// 											}
		// 										}
		// 									]
		// 								},
		// 								{
		// 									ruleType: this.exchangeConstants.plan.RULE_TYPE.CLEANUP_SIZE,
		// 									ruleEnabled: false,
		// 									ruleThreshold: 1000
		// 								},
		// 								{
		// 									ruleType: this.exchangeConstants.plan.RULE_TYPE.CLEANUP_AGE,
		// 									ruleEnabled: false,
		// 									ruleThreshold: 1000
		// 								}
		// 							],
		// 							addRecallLink: false
		// 						}
		// 					}
		// 				}
		// 			}
		// 		}
		// 	}
		// };

		_.set(
			masterDetails,
			'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupOneNote',
			false
		);
		_.set(
			masterDetails,
			'office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch',
			false
		);
		_.set(
			masterDetails,
			'office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupVersions',
			false
		);
		_.set(masterDetails, 'eePolicy.detail.eePolicy.extractionPolicy', {});
		this.planInfo = masterDetails;
		this.planInfo.summary.plan.planName = '';
		this.showData = {
			showAllSearchEntity: true
		};
		if (_.isUndefined(subType)) {
			subType = 'Office365';
		}
		this.planInfo.summary.subtype = subType;
		this.office365PlanFactory = new office365PlanFactory(
			$q,
			$timeout,
			cvLoc,
			cvUtil,
			profileService,
			'',
			subType,
			exchangeConstants,
			ediscoveryUtility
		);
		this.office365PlanFactory.planInfo = masterDetails;

		const isSaaSConfigSet = _.get(cvConfig, 'isOffice365SaaSConfiguration', false);
		this.isOffice365SaaSTenant = isSaaSConfigSet && (cv.isTenantAdmin || cv.isTenantOperator);
		this.office365PlanPrefix = '';
		if (this.isOffice365SaaSTenant) {
			this.saas_planName = '';
			this._getOrganizationDetails();
		}
		if (_.isUndefined(appType)) {
			appType = subType.toUpperCase();
		}
		this.appType = appType;
		this.getAppBasedModes = this.exchangeConstants.plan.APP_BASED_MODES[appType];
		this.getAppBasedModes.headerTile = this.cvLoc(this.getAppBasedModes.headerTile);
		this.getAppBasedModes.helpInfo = this.cvLoc(this.getAppBasedModes.helpInfo);
	}

	cancel() {
		this.$modalInstance.dismiss();
	}

	create() {
		if (this.isOffice365SaaSTenant) {
			this.planInfo.summary.plan.planName = `${this.office365PlanPrefix}${this.saas_planName}`;
		}
		this.profileService.checkPlanName(encodeURIComponent(this.planInfo.summary.plan.planName)).then(
			resp => {
				if (_.isUndefined(resp.data.id)) {
					this.error = '';
					const sendData = this.office365PlanFactory.preProcessData(true);
					if (sendData.errorProcessing) {
						return;
					}
					delete sendData.errorProcessing;
					this.profileService.createPlan(sendData).then(
						resp => {
							if (this.returnPlanIdToModal) {
								this.$modalInstance.close({ planId: resp.data, planName: sendData.summary.plan.planName });
							} else {
								let detailsPageState = 'office365PlanDetails';
								if (this.appType === 'DYNAMICS365') {
									detailsPageState = 'dynamics365PlanDetails';
								}
								this.$state.go(detailsPageState, {
									planId: _.get(resp, 'data', 0)
								});
							}
						},
						resp => {
							this.cvToaster.showErrorMessage({
								ttl: '10000',
								message: _.get(resp, 'data', this.cvLoc('generic_error'))
							});
						}
					);
				} else {
					this.cvToaster.showErrorMessage({
						ttl: '10000',
						message: this.cvLoc('error.nameExisted')
					});
				}
			},
			resp => {
				this.cvToaster.showErrorMessage({
					ttl: '10000',
					message: _.get(resp, 'data', this.cvLoc('generic_error'))
				});
			}
		);
	}

	_getOrganizationDetails() {
		this.office365Service.getOrganisationDetails(cv.orgId).then(
			response => {
				this.organizationName = _.get(response.data, 'organizationInfo.organization.connectName', '');
				if (this.organizationName.length > 0) {
					this.office365PlanPrefix = `${this.organizationName}-`;
				}
			},
			e => {
				this.organizationError = e.data;
				this.office365PlanPrefix = '';
			}
		);
	}
}

createOffice365PlanController.$inject = [
	'$uibModalInstance',
	'$state',
	'$q',
	'$timeout',
	'profileService',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'masterDetails',
	'ediscoveryUtility',
	'createNewPlanInline',
	'office365Service',
	'subType',
	'appType'
];
acAppExchangeModule.controller('createOffice365PlanController', createOffice365PlanController);
export default acAppExchangeModule;
