import { acAppExchangeModule } from 'common/js/modules';
import { exchangeConstants } from 'exchangeV2/js/constants/exchangeConstants.js';
import { exchangePlanFactory } from 'modules/plan/js/factory/exchangePlan.factory.js';
import 'dlo/js/services/profile.svc.js';
import 'ediscovery/common/js/services/ediscovery.util.svc.js';
import 'office365/js/services/office365.svc.js';

class createExchangePlanController {
	constructor(
		$modalInstance,
		$state,
		$q,
		$timeout,
		profileService,
		cvLoc,
		cvToaster,
		subtype,
		ediscoveryUtility,
		masterDetails,
		createNewPlanInline,
		office365Service,
		$scope,
		cvUtil
	) {
		this.cvLoc = cvLoc;
		this.$state = $state;
		this.subtype = subtype;
		this.$scope = $scope;
		this.showData = {
			showAllSearchEntity: true
		};
		this.exchangePlanFactory = new exchangePlanFactory(
			$q,
			$timeout,
			cvLoc,
			cvUtil,
			profileService,
			'',
			subtype,
			exchangeConstants,
			ediscoveryUtility
		);
		this.plan = this.exchangePlanFactory;
		this.cvToaster = cvToaster;
		this.profileService = profileService;
		this.$modalInstance = $modalInstance;
		this.exchangeConstants = exchangeConstants;
		this.createNewPlanInline = createNewPlanInline;
		this.returnPlanIdToModal = _.get(this, 'createNewPlanInline', false);
		const isSaaSConfigSet = _.get(cvConfig, 'isOffice365SaaSConfiguration', false);
		this.isOffice365SaaSTenant = isSaaSConfigSet && (cv.isTenantAdmin || cv.isTenantOperator);
		this.office365Service = office365Service;
		this.exchangePlanPrefix = '';
		if (this.isOffice365SaaSTenant) {
			this.saas_planName = '';
			this._getOrganizationDetails();
		}
		_.set(
			masterDetails,
			'exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch',
			false
		);
		_.set(masterDetails, 'eePolicy.detail.eePolicy.extractionPolicy', {});
		this.getInitData(masterDetails);
	}

	cancel() {
		this.$modalInstance.dismiss({});
	}

	getInitData(masterDetails) {
		this.exchangePlanFactory.setPlanInfo(masterDetails);
		this.plan.planInfo = masterDetails;
		_.set(this.plan.planInfo, 'summary.plan.planName', '');
		_.set(this.plan.planInfo, 'exchange.mbRetention.detail.emailPolicy.retentionPolicy', {
			type: '',
			numOfDaysForMediaPruning: -1,
			numOfDaysForDeletedMediaPruning: -1
		});
		if (this.subtype === this.exchangeConstants.plan.SUBTYPE.EXCHANGEUSER) {
			_.set(this.plan.planInfo, 'exchange.mbArchiving.detail.emailPolicy.archivePolicy.backupStubs', true);
			_.set(
				this.plan.planInfo,
				'exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch',
				false
			);
			_.set(
				this.plan.planInfo,
				'exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.previewPathDir.userAccount',
				{
					userName: '',
					password: [],
					confirmPassword: []
				}
			);
			_.set(this.plan.planInfo, 'exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgsDaysAfter', 365);
			_.set(this.plan.planInfo, 'exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.collectMsgWithAttach', true);
		}
	}

	create() {
		if (this.isOffice365SaaSTenant) {
			this.plan.planInfo.summary.plan.planName = `${this.exchangePlanPrefix}${this.saas_planName}`;
		}
		this.profileService.checkPlanName(encodeURIComponent(this.plan.planInfo.summary.plan.planName)).then(
			resp => {
				if (_.isUndefined(resp.data.id)) {
					this.error = '';
					const sendData = this.exchangePlanFactory.preProcessData();
					if (sendData.errorProcessing) {
						return;
					}
					delete sendData.errorProcessing;
					if (this.subtype === this.exchangeConstants.plan.SUBTYPE.EXCHANGEUSER) {
						if (
							_.get(sendData, 'exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox', false) === true
						) {
							_.set(sendData, 'exchange.mbCleanup.detail.emailPolicy.cleanupPolicy.archiveMailbox', true);
						}
					}
					this.profileService.createPlan(sendData).then(
						resp => {
							if (this.$scope.isAPICall) {
								return;
							} else {
								if (this.subtype === this.exchangeConstants.plan.SUBTYPE.EXCHANGEUSER) {
									if (this.returnPlanIdToModal) {
										this.$modalInstance.close({ planId: resp.data, planName: sendData.summary.plan.planName });
									} else {
										this.$state.go('userMailboxPlanDetails', {
											planId: _.get(resp, 'data', 0)
										});
									}
								}
								if (this.subtype === this.exchangeConstants.plan.SUBTYPE.EXCHANGEJOURNAL) {
									if (this.returnPlanIdToModal) {
										this.$modalInstance.close({ planId: resp.data, planName: sendData.summary.plan.planName });
									} else {
										this.$state.go('journalMailboxPlanDetails', {
											planId: _.get(resp, 'data', 0)
										});
									}
								}
							}
						},
						resp => {
							this.cvToaster.showErrorMessage({
								ttl: '10000',
								message: _.get(resp, 'data', this.cvLoc('generic_error'))
							});
						}
					);
				} else {
					this.cvToaster.showErrorMessage({
						ttl: '10000',
						message: this.cvLoc('error.nameExisted')
					});
				}
			},
			resp => {
				this.cvToaster.showErrorMessage({
					ttl: '10000',
					message: _.get(resp, 'data', this.cvLoc('generic_error'))
				});
			}
		);
	}

	_getOrganizationDetails() {
		this.office365Service.getOrganisationDetails(cv.orgId).then(
			response => {
				this.organizationName = _.get(response.data, 'organizationInfo.organization.connectName', '');
				if (this.organizationName.length > 0) {
					this.exchangePlanPrefix = `${this.organizationName}-`;
				}
			},
			e => {
				this.organizationError = e.data;
				this.exchangePlanPrefix = '';
			}
		);
	}
}

createExchangePlanController.$inject = [
	'$uibModalInstance',
	'$state',
	'$q',
	'$timeout',
	'profileService',
	'cvLoc',
	'cvToaster',
	'subtype',
	'ediscoveryUtility',
	'masterDetails',
	'createNewPlanInline',
	'office365Service',
	'$scope',
	'cvUtil'
];
acAppExchangeModule.controller('createExchangePlanController', createExchangePlanController);
export default acAppExchangeModule;
