import 'modules/plan/js/directives/planDirectives.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/plan/js/factory/plan.factory.js';

import { commonPlanModule } from 'common/js/modules';

var planMod = commonPlanModule;

var controllers = {};

controllers.createDatabasePlanController = [
	'$scope',
	'planFactory',
	'cvLoc',
	'cvUtil',
	'scheduleUIFactory',
	'cvBreadcrumbsTabsFactory',
	'SCHEDULE_PROPERTY',
	'$state',
	'$timeout',
	'$location',
	'$log',
	'profileService',
	function(
		$scope,
		planFactory,
		cvLoc,
		cvUtil,
		scheduleUIFactory,
		cvBreadcrumbsTabsFactory,
		SCHEDULE_PROPERTY,
		$state,
		$timeout,
		$location,
		$log,
		profileService
	) {
		var self = this;
		self.planType = 'MSP';
		self.planSubType = 'Database';
		self.masterTemplateData;
		self.planTemplate;

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.profiles'),
				link: '#profile'
			}
		]);

		//object to contain all the plan details
		self.planInfo = {};

		self.dataModel = {
			type: 'Data',
			planType: self.planType,
			planSubType: self.planSubType,
			primaryStorage: {},
			addedSchedules: [],
			auxCopySchedule: [],
			secondaryStorage: {},
			sla: 4,
			showSecondaryStorage: false,
			openState: true,
			status: {
				showSchedules: true
			}
		};

		self.logModel = {
			type: 'Log',
			planType: self.planType,
			planSubType: self.planSubType,
			primaryStorage: {},
			secondaryStorage: {},
			addedSchedules: [],
			auxCopySchedule: [],
			sla: null,
			slaTime: {
				hrs: 0,
				mins: 30
			},
			showSecondaryStorage: false,
			openState: false,
			status: {
				showSchedules: false
			}
		};

		self.initData = function() {
			planFactory.getMasterProfile(self.planType, self.planSubType).success(function(masterTemplate) {
				self.masterTemplateData = masterTemplate.profile;
				planFactory.getTemplateProfile(self.planType, self.planSubType).success(function(planTemplate) {
					self.planTemplate = planTemplate.profile;
					if (self.planTemplate) {
						self.autoSelect = true;
						profileService
							.getProfiles('all', false, 'Database')
							.success(function(data) {
								self.planInfo = self.planTemplate;
								if (data && data.length > 0) {
									self.planInfo.summary.plan.planName = '';
									self.autoSelect = false;
								}
							})
							.error(function() {
								self.generalMessage = {
									message: e,
									type: 'error'
								};
							});

						self.masterTemplateData = self.masterTemplateData;

						self.dataModel.primaryRetentionRules = self.masterTemplateData.storage.copy[0].retentionRules;
						$scope.$broadcast(
							'cvPlanDayInputSet',
							'primaryRetentionData',
							self.dataModel.primaryRetentionRules.retainBackupDataForDays
						);
						self.dataModel.secondaryRetentionRules = self.masterTemplateData.storage.copy[1]
							? self.masterTemplateData.storage.copy[1].retentionRules
							: {
									retainBackupDataForDays: 30
							  };
						$scope.$broadcast(
							'cvPlanDayInputSet',
							'secondaryRetentionData',
							self.dataModel.secondaryRetentionRules.retainBackupDataForDays
						);
						//self.dataModel.slaInMinutes = self.planTemplate.summary.slaInMinutes /60 ; //Default value for the SLA
						var dataSla = self.planTemplate.summary.slaInMinutes;
						var slaHrs = 0;
						if (dataSla >= 60) {
							slaHrs = Math.round(dataSla / 60);
						}
						self.dataModel.sla = slaHrs;

						var dataSchedules = [];
						var schedules = self.masterTemplateData.schedule;
						var auxCopySchedule = [];
						var counter = 0;
						schedules.subTasks.forEach(function(st) {
							var scheduleObje = scheduleUIFactory.convertSubTaskInfoToSchedule(st, self.planSubType);
							scheduleObje.id = Date.now() + 'Data' + ++counter;
							if (scheduleObje.operationType === 'BACKUP') {
								dataSchedules.push(scheduleObje);
							} else {
								auxCopySchedule.push(scheduleObje);
							}
						});
						self.dataModel.addedSchedules = dataSchedules;
						self.dataModel.auxCopySchedule = auxCopySchedule;

						if (self.masterTemplateData.database && self.masterTemplateData.database.storageLog) {
							self.logModel.primaryRetentionRules = self.masterTemplateData.database.storageLog.copy[0].retentionRules;
							$scope.$broadcast(
								'cvPlanDayInputSet',
								'primaryRetentionLog',
								self.logModel.primaryRetentionRules.retainBackupDataForDays
							);
							self.logModel.secondaryRetentionRules = self.masterTemplateData.database.storageLog.copy[1]
								? self.masterTemplateData.database.storageLog.copy[1].retentionRules
								: {
										retainBackupDataForDays: 30
								  };
							$scope.$broadcast(
								'cvPlanDayInputSet',
								'secondaryRetentionLog',
								self.logModel.secondaryRetentionRules.retainBackupDataForDays
							);
							var logSla = self.planTemplate.database.slaInMinutes;
							var slaHrs = 0;
							if (logSla >= 60) {
								slaHrs = Math.round(logSla / 60);
							}
							self.logModel.slaTime = {
								hrs: slaHrs,
								mins: logSla % 60
							};

							if (self.masterTemplateData.database && self.masterTemplateData.database.scheduleLog) {
								var schedules = self.masterTemplateData.database.scheduleLog;
								var counter = 0;
								schedules.subTasks.forEach(function(st) {
									var scheduleObje = scheduleUIFactory.convertSubTaskInfoToSchedule(st, self.planSubType);
									scheduleObje.id = Date.now() + 'Log' + ++counter;
									if (scheduleObje.operationType === 'BACKUP') {
										scheduleObje.isLogSla = true; //
										self.logModel.addedSchedules.push(scheduleObje);
									} else {
										self.logModel.auxCopySchedule.push(scheduleObje);
									}
								});
							}
						}
						$timeout(function() {
							angular.element('planName').select();
						}, 10);
					}
				});
			});
		};

		self.initData();

		//used to check plan name existed or not
		self.getPlanName = function(name) {
			var response = {
				nameExisted: false
			};
			var result = cvUtil.makeSynchronousCall('GET', 'checkPlanName.do?name=' + name);
			//if api calling success
			if (result.status === 200) {
				response.status = true;
				//if name existed
				if (result.response && result.response.id) {
					response.nameExisted = true;
				}
			} else {
				response.status = false;
			}
			return response;
		};

		self.cancel = function() {
			$location.path('/profile');
		};

		self.createPlan = function() {
			//Validating the data
			//Plan name validation
			self.showNameError = false;
			if (
				self.planInfo.summary.plan.planName === null ||
				self.planInfo.summary.plan.planName == undefined ||
				self.planInfo.summary.plan.planName === ''
			) {
				self.generalMessage = {
					message: cvLoc('error.noProfileName'),
					type: 'error'
				};
				return;
			}

			//check profile name existed or not
			if (self.getPlanName(self.planInfo.summary.plan.planName).status) {
				if (self.getPlanName(self.planInfo.summary.plan.planName).nameExisted) {
					self.generalMessage = {
						message: cvLoc('error.nameExisted'),
						type: 'error'
					};
					return;
				}
			} else {
				//if api calling falied
				self.generalMessage = {
					message: cvLoc('error.checkPlanName'),
					type: 'error'
				};
				return;
			}

			//Data configuration validation start
			//Primary storage check.
			if (!planFactory.isStorageValide(self.dataModel.primaryStorage)) {
				self.generalMessage = {
					message: cvLoc('error.selectPrimaryStoragePool'),
					type: 'error'
				};
				return;
			}

			// Retention period check
			if (!planFactory.isRetentionDaysValide(self.dataModel.primaryRetentionRules.retainBackupDataForDays)) {
				self.generalMessage = {
					message: cvLoc('error.retentionPeriod'),
					type: 'error'
				};
				return;
			}

			//Secondary storage check.
			if (self.dataModel.showSecondaryStorage) {
				if (!planFactory.isStorageValide(self.dataModel.secondaryStorage)) {
					self.generalMessage = {
						message: cvLoc('error.selectSecondaryStoragePool'),
						type: 'error'
					};
					return;
				}

				// Retention period check
				if (!planFactory.isRetentionDaysValide(self.dataModel.secondaryRetentionRules.retainBackupDataForDays)) {
					self.generalMessage = {
						message: cvLoc('error.retentionPeriod'),
						type: 'error'
					};
					return;
				}
			}

			//schedule validation
			if (self.dataModel.addedSchedules.length == 0) {
				self.generalMessage = {
					message: cvLoc('error.noDataScheduleAdded'),
					type: 'error'
				};
				return;
			}

			//Data configuration validation ends

			//Log configuration validation starts
			//Primary storage check.
			if (!planFactory.isStorageValide(self.logModel.primaryStorage)) {
				self.generalMessage = {
					message: cvLoc('error.selectPrimaryStoragePool'),
					type: 'error'
				};
				return;
			}

			// Retention period check
			if (!planFactory.isRetentionDaysValide(self.logModel.primaryRetentionRules.retainBackupDataForDays)) {
				self.generalMessage = {
					message: cvLoc('error.retentionPeriod'),
					type: 'error'
				};
				return;
			}

			//Secondary storage check.
			if (self.logModel.showSecondaryStorage) {
				if (!planFactory.isStorageValide(self.logModel.secondaryStorage)) {
					self.generalMessage = {
						message: cvLoc('error.selectSecondaryStoragePool'),
						type: 'error'
					};
					return;
				}

				// Retention period check
				if (!planFactory.isRetentionDaysValide(self.logModel.secondaryRetentionRules.retainBackupDataForDays)) {
					self.generalMessage = {
						message: cvLoc('error.retentionPeriod'),
						type: 'error'
					};
					return;
				}
			}

			//Log schedule validation
			if (self.logModel.addedSchedules.length == 0) {
				self.generalMessage = {
					message: cvLoc('error.noLogScheduleAdded'),
					type: 'error'
				};
				return;
			}

			//Reseting the message values if any errors comes.
			self.generalMessage = cvUtil.emptyMsg();

			//Log configuration validation ends

			//Updating the Data SLA value.
			//var slaInMinits = (self.dataModel.sla.hrs * 60 ) + self.dataModel.sla.mins;
			self.planInfo.summary.rpoInMinutes = self.dataModel.sla * 60;

			//Updating the schedules info start

			//Data schedules
			scheduleUIFactory.updateSchedules(self.dataModel.addedSchedules);

			//self.dataModel.addedSchedules.map(scheduleUIFactory.convertScheduleToSubTaskInfo);

			var dataSchedules = [];
			self.dataModel.addedSchedules.forEach(function(st) {
				dataSchedules.push(scheduleUIFactory.convertScheduleToSubTaskInfo(st));
			});

			//self.planInfo.schedules = self.dataModel.addedSchedules;
			self.planInfo.schedule.subTasks = dataSchedules;

			//Log schedules

			//Updating the Log SLA value.
			var logSlaInMinits = self.logModel.slaTime.hrs * 60 + self.logModel.slaTime.mins;
			self.planInfo.database.rpoInMinutes = logSlaInMinits;

			scheduleUIFactory.updateSchedules(self.logModel.addedSchedules);
			var logSchedules = [];
			self.logModel.addedSchedules.forEach(function(st) {
				logSchedules.push(scheduleUIFactory.convertScheduleToSubTaskInfo(st));
			});
			//self.logModel.addedSchedules.map(scheduleUIFactory.convertScheduleToSubTaskInfo);
			self.planInfo.database.scheduleLog.subTasks = logSchedules;
			//self.planInfo.logSchedules = self.logModel.addedSchedules;

			//Updating the schedules info end

			//Updating planInfo start..

			//Data storage policy
			var spCopy = planFactory.updateStoragePolicy(
				self.planInfo.storage.copy[0],
				self.dataModel.primaryStorage.storagePoolEntity
			);
			spCopy.sourceCopy = {
				copyName: 'NA'
			}; //for primary copy.
			spCopy.retentionRules.retainBackupDataForDays = self.dataModel.primaryInfinite
				? -1
				: self.dataModel.primaryRetentionRules.retainBackupDataForDays;
			self.planInfo.storage.copy[0] = spCopy;

			//Secondary copy storage policy
			if (self.dataModel.showSecondaryStorage) {
				var secondaryCopy = self.masterTemplateData.storage.copy[1]
					? self.masterTemplateData.storage.copy[1]
					: self.planInfo.storage.copy[0];

				var secondaryCopy = planFactory.updateStoragePolicy(
					secondaryCopy,
					self.dataModel.secondaryStorage.storagePoolEntity,
					self.dataModel.secondaryStorage.storagePoolType
				);
				delete secondaryCopy.dedupeFlags.enableClientSideDedup;
				secondaryCopy.copyType = 1; //SYNCHRONOUS secondary copy type flag

				//override flags if tape storage pool selected
				if (self.dataModel.secondaryStorage.storagePoolType === 'SECONDARY_COPY') {
					secondaryCopy.retentionRules.retainBackupDataForDays = null;
				} else {
					secondaryCopy.retentionRules.retainBackupDataForDays = self.dataModel.secondaryInfinite
						? -1
						: self.dataModel.secondaryRetentionRules.retainBackupDataForDays;
				}

				self.planInfo.storage.copy[1] = secondaryCopy;
			}

			//Log storage policy

			var logSPCopy = planFactory.updateStoragePolicy(
				self.planInfo.database.storageLog.copy[0],
				self.logModel.primaryStorage.storagePoolEntity
			);
			logSPCopy.sourceCopy = {
				copyName: 'NA'
			}; //for primary copy.
			logSPCopy.retentionRules.retainBackupDataForDays = self.logModel.primaryInfinite
				? -1
				: self.logModel.primaryRetentionRules.retainBackupDataForDays;

			self.planInfo.database.storageLog.copy[0] = logSPCopy;

			//Secondary copy storage policy
			if (self.logModel.showSecondaryStorage) {
				var logSecondaryCopy = self.masterTemplateData.database.storageLog.copy[1]
					? self.masterTemplateData.database.storageLog.copy[1]
					: self.planInfo.database.storageLog.copy[0];

				var logSecondaryCopy = planFactory.updateStoragePolicy(
					logSecondaryCopy,
					self.logModel.secondaryStorage.storagePoolEntity,
					self.logModel.secondaryStorage.storagePoolType
				);
				delete logSecondaryCopy.dedupeFlags.enableClientSideDedup;
				logSecondaryCopy.copyType = 1; //SYNCHRONOUS secondary copy type flag

				//override flags if tape storage pool selected
				if (self.logModel.secondaryStorage.storagePoolType === 'SECONDARY_COPY') {
					logSecondaryCopy.retentionRules.retainBackupDataForDays = null;
				} else {
					logSecondaryCopy.retentionRules.retainBackupDataForDays = self.logModel.secondaryInfinite
						? -1
						: self.logModel.secondaryRetentionRules.retainBackupDataForDays;
				}

				self.planInfo.database.storageLog.copy[1] = logSecondaryCopy;
			}

			//Updating planInfo end..

			planFactory
				.createPlan(self.planInfo)
				.success(function(data) {
					if ($state.is('dbsSetup')) {
						$scope.$emit('planAdded');
					} else {
						$location.path('/profileDetails/' + data.plan.summary.plan.planId);
					}
				})
				.error(function(e) {
					self.generalMessage = {
						message: cvLoc('error.createPlanFailed') + e,
						type: 'error'
					};
				});
		};
	}
];

planMod.controller(controllers);

export default planMod;
