const getCopyNameTemplate = (
	planRuleFactory,
	storageCopyFactory,
	cvLoc,
	showEdit,
	disabled,
	isFirstTime,
	isElastic,
	dataItem
) => {
	let formattedLabel = planRuleFactory.getCopyTypeName(dataItem);
	formattedLabel = formattedLabel ? formattedLabel : '';
	let isSelectiveCopy = dataItem.copyType && dataItem.copyType.length && dataItem.copyType == 'SELECTIVE';

	if (isSelectiveCopy === true) {
		let selectiveType = cvLoc('label.selectiveCopy');

		if (dataItem.selectiveCopyRules && dataItem.selectiveCopyRules.selectiveRule) {
			selectiveType = storageCopyFactory.getSelectiveType(dataItem.selectiveCopyRules.selectiveRule);
			if (selectiveType && selectiveType.label) {
				selectiveType = selectiveType.label;
			}
		}

		if (formattedLabel) {
			formattedLabel += ' ( ' + selectiveType + ' )';
		} else {
			formattedLabel = selectiveType;
		}
	}

	let copy = dataItem.StoragePolicyCopy.copyName;
	let copyName =
		`<span class="crop ` +
		dataItem.disabled +
		`" cv-toggle-content="` +
		copy +
		`" cv-toggle="tooltip" >` +
		copy +
		`</span>`;
	if (!dataItem.disabled && showEdit && !isFirstTime) {
		copyName = `<a class="crop k-grid-copyName" cv-toggle-content="` + copy + `" cv-toggle="tooltip" >` + copy + `</a>`;
	}
	copyName += `<div class="extended-retention" title="` + formattedLabel + `">` + formattedLabel + `</div>`;
	return copyName;
};

const getCopyTypeTemplate = showSource => {
	if (showSource) {
		return `<span class="crop" title="#:copyTypeName#">#:copyTypeName#</span>`;
	}
	return `<span></span>`;
};

const getSourceCopyTemplate = () => `#if(data.sourceCopy){
		#<span class="crop" title="#:sourceCopy.copyName#">#:sourceCopy.copyName#</span>#
		}else{
		#<span></span>#
		}#`;

const getStoragePoolNameTemplate = (ruleBasedStorage, isElastic, showSnapShotCopy, isFirstTime) => {
	/*
	 * if(showSnapShotCopy){ return `<span></span>`; } else{
	 */
	if (!ruleBasedStorage) {
		return `#if(data.useGlobalPolicy && data.useGlobalPolicy.storagePolicyName){
					#<span cv-toggle="tooltip" cv-toggle-content="#:toolTipMSG#">
						<a class="#:disabled#"
							href="\\#/#=poolURL#?storagePoolName=#=encodeURIComponent(useGlobalPolicy.storagePolicyName)#&storagePoolId=#=useGlobalPolicy.storagePolicyId#&\
							#if(data.poolTypeForUrl){ #storagePoolType=#=poolTypeForUrl## }
							else if(data.poolType){ #storagePoolType=#=poolType## }
							#">
							#:useGlobalPolicy.storagePolicyName#
						</a>
					</span>#
				}else{
					#<span>NA</span>#
				}#`;
	} else {
		if (!isElastic) {
			return `<span class="crop" title="#:storagePool.storagePoolEntity.storagePoolName#">#:storagePool.storagePoolEntity.storagePoolName#</span>`;
		}

		return `#if(storagePool){
			#<span cv-toggle="tooltip" cv-toggle-content="#:toolTipMSG#"><a class="#:disabled#" href="\\#/#=poolURL#?storagePoolName=#=encodeURIComponent(storagePool.storagePoolEntity.storagePoolName)#&storagePoolId=#=storagePool.storagePoolEntity.storagePoolId#">#:storagePool.storagePoolEntity.storagePoolName#</a></span>#
			}else{
			#<span><span/>#
			}#`;
	}
	//}
};

const getRetentionDaysTemplate = (cvLoc, planRuleFactory, storageCopyFactory, dataItem) => {
	let retentionRules = dataItem.retentionRules;
	let retentionTemplate = '';

	let formattedRetentionVal = '';

	//if (!planRuleFactory.isMirror(dataItem)) {
	if (planRuleFactory.isJobBasedCopy(dataItem) && retentionRules.jobs != undefined) {
		formattedRetentionVal = retentionRules.jobs + ' ' + cvLoc('label.retentionUnit.recoveryPoints');
	} else {
		let retentionUnitInfo = storageCopyFactory.getAppropriateUnitType(
			retentionRules.retainBackupDataForDays,
			retentionRules.retainBackupDataForDays == -1 ? true : false
		);
		formattedRetentionVal = retentionUnitInfo.qty + ' ' + retentionUnitInfo.label || '';
	}
	//	} else {
	//		formattedRetentionVal = cvLoc('label.notApplicable');
	//	}

	if (retentionRules.extendedRetentionRuleOne) {
		if (retentionRules.retainBackupDataForDays == -1) {
			retentionTemplate +=
				`<span class="crop,add-extra-margin" title="` +
				cvLoc('label.retentionUnit.infinite') +
				`">` +
				cvLoc('label.retentionUnit.infinite') +
				`</span>`;
		} else {
			retentionTemplate +=
				`<span class="crop,add-extra-margin" title="` +
				formattedRetentionVal +
				`">` +
				formattedRetentionVal +
				`</span>`;
		}

		retentionTemplate += `<div class="extended-retention">` + cvLoc('label.extendedRetentionConfigured') + `</div>`;
	} else {
		if (retentionRules.retainBackupDataForDays == -1) {
			retentionTemplate +=
				`<span class="crop" title="` +
				cvLoc('label.retentionUnit.infinite') +
				`">` +
				cvLoc('label.retentionUnit.infinite') +
				`</span>`;
		} else {
			retentionTemplate +=
				`<span class="crop" title="` + formattedRetentionVal + `">` + formattedRetentionVal + `</span>`;
		}
	}
	return retentionTemplate;
};

const getActionColTemplate = (showEdit, isElastic) => {
	return `#if(data.isSnapCopy === 'SET_TRUE' && data.isSnapPrimary === true){
		#<span><span>#
	}else if(data.isDefault && data.isDefault == 'SET_FALSE'){
		#<a class="k-icon k-i-delete k-i-trash k-grid-delete-copy"/>#
		}else{
		 #<span></span>#
		 }#`;
};

const getCopyName = (planRuleFactory, storageCopyFactory, cvLoc, showEdit, disabled, isFirstTime, isElastic) => ({
	'StoragePolicyCopy.copyName': {
		title: cvLoc('label.name'),
		type: 'string',
		width: '30%',
		template: getCopyNameTemplate.bind(
			undefined,
			planRuleFactory,
			storageCopyFactory,
			cvLoc,
			showEdit,
			disabled,
			isFirstTime,
			isElastic
		),
		searchField: 'StoragePolicyCopy.copyName'
	}
});

const getStoragePoolName = (cvLoc, ruleBasedStorage, isElastic, showSnapShotCopy, isFirstTime) => ({
	'StoragePolicyCopy.storagePolicyName': {
		title: cvLoc('label.storagePoolCol'),
		type: 'string',
		width: '25%',
		template: getStoragePoolNameTemplate(ruleBasedStorage, isElastic, showSnapShotCopy, isFirstTime),
		searchField: 'useGlobalPolicy.storagePolicyName'
	}
});

const getRetentionDays = (retentionLabel, planSubType, cvLoc, storageCopyFactory, planRuleFactory) => ({
	'retentionRules.retainBackupDataForDays': {
		title: retentionLabel,
		type: 'number',
		width: '30%',
		template: getRetentionDaysTemplate.bind(undefined, cvLoc, planRuleFactory, storageCopyFactory),
		searchField: 'retentionRules.retainBackupDataForDays',
		hidden: planSubType == 'Laptop'
	}
});

const getCopyType = (cvLoc, showSnapShotCopy) => ({
	copyTypeName: {
		title: cvLoc('label.copyType'),
		type: 'string',
		width: '15%',
		template: getCopyTypeTemplate(),
		searchField: 'copyTypeName',
		hidden: true
	}
});

const getSourceCopy = (cvLoc, showSource) => ({
	'sourceCopy.copyName': {
		title: cvLoc('label.source'),
		type: 'string',
		width: '25%',
		template: getSourceCopyTemplate(showSource),
		searchField: 'sourceCopy.copyName',
		hidden: !showSource
	}
});

const getActionCol = (showEdit, isElastic, isFirstTime) => ({
	ActionCol: {
		title: '',
		type: 'string',
		width: '5%',
		template: getActionColTemplate(showEdit, isElastic),
		hidden: !showEdit || isFirstTime,
		sortable: false
	}
});

export const getStorageCopyColumnTemplate = ({
	angularLibs,
	retentionLabel,
	isRuleBasedStorage,
	isElastic,
	planSubType,
	showSnapShotCopy,
	showSource,
	showEdit,
	disabled,
	storageCopyFactory,
	planRuleFactory,
	isFirstTime
}) => ({
	...getCopyName(
		planRuleFactory,
		storageCopyFactory,
		angularLibs.cvLoc,
		showEdit,
		disabled,
		isFirstTime,
		isRuleBasedStorage
	),
	...getCopyType(angularLibs.cvLoc, showSnapShotCopy),
	...getStoragePoolName(angularLibs.cvLoc, isRuleBasedStorage, isElastic, showSnapShotCopy),
	...getRetentionDays(retentionLabel, planSubType, angularLibs.cvLoc, storageCopyFactory, planRuleFactory),
	...getSourceCopy(angularLibs.cvLoc, showSource),
	...getActionCol(showEdit, isElastic, isFirstTime)
});
