<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.network"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.network">
	<div  data-ng-controller="topologyAddEditController as tc" data-ng-init="tc.init(tmc.topology)">
		<div class="setup-title">
			<h1 data-ng-show="tc.createTopology"><fmt:message key="pageHeader.addTopology" /></h1>
			<h1 data-ng-show="!tc.createTopology"><fmt:message key="pageHeader.editTopology" /></h1>
		</div>
		<div class="setup-content">
			<span class="{{tc.topologiesMessage.type}} serverMessage">{{tc.topologiesMessage.message}}</span>
			<form name="addTopologyForm" novalidate data-cv-submit="tc.createOrSaveTopology(tmc.close)" autocomplete="off" class="bootstrap-wrapper modal-margin form-horizontal">

		<!--// start new// -->
		<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="name"><cv:msg key="label.name" bundle="collections"/></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text"
							id="name"
							name="name"
							data-ng-model="tc.topology.topologyEntity.topologyName"
							required
							data-ng-class="{'has-error': cv.addTopologyForm.needsAttention(addTopologyForm.name)}"
							maxlength="50" />
				<span class="cv-help-block" data-ng-show="addTopologyForm.name.$error.required && cv.addTopologyForm.needsAttention(addTopologyForm.name)"><cv:msg key="error.name" bundle="collections" /></span>
				</div>

		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="servertype"><cv:msg key="label.clientType" bundle="network" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<label for="servertype" class="display-inline"><input name="radio"
													value="ct_Servers"
													type="radio"
													id="servertype"
													data-ng-model="tc.topology.clientType"
													data-ng-value="0"
													data-ng-change="tc.showCorrectLabelsForUI(tc.topology)"/> <cv:msg key="label.clientType.servers" bundle="network" /></label>
				<label for="clienttype" class="display-inline margin-left-20"><input name="radio"
										value="ct_Laptops"
										id="clienttype"
										type="radio"
										data-ng-model="tc.topology.clientType"
										data-ng-value="1"
										data-ng-change="tc.showCorrectLabelsForUI(tc.topology)"/> <cv:msg key="label.clientType.laptops" bundle="network" /></label>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="topologyType_select"><cv:msg key="label.topologyType" bundle="network" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
			<select id="topologyType_select" name="topologyType_select" data-ng-options="mode.id as mode.title for mode in tc.uiModel.topologyModes" data-ng-model="tc.topology.topologyType" data-ng-change="tc.showCorrectLabelsForUI(tc.topology)">
			</select>
			</div>
		</div>
		<div class="svg-primary-fill ng-cloak" id="topology-resource-container">
			<ng-include ng-show="tc.topology.topologyType === 1 && tc.topology.clientType === 0" src="'${pageContext.request.contextPath}/common/img/network-server.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 2 && tc.topology.clientType === 0"  src="'${pageContext.request.contextPath}/common/img/oneway-server.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 3 && tc.topology.clientType === 0"  src="'${pageContext.request.contextPath}/common/img/twoway-server.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 4	 && tc.topology.clientType === 0"  src="'${pageContext.request.contextPath}/common/img/cascading-server.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 1 && tc.topology.clientType === 1"  src="'${pageContext.request.contextPath}/common/img/network-laptop.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 2 && tc.topology.clientType === 1"  src="'${pageContext.request.contextPath}/common/img/oneway-laptop.svg'"></ng-include>
			<ng-include ng-show="tc.topology.topologyType === 4 && tc.topology.clientType === 1"  src="'${pageContext.request.contextPath}/common/img/cascading-laptop.svg'"></ng-include>
		</div>

		<!--  Advanced button toggle -->
		<div class="form-group margin-top-30" >
			<div class="col-xs-12 col-md-12 col-lg-12">
				<cv-toggle toggle-label="label.advanced" value="tc.uiModel.showAdvanced"></cv-toggle>
			</div>
		</div>

		<div class="form-group">
			<label class="col-xs-11 col-md-4 col-lg-4" for="firstClientGroup">
				<div class="topology-serial-container"><span class="topology-serial-number">1</span><span ng-bind="tc.uiModel.firstClientGroupLabel"></span></div>
			</label>
			<div class="col-xs-11 col-md-7 col-lg-7">
				<isteven-multi-select id="addTopologyModal_isteven-multi-select_#9538"
		                    input-model="tc.uiModel.listFirstClientGroups"
		                    output-model="tc.uiModel.firstClientGroup"
		                    item-label="name"
		                    button-label="name"
		                    tick-property="selected"
		                    class="isteven-multi-select user-group-select"
		                    directive-id="'firstClientGroup'"
		                    name="firstClientGroup"
		                    helper-elements="filter"
		                    selection-mode="single"
		                    group-property="group"
		                    tick-property="ticked"
		                    on-open="tc.updateTopology(1)"
		                    disable-property="disabled"
		                    translation="tc.uiModel.translation"
		                    on-item-click="tc.updateGroupNetworkOptions(1)">
		          </isteven-multi-select>

		          <span class="cv-help-block" data-ng-show="tc.uiModel.showErrorFirstClientGroup">{{ 'error.select' | cvLoc: tc.uiModel.firstClientGroupLabel }}</span>
			</div>
			<div class="col-xs-1 col-md-1 col-lg-1">
				<span  data-ng-show="tc.uiModel.showAdvanced && !tc.uiModel.showFirstGroupNetworkOptions" ng-disabled="!tc.uiModel.firstClientGroup.length || tc.uiModel.firstClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-down cursor-pointer margin-top-10" id="addGroupNetworkInfo" title='<cv:msg key="label.add" bundle="network"/>' data-ng-click="tc.showNetworkOptions(1)"></span>
                 </span>
                 <span  data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showFirstGroupNetworkOptions" ng-disabled="!tc.uiModel.firstClientGroup.length || tc.uiModel.firstClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-up cursor-pointer margin-top-10" id="addGroupNetworkInfo" data-ng-click="tc.showNetworkOptions(1)"></span>
                 </span>
			</div>

			<!-- Advanced Group Network Options  -->
			<div class="col-xs-12 col-md-12 col-lg-12 margin-top-20 margin-right-20 margin-bottom-20 margin-left-20" id="advancedOptions_Group1" data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showFirstGroupNetworkOptions" ng-disabled="tc.uiModel.firstClientGroup[0].Id <=0">
					<div class="col-xs-12 col-md-12 col-lg-12" >
						<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.tunnelPort" bundle="network"/></label>
						<cv-tile-edit class="margin-top-10" value="tc.uiModel.firstGroupOptions.tunnelPortLabel" enable-inlineedit="true" edit-func="tc.updateTunnelPort(1)">
							<input type="text" data-ng-model="tc.uiModel.firstGroupOptions.tunnelPort"/>
						</cv-tile-edit>
					</div>
					<div class="col-xs-12 col-md-12 col-lg-12" >
							<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.keepAliveInterval" bundle="network" /></label>
							<cv-tile-edit class="margin-top-10" value="tc.uiModel.firstGroupOptions.keepAliveIntervalLabel" enable-inlineedit="true" edit-func="tc.updateKeepAlive(1)">
									<input type="text" data-ng-model="tc.uiModel.firstGroupOptions.keepAliveInterval"/>
							</cv-tile-edit>
					</div>
			</div>
		</div>

		<div class="form-group" ng-if="tc.uiModel.showThirdClientGroup">
			<label class="col-xs-11 col-md-4 col-lg-4" for="thirdClientGroup">
				<div class="topology-serial-container"><span class="topology-serial-number">2</span><span ng-bind="tc.uiModel.thirdClientGroupLabel"></span></div>
			</label>
			<div class="col-xs-11 col-md-7 col-lg-7">
				<isteven-multi-select id="addTopologyModal_isteven-multi-select_#5157"
		                    input-model="tc.uiModel.listThirdClientGroups"
		                    output-model="tc.uiModel.thirdClientGroup"
		                    item-label="name"
		                    button-label="name"
		                    tick-property="selected"
		                    class="isteven-multi-select user-group-select"
		                    directive-id="'thirdClientGroup'"
		                    name="thirdClientGroup"
		                    helper-elements="filter"
		                    selection-mode="single"
		                    group-property="group"
		                    tick-property="ticked"
		                    on-open="tc.updateTopology(3)"
		                    disable-property="disabled"
		                    translation="tc.uiModel.translation"
		                    on-item-click="tc.updateGroupNetworkOptions(3)">
		          </isteven-multi-select>
		          <span class="cv-help-block" data-ng-show="tc.uiModel.showErrorThirdClientGroup">{{ 'error.select' | cvLoc: tc.uiModel.thirdClientGroupLabel }}</span>
			</div>

			<div class="col-xs-1 col-md-1 col-lg-1">
				<span  data-ng-show="tc.uiModel.showAdvanced && !tc.uiModel.showThirdGroupNetworkOptions" ng-disabled="!tc.uiModel.thirdClientGroup.length || tc.uiModel.thirdClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-down cursor-pointer margin-top-10" id="addGroupNetworkInfo" title='<cv:msg key="label.add" bundle="network"/>' data-ng-click="tc.showNetworkOptions(3)"></span>
                 </span>
                 <span  data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showThirdGroupNetworkOptions" ng-disabled="!tc.uiModel.thirdClientGroup.length || tc.uiModel.thirdClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-up cursor-pointer margin-top-10" id="addGroupNetworkInfo" data-ng-click="tc.showNetworkOptions(3)"></span>
                 </span>
			</div>

			<!-- Advanced Group Network Options  -->
			<div class="col-xs-12 col-md-12 col-lg-12 margin-top-20 margin-right-20 margin-bottom-20 margin-left-20" id="advancedOptions_Group3" data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showThirdGroupNetworkOptions" ng-disabled="tc.uiModel.thirdClientGroup[0].Id <=0">
					<div class="col-xs-12 col-md-12 col-lg-12" >
						<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.tunnelPort" bundle="network"/></label>
						<cv-tile-edit class="margin-top-10" value="tc.uiModel.thirdGroupOptions.tunnelPortLabel" enable-inlineedit="true" edit-func="tc.updateTunnelPort(3)">
							<input type="text" data-ng-model="tc.uiModel.thirdGroupOptions.tunnelPort"/>
						</cv-tile-edit>
					</div>
					<div class="col-xs-12 col-md-12 col-lg-12" >
							<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.keepAliveInterval" bundle="network" /></label>
							<cv-tile-edit class="margin-top-10" value="tc.uiModel.thirdGroupOptions.keepAliveIntervalLabel" enable-inlineedit="true" edit-func="tc.updateKeepAlive(3)">
									<input type="text" data-ng-model="tc.uiModel.thirdGroupOptions.keepAliveInterval"/>
							</cv-tile-edit>
					</div>
			</div>

		</div>

		<div class="form-group" data-ng-show="tc.uiModel.showFourthClientGroup">
			<label class="col-xs-11 col-md-4 col-lg-4" for="fourthClientGroup">
				<div class="topology-serial-container"><span class="topology-serial-number">3</span><span ng-bind="tc.uiModel.fourthClientGroupLabel"></span></div>
			</label>
			<div class="col-xs-11 col-md-7 col-lg-7">
				<isteven-multi-select id="addTopologyModal_isteven-multi-select_#0639"
		                    input-model="tc.uiModel.listFourthClientGroups"
		                    output-model="tc.uiModel.fourthClientGroup"
		                    item-label="name"
		                    button-label="name"
		                    tick-property="selected"
		                    class="isteven-multi-select user-group-select"
		                    directive-id="'fourthClientGroup'"
		                    name="fourthClientGroup"
		                    helper-elements="filter"
		                    selection-mode="single"
		                    group-property="group"
		                    tick-property="ticked"
		                    on-open="tc.updateTopology(4)"
		                    disable-property="disabled"
		                    translation="tc.uiModel.translation"
		                    on-item-click="tc.updateGroupNetworkOptions(4)">
		          </isteven-multi-select>
		          <span class="cv-help-block" data-ng-show="tc.uiModel.showErrorFourthClientGroup">{{ 'error.select' | cvLoc: tc.uiModel.fourthClientGroupLabel }}</span>
			</div>

			<div class="col-xs-1 col-md-1 col-lg-1">
				<span  data-ng-show="tc.uiModel.showAdvanced && !tc.uiModel.showFourthGroupNetworkOptions" ng-disabled="!tc.uiModel.fourthClientGroup.length || tc.uiModel.fourthClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-down cursor-pointer margin-top-10" id="addGroupNetworkInfo" title='<cv:msg key="label.add" bundle="network"/>' data-ng-click="tc.showNetworkOptions(4)"></span>
                 </span>
                 <span  data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showFourthGroupNetworkOptions" ng-disabled="!tc.uiModel.fourthClientGroup.length || tc.uiModel.fourthClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-up cursor-pointer margin-top-10" id="addGroupNetworkInfo" data-ng-click="tc.showNetworkOptions(4)"></span>
                 </span>
			</div>

			<!-- Advanced Group Network Options  -->
			<div class="col-xs-12 col-md-12 col-lg-12 margin-top-20 margin-right-20 margin-bottom-20 margin-left-20" id="advancedOptions_Group4" data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showFourthGroupNetworkOptions" ng-disabled="tc.uiModel.fourthClientGroup[0].Id <=0">
				<div class="col-xs-12 col-md-12 col-lg-12" >
						<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.tunnelPort" bundle="network"/></label>
						<cv-tile-edit class="margin-top-10" value="tc.uiModel.fourthGroupOptions.tunnelPortLabel" enable-inlineedit="true" edit-func="tc.updateTunnelPort(4)">
							<input type="text" data-ng-model="tc.uiModel.fourthGroupOptions.tunnelPort"/>
						</cv-tile-edit>
					</div>
					<div class="col-xs-12 col-md-12 col-lg-12" >
							<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.keepAliveInterval" bundle="network" /></label>
							<cv-tile-edit class="margin-top-10" value="tc.uiModel.fourthGroupOptions.keepAliveIntervalLabel" enable-inlineedit="true" edit-func="tc.updateKeepAlive(4)">
									<input type="text" data-ng-model="tc.uiModel.fourthGroupOptions.keepAliveInterval"/>
							</cv-tile-edit>
					</div>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-11 col-md-4 col-lg-4" for="secondClientGroup">
				<div class="topology-serial-container"><span class="topology-serial-number" ng-bind="tc.getSerialNumber()"></span><span ng-bind="tc.uiModel.secondClientGroupLabel"></span></div>
			</label>
			<div class="col-xs-11 col-md-7 col-lg-7">
				<isteven-multi-select id="addTopologyModal_isteven-multi-select_#7346"
			                input-model="tc.uiModel.listSecondClientGroups"
			                output-model="tc.uiModel.secondClientGroup"
			                item-label="name"
			                button-label="name"
			                tick-property="selected"
			                class="isteven-multi-select user-group-select"
			                directive-id="'secondClientGroup'"
			                name="secondClientGroup"
			                helper-elements="filter"
			                selection-mode="single"
			                group-property="group"
			                tick-property="ticked"
			                on-open="tc.updateTopology(2)"
			                disable-property="disabled"
			                translation="tc.uiModel.translation"
			                on-item-click="tc.updateGroupNetworkOptions(2)">
			      </isteven-multi-select>
			      <span class="cv-help-block" data-ng-show="tc.uiModel.showErrorSecondClientGroup">{{ 'error.select' | cvLoc: tc.uiModel.secondClientGroupLabel }}</span>
			</div>

			<div class="col-xs-1 col-md-1 col-lg-1">
				<span  data-ng-show="tc.uiModel.showAdvanced && !tc.uiModel.showSecondGroupNetworkOptions" ng-disabled="!tc.uiModel.secondClientGroup.length || tc.uiModel.secondClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-down cursor-pointer margin-top-10" id="addGroupNetworkInfo" title='<cv:msg key="label.add" bundle="network"/>' data-ng-click="tc.showNetworkOptions(2)"></span>
                 </span>
                 <span  data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showSecondGroupNetworkOptions" ng-disabled="!tc.uiModel.secondClientGroup.length || tc.uiModel.secondClientGroup[0].Id <=0">
                	<span class="k-icon k-i-arrow-chevron-up cursor-pointer margin-top-10" id="addGroupNetworkInfo" data-ng-click="tc.showNetworkOptions(2)"></span>
                 </span>
			</div>

			<!-- Advanced Group Network Options  -->
			<div class="col-xs-12 col-md-12 col-lg-12 margin-top-20 margin-right-20 margin-bottom-20 margin-left-20" id="advancedOptions_Group2" data-ng-show="tc.uiModel.showAdvanced && tc.uiModel.showSecondGroupNetworkOptions" ng-disabled="tc.uiModel.secondClientGroup[0].Id <=0">
					<div class="col-xs-12 col-md-12 col-lg-12" >
						<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.tunnelPort" bundle="network"/></label>
						<cv-tile-edit class="margin-top-10" value="tc.uiModel.secondGroupOptions.tunnelPortLabel" enable-inlineedit="true" edit-func="tc.updateTunnelPort(2)">
							<input type="text" data-ng-model="tc.uiModel.secondGroupOptions.tunnelPort"/>
						</cv-tile-edit>
					</div>
					<div class="col-xs-12 col-md-12 col-lg-12" >
							<label class="col-xs-6 col-md-6 col-lg-6" ><cv:msg key="label.keepAliveInterval" bundle="network" /></label>
							<cv-tile-edit class="margin-top-10" value="tc.uiModel.secondGroupOptions.keepAliveIntervalLabel" enable-inlineedit="true" edit-func="tc.updateKeepAlive(2)">
									<input type="text" data-ng-model="tc.uiModel.secondGroupOptions.keepAliveInterval"/>
							</cv-tile-edit>
					</div>
			</div>
		</div>
		<div class="form-group margin-top-30" data-ng-show="tc.topology.clientType == 1 && tc.topology.topologyType == 1">
			<div class="col-xs-12 col-md-12 col-lg-12">
				<cv-toggle class="margin-right-0" toggle-label="label.laptext" toggle-name="laptopProxyInfraEnabled" value="tc.topology.useWildcardProxy"></cv-toggle>
			</div>
		</div>

		<!--  Advanced section -->
		<div class="form-group margin-top-30 margin-left-20 margin-right-10" data-ng-show="tc.uiModel.showAdvanced">

				<div class="form-group margin-top-30" >
					<div class="col-xs-12 col-md-12 col-lg-12">
						<cv-toggle class="margin-right-0" toggle-label="label.encryptTraffic" toggle-name="encryptTraffic" value="tc.uiModel.advancedOptions.encryptTraffic"></cv-toggle>
					</div>
				</div>

				<div class="form-group" >
					<label class="col-xs-12 col-md-4 col-lg-4"  for="tunnelProtocol" ><cv:msg key="label.tunnelProtocol" bundle="network" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<select id="tunnelProtocol" name="tunnelProtocol" data-ng-options="protocol for protocol in tc.uiModel.tunnelProtocolList" data-ng-model="tc.uiModel.advancedOptions.tunnelProtocol" ng-disabled="tc.uiModel.advancedOptions.encryptTraffic"/>
					</div>
				</div>

				<div class="form-group" >
					<label class="col-xs-12 col-md-4 col-lg-4"  for="numberOfStreams" ><cv:msg key="label.numberOfStreams" bundle="network" /></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<select id="numberOfStreams" name="numberOfStreams" data-ng-options="stream for stream in tc.uiModel.numberOfStreamsList " data-ng-model="tc.uiModel.advancedOptions.numberOfStreams"/>
					</div>
				</div>

		</div>

		<!--  End of Advanced section -->
				<div class="button-container">
					<fmt:bundle basename="localization.messages">
				  		<button id="addTopologyModal_button_#0536" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="tmc.close()"><cv:msg key="Cancel" /></button>
				  		<button id="addTopologyModal_button_#2979" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save" /></button>
				  	</fmt:bundle>
				</div>

			</form>

		</div>
	</div>
</fmt:bundle>