import { acAppNetworkTopologyModule } from 'common/js/modules';
import 'modules/networkTopology/js/services/NetworkTopology.svc.js';
import 'modules/network/js/constants/nwtopology.constant.js';
import 'modules/networkTopology/js/controllers/NetworkTopology.ctrl.js';
import 'modules/settings/js/factories/cvPermissions.factory.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import { getNWTopologiesColumns } from 'modules/networkTopology/js/columns/NetworkTopologiesGrid.column.js';

class NetworkTopologyGrid {
	constructor(
		$scope,
		NetworkTopologyService,
		cvLoc,
		$modal,
		cvUtil,
		NW_TOPOLOGY_TYPE,
		$dialogs,
		cvToaster,
		$state,
		cvBreadcrumbsTabsFactory,
		NetworkTopologyFactory,
		$compile,
		cvPermissionFactory,
		ENTITY_TYPES,
		NW_CLIENT_TYPE
	) {
		this.NetworkTopologyService = NetworkTopologyService;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.NW_TOPOLOGY_TYPE = NW_TOPOLOGY_TYPE;
		this.NW_CLIENT_TYPE = NW_CLIENT_TYPE;
		this.cvToaster = cvToaster;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.NetworkTopologyFactory = NetworkTopologyFactory;
		this.cvPermissionFactory = cvPermissionFactory;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.$scope = $scope;
		this.$modal = $modal;
		this.$dialogs = $dialogs;
		this.$compile = $compile;
		this._initializeGrid();
		this._initializeBreadCrumbs();
	}

	_initializeGrid() {
		this.gridOptions = {
			gridTitle: this.cvLoc('pageHeader.nwTopologies'),
			tableName: 'networkTopologyList',
			searchable: true,
			url: this._getNWTopologies.bind(this),
			usePageToolbar: true,
			columns: this._getColumns(),
			onGridDataBound: this._onGridDataBound.bind(this),
			gridToolbarMenu: [
				{
					id: 'downloadNetworkSummary',
					label: this.cvLoc('pageHeader.downloadFWSummary'),
					onSelect: this.NetworkTopologyFactory.openFWDownloadSummaryModal
				},
				{
					id: 'addTopology',
					label: this.cvLoc('pageHeader.createTopology'),
					onSelect: this.NetworkTopologyFactory.openAddToplogyModal.bind(undefined, null)
				}
			]
		};
		this.$scope.gridOptions = this.gridOptions;
	}

	_initializeBreadCrumbs() {
		let breadCrumbs = [
			{
				title: this.cvLoc('label.nav.network'),
				link: '#nav/network'
			}
		];
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}

	_getColumns() {
		return getNWTopologiesColumns(
			{},
			{
				cvLoc: this.cvLoc,
				NW_TOPOLOGY_TYPE: this.NW_TOPOLOGY_TYPE,
				NW_CLIENT_TYPE: this.NW_CLIENT_TYPE,
				NetworkTopologyFactory: this.NetworkTopologyFactory,
				actions: this.actions
			}
		);
	}

	_onGridDataBound(dataItem, row) {
		let permittedOptions = dataItem.permittedOptions;
		let entityId = dataItem.permittedOptions.entityId;
		this.$scope[`permittedOptions${entityId}`] = permittedOptions;
		let actionTemplate = `<cv-permitted-actions cv-permitted-options="permittedOptions${entityId}"></cv-permitted-actions>`;
		row.find('.k-grid-topologyname').click(() => {
			this.NetworkTopologyFactory.openAddToplogyModal(dataItem);
		});
		row.find('.permittedActions').html(this.$compile(actionTemplate)(this.$scope));
	}

	_computePermittedActions(entity) {
		var arrayOfActionsToOverride = [
			{
				DELETE: {
					// delete: show when the entity is deconfigured
					show: true,
					onClick: this.NetworkTopologyFactory.deleteTopology.bind(undefined, entity.topologyEntity.topologyId)
				}
			}
		];

		let serverSpecificPermittedActions = [
			{
				PUSH_CONFIGURATION: {
					show: true,
					onClick: this.NetworkTopologyFactory.pushFWTopology.bind(
						undefined,
						entity.topologyEntity.topologyId,
						entity.topologyEntity.topologyName
					)
				}
			}
		];
		let serversPermittedList = [];
		serversPermittedList = this.cvPermissionFactory
			.updateAndGetCommonActionsList(arrayOfActionsToOverride, false, this.cvPermissionFactory.commonPermittedList)
			.concat(
				this.cvPermissionFactory.updateAndGetCommonActionsList(
					serverSpecificPermittedActions,
					false,
					this.NetworkTopologyFactory.topologySpecificActionitems
				)
			);
		return serversPermittedList;
	}

	_getNWTopologies(options) {
		let self = this;
		this.NetworkTopologyService.getNWTopologies()
			.success(function(data) {
				if (data !== undefined && data.firewallTopologies !== undefined) {
					data.firewallTopologies.forEach(entity => {
						entity.clientType = self.NetworkTopologyFactory.getClientType(entity);
						entity.permittedOptions = {
							entityType: self.ENTITY_TYPES.FW_TOPOLOGY_ENTITY,
							entity: angular.copy(entity),
							entityId: entity.topologyEntity.topologyId,
							entityName: entity.topologyEntity.topologyName,
							appendToBody: true,
							permittedActionList: self._computePermittedActions(entity)
						};
					});
					options.success(data.firewallTopologies);
				} else {
					options.success([]);
				}
			})
			.error(function(e) {
				options.success(null);
				self.cvToaster.showErrorMessage({
					message: e,
					ttl: '5000'
				});
			});
	}
}

NetworkTopologyGrid.$inject = [
	'$scope',
	'NetworkTopologyService',
	'cvLoc',
	'$uibModal',
	'cvUtil',
	'NW_TOPOLOGY_TYPE',
	'$dialogs',
	'cvToaster',
	'$state',
	'cvBreadcrumbsTabsFactory',
	'NetworkTopologyFactory',
	'$compile',
	'cvPermissionFactory',
	'ENTITY_TYPES',
	'NW_CLIENT_TYPE'
];

acAppNetworkTopologyModule.controller('NetworkTopologyGridController', NetworkTopologyGrid);

export default acAppNetworkTopologyModule;
