<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.network"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.network">
	<div class="setup-title">
		<h1>
			<fmt:message key="pageHeader.editRotation" />
		</h1>
	</div>
	<div class="setup-content schedule" data-ng-controller="certificateRotationController">
		<p class="{{configureRotationMsg.type}} serverMessage">{{configureRotationMsg.message}}</p>
		<form name="configureCertificateRotationForm" novalidate
			data-cv-submit="configureCertificateRotation()" autocomplete="off">
			<div class="modal-wrapper">
				<div class="modal-row">
					<label for="clientRotation" class="label"><span><fmt:message key="label.clientRotation" /></span></label>
					<div class="inline-wrapper">
					<input type="number" name="clientRotation" id="clientRotation" data-ng-model="model.clientRotation" min="1" required />
						<label for="clientRotationMonths" class="inline-label schedule-repeat-label"><fmt:message key="label.months"/></label>
					</div>
				</div>
				<div class="modal-row">
					<label for="caRotation" class="label"> <span><fmt:message key="label.CARotation" /></span></label>
					<div class="inline-wrapper">
					<input type="number" name="caRotation" id="caRotation" data-ng-model="model.caRotation" min="1" required />
						<label for="caRotationYears" class="inline-label schedule-repeat-label"><fmt:message key="label.years"/></label>
					</div>
				</div>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="certificateRotation_button_#9422" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" 
						data-ng-click="dismissModal()">
						<fmt:message key="Cancel" />
					</button>
					<button id="certificateRotation_button_#2492" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<fmt:message key="Save" />
					</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>