<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<nav class="nav side-nav navigation" cv-state-active>
    <div class="loading-nav" data-ng-class="{hidden:(noItemsFound? true : routes.length>0)}"><cv:msg key="Loading" bundle="messages"/></div>

    <form data-ng-show="dashboardEditMode === false" class="side-nav-search padding-15 padding-left-10 padding-right-10 position-relative">
        <input
            type="search"
            id="nav-search-field"
            class="form-control"
            placeholder='<cv:msg key="label.filterNavigation" bundle="navJs" />'
            title='<cv:msg key="label.filterNavigation" bundle="navJs" />'
            data-ng-model="navSearch"
            data-ng-change="searchRoutes(navSearch)"
            autocomplete="off"
        />
        <span data-ng-show="navSearch && navSearch !== ''" data-ng-click="clearFilter(currentNavState);" class="k-icon k-i-close side-nav-search-close" title='<cv:msg key="label.filterClear" bundle="navJs" />'></span>
    </form>

    <div id="side-nav-wrapper" class="position-relative" data-ng-class="{hidden:!routes.length}">
        <ul data-ng-init="validateRoute(routes)">
            <li data-ng-repeat="route in routes track by route.id" data-ng-click="openNav(route.cvClass)" class="{{route.cvClass}}" data-menu-name="{{route.state}}" >
                <a data-ng-if="route.children === undefined && route.url && route.state !== 'dashboard'"
                    target="_self"
                    ui_sref="{{route.state}}"
                    data-ng-cloak
                    title="{{route.cvTitle}}"
                    class="side-nav-item"
                    id="navigationItem_{{route.state}}"
                    data-ng-class="{'active-link':route.isActive}">
                    <span data-ng-bind-html="route.svg" class="side-nav-menu-icon"></span>
                    <span class="side-nav-menu-name" data-html data-ng-bind="route.cvTitle"></span>
                </a>
                <a data-ng-if="route.children === undefined && route.state === 'dashboard'"
                    data-dashboard-link
                    target="_self"
                    data-ng-cloak title="{{route.cvTitle}}"
                    id="navigationItem_{{route.state}}"
                    class="side-nav-item"
                    data-ng-class="{'active-link':route.isActive}">
                    <span data-ng-bind-html="route.svg" class="side-nav-menu-icon"></span>
                    <span class="side-nav-menu-name" data-ng-bind="route.cvTitle"></span>
                </a>
                <div data-ng-if="route.children && route.children.length && route.hasChildrenToShow && route.showRootNodeAsAccordian">
                    <a target="_self"
                        data-ng-cloak
                        title="{{route.cvTitle}}"
                        data-ng-click="toggleChildren(route)"
                        class="side-nav-item"
                        id="navigationItem_{{route.state}}"
                        data-ng-class="{'active-link':route.isActive}" >
                        <span data-ng-bind-html="route.svg" class="side-nav-menu-icon"></span>
                        <span class="side-nav-menu-name" data-ng-bind="route.cvTitle"></span>
                    </a>
                    <div uib-collapse="!route.isOpen">
                        <ul class="side-nav-sub-menu" data-nav-name="{{route.cvTitle}}" data-ng-init="validateChildren(route.children)">
                            <li data-menu-sub-name="{{child.children && child.children.length === 1 ? child.children[0].state: child.state}}"
                            data-ng-repeat="(i,child) in route.children track by child.id" class="{{child.cvClass}}">
                            <div data-ng-if="!child.isTabParent && ((child.hasMoreThanOneChild || (child.children && child.children.length > 1)) && child.hasChildrenToShow) && child.requireCollapsableChildren || (child.isApp)" data-ng-click="child.isApp && !child.loadedChildrenFirstTime ? child.onClick() : ''">
                                    <a data-ng-click="child.isOpen = !(child.isOpen || false)"
                                        class="side-nav-item"
                                        id="navigationItem_{{child.state}}"
                                        data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}">
                                        <span class="k-icon k-i-arrow-chevron-right side-nav-menu-icon side-nav-accordion" data-ng-class="{opened: child.isOpen}"></span>
                                        <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                    </a>
                                    <div uib-collapse="!child.isOpen">
                                        <ul class="side-nav-sub-menu" data-ng-init="validateChildren(child.children)">
                                            <li data-ng-repeat="subChild in child.children track by $index" data-menu-sub-name="{{subChild.state}}" data-ng-if="!subChild.isTabParent || (subChild.isTabParent && subChild.hasChildrenToShow)">
                                                <a data-ng-if="!subChild.isPage && !subChild.isTabParent"
                                                    ui-state="subChild.state"
                                                    target="_self"
                                                    title="{{subChild.cvTitle}}"
                                                    id="navigationItem_{{subChild.state}}"
                                                    class="side-nav-item"
                                                    data-ng-class="{'active-link':subChild.isActive}">
                                                    <span class="side-nav-menu-name no-padding" data-ng-bind="subChild.cvTitle"></span>
                                                </a>
                                                <!-- For tab third level children for eg: SQL Server and DB Instances-->
                                                <a data-ng-if="!subChild.isPage && subChild.isTabParent"
                                                    ui-state="subChild.children[0].state"
                                                    target="_self"
                                                    title="{{subChild.cvTitle}}"
                                                    id="navigationItem_{{subChild.state}}"
                                                    class="side-nav-item"
                                                    data-ng-class="{'active-link':subChild.isActive}">
                                                    <span class="side-nav-menu-name no-padding" data-ng-bind="subChild.cvTitle"></span>
                                                </a>
                                                <a data-ng-if="subChild.isPage && !subChild.isTabParent"
                                                    data-ng-href="{{subChild.url}}"
                                                    title="{{subChild.cvTitle}}"
                                                    id="navigationItem_{{subChild.state}}"
                                                    class="side-nav-item"
                                                    data-ng-class="{'active-link':subChild.isActive}">
                                                    <span class="side-nav-menu-name no-padding" data-ng-bind="subChild.cvTitle"></span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- For Tabed states-->
                                <a data-ng-if="!child.dontShowOnLeftPanel && ((child.hasMoreThanOneChild || (child.children && child.children.length >= 1 )) && child.hasChildrenToShow) && !route.requireCollapsableChildren && child.requireCollapsableChildren && child.isTabParent"
                                    target="_self" title="{{child.cvTitle}}"
                                    ui-sref="{{child.children[0].state}}"
                                    class="side-nav-item"
                                    id="navigationItem_{{child.state}}"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}" >
                                    <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                </a>
                                 <!-- Parent Landing page-->
                                <a data-ng-if="!child.isTabParent && ((child.hasMoreThanOneChild || (child.children && child.children.length > 1)) && child.hasChildrenToShow) && !route.requireCollapsableChildren && !child.requireCollapsableChildren"
                                    ui-sref="parentLanding({nav : child.state})"
                                    target="_self"
                                    title="{{child.cvTitle}}"
                                    id="navigationItem_{{child.state}}"
                                    class="side-nav-item"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}">
                                    <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                </a>
                                <!--Parent which has exactly one child-->
                                <a data-ng-if="!child.isTabParent && child.children && !child.hasMoreThanOneChild && child.children.length === 1 && !child.isApp"
                                    ui-sref="{{child.children[0].state}}"
                                    target="_self"
                                    id="navigationItem_{{child.children[0].state}}"
                                    title="{{child.children[0].cvTitle}}"
                                    class="side-nav-item"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}">
                                    <span class="side-nav-menu-name" data-ng-bind="child.children[0].cvTitle"></span>
                                </a>
                                <!-- Lowest level child Non-My-App-->
                                <a data-ng-if="!child.children && child.url && !child.isApp && !child.isWebConsoleLink && !child.isPage"
                                    ui-sref="{{child.state}}"
                                    target="_self"
                                    title="{{child.cvTitle}}"
                                    id="navigationItem_{{child.state}}"
                                    class="side-nav-item"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}">
                                    <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                </a>
                                <!-- Lowest level child My-App-->
                                <a data-ng-if="!child.children && child.url && !child.isApp && !child.isWebConsoleLink && child.isPage"
                                    href="{{child.url}}"
                                    target="_self"
                                    title="{{child.cvTitle}}"
                                    id="navigationItem_{{child.state}}"
                                    class="side-nav-item"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}">
                                    <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                </a>
                                <!--Lowest Level child webConsole link-->
                                <a data-ng-if="!child.children && child.url && !child.isApp && child.isWebConsoleLink"
                                    href="{{child.url}}"
                                    target="_blank"
                                    title="{{child.cvTitle}}"
                                    id="navigationItem_{{child.state}}"
                                    class="side-nav-item"
                                    data-ng-class="{'active-link' : child.isActive || (child.children && child.children.length === 1 && child.children[0].isActive)}" >
                                    <span class="side-nav-menu-name" data-ng-bind="child.cvTitle"></span>
                                    <span class="child side-nav-menu-icon side-nav-icon-right"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M19 19H5V5h7V3H5a2 2 0 0 0-2 2v14c0 1.1.9 2 2 2h14a2 2 0 0 0 2-2v-7h-2v7zM14 3v2h3.6l-9.8 9.8 1.4 1.4L19 6.4V10h2V3h-7z"/></svg></span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div></div>
            </li>
        </ul>
    </div>
    <div class="no-search-item side-nav-item" data-ng-if="noItemsFound">
        <span class="side-nav-menu-name" data-ng-bind="noItemsLabel"></span>
    </div>
</nav>