(function() {
	'use strict';
	var navigationMod = angular.module('cvModule.navigation');
	navigationMod.directive('cvLeftNav', [
		'cvNavigationFactory',
		function(cvNavigationFactory) {
			return {
				restrict: 'AE',
				templateUrl: appUtil.appRoot + 'modules/navigation/partials/cvLeftNav.jsp',
				scope: {
					routes: '=',
					selectednavigationview: '='
				},
				controller: [
					'$scope',
					'$rootScope',
					'$dialogs',
					'$attrs',
					'$state',
					'$timeout',
					'cvLoc',
					'$compile',
					'$log',
					'setupFactory',
					'$sce',
					'$stateParams',
					'$transitions',
					function(
						$scope,
						$rootScope,
						$dialogs,
						$attrs,
						$state,
						$timeout,
						cvLoc,
						$compile,
						$log,
						setupFactory,
						$sce,
						$stateParams,
						$transitions
					) {
						var id = 1;
						$scope.dashboardEditMode = false;

						$scope.filterIcon =
							'<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><path d="M30.5,0h-29c-1.3,0-2,1.6-1.1,2.6L12,14.1V27c0,0.5,0.2,0.9,0.6,1.2l5,3.5c1,0.7,2.4,0,2.4-1.2V14.1L31.6,2.6C32.5,1.6,31.8,0,30.5,0z"/></svg>';

						$scope.$on('editDashboard', function(evt, editData) {
							$scope.dashboardEditMode = editData.isEdit;
						});

						$scope.loopThroughRoutes = function(routes) {
							routes.forEach(function(route) {
								if (angular.isObject(route) && angular.isDefined(route)) {
									if (angular.isDefined(route.cvTitle)) {
										if (route.cvTitle.includes('label')) {
											route.cvTitle = route.titleLocalized ? route.cvTitle : cvLoc(route.cvTitle);
										}
									}
									if (angular.isDefined(route.svg) && !angular.isString(route.svg)) {
										route.svg = $sce.trustAsHtml(route.svg);
									}

									// if route contains keywords for filtering, localize them
									if (route.keywords !== undefined && angular.isArray(route.keywords)) {
										route.keywords = route.keywords.map(function(keyword) {
											return cvLoc(keyword);
										});
										// join into a single string, do this once rather than every search
										route._keywords = route.keywords.join(' ');
									}

									route.id = id;
									id++;
									if (angular.isArray(route.children)) {
										$scope.loopThroughRoutes(route.children);
									}
								}
							});
						};

						$scope.enableModern = $scope.selectednavigationview.type === 'modern';

						if (angular.isDefined($scope.routes) && angular.isArray($scope.routes) && $scope.routes.length > 0) {
							$scope.loopThroughRoutes($scope.routes);
						}

						$scope.showAppStudio =
							cv.additionalSettings &&
							cv.additionalSettings.AdminConsole &&
							cv.additionalSettings.AdminConsole.showAppStudio
								? cv.additionalSettings.AdminConsole.showAppStudio
								: false;

						$scope.viewSelected = function(viewType) {
							$scope.selectednavigationview.type = viewType;
						};

						/**
						 * This function checks for substates of any children and also ensures the parentLanding state
						 * is highlighted when any substates are visited.
						 *
						 * @param {array}
						 *            aCvSubStates
						 * @param {string}
						 *            sStateName
						 */

						var checkIfRouteSubStatesHasState = function(aCvSubStates, sStateName) {
							if (
								angular.isArray(aCvSubStates) &&
								sStateName &&
								angular.isDefined(sStateName) &&
								aCvSubStates.indexOf(sStateName) >= 0
							) {
								return true;
							}
							return false;
						};

						/**
						 * This function iterates over the children and returns true if child's stateName is equal to
						 * stateName passed. Function to be removed post => are supported on files which are loaded on
						 * appLoad
						 *
						 * @param {array}
						 *            aChildren
						 * @param {string}
						 *            sStateName
						 */

						var fChildrenContainsState = function(aChildren, sStateName) {
							if (angular.isArray(aChildren) && aChildren.length > 0 && sStateName && angular.isDefined(sStateName)) {
								for (var index = 0; index < aChildren.length; index++) {
									if (
										(angular.isDefined(aChildren[index].state) && aChildren[index].state === sStateName) ||
										checkIfRouteSubStatesHasState(aChildren[index].cvSubStates, sStateName)
									) {
										return true;
									}
								}
							}

							return false;
						};

						/**
						 * Recursively iterates through each route currently being displayed to determine whether or
						 * not the route needs to be opened or closed based on whether or not it has children, or if
						 * it has to be active based on the route the user is going to.
						 *
						 * @param {Object[]}
						 *            routes - An array of route objects to loop through.
						 * @param {string}
						 *            state - The current state the user will be going to.
						 * @param {boolean}
						 *            foundRoute - Whether or not we found a route to make active.
						 * @return Object The route that was found to make active if it has no children, or open if it
						 *         is a collapsible route. Returns NULL if no route was found.
						 */
						function handleRouteChange(routes, state, foundRoute) {
							var returnRoute = null;
							var isParentLandingRoute = false;
							if (
								state === 'parentLanding' &&
								$stateParams.nav &&
								angular.isDefined($stateParams.nav) &&
								$stateParams.nav !== ''
							) {
								isParentLandingRoute = true;
								state = $stateParams.nav;
							}
							if (state === 'appPageViewer' && angular.isDefined($stateParams.page) && $stateParams.page !== '') {
								state = 'pageViewer' + $stateParams.page;
							}
							angular.forEach(routes, function(route) {
								var found = false;

								/*
								 * For each route, we want to start by closing the collapsible
								 * ones and making all of the links not active.
								 */
								route.isOpen = false; //-- We decided not to close the collapsible ones when switching to a new link
								route.isActive = false;

								/*
								 * If we didn't find a route yet, then we will check the current
								 * route's name, and compare it with the one we're going to. If
								 * it's a match, or if the route has a sub-state equal to the
								 * state the user is going to, we specify that we found the right
								 * route we're looking to drill into.
								 */
								if (!foundRoute) {
									if (
										route.state === state ||
										(angular.isArray(route.cvSubStates) && route.cvSubStates.indexOf(state) >= 0)
									) {
										found = true;
										route.isOpen = true;
										//This condition is for highlighing second level parents when third level children are clicked. Eg: Customization should be highlighted when one visits theme
										if (!isParentLandingRoute && !route.isRootNode && fChildrenContainsState(route.children, state)) {
											route.isActive = true;
										}
									}
								}

								if (angular.isArray(route.children) && route.children.length > 0 && !isParentLandingRoute) {
									/*
									 * If the current route has children, we recursively call the
									 * method to loop over them. We do this for every route
									 * because we want to make sure we close all routes and make
									 * them not active when the user goes to another state.
									 */
									var activeRoute = handleRouteChange(route.children, state, returnRoute !== null);

									/*
									 * If we're still looking for the route to make active, and if
									 * the recursive call returned a route, that means we found
									 * the next route that contains the state the user is going
									 * to. Therefore, we make sure it can be shown to the user,
									 * and if so, we specify to return the current route once the
									 * iteration is over.
									 */
									if (!foundRoute && found && activeRoute !== null) {
										route.isOpen = true;
										returnRoute = route;
									}
								} else if (!foundRoute && found && !isParentLandingRoute) {
									/*
									 * If we made it here, then we found the route we're looking
									 * for, and it has no children. Therefore, we specify to
									 * return the current route once the iteration is over.
									 */
									route.isActive = true;
									returnRoute = route;
								} else if (!foundRoute && found && isParentLandingRoute) {
									/*
									 * If we are here, we know that we have reached one of the
									 * parent which holds the subStates or we have reached the
									 * parentLanding state for corresponding nav.
									 */

									if (route.state && angular.isDefined(route.state) && route.state !== '' && route.state === state) {
										route.isActive = true;
										returnRoute = route;
									} else {
										if (route.children && angular.isArray(route.children)) {
											route.children.forEach(function(ch) {
												ch.isActive = false;
												if (ch.state && angular.isDefined(ch.state) && ch.state !== '' && ch.state === state) {
													ch.isActive = true;
													route.isOpen = true;
													ch.isOpen = true;
													returnRoute = ch;
												}
											});
										}
									}
								}
							});
							return returnRoute;
						}

						/**
						 * To aovoid wath by adding function to ng-if, add ng-init to parent node
						 *
						 */
						// $scope.initRoutewithChildren =
						$scope.validateRoute = function(routes) {
							if ($scope.searchedFirstTime) return;
							routes.forEach(function(route) {
								if (route.children && route.children.length) {
									route.hasChildrenToShow = $scope.hasChildrenToShow(route);
									route.showRootNodeAsAccordian = $scope.showRootNodeAsAccordian(route);
								}
							});
						};

						$scope.validateChildren = function(children) {
							if ($scope.searchedFirstTime) return;
							children.forEach(function(child) {
								child.hasChildrenToShow = $scope.hasChildrenToShow(child);
							});
						};

						/**
						 * Check and see if the given setup is complete.
						 *
						 * The setup name can also be passed as a comma delimited string containing multiple setups
						 * names. In this case, if one of the setups is complete, the method will return true.
						 *
						 * @return boolean True if the given setup is complete; False otherwise.
						 */
						$scope.isSetupCompletedForRoute = function(setup) {
							//This is added for legacy suppowhatrt whene there was no key called skipInitialSetup
							if (
								angular.isUndefined(cvApp.globalParams.skipInitialSetup) ||
								cvApp.globalParams.skipInitialSetup === 'true' ||
								cvConfig.skipCoreSetup
							) {
								return true;
							}

							return setupFactory.isAtLeastOneSetupComplete(setup.split(','));
						};

						$transitions.onSuccess({}, function(transition) {
							var toState = transition.to();
							// Keep track of the current state for later use when clearing the search field
							$scope.currentNavState = toState.name;
							handleRouteChange($scope.routes, toState.name);
						});

						$scope.isSubnavVisible = false;

						$scope.toggleChildren = function(route) {
							if ($scope.dashboardEditMode) {
								$dialogs.confirm(cvLoc('label.confirmNavigationTitle'), cvLoc('label.confirmDashboardNavDetails'), {
									yesFunction: function() {
										self.dashboardEditMode = false;
										$rootScope.$broadcast('cancelEditDashboard');
										route.isOpen = !(route.isOpen || false);
									},
									noFunction: function() {}
								});
							} else {
								route.isOpen = !(route.isOpen || false);
							}
						};

						$scope.openNav = function(className) {
							$('.nav__list ul').removeClass('is-subnav-visible');
							$('.' + className + ' ul').addClass('is-subnav-visible');
							if ($('#wrapper').hasClass('pinned') && $('.pinned-sub-nav-link').length > 0) {
								var nav = $('.' + className + ' ul').attr('data-nav-name');
								if (nav) {
									$('.nav-subnav').css('display', 'none');
									$('.pinned-sub-nav-link').removeClass('pinned-sub-nav-link');
									$('ul[data-nav-name=' + nav + ' ]')
										.addClass('pinned-sub-nav-link')
										.css('display', '')
										.css('z-index', '999');
								}
							}
							Ps.update(document.getElementById('side-nav-wrapper'));
						};

						$scope.closeNav = function(e) {
							if (e == undefined || e.type == 'click') {
								setTimeout(function() {
									$('.nav__list ul').removeClass('is-subnav-visible');
								}, 10);
								return;
							}

							if (
								e.type == 'mouseleave' &&
								e.fromElement &&
								typeof e.fromElement.className == 'string' &&
								e.fromElement.className.indexOf('nav-subnav') == -1
							) {
								return;
							} else {
								setTimeout(function() {
									$('.nav__list ul').removeClass('is-subnav-visible');
								}, 10);
							}
						};

						$scope.navOpenClose = function() {
							if ($('.nav-trigger').is(':checked') === true) {
								$("label[for='nav-trigger']").css('transform', 'rotate(180deg)');
								$('.navigation').addClass('pinned');
							} else {
								$('.navigation').removeClass('pinned');
								$("label[for='nav-trigger']").css('transform', '');
							}

							//	                                        		if ($('#wrapper').hasClass('pinned')) {
							//	                                        		$('.nav-trigger:checked + .side-nav').css('overflow', 'visible');
							//	                                        		} else {
							//	                                        		$('.nav-trigger:checked + .side-nav').css('overflow', '');
							//	                                        		}

							$scope.resizeWindow();
						};

						$scope.resizeWindow = function(nav) {
							$(window).trigger('resize');
						};

						$scope.noItemsFound = false;
						$scope.noItemsLabel = cvLoc('label.noItemsFound');

						function filterRoutes(routes, search) {
							return cvNavigationFactory.filterRoutes(routes, search);
						}

						$scope.hasChildrenToShow = function(route) {
							return cvNavigationFactory.hasChildrenToShow(route);
						};

						$scope.showRootNodeAsAccordian = function(route) {
							if (route.isRootNode === true) {
								return true;
							} else if (!route.isRootNode && route.requireCollapsableChildren === true) {
								return true;
							} else {
								return false;
							}
						};

						/**
						 * Filters that routes shown based on a given search term. If the given search term is blank,
						 * it is assumed that the user cleared the search, and want's to see everything again.
						 *
						 * @param {string}
						 *            search - The search term to filter the routes by.
						 */
						$scope.searchedFirstTime = false;

						$scope.searchRoutes = function(search) {
							//Creating allRoutes only when filtering is done
							if (!$scope.searchedFirstTime) {
								$scope.allRoutes = angular.copy($scope.routes);
								$scope.searchedFirstTime = true;
							}

							if (angular.isString(search) && search.length > 0) {
								$scope.noItemsFound = false;
								$scope.routes = filterRoutes(angular.copy($scope.allRoutes), search);
								if ($scope.routes.length <= 0) {
									$scope.noItemsFound = true;
								}
							} else {
								$scope.routes = angular.copy($scope.allRoutes);
								$scope.noItemsFound = false;
								handleRouteChange($scope.routes, $scope.currentNavState);
							}
						};
						$scope.$on('stateIsAppPage', function(e) {
							handleRouteChange($scope.routes, 'appPageViewer');
						});

						// Clear Search Field and maintain the current Navigational Hierachy for the side nav
						$scope.clearFilter = function(activeState) {
							if ($scope.navSearch && angular.isDefined($scope.navSearch) && $scope.navSearch !== '') {
								$scope.navSearch = '';
								$scope.routes = angular.copy($scope.allRoutes);
								$scope.noItemsFound = false;
								handleRouteChange($scope.routes, activeState);
							}
						};
					}
				],
				link: function(scope, element, attrs) {
					requestAnimationFrame(function() {
						// $('#perfect-scrollbar').css('height', ($(window).height() - 105));
						Ps.initialize(document.getElementById('side-nav-wrapper'), {
							handlers: ['drag-scrollbar', 'wheel', 'touch']
						}),
							50;
					});

					// $(window).resize(function() {
					// 	// $('#perfect-scrollbar').css('height', ($(window).height() - 105));
					// 	Ps.update(document.getElementById('perfect-scrollbar'))
					// });
				}
			};
		}
	]);
})();
