import { cvModuleNavigationModule } from 'common/js/modules';

var mod = cvModuleNavigationModule;

mod.controller('parentLandingController', [
	'$scope',
	'cvNavigationFactory',
	'$stateParams',
	'$state',
	'cvToaster',
	'cvLoc',
	'cvUtil',
	'$location',
	'$window',
	'DASHBOARD_LINKS',
	function(
		$scope,
		cvNavigationFactory,
		$stateParams,
		$state,
		cvToaster,
		cvLoc,
		cvUtil,
		$location,
		$window,
		DASHBOARD_LINKS
	) {
		$scope.redirectToDefaultPage = function() {
			var defaultPath = cv.nav.defaultPath;

			if (defaultPath && angular.isDefined(defaultPath) && defaultPath !== '') {
				defaultPath = cvUtil.removeParamsFromURLString('_cid', defaultPath);
				defaultPath = cvUtil.removeParamsFromURLString('_cn', defaultPath);
			}

			if (!defaultPath.includes('subscriptions') && !defaultPath.includes('/reportDetails')) {
				defaultPath = cvUtil.removeRequiredAndOptionalParamsFromURLString(defaultPath);
			}

			if (angular.isUndefined(defaultPath) || defaultPath === '') {
				if (!cv.isAdmin && !cv.isMspUser) {
					defaultPath = '/uservms';
				} else {
					defaultPath = DASHBOARD_LINKS.OVERVIEW;
				}
			}
			$location.url(defaultPath);
		};
		$scope.stateRoute = cvNavigationFactory.getRouteForState($stateParams.nav);

		//This code is used to update the title on the tab
		var title;
		if (!$scope.stateRoute.pageTitle && !$scope.stateRoute.cvTitle) {
			title = cvLoc('label.adminConsole');
		}
		var pageTitle = $scope.stateRoute.cvTitle || $scope.stateRoute.pageTitle || title;
		$window.document.title = pageTitle;

		if ($scope.stateRoute === null || angular.isUndefined($scope.stateRoute)) {
			cvToaster.showErrorMessage({
				message: cvLoc('warn.accessDeniedToPage')
			});
			$scope.redirectToDefaultPage();
			return;
		}
		if (
			$scope.stateRoute.children === null ||
			!angular.isArray($scope.stateRoute.children) ||
			$scope.stateRoute.children.length <= 0
		) {
			cvToaster.showErrorMessage({
				message: cvLoc('warn.noAppsToShow')
			});
			$scope.redirectToDefaultPage();
			return;
		}
		$scope.arrayOfSubChildren = angular.isArray($scope.stateRoute.children) ? $scope.stateRoute.children : [];
	}
]);

export default mod;
