(function() {
	'use strict';

	var navigationMod = angular.module('cvModule.navigation', []);

	var controllers = {};

	/**
	 * The wrapper controller is for the wrapper element around the entire application, which means it will
	 * remain static throughout the life cycle of the app.
	 */
	controllers.wrapperController = [
		'$scope',
		'$rootScope',
		'cvMultiCommcell',
		'cvUtil',
		'$transitions',
		'cvNavigationFactory',
		'multiCommcellFactory',
		function($scope, $rootScope, cvMultiCommcell, cvUtil, $transitions, cvNavigationFactory, multiCommcellFactory) {
			/*
			 * This use case is for when a tenant admin logs in to change his/her password, he/she doesn't
			 * need the side nav.
			 *
			 *
			 */

			$scope.isMultiCC = cvMultiCommcell.getmultiselection();

			$scope.showDefaultCompanySelection = cv.sessionContext.showDefaultCompanySelection;
			var isForcePasswordSet = cv.nav.routes.length === 1 && cv.nav.routes[0].state === 'changePassword';

			if (isForcePasswordSet) {
				$scope.settingsPage = $scope.doesntNeedNav = true;
			}

			if (cv.isOnCommcellLevel || cv.isTenantAdmin || cv.isTenantOperator) {
				/*
				 * Check for users on the CommCell level to see if we have to account for showing setup
				 * screens. Since the controller will remain static throughout the life cycle of the app,
				 * we need to perform the following checks on every state change.
				 */
				$transitions.onStart({}, function(transition) {
					var toState = transition.to();
					/*
					 * We first check if the user is on a setup screen. A setup screen REQUIRES us to
					 * remove the side nav in order to properly show the page. If the user is not on a
					 * setup screen, then we check if user is on a page that doesn't need a nav ONLY when
					 * the core setup is not completed.
					 */

					$scope.statesWhichDoNotNeedLeftNav = [
						'coreSetup',
						'coreSetupTenantOS',
						'acSetup',
						'dloSetup',
						'vsaSetup',
						'dbsSetup',
						'ebsSetup',
						'cappsSetup',
						'cappsGDriveSetup',
						'cappsGMailSetup',
						'cappsOneDriveSetup',
						'cappsSalesforceSetup',
						'cappsAmazonSQLSetup',
						'cappsAzureSQLSetup',
						'exchangeSetup',
						'exchangeMailboxSetup',
						'complianceSetup',
						'cassandraSetup',
						'hadoopSetup',
						'exchangeDagSetup',
						'configureAzureApp',
						'OneDriveForBusinessSetup',
						'sharepointOnlineSetup',
						'exchangeOnlineSetup',
						'activateSetup',
						'activeDirectorySetup',
						'bigDataAppsSetup',
						'kubernetesSetup',
						'workflowEditor',
						'oauthCallback',
						'epicSetup'
					];

					if (
						!cvUtil.objectContainsNestedProperty('cv.sessionContext.completedSetups.CORE_SETUP', cv) ||
						(cvUtil.objectContainsNestedProperty('cv.sessionContext.completedSetups.CORE_SETUP', cv) &&
							cv.sessionContext.completedSetups.CORE_SETUP === false)
					) {
						$scope.statesWhichDoNotNeedLeftNav.push('feedback');
					}

					//if core setup steps are not all completed, don't show navigation menu
					if (
						!cvUtil.objectContainsNestedProperty('cv.sessionContext.setupStepsMap.CORE_SETUP', cv) ||
						(cvUtil.objectContainsNestedProperty('cv.sessionContext.setupStepsMap.CORE_SETUP', cv) &&
							!cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(step) {
								return step;
							}))
					) {
						$scope.statesWhichDoNotNeedLeftNav.push('gettingStarted');
					}

					if (cvConfig.isSaaSSubscriptionsEnabled && !cv.isMspAdmin) {
						//hide left nav on SaaS commcells
						$scope.statesWhichDoNotNeedLeftNav.push('managesubscriptions');
					}

					$scope.setupScreen = $scope.statesWhichDoNotNeedLeftNav.indexOf(toState.name) > -1;
					$scope.settingsPage = ['license', 'changePassword'].indexOf(toState.name) > -1;
					/**
					 * We need to compute only if it is not a setup screen and has more then
					 * changePassword state
					 */
					if (!$scope.setupScreen && !isForcePasswordSet) {
						$scope.doesntNeedNav =
							!cv.sessionContext.setupStepsMap.CORE_SETUP.every(function(finished) {
								return finished;
							}) && $scope.settingsPage;
					}

					// On adminconsole, if it is opened as an iframe content view to show details page from global view, hide left nav and header
					$scope.doesntNeedNav = $scope.doesntNeedNav || multiCommcellFactory.hideLeftNav();
					$scope.hideHeader = multiCommcellFactory.hideHeader();
				});

				$scope.clickWrapper = function() {
					$rootScope.$broadcast('QUICKVIEW_CLOSED', true);
				};
			}

			$scope.isNavHidden = function() {
				return cvNavigationFactory.isNavHidden();
			};

			$scope.isFullScreen = function() {
				return cvNavigationFactory.isFullScreen();
			};
		}
	];

	controllers.navigationListController = [
		'$scope',
		'$http',
		'cvLoc',
		'cvToaster',
		'$log',
		'cvNavigationFactory',
		'$stateParams',
		'$location',
		function($scope, $http, cvLoc, cvToaster, $log, cvNavigationFactory, $stateParams) {
			$scope.routes = [];

			var loopThroughRoutes = function(routes) {
				routes.forEach(function(route) {
					if (angular.isArray(route.children)) {
						loopThroughRoutes(route.children);
					}
					//This my-apps are apps designed from App Designer
					if (route.state === 'my-apps') {
						$scope.loadAppsInNav(route);
					}
				});
			};
			$scope.postProcessNavs = function() {
				loopThroughRoutes(cv.nav.routes);
				cv.nav.routes.forEach(function(route) {
					if (route.showNavItem) {
						$scope.routes.push(route);
					}
				});
			};

			var _computeAppChildrenAndSubState = function(app, localId) {
				var childrenAndSubStatesObjectToReturn = {
					children: [],
					cvSubStates: []
				};
				if (app.sys_id && angular.isDefined(app.sys_id)) {
					childrenAndSubStatesObjectToReturn.cvSubStates.push('appViewer' + app.sys_id);
				}
				if (app && app.menu && angular.isArray(app.menu) && app.menu.length > 0) {
					var pageId = localId * 10;
					app.menu.forEach(function(page) {
						pageId += 1;
						var indiVidualPageInApp = {
							state: 'pageViewer' + page.itemId,
							cvTitle: page.name,
							cvSubStates: ['pageViewer' + page.sys_id],
							templateUrl: 'appDesigner/partials/appPageViewer.jsp',
							url: cv.contextPath + '/#/my-app/' + app.sys_rowId + '?page=' + page.itemId,
							controller: 'AppPageViewerCtrl as vm',
							id: pageId,
							routeStart: 'appDesigner/js/controllers/appPageViewer.ctrl.js',
							showNavItem: true,
							titleLocalized: true,
							isPage: true,
							isMultiCommCellAware: false
						};
						childrenAndSubStatesObjectToReturn.children.push(indiVidualPageInApp);
						childrenAndSubStatesObjectToReturn.cvSubStates.push(indiVidualPageInApp.state);
						cvNavigationFactory.putItemInRouteStateToNavItemMap(indiVidualPageInApp.state, indiVidualPageInApp);
					});
				}

				return childrenAndSubStatesObjectToReturn;
			};

			$scope.loadAppsInNav = function(route) {
				var url = cv.contextPath + '/proxy/cr/viewer/apps';
				var headers = {
					'Content-Type': 'text/plain',
					Accept: 'text/plain'
				};
				$http
					.get(url, {
						headers: headers
					})
					.then(
						function(resp) {
							$scope.appsList = angular.copy(resp.data);
							if (angular.isUndefined(route.children) || !angular.isArray(route.children)) {
								route.children = [];
							}
							//This case sets localId to assign to the child element. Either it is the ID of My_Apps nav or if it has children it sets the value to value of id for last child
							var localId =
								angular.isArray(route.children) &&
								route.children.length >= 1 &&
								angular.isDefined(route.children[route.children.length - 1].id)
									? route.children[route.children.length - 1].id
									: route.id;

							if (
								$scope.appsList &&
								angular.isDefined($scope.appsList) &&
								angular.isArray($scope.appsList) &&
								$scope.appsList.length >= 1
							) {
								$scope.appsList.forEach(function(app) {
									localId = localId + 1;
									var childrenAndSubstatesObject = _computeAppChildrenAndSubState(app, localId);
									var inidividualAppUnderMyApps = {
										state: 'appViewer' + app.sys_id,
										cvTitle: app.name,
										isApp: true,
										cvSubStates: childrenAndSubstatesObject.cvSubStates,
										id: localId,
										showNavItem: true,
										titleLocalized: true,
										isMultiCommCellAware: false,
										loadedChildrenFirstTime: false,
										children: childrenAndSubstatesObject.children,
										requireCollapsableChildren: true
									};
									route.children.push(inidividualAppUnderMyApps);
									route.hasChildrenToShow = cvNavigationFactory.hasChildrenToShow(route);
									route.showRootNodeAsAccordian =
										route.isRootNode || (!route.isRootNode && route.requireCollapsableChildren);

									//updating navigation factory map when the apps got loaded under my-apps
									cvNavigationFactory.putItemInRouteStateToNavItemMap(
										inidividualAppUnderMyApps.state,
										inidividualAppUnderMyApps
									);
									if (!angular.isArray(route.cvSubStates)) {
										route.cvSubStates = [];
									}
									inidividualAppUnderMyApps.cvSubStates.forEach(function(subState) {
										route.cvSubStates.push(subState);
									});
								});
							}
							//updating my-apps to update its children information.
							cvNavigationFactory.putItemInRouteStateToNavItemMap(route.state, route);
							if ($stateParams.page && angular.isDefined($stateParams.page) && $stateParams.page !== '') {
								$scope.$broadcast('stateIsAppPage');
							}
						},
						function(err) {
							$log.error(err);
							cvToaster.showErrorMessage({
								message: cvLoc('error.errorLoadingApps')
							});
						}
					);
			};

			$scope.postProcessNavs();
			//Data model for leftNavDirective
			$scope.selectedNavigationView = {};
			$scope.selectedNavigationView.type = 'modern';
			$scope.modernViewRoutes = $scope.routes;
		}
	];
	navigationMod.controller(controllers);
})();
