import { globalFileSearchModule } from 'common/js/modules';
import 'vsa/js/factories/vendorTypes.factory.js';
import 'vsa/js/factories/downloads.factory.js';
import 'adminConsole/js/factories/restore.factory.js';

var globalSearchMod = globalFileSearchModule;

var controllers = {};
controllers.globalFileSearchController = [
	'$scope',
	'cvTableOptions',
	'cvLoc',
	'globalSearchService',
	'$stateParams',
	'cvUtil',
	'vendorTypes',
	'downloadsFactory',
	'restoreFactory',
	'browseService',
	'browseForAgentsService',
	'serverService',
	'AppTypesUtil',
	'AppTypes',
	'selectionService',
	'BrowseTypes',
	'$log',
	'cvToaster',
	function(
		$scope,
		cvTableOptions,
		cvLoc,
		globalSearchService,
		$stateParams,
		cvUtil,
		vendorTypes,
		downloadsFactory,
		restoreFactory,
		browseService,
		browseForAgentsService,
		serverService,
		AppTypesUtil,
		AppTypes,
		selectionService,
		BrowseTypes,
		$log,
		cvToaster
	) {
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		$scope.globalSearchVal = $stateParams.fileName || '';

		$scope.defaultPagingOptions = {
			page: 1,
			limit: 15
		};

		selectionService.clearSelection();
		$scope.currentPagingOptions = $scope.defaultPagingOptions;

		$scope.selectedServers = [];
		$scope.selectedVMs = [];

		$scope.facetOptions = [];

		$scope.resetFacets = function() {
			resetSizeFacets();
			resetServerFacets();
			//resetVMsFacets();
			resetDateFacets();
		};

		$scope.facets = {
			dateFacets: [
				{
					type: '_ModifiedTime_Today',
					selected: false,
					count: 0,
					localizeName: cvLoc('label.date.today'),
					queryString: '(ModifiedTime:[NOW/DAY+0DAY TO *])'
				},
				{
					type: '_ModifiedTime_Last 7 Days',
					selected: false,
					count: 0,
					localizeName: cvLoc('label.date.last7Days'),
					queryString: '(ModifiedTime:[NOW/DAY-7DAY TO *])'
				},
				{
					type: '_ModifiedTime_Last 30 Days',
					selected: false,
					count: 0,
					localizeName: cvLoc('label.date.last30Days'),
					queryString: '(ModifiedTime:[NOW/DAY-30DAY TO *])'
				},
				{
					type: '_ModifiedTime_Last Year',
					selected: false,
					count: 0,
					localizeName: cvLoc('label.date.lastYear'),
					queryString: '(ModifiedTime:[NOW/DAY-1YEAR TO *])'
				},
				{
					type: '_ModifiedTime_Beyond One Year',
					selected: false,
					count: 0,
					localizeName: cvLoc('label.date.beyondOneYear'),
					queryString: '(ModifiedTime:{* TO NOW/DAY-1YEAR})'
				}
			],
			sizeFacets: [
				{
					type: '_Size_Below 1 MB',
					localizeName: cvLoc('label.size.below1mb'),
					order: 1,
					selected: false,
					queryString: '(Size:{0 TO *} AND Size:[* TO 1048576])',
					count: 0
				},
				{
					type: '_Size_1 MB to 10 MB',
					localizeName: cvLoc('label.size.1mbto10mb'),
					order: 2,
					selected: false,
					queryString: '(Size:{1048576 TO *} AND Size:[* TO 10485760])',
					count: 0
				},
				{
					type: '_Size_10 MB to 50 MB',
					localizeName: cvLoc('label.size.10mbto50mb'),
					order: 3,
					selected: false,
					queryString: '(Size:{10485760 TO *} AND Size:[* TO 52428800])',
					count: 0
				},
				{
					type: '_Size_50 MB to 1 GB',
					localizeName: cvLoc('label.size.50mbto1gb'),
					order: 4,
					selected: false,
					queryString: '(Size:{52428800 TO *} AND Size:[* TO 1073741824])',
					count: 0
				},
				{
					type: '_Size_Above 1 GB',
					localizeName: cvLoc('label.size.above1gb'),
					order: 5,
					selected: false,
					queryString: '(Size:{1073741824 TO *})',
					count: 0
				}
			],
			serverFacets: [],
			vmsFacets: []
		};

		function getDataFromServer(val, pageOptions, facetOptions) {
			if (val === '') {
				$scope.dataFromServer = [];
				$scope.dataFromServer.length = 0;
				$scope.gridOptions.gridOptions.totalItems = 0;
				$scope.resetFacets();
				$scope.$apply();
				return;
			}

			let fileSearchTerm = val.replace('*', '');

			globalSearchService
				.getFileSearchData(fileSearchTerm, pageOptions, facetOptions)
				.then(function(results) {
					if (results.data && results.data.response && results.data.response.docs) {
						$scope.gridOptions.gridOptions.totalItems = results.data.response.numFound;
						$scope.dataFromServer = results.data.response.docs;
					}

					updateFacets(results.data.facets);

					$scope.dataFromServer.forEach(function(item) {
						item.FilePath = item.FilePath ? item.FilePath : item.Url;
						item.modDate = new Date(item.ModifiedTime);
						item.modDate = item.modDate.toDateString() + ' ' + item.modDate.toLocaleTimeString();
						let { AppType, FilePath, VMUniqueIdentifier, VMName, VMHypervisor } = item;

						// FS browse
						if (AppType === 33 || AppType === 29) {
							//item.formattedSize = item.Size;

							item.type = 'browse';
							item.browseurl =
								'#/browseForAgents/' +
								item.AppType +
								'//?clientGroupName=&subclientId=' +
								item.ApplicationId +
								'&path=' +
								item.FilePath +
								'&globalSearch=true';
							item.path = item.FilePath;
							item.browseType = BrowseTypes.FS_FILE_BROWSE;
						}

						// Temp way to check VSA agent type. Replace the VMname to APPType once API is changed
						else if (VMName) {
							if (FilePath[0] === '/') {
								FilePath = FilePath.replace(/\//g, '\\');
							}
							let vendorName = vendorTypes.getVendorName(VMHypervisor);
							item.vendor = vendorName;
							let path = escape('/' + VMUniqueIdentifier + '/' + FilePath);
							item.type = 'browse';
							item.browseurl =
								'#/browse/vsFileBrowse/' +
								item.ApplicationId +
								'/' +
								'%5C' +
								VMUniqueIdentifier +
								'%5C' +
								escape(FilePath) +
								'?vendor=' +
								vendorName +
								'&vmname=' +
								VMName +
								'&globalSearch=true';
							item.path = VMUniqueIdentifier + '\\' + FilePath;
							item.browseType = BrowseTypes.VS_FILE_BROWSE;
							item.FilePath = FilePath;
						}

						item.showDownloadOption = downloadsFactory.showDownloadOption(item.browseType, VMName);
					});
				})
				.catch(function(err) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: cvLoc('error.fileSearchFailed')
					});
					$scope.dataFromServer = [];
				});
		}

		$scope.appTypeActionSupport = function(appType) {
			return appType == 33 || appType == 29 || appType == 106;
		};

		angular.extend(globalGridOptions, {
			data: 'dataFromServer',
			enableGridMenu: false,
			useExternalPagination: true,
			useExternalSorting: true,
			paginationPageSize: $scope.currentPagingOptions.limit,
			columnDefs: [
				{
					field: 'FileName',
					cvUserPref: 'FileName',
					enableHiding: false,
					name: 'fileName',
					displayName: cvLoc('label.header.fileName'),
					cellTemplate:
						'<span class="crop"><a href="" data-ng-click="grid.appScope.doShowRestoreDialog(row.entity)" title="{{row.entity.FileName}}" data-ng-bind-html="row.entity.FileName | uibTypeaheadHighlight:grid.appScope.globalSearchVal"></a></span>',
					width: '20%'
				},
				{
					field: 'ClientName',
					enableHiding: false,
					name: 'ClientName',
					displayName: cvLoc('label.header.serverName'),
					cellTemplate:
						'<a href="#/fsAgentDetails/{{row.entity.ClientId}}/{{row.entity.AppType}}" data-ng-if="row.entity.ClientName && !row.entity.VMName" class="crop" title="{{row.entity.ClientName}}">{{row.entity.ClientName}}</a>' +
						'<a href="#/vm/{{row.entity.VMUniqueIdentifier}}" data-ng-if="row.entity.VMName" class="crop" title="{{row.entity.VMName}}">{{row.entity.VMName}}</a>',
					width: '20%'
				},
				{
					field: 'Size',
					enableHiding: false,
					name: 'Size',
					displayName: cvLoc('label.header.size'),
					cellTemplate:
						'<span class="crop" title="{{row.entity.Size | capacity}}">{{row.entity.Size | capacity}}</span>',
					width: '10%'
				},
				{
					field: 'ModifiedTime',
					enableHiding: false,
					name: 'modDate',
					displayName: cvLoc('label.header.modifiedDate'),
					cellTemplate: '<span class="crop" title="{{row.entity.modDate}}">{{row.entity.modDate}}</span>',
					width: '15%'
				},
				{
					field: 'FilePath',
					enableHiding: false,
					name: 'FilePath',
					displayName: cvLoc('label.header.path'),
					cellTemplate: '<span class="crop" title="{{row.entity.FilePath}}">{{row.entity.FilePath}}</span>'
				},
				{
					field: 'Actions',
					enableHiding: false,
					enableSorting: false,
					name: 'Actions',
					width: '10%',
					displayName: cvLoc('label.globalSearch.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown data-ng-if="grid.appScope.appTypeActionSupport(row.entity.AppType)" on-toggle="grid.appScope.toggleActionMenu(open)">\
								<a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>\
								<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
									<li data-ng-if="row.entity.showDownloadOption" data-ng-click="grid.appScope.downloadFile(row.entity)">\
										<a class="crop">' +
						cvLoc('label.globalSearch.download') +
						'</a>\
									</li>\
									<li data-ng-click="grid.appScope.doShowRestoreDialog(row.entity)">\
										<a class="crop">' +
						cvLoc('header.restore') +
						'</a>\
									</li>\
								</ul></div>'
				}
			],
			onRegisterApi: function(gridApi) {
				$scope.gridApi = gridApi;
				gridApi.pagination.on.paginationChanged($scope, function(newPage, pageSize) {
					$scope.currentPagingOptions.page = newPage;
					$scope.currentPagingOptions.limit = pageSize;
					getDataFromServer($scope.globalSearchVal, $scope.currentPagingOptions, $scope.facetOptions);
				});

				$scope.navigateToFirstPage = function() {
					if (gridApi.pagination.getPage() > 1) {
						gridApi.pagination.seek(1);
					}
				};

				gridApi.core.on.sortChanged($scope, function(grid, sortColumns) {
					if (sortColumns.length == 0) {
						// reset sort
						$scope.currentPagingOptions.sortField = 'FileName';
						$scope.currentPagingOptions.sortDir = 'asc';
					} else {
						$scope.currentPagingOptions.page = 1; //reset page
						$scope.currentPagingOptions.sortField = sortColumns[0].field;
						$scope.currentPagingOptions.sortDir = sortColumns[0].sort.direction === 'asc' ? 'asc' : 'desc';
					}
					$scope.createAndUpdateFacets();
					$scope.navigateToFirstPage();
				});
			}
		});

		$scope.gridOptions = {
			cvTableName: 'globalFileSearchTable',
			cvIsSearchable: false,
			gridOptions: globalGridOptions
		};

		$scope.fileNameSearched = debounce(function(val) {
			getDataFromServer($scope.globalSearchVal, $scope.defaultPagingOptions, $scope.facetOptions);
		}, 500);

		function debounce(func, wait, immediate) {
			var timeout;
			return function() {
				var context = this,
					args = arguments;
				var later = function() {
					timeout = null;
					if (!immediate) {
						func.apply(context, args);
					}
				};
				var callNow = immediate && !timeout;
				clearTimeout(timeout);
				timeout = setTimeout(later, wait);
				if (callNow) {
					func.apply(context, args);
				}
			};
		}

		function updateFacets(facetsObj) {
			for (var property in facetsObj) {
				if (facetsObj.hasOwnProperty(property)) {
					if (property.startsWith('_Size_')) {
						updateSizeFacets(property, facetsObj[property].count);
					} else if (property.startsWith('ClientName')) {
						updateServerFacets(facetsObj[property]);
					} else if (property.startsWith('_ModifiedTime_')) {
						updateDateFacets(property, facetsObj[property].count);
					}
					//				  else if(property.startsWith('VMName')) {
					//					  updateVMsFacets(facetsObj[property]);
					//				  }
				}
			}
		}

		function updateDateFacets(type, count) {
			for (var i = 0; i < $scope.facets.dateFacets.length; i++) {
				if ($scope.facets.dateFacets[i].type === type) {
					$scope.facets.dateFacets[i].count = count;
					return;
				}
			}
		}

		function updateServerFacets(serverObj) {
			$scope.facets.serverFacets = [];
			$scope.facets.serverFacets.length = 0;
			for (var i = 0; i < serverObj.buckets.length; i++) {
				$scope.facets.serverFacets.push({
					type: serverObj.buckets[i].val,
					count: serverObj.buckets[i].count,
					selected: $scope.selectedServers.includes(serverObj.buckets[i].val)
				});
			}
		}

		//	function updateVMsFacets(serverObj) {
		//		$scope.facets.vmsFacets = [];
		//		$scope.facets.vmsFacets.length = 0;
		//		for(var i=0;i<serverObj.buckets.length;i++) {
		//			$scope.facets.vmsFacets.push({
		//				'type' : serverObj.buckets[i].val,
		//				'count' :  serverObj.buckets[i].count,
		//				'selected' : $scope.selectedVMs.includes(serverObj.buckets[i].val)
		//			});
		//		}
		//	}

		function updateSizeFacets(type, count) {
			for (var i = 0; i < $scope.facets.sizeFacets.length; i++) {
				if ($scope.facets.sizeFacets[i].type === type) {
					$scope.facets.sizeFacets[i].count = count;
					return;
				}
			}
		}

		function createFacets() {
			$scope.facetOptions = [];
			var sizeFa = createSizeFacets();
			if (sizeFa != '') {
				$scope.facetOptions.push({
					key: 'fq',
					value: sizeFa
				});
			}
			var serverFa = createServerFacets();
			if (serverFa != '') {
				$scope.facetOptions.push({
					key: 'fq',
					value: serverFa
				});
			}

			//		var vmsFa = createVMsFacets();
			//		if(vmsFa!="") {
			//			$scope.facetOptions.push({
			//				'key' : 'fq',
			//				'value' : vmsFa
			//			});
			//		}

			var dateFa = createDateFacets();
			if (dateFa != '') {
				$scope.facetOptions.push({
					key: 'fq',
					value: dateFa
				});
			}
		}

		function createServerFacets() {
			var serverObj = $scope.facets.serverFacets;
			var str = '';
			var found = 0;
			$scope.selectedServers.length = 0;
			$scope.selectedServers = [];
			for (var property in serverObj) {
				if (serverObj.hasOwnProperty(property)) {
					if (serverObj[property].selected) {
						if (str === '') {
							str = '{!tag=tag_ClientName,tag_page_override}';
						}

						var clientStr = '(ClientName:"' + serverObj[property].type + '")';
						if (found == 0) {
							str += clientStr;
						} else {
							str += ' OR ' + clientStr;
						}
						$scope.selectedServers.push(serverObj[property].type);
						found = 1;
					}
				}
			}
			return str;
		}

		//	function createVMsFacets() {
		//		var serverObj = $scope.facets.vmsFacets;
		//		var str = '';
		//		var found = 0;
		//		$scope.selectedVMs.length=0;
		//		$scope.selectedVMs = [];
		//		for (var property in serverObj) {
		//			 if (serverObj.hasOwnProperty(property)) {
		//				 if(serverObj[property].selected) {
		//					if(str==='') {
		//						str="{!tag=tag_VMName,tag_page_override}";
		//					}
		//
		//					var clientStr = '(VMName:"'+ serverObj[property].type +'")';
		//					if(found==0) {
		//						str+=clientStr;
		//					} else {
		//						str+=" OR " + clientStr
		//					}
		//					$scope.selectedVMs.push(serverObj[property].type);
		//					found=1;
		//				 }
		//			 }
		//		}
		//		return str;
		//	}

		function createSizeFacets() {
			var sizeObj = $scope.facets.sizeFacets;
			var str = '';
			var found = 0;
			for (var property in sizeObj) {
				if (sizeObj.hasOwnProperty(property)) {
					if (sizeObj[property].selected) {
						if (str === '') {
							str = '{!tag=tag_group_Size}';
						}
						if (found == 0) {
							str += sizeObj[property].queryString;
						} else {
							str += ' OR ' + sizeObj[property].queryString;
						}
						found = 1;
					}
				}
			}
			return str;
		}

		function createDateFacets() {
			var sizeObj = $scope.facets.dateFacets;
			var str = '';
			var found = 0;
			for (var property in sizeObj) {
				if (sizeObj.hasOwnProperty(property)) {
					if (sizeObj[property].selected) {
						if (str === '') {
							str = '{!tag=tag_group_ModifiedTime}';
						}
						if (found == 0) {
							str += sizeObj[property].queryString;
						} else {
							str += ' OR ' + sizeObj[property].queryString;
						}
						found = 1;
					}
				}
			}
			return str;
		}

		$scope.createAndUpdateFacets = function() {
			createFacets();
			getDataFromServer($scope.globalSearchVal, $scope.defaultPagingOptions, $scope.facetOptions);
		};

		$scope.createAndUpdateFacets();

		$scope.clearSizeFacets = function(evt) {
			for (var property in $scope.facets.sizeFacets) {
				$scope.facets.sizeFacets[property].selected = false;
			}
			evt.stopPropagation();
			evt.preventDefault();
			$scope.createAndUpdateFacets();
		};

		$scope.clearServerFacets = function(evt) {
			for (var property in $scope.facets.serverFacets) {
				$scope.facets.serverFacets[property].selected = false;
			}
			evt.stopPropagation();
			evt.preventDefault();
			$scope.createAndUpdateFacets();
		};

		//	$scope.clearVMsFacets = function(evt) {
		//		for (var property in  $scope.facets.vmsFacets) {
		//			 $scope.facets.vmsFacets[property].selected = false;
		//		}
		//		evt.stopPropagation();
		//		evt.preventDefault();
		//		$scope.createAndUpdateFacets();
		//	};

		$scope.clearSourceFacets = function(evt) {
			//$scope.clearVMsFacets(evt);
			$scope.clearServerFacets(evt);
		};

		$scope.clearDateFacets = function(evt) {
			for (var property in $scope.facets.dateFacets) {
				$scope.facets.dateFacets[property].selected = false;
			}
			evt.stopPropagation();
			evt.preventDefault();
			$scope.createAndUpdateFacets();
		};

		function resetSizeFacets() {
			for (var property in $scope.facets.sizeFacets) {
				$scope.facets.sizeFacets[property].selected = false;
				$scope.facets.sizeFacets[property].count = 0;
			}
		}

		function resetDateFacets() {
			for (var property in $scope.facets.dateFacets) {
				$scope.facets.dateFacets[property].selected = false;
				$scope.facets.dateFacets[property].count = 0;
			}
		}

		function resetServerFacets() {
			$scope.facets.serverFacets = [];
			$scope.facets.serverFacets.length = 0;
			$scope.selectedServers = [];
			$scope.selectedServers.length = 0;
		}

		//	function resetVmsFacets() {
		//		$scope.facets.vmsFacets = [];
		//		$scope.facets.vmsFacets.length = 0;
		//		$scope.selectedVMs = [];
		//		$scope.selectedVMs.length = 0;
		//	}

		$scope.downloadFile = function(obj) {
			if (obj.FilePath[0] === '\\') {
				obj.FilePath = obj.FilePath.replace('\\', '');
			}
			downloadsFactory.processDownloadRequest(obj);
		};

		const setBrowseServiceEntity = function(clientId, clientName, subclientId, applicationId, browseType) {
			const entity = { clientId, clientName, subclientId, applicationId };
			entity.appTypeId = applicationId;
			switch (browseType) {
				case BrowseTypes.FS_FILE_BROWSE:
					browseForAgentsService.entity = entity;
					break;
				case BrowseTypes.VS_FILE_BROWSE:
					browseService.entity = entity;
					break;
				default:
					$log.error('Browse Type is not supported', browseType);
					break;
			}
		};

		$scope.doShowRestoreDialog = function(selectedRow) {
			selectionService.clearSelection();
			const { ClientId, ClientName, ApplicationId, VMUniqueIdentifier, AppType, browseType, vendor } = selectedRow;
			selectionService.selectionArray = [selectedRow];
			setBrowseServiceEntity(ClientId, ClientName, ApplicationId, AppType, browseType);
			restoreFactory.doShowRestoreDialogSub(browseType, vendor, selectedRow, VMUniqueIdentifier, vendor);
		};
	}
];

globalSearchMod.controller(controllers);

export default globalSearchMod;
