import { dloAppCustomizationModule } from 'common/js/modules';

var app = dloAppCustomizationModule;

app.service('customizationService', [
	'$http',
	function($http) {
		/**
		 * Organization Id is now needed in call because we need to check completed setups in Java Controller Code
		 */

		this.getNavList = function(organizationId) {
			return $http.get('navList.do?organizationId=' + organizationId);
		};

		this.setUpdateHidenNavList = function(updatedNavItemRequest, companyId) {
			return $http.post('updateHideNavList.do', {
				updatedNavItemRequest: JSON.stringify(updatedNavItemRequest),
				companyId: companyId
			});
		};

		this.getRoleToDeniedNavs = function() {
			return $http.get('getRoleToDeniedStateMap.do');
		};

		this.getHideNavsList = function(companyId) {
			if (companyId != 0) {
				return $http.get('getNavigationSettings.do?organizationId=' + companyId);
			} else {
				return $http.get('getNavigationSettings.do');
			}
		};

		this.setUpdateStateToReportMap = function(stateToReportMap) {
			return $http.post('updateStateToReportMap.do', {
				stateToReportMap: JSON.stringify(stateToReportMap)
			});
		};

		this.getStateToReportMap = function() {
			return $http.get('getStateToReportMap.do');
		};
	}
]);

export default app;
