import { navCustomizationModule } from 'common/js/modules';
var mod = navCustomizationModule;
mod.factory('customizationFactory', [
	'cvLoc',
	'$stateParams',
	function(cvLoc, $stateParams) {
		var factory = {};

		/**
		 *
		 * @param {string} tabName accepts value like initialLanding or navigationPreferences
		 * @param {int/string} subscriptionId value of the company id
		 * @param {string} subscriptionName value of company name
		 */
		let _returnTabLink = function(tabName, subscriptionId, subscriptionName) {
			if (tabName && angular.isDefined(tabName) && tabName !== '') {
				if (subscriptionId && angular.isDefined(subscriptionId)) {
					if (cv.isTenantAdmin) {
						return '/' + tabName + '?subscriptionId=' + subscriptionId;
					} else {
						//if companyId is set in url it means we are accessing company details from global Navigation and company dropdown
						if (
							angular.isDefined($stateParams) &&
							angular.isDefined($stateParams.companyId) &&
							$stateParams.companyId !== ''
						) {
							var initialPrefLink = '/' + tabName + '?&companyId=' + subscriptionId;
							if (angular.isDefined($stateParams._cn) && $stateParams._cn !== '') {
								initialPrefLink += '&_cn=' + $stateParams._cn;
							}
							return initialPrefLink;
						}
						//If we reached here, we are accessing initialLanding from companyDetails page
						return '/' + tabName + '?subscriptionId=' + subscriptionId + '&subscriptionName=' + subscriptionName;
					}
				}
				return '/' + tabName;
			}
			return '/';
		};
		/**
		 *
		 * @param {string} overrideUrl : is the url which is used to override the tabUrl
		 */
		let _getNavigationPreferencesTab = function(overrideUrl) {
			let baseNavigationPreferencesTabInfo = {
				title: cvLoc('label.nav.navigationPreferences'),
				url: '/navigationPreferences'
			};
			if (overrideUrl && angular.isDefined(overrideUrl) && overrideUrl !== '') {
				baseNavigationPreferencesTabInfo.url = overrideUrl;
			}

			return baseNavigationPreferencesTabInfo;
		};
		/**
		 *
		 * @param {string} overrideUrl : is the url which is used to override the tabUrl
		 */
		let _getInitialLandingTab = function(overrideUrl) {
			let baseInitialLandingTabInfo = {
				title: cvLoc('label.nav.initialLanding'),
				url: '/initialLanding'
			};
			if (overrideUrl && angular.isDefined(overrideUrl) && overrideUrl !== '') {
				baseInitialLandingTabInfo.url = overrideUrl;
			}

			return baseInitialLandingTabInfo;
		};

		let _getOvrrideLandingTab = function() {
			return {
				title: cvLoc('label.nav.overrideLanding'),
				url: '/overrideLanding'
			};
		};
		/**
		 *  @param {string} stateName : accepts stateName : navigationPreferences, initialLanding, overrideLanding
		 *  @param {string/int} subscriptionId : companyId
		 *  @param {string} subscriptionName : companyName
		 *
		 *  */

		factory.getTabsForState = function(stateName, subscriptionId, subscriptionName) {
			let tabs = [];

			if (stateName === 'navigationPreferences') {
				// At Company Level We show only navigation Preferences and Initial Landing and Global level we show all three (Navigation Preferences, Initial Landing, Override Landing)
				if (cv.isAdmin || cv.isTenantAdmin || angular.isDefined(subscriptionId)) {
					tabs.push(_getNavigationPreferencesTab());
					tabs.push(_getInitialLandingTab(_returnTabLink('initialLanding', subscriptionId, subscriptionName)));
				}
				if (
					cv.isAdmin &&
					!cv.isTenantAdmin &&
					angular.isUndefined(subscriptionId) &&
					angular.isDefined(cvConfig.isOverrideLandingTabEnabled) &&
					cvConfig.isOverrideLandingTabEnabled
				) {
					tabs.push(_getOvrrideLandingTab());
				}
			}

			if (stateName === 'initialLanding') {
				if (cv.isAdmin || cv.isTenantAdmin || angular.isDefined(subscriptionId)) {
					tabs.push(
						_getNavigationPreferencesTab(_returnTabLink('navigationPreferences', subscriptionId, subscriptionName))
					);
					tabs.push(_getInitialLandingTab());
				}

				if (
					cv.isAdmin &&
					!cv.isTenantAdmin &&
					angular.isUndefined(subscriptionId) &&
					angular.isDefined(cvConfig.isOverrideLandingTabEnabled) &&
					cvConfig.isOverrideLandingTabEnabled
				) {
					tabs.push(_getOvrrideLandingTab());
				}
			}

			if (stateName === 'overrideLanding') {
				if (cv.isAdmin && !cv.isTenantAdmin && angular.isUndefined(subscriptionId)) {
					tabs.push(_getNavigationPreferencesTab());
					tabs.push(_getInitialLandingTab());
					tabs.push(_getOvrrideLandingTab());
				}
			}

			return tabs;
		};
		return factory;
	}
]);
export default mod;
