import { navCustomizationModule } from 'common/js/modules';
import 'modules/settings/js/services/settings.svc.js';

class UserSetting {
	constructor(value, text, mspSelected, tenantSelected) {
		this.value = value;
		this.text = text;
		this.mspSelected = mspSelected || false;
		this.tenantSelected = tenantSelected || false;
	}
}

var navMod = navCustomizationModule;

navMod.controller('userSettingsController', [
	'$log',
	'$dialogs',
	'cvLoc',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'cvTableOptions',
	'settingsService',
	'$q',
	'USER_SETTINGS',
	function(
		$log,
		$dialogs,
		cvLoc,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		cvTableOptions,
		settingsService,
		$q,
		USER_SETTINGS
	) {
		let self = this;
		const HIDE_COMMCELL_DROPDOWN = 'hideCommcellDropdown';
		const HIDE_COMPANY_DROPDOWN = 'hideCompanyDropdown';
		const _setupBreadCrumbs = () => {
			let breadCrumbs = [];
			breadCrumbs.push({
				title: cvLoc('label.nav.masterCustomization'),
				link: '#nav/masterCustomization'
			});
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};
		self.isMspAdmin = cv.isMspAdmin;
		self.noPermissionToSetCustomization = cvLoc('label.noPermissionToSetCustomization');

		_setupBreadCrumbs();

		const USER_SETTINGS_LIST = {
			LANGUAGE: { show: cvConfig.showLanguageSelection, label: cvLoc('label.language') },
			USER_PREF: { show: true, label: cvLoc('label.userPreference') },
			LICENSE: { show: true, label: cvLoc('label.license') },
			ACCESSIBILITY: { show: true, label: cvLoc('label.accessibility') },
			ABOUT: { show: true, label: cvLoc('label.about') },
			HELP: { show: true, label: cvLoc('label.help') },
			FEEDBACK: { show: cvConfig.showFeedback, label: cvLoc('label.feedback') },
			SUPPORT: { show: true, label: cvLoc('label.customerSupport') },
			CHANGE_PASS: { show: true, label: cvLoc('label.changePassword') },
			LOCK: { show: cvConfig.showLockSession, label: cvLoc('label.lock') },
			LOGOUT: { show: true, label: cvLoc('label.logout') }
		};

		self.hideSettingsMsp = '';
		self.hideSettingsTenant = '';
		self.hideSettingsLoaded = false;

		const hideSettingsContainsSetting = (option, isMSP) => {
			let hideSettingsArray = self.hideSettingsArrayMsp;
			if (!isMSP) {
				hideSettingsArray = self.hideSettingsArrayTenant;
			}
			return _.isArray(hideSettingsArray) && hideSettingsArray.length > 0 && hideSettingsArray.includes(option);
		};

		const _getUserSettings = () => {
			let userSettingsArray = [];

			Object.keys(USER_SETTINGS_LIST).forEach(function(key) {
				if (USER_SETTINGS_LIST[key].show) {
					userSettingsArray.push(
						new UserSetting(
							USER_SETTINGS[key],
							USER_SETTINGS_LIST[key].label,
							hideSettingsContainsSetting(USER_SETTINGS[key], true),
							hideSettingsContainsSetting(USER_SETTINGS[key], false)
						)
					);
				}
			});

			return userSettingsArray;
		};

		self.resetSelection = () => {
			self.userSettings.forEach(function(userOption) {
				userOption.mspSelected = false;
				userOption.tenantSelected = false;
			});
			self.saveUserSettingsCustomization();
		};

		self.saveUserSettingsCustomization = () => {
			let mspHideString = '';
			let tenantHideString = '';
			self.userSettings.forEach(function(userSetting) {
				if (userSetting != null && userSetting.mspSelected) {
					mspHideString += userSetting.value + ',';
				}
				if (userSetting.tenantSelected) {
					tenantHideString += userSetting.value + ',';
				}
			});
			// Removing , from the string
			if (mspHideString.length > 0) {
				mspHideString = mspHideString.substring(0, mspHideString.length - 1);
			}
			if (tenantHideString.length > 0) {
				tenantHideString = tenantHideString.substring(0, tenantHideString.length - 1);
			}

			if (!_.isEqual(mspHideString, self.hideSettingsMsp) && !_.isEqual(tenantHideString, self.hideSettingsTenant)) {
				let promises = [];
				promises.push(settingsService.setGlobalParam(HIDE_COMMCELL_DROPDOWN, mspHideString));
				promises.push(settingsService.setGlobalParam(HIDE_COMPANY_DROPDOWN, tenantHideString));
				$q.all(promises)
					.then(function(results) {
						self.hideSettingsMsp = mspHideString;
						self.hideSettingsTenant = tenantHideString;
						location.reload();
					})
					.catch(function(error) {
						$log.error('Error setting global param for hide commcell and company dropdown');
					});
			} else if (!_.isEqual(mspHideString, self.hideSettingsMsp)) {
				settingsService
					.setGlobalParam(HIDE_COMMCELL_DROPDOWN, mspHideString)
					.then(function(data) {
						self.hideSettingsMsp = mspHideString;
						location.reload();
						//Doing nothing
					})
					.catch(function(error) {
						$log.error('Error setting global param for hide commcell dropdown');
					});
			} else if (!_.isEqual(tenantHideString, self.hideSettingsTenant)) {
				settingsService
					.setGlobalParam(HIDE_COMPANY_DROPDOWN, tenantHideString)
					.then(function(data) {
						self.hideSettingsTenant = tenantHideString;
						//Doing nothing
					})
					.catch(function(error) {
						$log.error('Error setting global param for hide company dropdown');
					});
			}
		};
		//Click handler for Saving user setting customization
		self.saveUserSettingsCustomizationDialog = () => {
			$dialogs.confirm(cvLoc('label.save'), cvLoc('prompt.saveChanges'), {
				noFunction: function() {},
				yesFunction: function() {
					self.saveUserSettingsCustomization();
				}
			});
		};
		//Click handler for resetting user setting customization selection.
		self.resetSelectionDialog = () => {
			$dialogs.confirm(cvLoc('label.reset'), cvLoc('prompt.resetCustomizationOptions'), {
				noFunction: function() {},
				yesFunction: function() {
					self.resetSelection();
				}
			});
		};

		self.constructGrid = () => {
			self.cvPageLinks = [
				{
					label: cvLoc('label.reset'),
					onclick: self.resetSelectionDialog
				},
				{
					label: cvLoc('label.save'),
					onclick: self.saveUserSettingsCustomizationDialog // Open Modal for confirmation
				}
			];
			self.columnDefs = [
				{ name: cvLoc('label.userSettings'), field: 'text', width: '30%', headerCellClass: 'left-align' },
				{
					field: 'mspSelected',
					displayName: cvLoc('label.commcell'),
					cellTemplate:
						'<input type="checkbox" id="{{row.entity.value + \'Commcell\'}}"  class=""  data-ng-model="row.entity.mspSelected" />' +
						'<label for="{{row.entity.value + \'Commcell\'}}">&nbsp;</label>'
				},
				{
					field: 'tenantSelected',
					displayName: cvLoc('label.company'),
					cellTemplate:
						'<input type="checkbox" id="{{row.entity.value + \'Companies\'}}"  class=""  data-ng-model="row.entity.tenantSelected" />' +
						'<label for="{{row.entity.value + \'Companies\'}}">&nbsp;</label>'
				}
			];

			// GridOptions to create cvGrid
			self.gridOptions = {
				cvIsPageTitle: true,
				cvPageLinks: cv.isMspAdmin ? self.cvPageLinks : [],
				cvGridCssClass: 'grid-style users-grid ui-tree-grid navigation-preferences',
				cvIsSearchable: true,
				cvHasTitle: true,
				cvAppScope: self,
				cvSearchFields: ['text'],
				cvInfoText: cvLoc('label.userSettingsInfoText'),
				cvGridTitle: cvLoc('label.nav.userOptions'),
				// cvGridDirectives: {
				// 	uiGridTreeView: true,
				// 	uiGridPagination: false
				// },
				gridOptions: angular.extend(angular.copy(cvTableOptions.commonNgGridOptions), {
					data: 'userSettings',
					enableSorting: false,
					enableFiltering: true,
					enableTreeView: true,
					showTreeExpandNoChildren: false,
					onRegisterApi: function(gridApi) {
						self.gridApi = gridApi;
					},
					enablePaginationControls: false,
					enableGridMenu: false,
					paginationPageSize: 100,
					columnDefs: self.columnDefs
				})
			};
		};

		const loadEmptyGrid = () => {
			self.userSettings = [];
			self.constructGrid();
			self.hideSettingsLoaded = true;
		};

		if (cv.isMspAdmin) {
			const promises = [];
			promises.push(settingsService.getGlobalParam(HIDE_COMMCELL_DROPDOWN));
			promises.push(settingsService.getGlobalParam(HIDE_COMPANY_DROPDOWN));
			$q.all(promises)
				.then(function(results) {
					//We have to do json.parse because while saving the information through UI, we do JSON.stringify.
					//Need to check if value is set directly in DB, how is the value returned.
					self.hideSettingsMsp = JSON.parse(_.get(results[0], 'data.globalParamsResultList[0].value', '""'));
					self.hideSettingsTenant = JSON.parse(_.get(results[1], 'data.globalParamsResultList[0].value', '""'));
					self.hideSettingsArrayMsp = self.hideSettingsMsp.split(',');
					self.hideSettingsArrayTenant = self.hideSettingsTenant.split(',');
					self.userSettings = _getUserSettings();
					self.constructGrid();
					self.hideSettingsLoaded = true;
				})
				.catch(function(error) {
					$log.error('Error fetching global params for company and msp global hide drop down option');
					loadEmptyGrid();
				});
		}
	}
]);

export default navMod;
