import 'modules/navCustomization/js/services/customization.svc.js';
import 'users/js/services/users.svc.js';

import { navCustomizationModule } from 'common/js/modules';

class UserGroupNavigationPrefController {
	constructor(
		$log,
		$dialogs,
		cvLoc,
		cvTableOptions,
		$stateParams,
		customizationService,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		userService,
		$q
	) {
		this.$log = $log;
		this.$dialogs = $dialogs;
		this.cvLoc = cvLoc;
		this.cvTableOptions = cvTableOptions;
		this.$stateParams = $stateParams;
		this.customizationService = customizationService;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.cvToaster = cvToaster;
		this.userService = userService;
		this.userGroupId =
			$stateParams.userGroupId != null && !_.isUndefined('$stateParams.userGroupId')
				? $stateParams.userGroupId
				: undefined;
		this.userGroupName =
			$stateParams.userGroupName != null && !_.isUndefined('$stateParams.userGroupName')
				? $stateParams.userGroupName
				: '';
		this.$q = $q;
		this._setupBreadCrumbs();
		this._init();
	}

	_setupBreadCrumbs() {
		let breadCrumbs = [];

		breadCrumbs.push({
			title: this.userGroupName ? this.userGroupName : this.cvLoc('label.nav.userGroups'),
			link:
				this.userGroupId != null && !_.isUndefined(this.userGroupId) ? '#userGroup/' + this.userGroupId : '#usergroups'
		});
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}

	_init() {
		'use strict';
		var self = this;

		self.navsToShow = []; // This is the data-model which is created for setting the content in Customization Page
		self.serviceType = '';
		self.providerId = 0;

		const RELPATH_ADMINCONSOLE = 'CommServDB.AdminConsole';
		const TENANT_ADMIN = 'Role_Tenant_Admin';
		const EXCLUDE = 'hideNavItems';
		const INCLUDE = 'includeNavItems';

		/**
		 *
		 * @param {string} st
		 * return true if string is not null / not undefined / not empty
		 */
		const _isValidString = st => {
			return st !== null && st !== undefined && st !== '';
		};

		// Defaulting the roles to false. The roles will
		const _setSelection = navItem => {
			if (navItem && _isValidString(navItem.state)) {
				navItem.hideNavItem =
					self.hideNavItemsList.has(navItem.state) && !self.includeNavItemsList.has(navItem.state) ? true : false;
				navItem.includeNavItem =
					!self.hideNavItemsList.has(navItem.state) && self.includeNavItemsList.has(navItem.state) ? true : false;
			} else {
				navItem.hideNavItem = false;
				navItem.includeNavItem = false;
			}
		};

		const _routeHasRole = (route, roleName) => {
			if (angular.isArray(route.roles)) {
				if (route.roles.includes(roleName)) {
					return true;
				}
			}
			// Else if the route does not have roles defined then consider that it has roles
			else {
				return true;
			}
		};
		/*
		 * We need to set the levels on each nav for having that hierarchy and each Nav should be a part of
		 * the array so in below function we do the following things:- 1. set the hierarchy level 2. Set the
		 * roles of the navItem. (Setting roles is nothing but setting the corresponding role of the navItem
		 * to true or false which is used in selecting the checkbox) 3. Push the content in model and continue
		 * checking for its children.
		 */

		const _addLevelandModifyData = (navItem, level) => {
			if (angular.isDefined(navItem)) {
				navItem.$$treeLevel = level;
				_setSelection(navItem);
				self.navsToShow.push(navItem);
				if (angular.isArray(navItem.children)) {
					navItem.children.forEach(child => {
						//ChildItem will be seen if
						if (child.showNavItem) {
							if (cv && cv.orgId) {
								if (_routeHasRole(child, TENANT_ADMIN)) {
									_addLevelandModifyData(child, level + 1);
								}
							} else {
								_addLevelandModifyData(child, level + 1);
							}
						}
					});
				}
			}
		};
		// This function is used to setup the cvGrid data model for the first time and when we click reset to default. This basically tells which row to show and which not to show based on userRole
		const _setupDefaultModel = () => {
			if (angular.isDefined(self.routes)) {
				self.routes.forEach(route => {
					if (route.showNavItem) {
						let level = 0;
						// if tenant admin or tenant operator logs in
						if (cv && cv.orgId) {
							if (_routeHasRole(route, TENANT_ADMIN)) {
								_addLevelandModifyData(route, level);
							}
						} else {
							_addLevelandModifyData(route, level);
						}
					}
				});
			}
		};

		const _updateList = (model, editOp, stateName) => {
			if (model && editOp !== null && stateName) {
				switch (editOp) {
					case 0:
						if (model.has(stateName)) {
							model.delete(stateName);
						}
						break;
					case 1:
						if (!model.has(stateName)) {
							model.add(stateName);
						}
						break;
				}
			}
		};
		/**
		 * editOperation : 0 remove, 1 : add
		 * */
		const _updateHideNavItemsAndIncludeNavItems = (actionType, item, editOperation) => {
			if (
				item !== null &&
				item !== undefined &&
				!angular.isArray(item.children) &&
				item.state !== null &&
				item.state !== undefined
			) {
				switch (actionType) {
					case 'hideNavItem':
						_updateList(self.hideNavItemsList, editOperation, item.state);
						break;
					case 'includeNavItem':
						_updateList(self.includeNavItemsList, editOperation, item.state);
						break;
				}
			}
		};

		// This ng-Change event triggers when the indiviudal check boxes are ticked. What it does is when a check box is ticked or unticked , if the nav has children all the n level deep children will obey the change.
		self.selectAndUpdateTicks = (navItem, roleName) => {
			if (navItem != null && !_.isUndefined(navItem) && roleName != null && !_.isUndefined(roleName)) {
				switch (roleName) {
					case 'hideNavItem': {
						if (navItem.hideNavItem === true) {
							_updateHideNavItemsAndIncludeNavItems('hideNavItem', navItem, 1);
							if (navItem.includeNavItem === true) {
								navItem.includeNavItem = false;
								_updateHideNavItemsAndIncludeNavItems('includeNavItem', navItem, 0);
							}
						} else {
							_updateHideNavItemsAndIncludeNavItems('hideNavItem', navItem, 0);
						}

						break;
					}
					case 'includeNavItem': {
						if (navItem.includeNavItem === true) {
							_updateHideNavItemsAndIncludeNavItems('includeNavItem', navItem, 1);
							if (navItem.hideNavItem === true) {
								navItem.hideNavItem = false;
								_updateHideNavItemsAndIncludeNavItems('hideNavItem', navItem, 0);
							}
						} else {
							_updateHideNavItemsAndIncludeNavItems('includeNavItem', navItem, 0);
						}
						break;
					}
				}

				if (angular.isArray(navItem.children)) {
					if (angular.isDefined(navItem[roleName + 'atleastOneChildSelected'])) {
						navItem[roleName + 'atleastOneChildSelected'] = false;
					}
					navItem.children.forEach(function(childItem) {
						switch (roleName) {
							case 'hideNavItem': {
								/**
								 * This check is not needed at parent level because we have disabled that selection using ng-disabled
								 * hideNavItems is done only for
								 *   a. Any state for non master user group
								 *   b. Any state but for navigationPreferences for master userGroup
								 * */
								if (
									parseInt(self.userGroupId) !== 1 ||
									(parseInt(self.userGroupId) === 1 && childItem.state !== 'navigationPreferences')
								) {
									childItem.hideNavItem = navItem.hideNavItem;
									if (childItem.hideNavItem === true) {
										_updateHideNavItemsAndIncludeNavItems('hideNavItem', childItem, 1);
										if (childItem.includeNavItem === true) {
											childItem.includeNavItem = false;
											_updateHideNavItemsAndIncludeNavItems('includeNavItem', childItem, 0);
										}
									} else {
										_updateHideNavItemsAndIncludeNavItems('hideNavItem', childItem, 0);
									}
									break;
								}
							}
							case 'includeNavItem': {
								if (
									parseInt(self.userGroupId) !== 1 ||
									(parseInt(self.userGroupId) === 1 && childItem.state !== 'navigationPreferences')
								) {
									childItem.includeNavItem = navItem.includeNavItem;
									if (childItem.includeNavItem === true) {
										_updateHideNavItemsAndIncludeNavItems('includeNavItem', childItem, 1);
										if (childItem.hideNavItem === true) {
											childItem.hideNavItem = false;
											_updateHideNavItemsAndIncludeNavItems('hideNavItem', childItem, 0);
										}
									} else {
										_updateHideNavItemsAndIncludeNavItems('includeNavItem', childItem, 0);
									}
									break;
								}
							}
						}
						if (angular.isArray(childItem.children)) {
							self.selectAndUpdateTicks(childItem, roleName);
						}
					});
				}
			}
		};

		//This pieced of code is executed, when we click on save link on Page
		const _updatePrefrences = () => {
			const additionalSettingsList = [
				{
					keyName: EXCLUDE,
					value: [...self.hideNavItemsList].join(','),
					relativepath: RELPATH_ADMINCONSOLE,
					deleted: 0,
					type: 'MULTISTRING',
					enabled: 1
				},
				{
					keyName: INCLUDE,
					value: [...self.includeNavItemsList].join(','),
					relativepath: RELPATH_ADMINCONSOLE,
					deleted: 0,
					type: 'MULTISTRING',
					enabled: 1
				}
			];

			self.userService
				.editUserGroup({
					userGroupId: JSON.stringify(self.userGroupId),
					serviceType: JSON.stringify(self.serviceType),
					providerId: JSON.stringify(self.providerId),
					additionalSettings: JSON.stringify(additionalSettingsList)
				})
				.success(data => {
					this.cvToaster.showSuccessMessage({
						message: this.cvLoc('info.savedPreferences')
					});
				})
				.error(error => {
					this.$log.error('Error updating userGroup navigation preferences');
					this.cvToaster.showErrorMessage({
						message: this.cvLoc('error.errorSavingPreferences')
					});
				});
		};
		const _localizecvTitleUtil = navItem => {
			if (navItem.cvTitle !== null && angular.isDefined(navItem.cvTitle)) {
				navItem.cvTitle = navItem.titleLocalized ? navItem.cvTitle : this.cvLoc(navItem.cvTitle);
			}
		};

		// Utility function to localize the title of navs and its subchildren
		const _localizecvTitle = navItem => {
			_localizecvTitleUtil(navItem);
			if (angular.isArray(navItem.children)) {
				navItem.children.forEach(function(child) {
					_localizecvTitle(child);
				});
			}
		};

		// This is helper function for handling parent ticks.

		self.checkChildrenAndUpdateTick = (nav, role) => {
			var navresult = true;
			var childresult = true;
			var atLeastOneChildSelected = false;

			nav.children.forEach(child => {
				if (child.showNavItem) {
					var subchildresult = true;
					if (angular.isArray(child.children) && child.children.length > 0) {
						subchildresult = subchildresult && self.checkChildrenAndUpdateTick(child, role);
						atLeastOneChildSelected = atLeastOneChildSelected || child[role + 'atleastOneChildSelected'];
						childresult = childresult && subchildresult;
					} else {
						childresult = childresult && child[role];
						atLeastOneChildSelected = atLeastOneChildSelected || child[role];
					}
					navresult = navresult && childresult;
				}
			});
			nav[role + 'atleastOneChildSelected'] = atLeastOneChildSelected;
			return navresult;
		};

		// This method is used to handle parent ticks based on children selection. If all children are selected , the parent will be ticked otherwise it will be unticked.

		const _parentElementTicksHandler = () => {
			self.navsToShow.forEach(nav => {
				if (angular.isDefined(nav) && angular.isDefined(nav.children) && nav.children.length > 0) {
					nav.hideNavItem = self.checkChildrenAndUpdateTick(nav, 'hideNavItem');
					nav.includeNavItem = self.checkChildrenAndUpdateTick(nav, 'includeNavItem');
				}
			});
		};

		const _getUserGroupDeniedNavItems = () => {
			self.userService
				.getUserGroup(self.userGroupId)
				.success(userGroupData => {
					self.serviceType = userGroupData.serviceType ? userGroupData.serviceType : '';
					self.providerId = userGroupData.provider ? userGroupData.provider.providerId : 0;

					if (userGroupData && angular.isObject(userGroupData) && userGroupData.hasOwnProperty('additionalSettings')) {
						const hideNavItemsSetting = userGroupData.additionalSettings.filter(setting => {
							return setting && setting.keyName && setting.keyName === EXCLUDE;
						});
						const includeNavItemsSetting = userGroupData.additionalSettings.filter(setting => {
							return setting && setting.keyName && setting.keyName === INCLUDE;
						});
						if (
							hideNavItemsSetting &&
							hideNavItemsSetting[0] &&
							hideNavItemsSetting[0].enabled === 1 &&
							_isValidString(hideNavItemsSetting[0].value)
						) {
							self.hideNavItemsList = new Set(hideNavItemsSetting[0].value.trim(' ').split(','));
						} else {
							self.hideNavItemsList = new Set();
						}
						if (
							includeNavItemsSetting &&
							includeNavItemsSetting[0] &&
							includeNavItemsSetting[0].enabled === 1 &&
							_isValidString(includeNavItemsSetting[0].value)
						) {
							self.includeNavItemsList = new Set(includeNavItemsSetting[0].value.trim(' ').split(','));
						} else {
							self.includeNavItemsList = new Set();
						}
					} else {
						self.hideNavItemsList = new Set();
						self.includeNavItemsList = new Set();
					}
					/**
					 * localizing iterates once over navs, so if it is MSP admin, localizing is left so we are doing it and loading self.routes.
					 */
					if (cv && cv.orgId === 0) {
						// We need to localize the title before storing in datamodel used for grid. So below iteration will do that
						self.navs.forEach(function(nav) {
							_localizecvTitle(nav);
						});

						self.routes = angular.copy(self.navs); // We are making a copy here because when we get the changes in settings we will do the changes on this model.
					}

					_setupDefaultModel();
					_parentElementTicksHandler();
				})
				.error(uGErrorData => {
					this.$log.error('Error loading HideNav List');
					this.cvToaster.showErrorMessage({
						message: this.cvLoc('error.errorLoadingNavigationPreferences')
					});
				});
		};

		const _addRemoveRolesToRoutesIfNotPresent = (deniedNavItemsListTenantAdmin, individualRoute, parentRoute) => {
			if (individualRoute.cvTitle && angular.isDefined(individualRoute.cvTitle)) {
				if (angular.isArray(individualRoute.children) && individualRoute.children.length > 0) {
					individualRoute.children.forEach(function(child) {
						_addRemoveRolesToRoutesIfNotPresent(deniedNavItemsListTenantAdmin, child, individualRoute);
					});
				}

				_localizecvTitleUtil(individualRoute);

				//All Child nodes are checked if it is not present in deniedNavItemsListTenantAdmin and it doesnot have role, append that role
				if (
					individualRoute.state &&
					angular.isDefined(individualRoute) &&
					angular.isUndefined(individualRoute.children) &&
					individualRoute.showNavItem
				) {
					// if route is not present in denied nav items list, then add role to that state else if it is present then in denied nav Items and state has the role, then we need to remove it.

					if (!deniedNavItemsListTenantAdmin.has(individualRoute.state)) {
						if (!angular.isArray(individualRoute.roles) || angular.isUndefined(individualRoute.roles)) {
							individualRoute.roles = [];
						}

						if (!individualRoute.roles.includes(TENANT_ADMIN)) {
							individualRoute.roles.push(TENANT_ADMIN);
							if (!angular.isArray(parentRoute.roles) || angular.isUndefined(parentRoute.roles)) {
								parentRoute.roles = [];
							}
							if (!parentRoute.roles.includes(TENANT_ADMIN)) {
								parentRoute.roles.push(TENANT_ADMIN);
							}
						}
					} else {
						if (
							angular.isArray(individualRoute.roles) &&
							individualRoute.roles.length >= 0 &&
							individualRoute.roles.includes(TENANT_ADMIN)
						) {
							var index = individualRoute.roles.indexOf(TENANT_ADMIN);
							if (index > -1) {
								individualRoute.roles.splice(index, 1);
							}

							if (
								angular.isDefined(parentRoute.children) &&
								angular.isArray(parentRoute.children) &&
								parentRoute.children.length > 0
							) {
								var removeTenantAdminRoleForParent = true;
								parentRoute.children.forEach(function(child) {
									if (angular.isArray(child.roles) && child.roles.includes(TENANT_ADMIN)) {
										removeTenantAdminRoleForParent = false;
									}
								});

								if (removeTenantAdminRoleForParent) {
									var parentIndex = parentRoute.roles.indexOf(TENANT_ADMIN);
									if (parentIndex > -1) {
										parentRoute.roles.splice(index, 1);
									}
								}
							}
						}
					}
				}
			}
		};

		/*
            This function fetches the Organization denied navigation item
        */
		const _getOrganizationNavigationPreferences = organizationId => {
			const internalPromises = [];
			internalPromises.push(this.customizationService.getRoleToDeniedNavs());
			internalPromises.push(this.customizationService.getHideNavsList(organizationId));
			this.$q
				.all(internalPromises)
				.then(function(results1) {
					const roleToDeniedNavs = results1[0].data;
					const navSettingsResponse = results1[1].data.navSettings;
					//If we are checking userGroup at companyLevel or changing company context and checking this
					self.companyDeniedNavItems = new Set();
					self.companyDeniedNavItems = new Set(roleToDeniedNavs.Role_Tenant_Admin);
					if (
						!angular.equals({}, navSettingsResponse) &&
						angular.isArray(navSettingsResponse.globalSettings) &&
						navSettingsResponse.globalSettings.length > 0
					) {
						const globalCompanyDeniedNavs = navSettingsResponse.globalSettings.filter(
							navSetting => navSetting.userRole && navSetting.userRole === TENANT_ADMIN
						);
						const companyNavSettingForTenantAdmin = navSettingsResponse.companySettings.filter(
							navSetting => navSetting.userRole && navSetting.userRole === TENANT_ADMIN
						);
						if (
							angular.isArray(globalCompanyDeniedNavs) &&
							globalCompanyDeniedNavs[0] != null &&
							globalCompanyDeniedNavs[0].deniedNavItems != null
						) {
							self.companyDeniedNavItems = new Set(globalCompanyDeniedNavs[0].deniedNavItems.trim(' ').split(','));
						}
						// If include navigation items are set at company level, we will show this included item on the left tree.
						if (
							angular.isArray(companyNavSettingForTenantAdmin) &&
							companyNavSettingForTenantAdmin[0] != null &&
							companyNavSettingForTenantAdmin[0].includeNavItems != null
						) {
							const companyTenantAdminIncludeNavItems = companyNavSettingForTenantAdmin[0].includeNavItems
								.trim(' ')
								.split(',');
							angular.forEach(companyTenantAdminIncludeNavItems, function(includeNavItem) {
								if (self.companyDeniedNavItems.has(includeNavItem)) {
									self.companyDeniedNavItems.delete(includeNavItem);
								}
							});
						}
					}

					// We need to localize the title before storing in datamodel used for grid. We also need to add remove the roles to navigaiton items based on organization denied nav items list so we would need one more iteration over each route so combining the two together.
					self.navs.forEach(function(nav) {
						_addRemoveRolesToRoutesIfNotPresent(self.companyDeniedNavItems, nav, nav);
					});
					self.routes = angular.copy(self.navs); // We are making a copy here because when we get the changes in settings we will do the changes on this model.
					_getUserGroupDeniedNavItems();
				})
				.catch(function(err) {
					this.$log.error('Error loading Organization denied nav List');
					this.cvToaster.showErrorMessage({
						message: this.cvLoc('error.errorLoadingNavigationPreferences')
					});
				});
		};

		// This is the starting point of the controller where the controller gets the acNav.json information
		this.customizationService
			.getNavList(angular.isDefined(cv.orgId) ? parseInt(cv.orgId) : 0)
			.success(function(data) {
				self.navs = data.routes;
				//This if will be executed only when orgId is non zero
				if (cv && cv.orgId) {
					_getOrganizationNavigationPreferences(cv.orgId);
				} else {
					_getUserGroupDeniedNavItems();
				}
			})
			.error(function(navListErrorData) {
				this.$log.error('Error loading Nav List');
				this.cvToaster.showErrorMessage({
					message: this.cvLoc('error.errorLoadingNavList')
				});
			});

		// This function is triggered when save is clicked
		self.saveCustomization = () => {
			self.$dialogs.confirm(self.cvLoc('label.save'), self.cvLoc('prompt.saveChanges'), {
				noFunction: function() {},
				yesFunction: function() {
					_updatePrefrences(true);
					_parentElementTicksHandler();
				}
			});
		};

		self.isDisabled = stateName => {
			/* Navigation preferences tab cannot be hidden from Master Group users
			 */

			if (
				stateName &&
				stateName.length >= 1 &&
				stateName === 'navigationPreferences' &&
				parseInt(self.userGroupId) === 1
			) {
				return true;
			} else {
				return false;
			}
		};
		// Defining pageLinks for cvGrid
		self.cvPageLinks = [
			{
				label: this.cvLoc('label.save'),
				onclick: self.saveCustomization // Open Modal for confirmation
			}
		];
		self.columnDefs = [
			{ name: this.cvLoc('gridHeader.name'), field: 'cvTitle', width: '30%', headerCellClass: 'left-align' },
			{
				field: 'hideNavItem',
				displayName: this.cvLoc('label.exclude'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'hideNavItem\'}}"  class=""  data-ng-disabled="grid.appScope.isDisabled(row.entity.state)" data-ng-model="row.entity.hideNavItem" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'hideNavItem\')" data-ng-class="{\'partial-selection\': !row.entity.hideNavItem && row.entity.hideNavItematleastOneChildSelected}" />' +
					'<label for="{{row.entity.state + \'hideNavItem\'}}">&nbsp;</label>'
			}
		];

		if (cv.isMspAdmin) {
			self.columnDefs.splice(1, 0, {
				field: 'includeNavItem',
				displayName: this.cvLoc('label.include'),
				cellTemplate:
					'<input type="checkbox" id="{{row.entity.state + \'includeNavItem\'}}"  class=""  data-ng-disabled="grid.appScope.isDisabled(row.entity.state)" data-ng-model="row.entity.includeNavItem" data-ng-change="grid.appScope.selectAndUpdateTicks(row.entity,\'includeNavItem\')" data-ng-class="{\'partial-selection\': !row.entity.includeNavItem && row.entity.includeNavItematleastOneChildSelected}" />' +
					'<label for="{{row.entity.state + \'includeNavItem\'}}">&nbsp;</label>'
			});
		}

		// GridOptions to create cvGrid
		self.gridOptions = {
			cvIsPageTitle: true,
			cvPageLinks: self.cvPageLinks,
			cvGridCssClass: 'grid-style users-grid ui-tree-grid navigation-preferences',
			cvIsSearchable: true,
			cvHasTitle: true,
			cvSearchHandler: function(searchtext) {
				if (self.gridApi && searchtext.length >= 1) {
					self.gridApi.treeBase.expandAllRows();
				} else {
					self.gridApi.treeBase.collapseAllRows();
				}
			},
			cvAppScope: self,
			cvSearchFields: ['cvTitle'],
			cvInfoText: this.cvLoc('label.userGroupNavigationPreferencesInfoText', self.userGroupName),
			cvGridTitle: angular.isDefined(self.userGroupName)
				? this.cvLoc('pageHeader.navcustomization') + ' - ' + self.userGroupName
				: this.cvLoc('pageHeader.navcustomization'),
			cvGridDirectives: {
				uiGridTreeView: true,
				uiGridPagination: false
			},
			gridOptions: angular.extend(angular.copy(this.cvTableOptions.commonNgGridOptions), {
				data: 'navsToShow',
				enableSorting: true,
				enableFiltering: true,
				enableTreeView: true,
				showTreeExpandNoChildren: false,
				onRegisterApi: function(gridApi) {
					self.gridApi = gridApi;
				},
				enablePaginationControls: false,
				enableGridMenu: false,
				paginationPageSize: 100,
				columnDefs: self.columnDefs
			})
		};
	}
}
UserGroupNavigationPrefController.$inject = [
	'$log',
	'$dialogs',
	'cvLoc',
	'cvTableOptions',
	'$stateParams',
	'customizationService',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'userService',
	'$q'
];
navCustomizationModule.controller('userGroupNavigationPreferencesController', UserGroupNavigationPrefController);
export default navCustomizationModule;
