import 'modules/navCustomization/js/services/customization.svc.js';
import 'adminConsole/js/controllers/reports.ctrl.js';
import 'dlo/js/services/customization.svc.js';
import 'adminConsole/js/factories/reports.factory.js';
import 'modules/navCustomization/js/factory/customization.factory.js';

import { navCustomizationModule } from 'common/js/modules';

var navCustomizationMod = navCustomizationModule;

navCustomizationMod.controller('overrideLandingController', [
	'$log',
	'cvUtil',
	'$dialogs',
	'cvLoc',
	'cvTableOptions',
	'customizationService',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'customReportsFactory',
	'$q',
	'customizationFactory',
	'tabService',
	function(
		$log,
		cvUtil,
		$dialogs,
		cvLoc,
		cvTableOptions,
		customizationService,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		customReportsFactory,
		$q,
		customizationFactory,
		tabService
	) {
		var self = this;
		// This is the data-model which is created for setting the content in Customization Page
		self.isTenantAdmin = cv.isTenantAdmin;
		self.userRole = cv.userRole;
		self.stateToReportMap = {};

		tabService.init({ tabs: customizationFactory.getTabsForState('overrideLanding', undefined, undefined) });

		//We need to set the levels on each nav for having that hierarchy and each Nav should be a part of the array so in below function we do the following things:-
		//  1. set the hierarchy level
		// 	2. Set the roles of the navItem. (Setting roles is nothing but setting the corresponding role of the navItem to true or false which is used in selecting the checkbox)
		// 	3. Push the content in model and continue checking for its children.

		self.addLevelandModifyData = function(navItem, level) {
			if (
				angular.isDefined(navItem) &&
				navItem.state &&
				angular.isDefined(navItem.state) &&
				navItem.state !== 'navigationPreferences'
			) {
				navItem.$$treeLevel = level;

				self.navsToShow.push(navItem);
				if (angular.isArray(navItem.children)) {
					navItem.children.forEach(function(child) {
						if (child.showNavItem) {
							self.addLevelandModifyData(child, level + 1);
						}
					});
				}
			}
		};
		// This function is used to setup the cvGrid data model for the first time and when we click reset to default
		self.setupDefaultModel = function() {
			if (angular.isDefined(self.routes)) {
				self.routes.forEach(function(route) {
					if (route.showNavItem) {
						var level = 0;
						self.addLevelandModifyData(route, level);
					}
				});
			}
		};

		//This function is used to set the overrideLanding report for navigation in addition to localization of cvTitle
		self.localizecvTitleAndSetDefaultReport = function(navItem) {
			if (navItem.cvTitle !== null && angular.isDefined(navItem.cvTitle)) {
				navItem.cvTitle = navItem.titleLocalized ? navItem.cvTitle : cvLoc(navItem.cvTitle);
			}
			navItem.reportsList = angular.copy(self.reportsList);
			navItem.reportsList.forEach(function(report) {
				report.ticked = false;
			});
			if (angular.isArray(navItem.children)) {
				navItem.children.forEach(function(child) {
					self.localizecvTitleAndSetDefaultReport(child);
				});
			}
		};

		//This function is used for overriding the report selection. If any nav has the report overriden, we set the report's tick property to true.
		self.overRideReportPreferences = function() {
			self.navsToShow.forEach(function(nav) {
				if (angular.isDefined(self.stateToReportMap) && angular.isDefined(self.stateToReportMap[nav.state])) {
					nav.reportsList.forEach(function(report) {
						if (report.reportName === self.stateToReportMap[nav.state]) {
							report.ticked = true;
						}
					});
				}
			});
		};

		//Make multiple api calls, and once all the reponses are received , the code inside would be executed.
		$q.all([
			customReportsFactory.getReportsList(),
			customizationService.getNavList(0),
			customizationService.getStateToReportMap()
		]).then(
			function(responses) {
				self.reportsList = [];
				self.dashBoardReports = [
					{ reportName: 'Cloudapps Dashboard' },
					{ reportName: 'Virtualization Dashboard' },
					{ reportName: 'Endpoint Dashboard' },
					{ reportName: 'Servers Dashboard' }
				];
				self.navsToShow = [];
				self.reportsList = responses[0].data.reports;
				self.navs = responses[1].data.routes;
				self.dashBoardReports.forEach(function(dashboardReport) {
					self.reportsList.unshift(dashboardReport);
				});
				if (self.navs) {
					//This is done to remove webConsole Links to be overriden by some other report
					var indexOfWC = self.navs.findIndex(item => item.state === 'webconsole');
					if (indexOfWC > 0) {
						self.navs.splice(indexOfWC, 1);
					}
					self.navs.forEach(function(nav) {
						self.localizecvTitleAndSetDefaultReport(nav);
					});
					self.routes = angular.copy(self.navs);
					self.defaultNavs = angular.copy(self.navs);
					self.setupDefaultModel();
				}
				if (responses[2].data) {
					self.stateToReportMap = responses[2].data;
					self.overRideReportPreferences();
				}
			},
			function() {
				cvToaster.showErrorMessage({
					message: cvLoc('error.errorLoadingNavigationLandingPreferences')
				});
				$log.error('Error loading state to report map');
			}
		);

		self.submit = function(savePreferences) {
			self.stateToReportMap = {};
			self.navsToShow.forEach(function(nav) {
				if (
					nav.selectedReportCommcellAdmin !== null &&
					angular.isDefined(nav.selectedReportCommcellAdmin) &&
					nav.selectedReportCommcellAdmin.length >= 1
				) {
					self.stateToReportMap[nav.state] = nav.selectedReportCommcellAdmin[0].reportName;
				}
			});
			customizationService
				.setUpdateStateToReportMap(self.stateToReportMap)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: savePreferences ? cvLoc('info.savedPreferences') : cvLoc('info.resetPreferences')
					});
				})
				.error(function(data) {
					$log.error(data);
					cvToaster.showErrorMessage({
						message: savePreferences ? cvLoc('error.errorSavingPreferences') : cvLoc('error.resetting')
					});
				});
		};
		// This function is triggered when reset to default is clicked
		self.resetToDefault = function() {
			$dialogs.confirm(cvLoc('label.customizationReset'), cvLoc('prompt.resetToDefault'), {
				noFunction: function() {},

				yesFunction: function() {
					self.navsToShow = [];
					self.routes = angular.copy(self.defaultNavs);
					self.setupDefaultModel();
					self.submit(false);
				}
			});
		};

		self.saveCustomization = function() {
			$dialogs.confirm(cvLoc('label.save'), cvLoc('prompt.saveChanges'), {
				noFunction: function() {},

				yesFunction: function() {
					self.submit(true);
				}
			});
		};
		self.localLang = cvUtil.getIStevenLocLabels();
		self.cvPageLinks = [
			{
				label: cvLoc('label.customizationReset'),
				onclick: self.resetToDefault
			},
			{
				label: cvLoc('label.save'),
				onclick: self.saveCustomization // Open Modal for confirmation
			}
		];

		//This is used for resetting the ticked property of reportList
		self.resetSingleSelection = function(reportsList) {
			if (reportsList && angular.isDefined(reportsList) && reportsList.length > 0) {
				reportsList.forEach(function(report) {
					report.ticked = false;
				});
			}
		};

		self.columnDefs = [
			{ name: cvLoc('gridHeader.name'), field: 'cvTitle', width: '30%', headerCellClass: 'left-align' },
			{
				field: 'reportsList',
				displayName: cvLoc('label.overrideReport'),
				cellTemplate:
					'<div data-ng-if="row.entity.children === null || row.entity.children === undefined" class="col-xs-12 col-md-8 col-lg-8">' +
					'<isteven-multi-select input-model="row.entity.reportsList" output-model="row.entity.selectedReportCommcellAdmin" output-properties="reportName" button-label="reportName" item-label="reportName" tick-property="ticked" class="isteven-multi-select user-group-select" id="reportsList" search-property="reportName" name="ReportsList" helper-elements="reset filter" max-labels="1" selection-mode="single" translation="grid.appScope.localLang" disable-property="disabled" on-reset="grid.appScope.resetSingleSelection(row.entity.reportsList)"></isteven-multi-select>' +
					'</div>'
			}
		];

		self.gridOptions = {
			cvIsPageTitle: true,
			cvPageLinks: self.cvPageLinks,
			cvGridCssClass: 'grid-style nav-grid',
			cvIsSearchable: true,
			cvSearchHandler: function(searchtext) {
				if (self.gridApi && searchtext.length >= 1) {
					self.gridApi.treeBase.expandAllRows();
				} else {
					self.gridApi.treeBase.collapseAllRows();
				}
			},
			cvHasTitle: true,
			cvAppScope: self,
			cvInfoText: cvLoc('label.overrideLandingInfoText'),
			cvSearchFields: ['cvTitle'],
			cvGridTitle: cvLoc('label.nav.overrideLanding'),
			cvGridDirectives: {
				uiGridTreeView: true,
				uiGridPagination: false
			},
			gridOptions: angular.extend(angular.copy(cvTableOptions.commonNgGridOptions), {
				data: 'navsToShow',
				enableSorting: true,
				enableTreeView: true,
				onRegisterApi: function(gridApi) {
					self.gridApi = gridApi;
				},
				enableFiltering: true,
				showTreeExpandNoChildren: false,
				enablePaginationControls: false,
				enableGridMenu: false,
				paginationPageSize: 100,
				columnDefs: self.columnDefs
			})
		};

		// Add breadcrumbs

		var breadCrumbs = [];

		breadCrumbs.push({
			title: cvLoc('label.nav.masterCustomization'),
			link: '#nav/masterCustomization'
		});

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}
]);
export default navCustomizationMod;
