<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div>
    <div class="setup-title">
        <h1>
            <cv:msg key="label.selectSnapEngines" bundle="nas" />
        </h1>
    </div>
    <div class="setup-content">
        <span class="{{editSnapEngineCtrl.serverMessage.type}} serverMessage">{{editSnapEngineCtrl.serverMessage.message}}</span>
        <form name="editSnapForm" novalidate cv-submit="editSnapEngineCtrl.updateSnapEngineSettings()"
            autocomplete="off" class="add-collection-form">
            <label for="snapEngines" class="" ><cv:msg key="label.selectSnapEngines" bundle="nas"/>
                <div class="company-multi-select">
                    <isteven-multi-select
                          input-model="editSnapEngineCtrl.snapEngineList"
                          output-model="editSnapEngineCtrl.selectedSnapEngine"
                          button-label="name"
                          item-label="name"
                          tick-property="selected"
                          class="isteven-multi-select user-group-select"
                          id="snapEngines"
                          name="snapEngines"
			  			  helper-elements="{{editSnapEngineCtrl.helperElements}}"
			  			  selection-mode="{{editSnapEngineCtrl.selectionMode}}"
                          max-labels="1"
                          translation="editSnapEngineCtrl.localLang"
                          on-item-click="editSnapEngineCtrl.validateNodeSelection()"
                          on-select-none="editSnapEngineCtrl.validateNodeSelection()"
                          on-select-all="editSnapEngineCtrl.validateNodeSelection()"
                          on-reset="editSnapEngineCtrl.validateNodeSelection()"
                          group-property="msGroup">
                    </isteven-multi-select>
                </div>
                <span class="help-block" data-ng-show="editSnapEngineCtrl.showSnapEngineErrorMessage"><cv:msg key="error.selectSnapEngines" bundle="nas"/></span>
            </label>
            <div class="button-container">
                    <button id="snapEnginePopup_button_#2979" type="button" class="btn btn-default cvBusyOnAjax" 
                        data-ng-click="editSnapEngineCtrl.cancel()">
                        <cv:msg key="Cancel" bundle="messages" />
                    </button>
                    <button id="snapEnginePopup_button_#6543" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                        <cv:msg key="Save" bundle="messages" />
                    </button>
            </div>
        </form>
    </div>
</div>
