<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<div>

    <script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
		<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
        <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
        <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    </script>

    <div class="setup-title">
        <h1>
            <label ng-if="!isEditMode"><cv:msg key="label.addNutanixFiles" bundle="servers"/></label>
        </h1>
    </div>

    <div class="nutanix-modal setup-content">
        <form name="addFileStorageForm" id="addFileStorageForm" novalidate autocomplete="off">
            <div class="form-horizontal bootstrap-wrapper modal-margin">

            	<!-- =====SERVERNAME===== -->
                <div class="form-group">
                        <label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="header.name" bundle="servers" /></label>
                        <div class="col-xs-12 col-md-8 col-lg-8">
						   <input type="text" class="col-xs-12 col-md-4 col-lg-4" data-ng-model="serverName" ng-change="nutanixCreateController.clientNameHelpTextProperty = (serverName.length > 0) ? false : true"/>
                           <span class="help-block padding-top-7" ng-if="nutanixCreateController.clientNameHelpTextProperty!=null && nutanixCreateController.clientNameHelpTextProperty"><cv:msg key="option.clientName" bundle="clients"/> </span>
                        </div>
                </div>

				<!-- =====PLAN===== -->
                <div class="form-group">
                    <label class="col-xs-12 col-md-4 col-lg-4" for="array"> <cv:msg key="label.fileServerHost" bundle="servers"/></label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
                        <isteven-multi-select input-model="arrayList" output-model="outputArrayList" button-label="name" id="nutanix-create-array"
                                              item-label="name" tick-property="selected"
                                              class="isteven-multi-select user-group-select" id="nutanixArrays" name="array"
                                              helper-elements="reset" selection-mode="single"
                                              translation = "nutanixCreateController.arrayListLabel"
                                              on-item-click="nutanixCreateController.selectArrayHelpTextPropertyCustom = (outputArrayList.length > 0) ? false : true"></isteven-multi-select>
                        <span class="help-block padding-top-7" data-ng-show="nutanixCreateController.selectArrayHelpTextPropertyCustom != null && nutanixCreateController.selectArrayHelpTextPropertyCustom"><cv:msg key="label.pleaseSelectHost" bundle="servers"/> </span>
                    </div>
                </div>

				<!-- =====HOST===== -->
                <div class="form-group">
                    <label class="col-xs-12 col-md-4 col-lg-4" for="plan"> <cv:msg key="label.profile" bundle="profiles"/> </label>
                    <div class="col-xs-12 col-md-8 col-lg-8">
                        <isteven-multi-select input-model="planList" output-model="outputPlanList" button-label="name" id="nutanix-create-plan"
                        					  item-label="name" tick-property="selected"
                                              class="isteven-multi-select user-group-select" id="plans" name="plans"
                                              helper-elements="reset" selection-mode="single" on-reset="onResetPlans"
                                              translation = "nutanixCreateController.planListLabel"
                                              on-item-click="nutanixCreateController.selectPlanHelpTextPropertyCustom = (outputPlanList.length > 0) ? false : true"></isteven-multi-select>
                       <span class="help-block padding-top-7" data-ng-show="nutanixCreateController.selectPlanHelpTextPropertyCustom != null && nutanixCreateController.selectPlanHelpTextPropertyCustom"><cv:msg key="label.selectPlan" bundle="servers"/> </span>
                    </div>
                </div>

				<div data-ng-repeat="(key, data) in backupMethodsData track by key">
					<div class="form-group">
                         <label class="col-xs-12 col-md-4 col-lg-4" for="backuptype">
                              <toggle-control data-ng-class="{'nutanix-create-enable-toggle-cifs': key === 'cifs' }" class="nutanix-create-enable-toggle add-full-backup-toggle" status="data.enabled ? 'enabled-activity' : 'disabled-activity'"
                                              title="<cv:msg key="label.enableDisable" bundle="messages" />"
                                              data-ng-click="data.enabled = !data.enabled;nutanixCreateController.selectBackupMethod=false;">
                              </toggle-control>
                              <span class="padding-left-5" for="{{key}}">{{key === 'cifs' ? ('label.cifs' | cvLoc) : ('label.nfs' | cvLoc)}}</span>
                         </label>
                         <div class="col-xs-12 col-md-8 col-lg-8 inner-content"  data-ng-if="nutanixCreateController.selectBackupMethod && key === 'cifs'">
                         	<span class="help-block"><cv:msg key="error.backupTyeSelect" bundle="nas"/></span>
                         </div>
                    </div>

                    <div class="backup-method-block" data-ng-if="data.enabled">
                    	 <cv-nas-accessnodes-component data-accessnodeoptions="data.accessNodeOptions"></cv-nas-accessnodes-component>
						 <div data-ng-if="key === 'cifs'" class="form-group margin-bottom-0">
						 	 <div class="col-xs-12 col-md-4 col-lg-4">
						 	 	<h4 for="accessNodes" class="accessnode-label"><cv:msg key="label.impersonateUser" bundle="restore"/></h4>
						 	 </div>
						 	 <div class="col-xs-12 col-md-4 col-lg-4 inner-content">
								<span data-ng-if="impersonateUser.userName !== ''" data-ng-bind="impersonateUser.userName"></span>
								<span data-ng-if="impersonateUserCredentialinfo.credentialName !== ''" data-ng-bind="impersonateUserCredentialinfo.credentialName"></span>
                                <span data-ng-if="!impersonateUser.userName && impersonateUserCredentialinfo.credentialId === 0"  data-ng-class="{'help-block': nutanixCreateController.selectImpersonationHelpTextPropertyCustom}"><cv:msg key="label.noUserSelected" bundle="servers"/></span>
						 	 </div>
						 	 <div class="col-xs-12 col-md-4 col-lg-4">
								<div class="page-details-box-links"><a data-ng-click="showEditCredentials()"> <cv:msg key="action.edit" bundle="snapArray"/></a></div>
						 	 </div>
						 </div>

						  <div class="form-group ">
						  	  <div class="col-xs-12 col-md-4 col-lg-4"><h4 for="accessNodes" class="accessnode-label"><cv:msg key="label.backupContent" bundle="restore"/></h4></div>
						  	  <div class="col-xs-12 col-md-4 col-lg-4 inner-content">
									<span data-ng-if="key === 'cifs' && (!backupMethodsData.cifs.content['Content'] || backupMethodsData.cifs.content['Content'].length === 0)" ><cv:msg key="label.allCfsShares" bundle="servers"/></span>
									<span data-ng-if="key === 'nfs' && (!backupMethodsData.nfs.content['Content'] || backupMethodsData.nfs.content['Content'].length === 0) " ><cv:msg key="label.allNfsExports" bundle="servers"/></span>
						 	  </div>
						  	  <div class="col-xs-12 col-md-4 col-lg-4">
								<div class="page-details-box-links"><a data-ng-click="selectAccessNodes(key)"> <cv:msg key="action.edit" bundle="snapArray"/></a></div>
						  	  </div>
						  </div>
						  <div class="form-group ">
	                          <div data-ng-if="key === 'cifs'">
								    <div class="content-selection col-xs-12 col-md-12 col-lg-12" data-ng-repeat="(contentKey, contentValue) in backupMethodsData.cifs.content">
								    	<div class="col-xs-12 col-md-4 col-lg-4">
							 	 			<h5 for="accessNodes" class="accessnode-label">{{contentKey}}</h5>
							 	 		</div>
								    	<div class="col-xs-12 col-md-8 col-lg-8 inner-content" uib-popover-html="contentPopOver(contentKey,contentValue)" popover-trigger="'mouseenter'">
											<ul class="content-paths crop">
												<li class="path" data-ng-repeat="path in contentValue">{{path}}</li>
											</ul>
										</div>
									</div>
	                          </div>
	                          <div data-ng-if="key === 'nfs'">
								    <div class="content-selection col-xs-12 col-md-12 col-lg-12" data-ng-repeat="(contentKey, contentValue) in backupMethodsData.nfs.content">
								    	<div class="col-xs-12 col-md-4 col-lg-4">
							 	 			<h5 for="accessNodes" class="accessnode-label">{{contentKey}}</h5>
							 	 		</div>
								    	<div class="col-xs-12 col-md-8 col-lg-8 inner-content" uib-popover-html="contentPopOver(contentKey,contentValue)"  popover-trigger="'mouseenter'">
											<ul class="content-paths crop">
												<li class="path" data-ng-repeat="path in contentValue">{{path}}</li>
											</ul>
										</div>
									</div>
	                          </div>
                          </div>
                    </div>
				</div>

</form>

			<!-- =====SAVE AND CANCEL===== -->
            <div class="button-container">
                <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel"/></button>
                <button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="addNutanixFileServer()"><cv:msg key="Save"/></button>
            </div>

    </div>

    </div>
