<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<div>
<script>
    <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
</script>
	<div class="setup-title">
		<h1>
		     <label for="array">{{ctrl.headingLabel}}</label>
		</h1>
	</div>
	<div class="add-array-modal setup-content">
	<span class="{{ctrl.errorMessage.type}}" data-ng-bind="ctrl.errorMessage.message"></span>
	<form name="addArrayForm" id="addArrayForm" novalidate autocomplete="off" data-cv-submit="ctrl.addArray()">
	 	<div class="form-horizontal bootstrap-wrapper modal-margin">
		<p class="{{ctrl.previewMessage.type}} serverMessage">{{ctrl.previewMessage.message}}</p>
		    <!-- ===== Vendor List ===== -->
		   <div class="form-group" data-ng-if="ctrl.params.clientType === 'NAS'">
		      <label class="col-xs-12 col-md-4 col-lg-4" for="array"> <cv:msg key="label.vendorType" bundle="servers"/></label>
               <div class="col-xs-12 col-md-8 col-lg-8" >
                   <isteven-multi-select input-model="ctrl.vendorList" output-model="ctrl.selectedVendor" button-label="vendorName" id="nas-vendor-dropdown"
                                         item-label="vendorName" tick-property="selected"
                                         class="isteven-multi-select user-group-select" id="nasVendorList" name="vendors"
                                         helper-elements="reset" selection-mode="single"
                                         translation = "ctrl.vendorListLabel"
                                         on-item-click="ctrl.updateVendor()"></isteven-multi-select>
                   <span class="help-block padding-top-7" data-ng-show="ctrl.showErrors && ctrl.selectedVendor.length === 0"><cv:msg key="label.vendor.selectVendorType" bundle="nas"/> </span>
               </div>
           </div>

		    <div class="form-group">
                <label class="col-xs-12 col-md-4 col-lg-4" for="arrayNameInput" data-ng-bind="ctrl.arrayNameLabel"></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <input id="arrayNameInput" type="text" name="arrayNameInput" placeholder="{{ctrl.arrayNamPlaceholderText}}" data-ng-model="ctrl.arrayInfo.arrayName.name" data-ng-blur="ctrl.validateHostName()"/>
                    <span class="help-block padding-top-7" data-ng-show="ctrl.showErrors && !ctrl.arrayInfo.arrayName.name"><cv:msg key="error.arrayName" bundle="snapArray"/> </span>
                    <span class="help-block padding-top-7" data-ng-show="ctrl.showHostNameFQDNError"><cv:msg key="label.errorFQDN" bundle="nas"/></span>
                </div>
            </div>

            <div class="form-group" data-ng-if="ctrl.showControlHost">
                <label class="col-xs-12 col-md-4 col-lg-4" for="arrayNameInput"><cv:msg key="label.hostName" bundle="snapArray" /></label>
                <div class="col-xs-12 col-md-8 col-lg-8">
                    <input id="arrayNameInput" type="text" name="arrayNameInput" data-ng-model="ctrl.arrayInfo.ctrlHostName"/>
                    <span class="help-block padding-top-7" data-ng-show="ctrl.showErrors && !ctrl.arrayInfo.ctrlHostName"><cv:msg key="error.arrayHost" bundle="snapArray"/> </span>
                </div>
            </div>

            <div class="form-group">
                 <label class="col-xs-12 col-md-4 col-lg-4" for="arrayUserName">{{ctrl.userLabel}}</label>
                 <div class="col-xs-12 col-md-8 col-lg-8">
                     <input id="arrayUserName" type="text" name="arrayUserName" data-ng-model="ctrl.arrayInfo.userPswd.userName"  />
                     <span class="help-block padding-top-7" data-ng-show="ctrl.showErrors && !ctrl.arrayInfo.userPswd.userName"><cv:msg key="error.userName" bundle="archiving"/> </span>
                 </div>
             </div>

             <div class="form-group">
                  <label class="col-xs-12 col-md-4 col-lg-4" for="arrayPassword"><cv:msg key="label.password" bundle="users"/></label>
                  <div class="col-xs-12 col-md-8 col-lg-8">
                      <input id="arrayPassword" type="password" name="arrayPassword" data-ng-model="ctrl.arrayPassword"/>
                      <span class="help-block padding-top-7" data-ng-show="ctrl.showErrors && !ctrl.arrayPassword"><cv:msg key="error.password" bundle="archiving"/> </span>
                  </div>
              </div>

        <button type="button" data-ng-if="ctrl.params.clientType === 'NAS'" data-ng-click="ctrl.addArray(true)" class="btn btn-default pull-right cvBusyOnAjax margin-top-10 preview-button"><cv:msg key="label.preview" bundle="archiving"/></button>

					<!-- =====SAVE AND CANCEL===== -->
         <div class="button-container">
             <button type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="ctrl.cancel()"><cv:msg key="Cancel"/></button>
             <button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="ctrl.params.clientType !== 'NAS'"><cv:msg key="Save"/></button>
             <button type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-if="ctrl.params.clientType === 'NAS'"><cv:msg key="action.ok" bundle="snapArray"/></button>
         </div>
			</div>
	</form>
	</div>
</div>