import 'modules/nas/js/services/nas.svc.js';
import 'modules/nas/js/controllers/nas.ctrl.js';
import 'modules/nas/js/controllers/addArray.ctrl.js';
import 'modules/nas/js/components/cvNasMigrationPreview.component.js';
import 'archiving/js/components/migrateNasServer.component.js';
import {
	NAS_CONSTANTS,
	CLIENT_INFO,
	PROTOCOLS,
	SUPPORTED_SNAP_VENDORS,
	SUPPORTED_SNAP_OS_IDS
} from 'modules/nas/js/constants';

import { acAppNasModule } from 'common/js/modules';
var nasMod = acAppNasModule;
var factories = {};

factories.nasFactory = [
	'$location',
	'cvLoc',
	'nasService',
	'clientGroupService',
	'$state',
	'cvToaster',
	'$uibModal',
	'AppTypesUtil',
	'EntityTypesUtil',
	'cvUtil',
	function(
		$location,
		cvLoc,
		nasService,
		clientGroupService,
		$state,
		cvToaster,
		$modal,
		AppTypesUtil,
		EntityTypesUtil,
		cvUtil
	) {
		var factory = {};

		factory.openCreateNewNASClient = function() {
			let v2Style = _.get(cv, 'additionalSettings.Console.bEnableV2NasCreate', true);
			if (v2Style) {
				factory.openCreateNewNasServerClient();
			} else {
				return $modal.open({
					templateUrl: appUtil.appRoot + 'modules/nas/partials/addNasServer.jsp',
					backdrop: 'static',
					controller: 'addNasClientController as addNasCtrl'
				});
			}
		};

		factory.openNasPushInstall = function(addIdaParams, planEntity) {
			let v2Style = _.get(cv, 'additionalSettings.Console.bEnableV2NasCreate', true);
			if (v2Style) {
				factory.updateNasOrFileServerClient(addIdaParams, planEntity);
			} else {
				return $modal.open({
					templateUrl: appUtil.appRoot + 'modules/nas/partials/addNasServer.jsp',
					backdrop: 'static',
					controller: 'addIDAToNasClient as addNasCtrl',
					resolve: {
						addIdaParams: function() {
							return addIdaParams;
						}
					}
				});
			}
		};

		factory.createNasSubclient = function(params) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/addNasSubclient.jsp',
				controller: 'addNasSubclientController as addNasScCtrl',
				backdrop: 'static',
				resolve: {
					clientInfo: function() {
						return params.clientInfo;
					},
					agentInfo: function() {
						return params.agentInfo;
					},
					agentsList: function() {
						return params.agentsList;
					}
				}
			});
		};

		factory.getProxyList = function() {
			factory.proxyList = [];

			return nasService
				.getProxyList()
				.success(function(data) {
					factory.proxyList = data;
				})
				.error(function(data) {
					$log.error('Error loading proxy list');
				});
		};

		/*
		 * Generic browse options required for NAS / Nutanix File server browse for CIFS|NFS|NDMP agents.The
		 * same object will be reused at 1. Nutanix create client screen 2. Agent details subclient creation
		 * 3. Agent details page subclinet content add / edit 4. Subclient details edit content tile.
		 *
		 */
		factory.getContentOptionsForBrowse = function(options) {
			let proxyType = options.appId == 33 ? 'windows' : 'linux';
			let nasContentOptions = {
				isNetworkShareBrowse: !AppTypesUtil.isNASAgent(options.appId),
				isNAS: true,
				isFileServer: true,
				isFileStorageServer: options.isFileStorageServer,
				applicationId: options.appId,
				hideShowAsUser: options.hideShowAsUser,
				subclientDetails: {
					subClientEntity: {
						applicationId: options.appId,
						interfacePath: options.fsHost
					},
					fsSubClientProp: {
						enableNetworkShareAutoMount: options.enableNetworkShareAutoMount
					}
				},
				hideProxySelection: options.isFileStorageServer || AppTypesUtil.isNASAgent(options.appId) ? true : false,
				nasBrowseOptions: {
					appId: options.appId,
					enableAutomountBrowse: true,
					interfacePath: options.fsHost,
					ndmpRequest: _.get(options, 'ndmpRequest'), // ndmp browse during client creation
					arrayInfo: _.get(options, 'arrayInfo'),
					planId: _.get(options, 'planEntity.planId'),
					intelliSnapEnabled: options.intelliSnapEnabled,
					proxyOptional: !options.isArchival // archival access nodes are required
				}
			};
			let selectedAccessNode = options.backupAccessNodes && options.backupAccessNodes[0];

			if (selectedAccessNode) {
				if (typeof selectedAccessNode.clientGroupId !== 'undefined') {
					nasContentOptions.nasBrowseOptions.proxy = selectedAccessNode.clientGroupId;
					nasContentOptions.isClientGroup = true;
				} else {
					nasContentOptions.nasBrowseOptions.proxy = selectedAccessNode.clientId;
				}

				if (!AppTypesUtil.isNASAgent(options.appId)) {
					nasContentOptions.clientId = selectedAccessNode.clientGroupId;
				}
			} else if (!AppTypesUtil.isNASAgent(options.appId)) {
				nasContentOptions.clientId = 0;
				nasContentOptions.nasBrowseOptions.proxy = 0;
			}

			return nasContentOptions;
		};

		factory.openNetworkShareAutoMountBrowse = function(params) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/nsAutoMountBrowse.jsp',
				controller: 'nsAutoMountBrowseController as nsAutoMountCtrl',
				backdrop: 'static',
				resolve: {
					subclientInfo: function() {
						return params.subclientInfo;
					},
					nasBrowseOptions: function() {
						return params.nasBrowseOptions;
					}
				},
				windowClass: 'small-size'
			});
		};

		function getProtocolParams(appId) {
			switch (appId) {
				case 33:
					return {
						appId: 33,
						label: NAS_CONSTANTS.CIFS,
						osType: 1,
						contentLabel: cvLoc('label.allCfsShares')
					};
				case 29:
					return {
						appId: 29,
						label: NAS_CONSTANTS.NFS,
						osType: 2,
						contentLabel: cvLoc('label.allNfsExports')
					};
				case 13:
					return {
						appId: 13,
						label: NAS_CONSTANTS.NDMP,
						contentLabel: cvLoc('label.allVolumes')
					};
				default:
					undefined;
			}
		}

		factory.openCreateNewNasServerClient = function() {
			factory.addUpdateNasOrFileServers({
				serverType: NAS_CONSTANTS.NAS,
				label: cvLoc('heading.AddNASServer'),
				labelHelp: cvLoc('label.addNasHelpText'),
				createSuccessMessage: cvLoc('toast.nasServerCreated')
			});
		};

		factory.openCreateNewNutanixFilesClient = function() {
			factory.addUpdateNasOrFileServers({
				serverType: NAS_CONSTANTS.NUTANIX,
				label: cvLoc('label.addNuntanixFiles'),
				labelHelp: cvLoc('label.addNuntanixFilesHelpText'),
				createSuccessMessage: cvLoc('toast.nutanixFilesCreated')
			});
		};

		factory.openCreateQumuloFilesClient = function() {
			factory.addUpdateNasOrFileServers({
				serverType: NAS_CONSTANTS.QUMULO,
				label: cvLoc('label.addQumuloFileStorage'),
				labelHelp: cvLoc('label.addQumuloFileStorageHelpText'),
				createSuccessMessage: cvLoc('toast.qumuloFileStorageCreated')
			});
		};

		factory.getProtocols = function(serverInfo, installedProtocols) {
			let protocols = PROTOCOLS[serverInfo.serverType];

			let avaialableProtocols = protocols.map(protocol => {
				let protcolDef = getProtocolParams(protocol);
				if (installedProtocols && installedProtocols.indexOf(protocol) !== -1) {
					protcolDef.disabled = true;
				}

				//				if (serverInfo.clientAppType && serverInfo.clientAppType === 4 && protcolDef.label === NAS_CONSTANTS.NDMP) {
				//					protcolDef.hidden = true;
				//				}

				return protcolDef;
			});
			return avaialableProtocols;
		};

		factory.addUpdateNasOrFileServers = function(serverInfo, clientDetails) {
			let editMode = typeof clientDetails !== 'undefined';
			let installedPrtocols = _.get(clientDetails, 'client.idaList');
			let protocolMap = [];
			if (installedPrtocols) {
				protocolMap = _.map(installedPrtocols, 'idaEntity.applicationId');
			}
			let fileServerInfo = _.get(clientDetails, 'pseudoClientInfo.fileServerInfo');
			let clientEntity = _.get(clientDetails, 'client.clientEntity');

			let clientInfo = CLIENT_INFO[serverInfo.serverType];
			if (serverInfo.clientAppType) {
				clientInfo.clientAppType = serverInfo.clientAppType;
			}
			clientInfo.fileServerInfo = fileServerInfo;

			let protocols = factory.getProtocols(serverInfo, protocolMap);
			factory.openCreateNasOrFileServerClient({
				clientInfo: clientInfo,
				planEntity: serverInfo.planEntity,
				entity: clientEntity,
				protocols: protocols,
				editMode: editMode,
				isNasServer: serverInfo.serverType === NAS_CONSTANTS.NAS,
				serverType: serverInfo.serverType,
				label: serverInfo.label,
				labelHelp: serverInfo.labelHelp,
				createSuccessMessage: serverInfo.createSuccessMessage
			});
		};

		factory.updateNasOrFileServerClient = function(clientDetails, planEntity) {
			let clientAppType = _.get(clientDetails, 'pseudoClientInfo.clientAppType');
			if (!clientAppType) {
				clientAppType = NAS_CONSTANTS.GENERIC;
			}

			let serverInfo = _.find(factory.getVendorList(), { clientAppTypeName: clientAppType });
			factory.addUpdateNasOrFileServers(
				{
					serverType: serverInfo.serverType,
					planEntity: planEntity,
					label: cvLoc('label.addProtocol'),
					labelHelp: cvLoc('label.addNasSoftwareHelpText'),
					createSuccessMessage: cvLoc('toast.nasServerCreated')
				},
				clientDetails
			);
		};

		factory.openCreateNasOrFileServerClient = function(clientParams) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/addNasOrFileStorageServer.jsp',
				backdrop: 'static',
				controller: 'nasFileServerClientController as ctrl',
				resolve: {
					clientParams: clientParams
				}
			});
		};

		factory.isFileStorageServer = function(clientDetails) {
			return factory.isNuatnixServer(clientDetails) || factory.isQumuloServer(clientDetails);
		};

		factory.getVendorList = function() {
			return [
				{
					vendorName: 'Generic',
					clientAppTypeName: 'GENERIC',
					clientAppType: 4,
					vendorType: 10,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Dell EMC Isilon',
					clientAppTypeName: 'ISILON',
					clientAppType: 3,
					vendorType: 18,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'NetApp',
					clientAppTypeName: 'NETAPP',
					clientAppType: 5,
					vendorType: 2,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Dell EMC VNX/Celerra',
					clientAppTypeName: 'CELERRA_VNX',
					clientAppType: 6,
					vendorType: 1,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Hitachi NAS',
					clientAppTypeName: 'BLUEARC',
					clientAppType: 7,
					vendorType: 9,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Dell EMC Unity',
					clientAppTypeName: 'UNITY',
					clientAppType: 8,
					vendorType: 33,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Huawei',
					clientAppTypeName: 'HUAWEI',
					clientAppType: 9,
					vendorType: 32,
					serverTypeLabel: cvLoc('label.nasServer'),
					serverType: NAS_CONSTANTS.NAS
				},
				{
					vendorName: 'Nutanix',
					clientAppTypeName: 'NUTANIX_AFS',
					clientAppType: 2,
					vendorType: 34,
					serverTypeLabel: cvLoc('label.nutanixFiles'),
					serverType: NAS_CONSTANTS.NUTANIX
				},
				{
					clientAppTypeName: 'QUMULO',
					clientAppType: 10,
					serverTypeLabel: cvLoc('label.qumuloFiles'),
					serverType: NAS_CONSTANTS.QUMULO
				}
			];
		};

		factory.isIntelliSnapSupported = function(clientDetails) {
			let supported = false;
			if (EntityTypesUtil.isNasClient(clientDetails)) {
				let vendor = _.get(clientDetails, 'pseudoClientInfo.nasClientProperties.vendorType');
				let osId = _.get(clientDetails, 'client.osInfo.osId');
				if (vendor === NAS_CONSTANTS.GENERIC_NDMP_SERVER && osId === NAS_CONSTANTS.GENERIC_FILER_OS_ID) {
					supported = true;
				} else if (_.includes(SUPPORTED_SNAP_VENDORS, vendor) || _.includes(SUPPORTED_SNAP_OS_IDS, osId)) {
					supported = true;
				}
			}

			return supported;
		};

		factory.getServerTypeLabel = function(clientDetails) {
			let osSubType = _.get(clientDetails, 'client.osInfo.SubType');
			if (osSubType === NAS_CONSTANTS.NAS) {
				let osName = _.get(clientDetails, 'client.osInfo.OsDisplayInfo.OSName');
				if (osName === NAS_CONSTANTS.NUTANIX_LABEL) {
					return cvLoc('label.nutanixFiles');
				} else if (osName === NAS_CONSTANTS.QUMULO_LABEL) {
					return cvLoc('label.qumuloFiles');
				} else {
					return cvLoc('label.nasServer');
				}
			}
		};

		factory.isNuatnixServer = function(clientDetails) {
			let osName = _.get(clientDetails, 'client.osInfo.OsDisplayInfo.OSName');
			return osName === NAS_CONSTANTS.NUTANIX_LABEL;
		};

		factory.isQumuloServer = function(clientDetails) {
			let osName = _.get(clientDetails, 'client.osInfo.OsDisplayInfo.OSName');
			return osName === NAS_CONSTANTS.QUMULO_LABEL;
		};

		factory.addArray = function(params) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/addArray.jsp',
				backdrop: 'static',
				resolve: {
					params: params
				},
				controller: 'createArrayController as ctrl'
			});
		};

		factory.isIpAddress = function(name, serverType) {
			if (serverType === NAS_CONSTANTS.QUMULO || serverType === NAS_CONSTANTS.NUTANIX) {
				return cvUtil.isValidIpAddress(name);
			}
			return false;
		};

		factory.openNDMPDetails = function(ndmpServerProperties) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/ndmpServerDetails.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				resolve: {
					ndmpServerProperties: ndmpServerProperties
				},
				controller: [
					'$scope',
					'cvUtil',
					'ndmpServerProperties',
					'$uibModalInstance',
					'cvLoc',
					'nasFactory',
					'cvTableOptions',
					function($scope, cvUtil, ndmpServerProperties, $modalInstance, cvLoc, nasFactory, cvTableOptions) {
						$scope.ndmpServerProperties = ndmpServerProperties;
						$scope.vendor = cvUtil.lookupEnumConstant(ndmpServerProperties.vendorType);
					}
				]
			});
		};

		factory.openEditAccessnodesModal = accessnodeoptions => {
			$modal.open({
				windowClass: 'small-size',
				controller: 'editAccessnodeModalController',
				controllerAs: 'editAccessnodeCtrl',
				templateUrl: `${appUtil.appRoot}modules/nas/partials/editAccessnodesModalTemplate.jsp`,
				resolve: {
					accessnodeoptions
				}
			});
		};

		factory.openEditNdmpProperties = function(modifyrequest) {
			return $modal.open({
				templateUrl: appUtil.appRoot + 'modules/nas/partials/editNDMPProperties.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				resolve: {
					modifyrequest: modifyrequest
				},
				controller: [
					'$scope',
					'cvUtil',
					'modifyrequest',
					'$uibModalInstance',
					'cvLoc',
					'nasFactory',
					'cvToaster',
					function($scope, cvUtil, modifyrequest, $modalInstance, cvLoc, nasFactory, cvToaster) {
						$scope.modifyrequest = _.clone(modifyrequest);
						$scope.arrayPassword = '';
						$scope.isValidRequest = function() {
							$scope.showErrors = false;
							if (
								!_.get($scope.modifyrequest, 'ndmpServerDetails.ndmpCredentials.userName') ||
								!$scope.arrayPassword ||
								!_.get($scope.modifyrequest, 'listenPort')
							) {
								$scope.showErrors = true;
								return false;
							}
							return true;
						};

						$scope.updateNdmpProperties = function() {
							let request = _.clone($scope.modifyrequest);
							request.ndmpServerDetails.ndmpCredentials.password = Base64.encode($scope.arrayPassword);
							if ($scope.isValidRequest()) {
								nasService
									.updateNDMPProperties(request)
									.success(function(successData) {
										if (successData && successData.errorMessage) {
											$scope.ndmpErrorMessage = cvUtil.errMsg(successData.errorMessage);
										} else {
											cvToaster.showInfoMessage({
												ttl: '10000', //10 sec
												message: cvLoc('label.ndmpServerUpdateMessage')
											});
											$modalInstance.close(request);
										}
									})
									.error(function(errorMessage) {
										$scope.ndmpErrorMessage = cvUtil.errMsg(errorMessage);
									});
							}
						};
					}
				]
			});
		};

		factory.filterAccessnodeAttributes = accessnodes => {
			return _.map(accessnodes, accessnode => {
				if (accessnode.clientGroupId) {
					return {
						_type_: 28,
						clientGroupId: accessnode.clientGroupId,
						clientGroupName: accessnode.name || accessnode.clientGroupName
					};
				}

				return {
					_type_: 3,
					clientId: accessnode.clientId,
					clientName: accessnode.name || accessnode.clientName
				};
			});
		};

		/**
		 * @param {29 |
		 *            33} appId Application ID
		 * @param {Object}
		 *            migrationConfig Existing config to be edited
		 * @param {Boolean}
		 *            isNasCreationUserFlow Identify if the modal is opened from NAS adding flow or editing
		 *            existing NAS
		 * @returns {Object} Modal instance
		 */
		factory.openMigrationDialog = function(appId, migrationConfig, isNasCreationUserFlow, additionalConfig) {
			return $modal.open({
				component: 'migrateNasServer',
				backdrop: 'static',
				resolve: {
					appId: () => appId,
					migrationConfig: () => migrationConfig,
					isNasCreationUserFlow: () => isNasCreationUserFlow,
					additionalConfig: () => additionalConfig
				}
			});
		};

		/**
		 * Maps the migrationConfig to the format required for API
		 *
		 * @param {Object}
		 *            migrationConfig
		 * @returns {Object} Payload for API request of type MigrateServerDetails
		 */
		factory.getMigrationConfigPayload = function(migrationConfig) {
			const filterContentFields = ({ subclient, backupset, path, isArchiveOrOnePassSubClient }) => ({
				subclient,
				backupset,
				path,
				isArchiveOrOnePassSubClient
			});
			const mapCutoverApprovers = user => {
				switch (user.userInfo.userType) {
					case 'USER': {
						return {
							userId: user.userInfo.id,
							userName: user.loginName,
							_type_: 13
						};
					}
					case 'EMAIL': {
						return {
							userEmail: user.userEmail
						};
					}
					case 'COMMCELL_GROUP':
					case 'EXTERNAL_GROUP': {
						return {
							userGroupId: user.userInfo.id,
							userGroupName: user.loginName,
							_type_: 15
						};
					}
				}
			};
			const mapServerFields = ({ clientName, clientId }) => ({ clientName, clientId });
			const mapUserCredentials = ({ userName, password }) => ({ userName, password: Base64.encode(password) });
			return {
				cutOverApprovers: migrationConfig.cutOverApprovers.map(mapCutoverApprovers),
				dateAndTime: migrationConfig.dateAndTime,
				sourceServer: mapServerFields(migrationConfig.sourceServer),
				backupThreshold: migrationConfig.backupThreshold,
				targetStartingPath: migrationConfig.targetStartingPath,
				includedBackupContent: migrationConfig.includedBackupContent.map(filterContentFields),
				excludedBackupContent: migrationConfig.excludedBackupContent.map(filterContentFields),
				...(migrationConfig.impersonateUser && {
					impersonateUser: mapUserCredentials(migrationConfig.impersonateUser)
				}),
				...(migrationConfig.backupDataAccessNodes && {
					backupDataAccessNodes: migrationConfig.backupDataAccessNodes
				})
			};
		};

		/**
		 * Maps the migrationConfig received from API to the format required for editing in modal
		 *
		 * @param {Object}
		 *            migrateServerDetails migrationConfig of type MigrateServerDetails received from API
		 * @return {Object} migrationConfig object for migrateNasServer modal
		 */
		factory.mapMigrationConfigResponseToModal = function(migrateServerDetails) {
			const mapCutoverApprovers = user => {
				if (!_.isUndefined(user.userId) && !_.isUndefined(user.userName)) {
					// Is an existing user
					return {
						iconClass: 'k-i-user',
						loginName: user.userName,
						name: user.name,
						userEmail: user.userEmail,
						userInfo: {
							id: user.userId,
							name: user.name,
							userType: 'USER'
						}
					};
				} else if (!_.isUndefined(user.userGroupId) && !_.isUndefined(user.userGroupName)) {
					// Is an existing user group
					return {
						iconClass: 'k-i-myspace',
						loginName: user.userGroupName,
						userInfo: {
							id: user.userGroupId,
							name: user.userGroupName,
							userType: 'COMMCELL_GROUP' // Can also be EXTERNAL_GROUP, but is irrelevant since this field is used only for identifying groups
						}
					};
				} else if (!_.isUndefined(user.userEmail)) {
					// Is a non-existing user with just email
					return {
						iconClass: 'k-i-email',
						loginName: user.userEmail,
						name: user.userEmail,
						userEmail: user.userEmail,
						userInfo: {
							id: user.userEmail,
							name: user.userEmail,
							userType: 'EMAIL'
						}
					};
				}
			};
			const cutoverApproversSortOrder = {
				USER: 1,
				COMMCELL_GROUP: 2,
				EXTERNAL_GROUP: 2,
				EMAIL: 3
			};
			const cutoverApproverSortField = {
				USER: 'name',
				COMMCELL_GROUP: 'loginName',
				EXTERNAL_GROUP: 'loginName',
				EMAIL: 'userEmail'
			};
			const sortCutoverApprovers = (a, b) => {
				const sortByType =
					cutoverApproversSortOrder[a.userInfo.userType] - cutoverApproversSortOrder[b.userInfo.userType];
				const sortByDisplayField = a[cutoverApproverSortField[a.userInfo.userType]].localeCompare(
					b[cutoverApproverSortField[b.userInfo.userType]]
				);
				return sortByType || sortByDisplayField;
			};
			return {
				cutOverApprovers: migrateServerDetails.cutOverApprovers.map(mapCutoverApprovers).sort(sortCutoverApprovers),
				dateAndTime: migrateServerDetails.dateAndTime,
				backupThreshold: migrateServerDetails.backupThreshold,
				sourceServer: migrateServerDetails.sourceServer,
				targetStartingPath: migrateServerDetails.targetStartingPath,
				includedBackupContent: _.get(migrateServerDetails, 'includedBackupContent', []),
				excludedBackupContent: _.get(migrateServerDetails, 'excludedBackupContent', [])
			};
		};

		return factory;
	}
];

nasMod.factory(factories);

export default nasMod;
