import 'modules/nas/js/factory/nas.factory.js';
import 'modules/nas/js/services/nas.svc.js';
import { NAS_CONSTANTS } from 'modules/nas/js/constants';
import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

var controllers = {};

controllers.nsAutoMountBrowseController = [
	'$log',
	'$state',
	'$stateParams',
	'cvLoc',
	'AppTypesUtil',
	'cvUtil',
	'nasService',
	'$uibModalInstance',
	'subclientInfo',
	'nasBrowseOptions',
	function(
		$log,
		$state,
		$stateParams,
		cvLoc,
		AppTypesUtil,
		cvUtil,
		nasService,
		$modalInstance,
		subclientInfo,
		nasBrowseOptions
	) {
		var self = this;

		self.subclientInfo = subclientInfo;
		self.selectedAccessNode = [];

		self.localLang = cvUtil.getIStevenLocLabels();

		// if there is an error while connection with the saved access node.
		if (nasBrowseOptions && nasBrowseOptions.error) {
			self.serverMessage = {
				message: nasBrowseOptions.error,
				type: 'help-block padding-top-10'
			};
		}

		self.nasBrowseOptions = nasBrowseOptions;
		self.showHelp = nasBrowseOptions.proxyOptional;
		/*
		 * Inputs to this dialog are
		 *
		 * 1. clientId 2. subclient details (If applicable because new subclient) 2. application ID 3. proxy
		 * client that was the part of subclient list (if any)
		 *
		 * NFS and CIFS fields 1. interface path - text field 2. proxy list - render the list of proxies using
		 * nas proxy api 3. user name and password - text field
		 *
		 */
		// Proxy MA
		self.proxyMADropDownMsg = cvLoc('label.loading');

		function setProxyList(data) {
			let proxyList = [];
			let fetchedClients = data.clients;
			for (let i = 0; i < fetchedClients.length; i++) {
				let current = fetchedClients[i];
				proxyList.push(current);
			}
			self.subclientInfo.proxyMaList = proxyList;
			self.proxyMADropDownMsg = cvLoc('label.selectAccessNode');
		}

		if (AppTypesUtil.isWindowsFileSystem(nasBrowseOptions.appId)) {
			nasService
				.getProxyNodes(NAS_CONSTANTS.CIFS)
				.success(setProxyList)
				.error(function(errorMessage) {
					self.proxyMADropDownMsg = cvLoc('error.loadingAccessNode');
				});
		} else if (AppTypesUtil.isUnixFileSystem(nasBrowseOptions.appId)) {
			nasService
				.getProxyNodes(NAS_CONSTANTS.NFS)
				.success(setProxyList)
				.error(function(errorMessage) {
					self.proxyMADropDownMsg = cvLoc('error.loadingAccessNode');
				});
		}

		self.validateInputFields = function() {
			var bValidInput = true;
			self.showEnterInterfacePathHelpText = false;
			self.showProxyHelpText = false;
			self.emptyServerMsg();

			// Validating interface Path
			if (!self.nasBrowseOptions.interfacePath || self.nasBrowseOptions.interfacePath.trim().length === 0) {
				self.showEnterInterfacePathHelpText = true;
				bValidInput = false;
			}

			// Validating proxy
			if (!self.nasBrowseOptions.proxyOptional && self.selectedAccessNode.length === 0) {
				self.showProxyHelpText = true;
				bValidInput = false;
			}

			return bValidInput;
		};

		self.autoMountBrowse = function() {
			// Validate fields
			if (!self.validateInputFields()) {
				return;
			}

			$modalInstance.close(self.nasBrowseOptions);
		};

		self.emptyServerMsg = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};

		self.onDropdownClose = function() {
			if (self.selectedAccessNode && self.selectedAccessNode.length > 0) {
				self.nasBrowseOptions.proxy = self.selectedAccessNode[0].clientId;
				self.showHelp = false;
				self.showProxyHelpText = false;
			}
		};
	}
];

nasMod.controller(controllers);

export default nasMod;
