import 'adminConsole/js/directives/cv-activity-control-component.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'commonForAllAgents/js/services/releaseLicense.svc.js';
import 'commonForAllAgents/js/controllers/releaseLicenseModal.ctrl.js';
import 'commonForAllAgents/js/controllers/pushInstallSoftware.ctrl.js';
import 'adminConsole/js/controllers/backup.ctrl.js';
import 'modules/nas/js/factory/nas.factory.js';
import 'capps/js/services/cappsClients.svc.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'commonForAllAgents/js/controllers/generatePackage.ctrl.js';
import 'adminConsole/js/controllers/createBackupSet.ctrl.js';
import 'adminConsole/js/services/subclients.svc.js';
import 'modules/ida/js/services/idaService.svc.js';
import 'modules/nas/js/services/nas.svc.js';
import 'commonForAllAgents/js/controllers/reconfigureClient.ctrl.js';
import 'commonForAllAgents/js/controllers/updateSoftware.ctrl.js';
import 'commonForAllAgents/js/controllers/uninstallSoftware.ctrl.js';
import 'commonForAllAgents/js/services/clients.svc.js';
import 'adminConsole/js/services/clients.svc.js';
import 'adminConsole/js/factories/acBrowseUtils.factory.js';
import 'adminConsole/js/directives/cv-proxy-servers.js';
import 'adminConsole/js/constants/slaStatus.constant.js';
import { NAS_CONSTANTS } from 'modules/nas/js/constants';

import { acAppNasModule } from 'common/js/modules';

var nasMod = acAppNasModule;

var controllers = {};
var factories = {};

factories.nasClientFactory = [
	'clientService',
	'cvToaster',
	'$log',
	'allAgentsService',
	'uninstallSoftwareFactory',
	'updateSoftwareFactory',
	'reconfigureClientFactory',
	'cvLoc',
	'$dialogs',
	'cvUtil',
	'$state',
	'$stateParams',
	'$q',
	'nasService',
	'idaService',
	'subclientService',
	'$uibModal',
	function(
		clientService,
		cvToaster,
		$log,
		allAgentsService,
		uninstallSoftwareFactory,
		updateSoftwareFactory,
		reconfigureClientFactory,
		cvLoc,
		$dialogs,
		cvUtil,
		$state,
		$stateParams,
		$q,
		nasService,
		idaService,
		subclientService,
		$modal
	) {
		var factory = {};

		factory.clientId = 0;
		factory.clientDetail = {};
		factory.agentsList = [];
		factory.nasSubclientsList = [];

		factory.getClientDetails = function(id) {
			return clientService
				.getClientDetails(id)
				.success(function(data) {
					factory.clientDetail = data;
					factory.clientId = id;
				})
				.error(function(data) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: 'Error loading client detail'
					});
				});
		};

		factory.getAgentsList = function(clientId) {
			return clientService
				.getAgents(clientId)
				.success(function(data) {
					factory.agentsList = data;
				})
				.error(function(data) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: 'Error loading agents'
					});
				});
		};

		factory.getAgentsRoles = function(clientId) {
			return clientService
				.getDloServerDetails(clientId)
				.success(function(data) {
					factory.roles = data.roles;
				})
				.error(function(data) {
					cvToaster.showErrorMessage({
						ttl: '5000', //5 sec
						message: 'Error loading roles'
					});
				});
		};

		factory.deleteSubclient = function(subclientEntity, successCallBack) {
			var successCallBackFunction = successCallBack;
			if (successCallBackFunction === null) {
				successCallBackFunction = function() {
					$log.info(subclientEntity.subclientName + ' subclient deleted successfully');
					$state.forceReload();
				};
			}
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					subclientService
						.deleteSubclient({
							genericEntity: angular.toJson(subclientEntity)
						})
						.success(successCallBackFunction)
						.error(function(errorMessage) {
							errorMessage = errorMessage !== null ? errorMessage : cvLoc('genericError');
							$log.error(errorMessage);
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: errorMessage
							});
						});
				}
			};
			$dialogs.confirm(
				cvLoc('header.deleteSubclient'),
				cvLoc('label.confirmDeleteSubclient', '<b>' + subclientEntity.subclientName + '</b>'),
				callBackFunctions
			);
		};

		factory.deleteClient = function(clientId, clientName) {
			// delete client
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					allAgentsService
						.deleteClient(clientId)
						.success(function(data) {
							$state.transitionTo(
								$state.current.name === 'fsServersList' ? 'fsServersList' : 'clientGroupDetails',
								$stateParams,
								{
									reload: true,
									inherit: false,
									notify: true
								}
							);
							cvToaster.showSuccessMessage({
								message: clientName + ' ' + cvLoc('info.deleteSuccessful')
							});
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('prompt.confirmDeleteServer', '<b>' + clientName + '</b>'),
				callBackFunctions
			);
		};

		factory.nasAgentColDef = [
			{
				field: 'idaEntity.appName',
				sort: {
					direction: 'asc',
					priority: 0
				},
				displayName: cvLoc('label.protocol'),
				cellTemplate:
					'<a ng-class="{\'disabled\': !grid.appScope.licenseMap[row.entity.idaEntity.applicationId]}" ng-if="row.entity.idaEntity.applicationId==13 || row.entity.idaEntity.applicationId==29 || row.entity.idaEntity.applicationId==33" class="crop" href="#fsAgentDetails/{{row.entity.idaEntity.clientId}}/{{row.entity.idaEntity.applicationId}}">' +
					'{{ row.entity.idaEntity.applicationId === 33 ? "CIFS" : row.entity.idaEntity.applicationId === 29 ? "NFS" : row.entity.idaEntity.appName }}</a>',
				width: '15%',
				enableHiding: false
			},
			{
				field: 'configured',
				displayName: cvLoc('header.configured'),
				cellTemplate:
					'<span class="k-icon k-i-check" data-ng-if="grid.appScope.licenseMap[row.entity.idaEntity.applicationId]"></span><span class="k-icon k-i-close" data-ng-if="!grid.appScope.licenseMap[row.entity.idaEntity.applicationId]"></span>',
				width: '15%',
				cvUserPref: 'installDate',
				enableFiltering: false
			},
			{
				field: 'AgentProperties.commonProperties.lastBackupTime',
				displayName: cvLoc('label.lastBackup'),
				cellTemplate:
					'<span class="crop" data-ng-show="row.entity.AgentProperties.commonProperties.lastBackupTime==0"><div>' +
					cvLoc('label.neverBackedUp') +
					'</div></span><span class="crop" data-ng-show="row.entity.AgentProperties.commonProperties.lastBackupTime!=0"><div class="time" val="{{row.entity.AgentProperties.commonProperties.lastBackupTime}}"></div></span>',
				width: '15%',
				cvUserPref: 'installDate',
				enableFiltering: false
			},
			{
				field: 'slaStatus',
				displayName: cvLoc('label.slaStatus'),
				cellTemplate:
					'<span class="{{grid.appScope.slaStatusMap[row.entity.idaEntity.applicationId].slaClass}}">{{grid.appScope.slaStatusMap[row.entity.idaEntity.applicationId].status}}</span>',
				width: '15%',
				cvUserPref: 'slaStatus',
				enableFiltering: false
			},
			{
				field: 'AgentProperties.commonProperties.applicationSize',
				displayName: cvLoc('header.applicationSize'),
				cellTemplate:
					'<span class="crop">{{row.entity.AgentProperties.commonProperties.applicationSize| capacity}}</span>',
				width: '15%',
				cvUserPref: 'lastBackupSize',
				enableFiltering: false
			},
			{
				field: 'idaEntity',
				enableFiltering: false,
				enableSorting: false,
				enableHiding: false,
				displayName: cvLoc('header.actions'),
				cellTemplate:
					'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
					'<li><a class="crop" href="#jobs?serverId={{grid.appScope.clientId}}&serverName={{grid.appScope.clientDetails.client.clientEntity.clientName}}&applicationId={{row.entity.idaEntity.applicationId}}&jobType={{\'Backup\'}}&activeJobs=2&view=finishedJobs1">' +
					cvLoc('label.BackupHistory') +
					'</a></li><li><a class="crop" href="#jobs?serverId={{grid.appScope.clientId}}&serverName={{grid.appScope.clientDetails.client.clientEntity.clientName}}&applicationId={{row.entity.idaEntity.applicationId}}&jobType={{\'Restore\'}}&activeJobs=2&view=finishedJobs1">' +
					cvLoc('label.RestoreHistory') +
					'</a></li>' +
					'<li data-ng-if="!grid.appScope.licenseMap[row.entity.idaEntity.applicationId]"> <a href="" data-ng-click="grid.appScope.reconfigureAgent(row.entity.idaEntity.clientId, row.entity.idaEntity.applicationId)">' +
					cvLoc('label.reconfigure') +
					'</a></li>' +
					'<li data-ng-if="grid.appScope.licenseMap[row.entity.idaEntity.applicationId]"> <a href="" data-ng-click="grid.appScope.releaseAgentLicense(row.entity.idaEntity.clientId, row.entity.idaEntity.applicationId)">' +
					cvLoc('label.releaseLicense') +
					'</a></li>' +
					'</ul></div>',
				width: '10%'
			}
		];

		factory.nasSubclientColDef = [
			{
				field: 'subClientEntity.subclientName',
				sort: {
					direction: 'asc',
					priority: 0
				},
				displayName: cvLoc('label.SubclientName'),
				cellTemplate:
					'<a class="crop" href="#/fsSubclientDetails/{{row.entity.subClientEntity.subclientId}}?clientGroupName=Servers">{{row.entity.subClientEntity.subclientName}}</a>',
				enableHiding: false,
				enableFiltering: true
			},
			{
				field: 'subClientEntity.applicationId',
				displayName: cvLoc('label.backupType'),
				cellTemplate:
					'<span class="crop">{{row.entity.subClientEntity.applicationId == 33 ? "CIFS" : (row.entity.subClientEntity.applicationId == 29 ? "NFS" : "NDMP")}}</span>',
				width: '25%',
				enableFiltering: true
			},
			/*
			 * { field : 'subClientEntity.backupsetName', displayName : cvLoc('label.backupSet'), cellTemplate : '<span
			 * class="crop">{{row.entity.subClientEntity.backupsetName}}</span>', width : '25%',
			 * enableFiltering : true },
			 */
			{
				field: 'subClientEntity',
				displayName: cvLoc('header.restore'),
				// Restore is not applicable for System created
				// subclient,IndexBackup,for index backup

				cellTemplate:
					'<div class="btn-group" data-ng-show="row.entity.commonProperties.lastBackupTime!=0 && row.entity.commonProperties.indexingBackupSubClient==false" uib-dropdown>' +
					'<a href="#idaBrowse/{{row.entity.subClientEntity. applicationId}}/{{row.entity.subClientEntity.subclientId}}?entityType=SUBCLIENT_ENTITY&path={{grid.appScope.getRootPath(row.entity.subClientEntity.applicationId)}}">' +
					cvLoc('header.restore') +
					'</a>' +
					'</div>',
				/*
				 * + '<div class="btn-group" data-ng-show="row.entity.subClientEntity.applicationId == 13 &&
				 * row.entity.commonProperties.lastBackupTime!=0 &&
				 * row.entity.commonProperties.indexingBackupSubClient==false" uib-dropdown>'+ '<a href
				 * class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span
				 * class="grid-action-icon"></span></a>'+ '<ul uib-dropdown-menu class="dropdown-menu" role="menu">'+ '<li><a
				 * href="#idaBrowse/{{row.entity.subClientEntity.
				 * applicationId}}/{{row.entity.subClientEntity.subclientId}}?entityType=SUBCLIENT_ENTITY&path={{grid.appScope.getRootPath(row.entity.subClientEntity.applicationId)}}">' +
				 * cvLoc('header.restore') + '</a></li>'+ '<li><a
				 * href="#idaBrowse/{{row.entity.subClientEntity.
				 * applicationId}}/{{row.entity.subClientEntity.subclientId}}?entityType=SUBCLIENT_ENTITY&path={{grid.appScope.getRootPath(row.entity.subClientEntity.applicationId)}}&isLiveBrowse=true">' +
				 * cvLoc('header.LiveBrowseAndRestore') + '</a></li>'+ '</ul>'+ '</div>',
				 */

				width: '25%',
				cvUserPref: 'restore',
				enableSorting: false,
				enableFiltering: false
			},
			{
				field: 'subClientEntity.subclientId.commonProperties',
				displayName: cvLoc('header.actions'),
				cellTemplate:
					'<div class="btn-group" uib-dropdown>' +
					'<a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled">' +
					'<span class="grid-action-icon"></span></a>' +
					'<ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
					'<li><a href="" data-ng-class="{inheritedSecurityAssociation : (row.entity.commonProperties.enableBackup==false)}" ng-click="row.entity.commonProperties.enableBackup==false || grid.appScope.showBackupOptions(row.entity.subClientEntity,row.entity.fsSubClientProp && row.entity.fsSubClientProp.extendStoragePolicyRetention)">' +
					cvLoc('action.backup') +
					'</a></li>' +
					'<li><a class="crop" href="#jobs?serverId={{grid.appScope.clientId}}&serverName={{grid.appScope.backupSetDetails.backupSetEntity.clientName}}&applicationId={{grid.appScope.applicationId}}&collectionId={{row.entity.subClientEntity.subclientId}}&collectionName={{row.entity.subClientEntity.subclientName}}&jobType={{\'Backup\'}}&activeJobs=0">' +
					cvLoc('label.BackupHistory') +
					'</a></li>' +
					'<li data-ng-if="row.entity.commonProperties.isDefaultSubclient!=true"><a class="crop" href="" ng-click="grid.appScope.deleteSubclient(row.entity.subClientEntity)">' +
					cvLoc('Delete') +
					'</a></li>' +
					'</ul>' +
					'</div>',
				width: '15%',
				enableFiltering: false,
				enableSorting: false,
				enableHiding: false
			}
		];

		factory.renderNasSubclients = function(clientId) {
			return nasService
				.getSubclientList(clientId, 0)
				.success(function(subclientList) {
					factory.nasSubclientsList = subclientList;
				})
				.error(function() {
					$log.error('Error loading backupsets');
				});
		};

		factory.getSnapEnabledStatusInfo = function() {
			if (angular.isUndefined(factory.snapEnabledStatusInfo) && factory.clientDetail) {
				factory.snapEnabledStatusInfo = factory.clientDetail.clientProps.EnableSnapBackups
					? 'enabled-activity'
					: 'disabled-activity';
			}
			return factory.snapEnabledStatusInfo;
		};

		factory.manageSnapSettings = function() {
			return nasService
				.updateClientSnapSettings({
					clientId: parseInt(factory.clientId),
					action: factory.snapEnabledStatusInfo == 'enabled-activity' ? false : true
				})
				.success(function(data) {
					if (data.errorCode == 0) {
						factory.snapEnabledStatusInfo =
							factory.snapEnabledStatusInfo == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						$log.error('update Snap failed: ' + data.errorString);
					}
				})
				.error(function(e) {
					$log.error('update Snap option activity failed', e);
				});
		};

		factory.openUserEditModal = clientDetails => {
			return $modal.open({
				templateUrl: 'adminConsole/partials/userCredentials.jsp',
				windowClass: 'small-size',
				controller: 'manageUserCredentialsController',
				resolve: {
					controllerParams: function() {
						return {
							impersonateUser: _.get(clientDetails, 'pseudoClientInfo.userCredentials'), //passed by reference. will have the changes made inside the controller.
							impersonateUserCredentialinfo: _.get(clientDetails, 'pseudoClientInfo.userSavedCredentials'),
							headingLabel: cvLoc('label.qumuloCrdentials')
						};
					}
				}
			});
		};

		return factory;
	}
];

nasMod.factory(factories);

controllers.nasClientDetails = [
	'$scope',
	'nasClientFactory',
	'createBackupSetFactory',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$state',
	'cvTableOptions',
	'cvPageActionsFactory',
	'AppTypes',
	'$log',
	'generatePackageFactory',
	'AppTypesUtil',
	'securityFactory',
	'activityControlFactory',
	'ENTITY_TYPES',
	'cappsClientService',
	'CAPPS_CONSTANTS',
	'nasFactory',
	'backupOptionsFactory',
	'pushInstallSoftwareFactory',
	'acBrowseUtils',
	'releaseLicenseFactory',
	'releaseLicenseService',
	'reconfigureClientFactory',
	'agentFactory',
	'uiGridConstants',
	'clientService',
	'SLA_STATUS',
	'clientDetailService',
	'nasService',
	function(
		$scope,
		nasClientFactory,
		createBackupSetFactory,
		$stateParams,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$state,
		cvTableOptions,
		cvPageActionsFactory,
		AppTypes,
		$log,
		generatePackageFactory,
		AppTypesUtil,
		securityFactory,
		activityControlFactory,
		ENTITY_TYPES,
		cappsClientService,
		CAPPS_CONSTANTS,
		nasFactory,
		backupOptionsFactory,
		pushInstallSoftwareFactory,
		acBrowseUtils,
		releaseLicenseFactory,
		releaseLicenseService,
		reconfigureClientFactory,
		agentFactory,
		uiGridConstants,
		clientService,
		SLA_STATUS,
		clientDetailService,
		nasService
	) {
		// ######## Set Properties ########
		var self = this;
		self.serverMessage = cvUtil.infoMsg('Loading');
		self.clientId = $stateParams.clientId;
		self.clientGroupName = $stateParams.clientGroupName;
		self.clientGroupId = $stateParams.clientGroupId;

		self.entityType = ENTITY_TYPES.CLIENT_ENTITY;
		self.genericEntity = {
			clientId: parseInt($stateParams.clientId)
		};
		self.acParams = {
			entityType: self.entityType,
			genericEntity: self.genericEntity,
			activityControlOptionsObject: activityControlFactory.createActivityControlOptionsObject(),
			optionsLoaded: false
		};
		self.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		self.associationsLoaded = false;
		self.isNasSubclientsSupported = false;
		self.isAgentsSupported = true;
		self.isFileStorageServer = false;
		self.showAddSoftware = false;
		self.impersonateUser = { userName: '' };
		self.slaStatusMap = {};
		self.planEntity = { planId: -1, planName: cvLoc('label.notAssigned') };

		//self.agentsList = [];
		//self.nasSubclientList = [];
		self.path = encodeURIComponent(acBrowseUtils.getRootPathForBrowse($stateParams.applicationId));
		// ######## Set Properties END ########

		clientDetailService.getClientPlan($stateParams.clientId).success(function(data) {
			if (data.summary && data.summary.plan.planName) {
				self.planEntity = data.summary.plan;
			}
		});

		// ######## Render Client Details ########
		nasClientFactory.getClientDetails($stateParams.clientId).then(function() {
			self.serverMessage = cvUtil.emptyMsg();

			self.clientDetails = nasClientFactory.clientDetail;

			const idaList = self.clientDetails.client.idaList;
			const slaStatusClass = {
				MET_SLA: 'green-font',
				MISSED_SLA: 'red-font',
				MIGHT_MISS_SLA: 'orange-font'
			};

			idaList.map(idaInfo => {
				let slaStatus = {
					slaClass: slaStatusClass[idaInfo.summary.slaStatus],
					status: cvLoc(SLA_STATUS[idaInfo.summary.slaStatus]),
					statusHelpText: idaInfo.summary.slaCategoryDescription
				};
				self.slaStatusMap[idaInfo.idaEntity.applicationId] = slaStatus;
			});

			self.planRuleEnabled = cvConfig.enableRulesForPlan;
			self.clientRegion = _.get(self.clientDetails, 'clientProps.clientRegionInfo.region', {});
			self.snapEnabledStatusInfo = nasClientFactory.getSnapEnabledStatusInfo();

			self.serverType = nasFactory.getServerTypeLabel(self.clientDetails);
			self.isFileStorageServer = nasFactory.isFileStorageServer(self.clientDetails);
			self.isQumuloServer = nasFactory.isQumuloServer(self.clientDetails);
			self.osName = _.get(self.clientDetails, 'client.osInfo.OsDisplayInfo.OSName');
			self.vendorType = _.get(self.clientDetails, 'pseudoClientInfo.nasClientProperties.vendorType');
			self.isNasServer = !self.isFileStorageServer;

			self.changeNameObj = {
				id: self.clientDetails.client.clientEntity.clientId,
				name: self.clientDetails.client.displayName
			};

			self.changeNameSuccess = function(id, name) {
				if (id === null) {
					self.clientDetails.client.displayName = name;
				}
			};

			self.showManageArray = false;

			if (self.isQumuloServer) {
				self.showImpersonateUser = true;
				self.impersonateUser.userName = _.get(self.clientDetails, 'pseudoClientInfo.userCredentials.userName');
				if (!self.impersonateUser.userName) {
					self.impersonateUser.userName = _.get(
						self.clientDetails,
						'pseudoClientInfo.userSavedCredentials.credentialName'
					);
				}
			}

			if (self.isNasServer) {
				self.vendorName = cvUtil.lookupEnumConstant(self.vendorType);
				self.showSnapTile = nasFactory.isIntelliSnapSupported(self.clientDetails);
				self.showManageArray = true;
				self.showArrayEditLink = false;
				let arrayName = _.get(self.clientDetails, 'pseudoClientInfo.fileServerInfo.arrayName');
				if (arrayName) {
					self.arrayName = arrayName;
				} else {
					self.showArrayEditLink = true;
					self.arrayName = cvLoc('label.notAvailable');
				}
			}

			if (self.agentsList) {
				self.clientDetails.client.idaList = self.agentsList;
				// enable add software where there is at least one agent pending.
				self.showAddSoftware = self.isFileStorageServer ? self.agentsList.length < 2 : self.agentsList.length < 3;
			}

			self.generateDeviceActionsParams = {
				isClientDeconfigured: self.clientDetails.clientProps.IsDeletedClient,
				isUserCentricClient: self.clientDetails.clientProps.IsVirtualClient,
				clientId: self.clientDetails.client.clientEntity.clientId,
				clientName: self.clientDetails.client.clientEntity.clientName,
				physicalClientId: self.clientDetails.clientProps.physicalClient.clientId,
				hideReadinessCheck: true
			};

			self.redirectState = $state.current.name === 'fsServersList' ? $state.current.name : 'clientGroupDetails';

			var activityControlOptionsFromServer =
				nasClientFactory.clientDetail.clientProps.clientActivityControl.activityControlOptions;
			self.acParams.activityControlOptions = activityControlFactory.getActivityControlOptions(
				self.entityType,
				activityControlOptionsFromServer
			);
			self.acParams.optionsLoaded = true;

			//entityType,genericEntity and formattedSecurityAssociations are required by security directive.
			var securityAssociations = self.clientDetails.clientProps.securityAssociations;
			self.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(securityAssociations);
			self.associationsLoaded = true;
		});
		// ######## Render Client Details END ########

		self.licenseMap = {};
		// Get License
		releaseLicenseService
			.getLicenseList($stateParams.clientId)
			.success(function(data) {
				if (data.length === 0) {
					self.availableLicenses = data;
					return;
				}
				data.forEach(function(item) {
					self.licenseMap[item.license.appType] = true;
				});

				self.availableLicenses = data;
			})
			.error(function(errorMsg) {});

		// ######## Subclient Details Start ########

		nasClientFactory.getAgentsList($stateParams.clientId).then(function() {
			self.agentsList = nasClientFactory.agentsList;

			if (self.clientDetails) {
				self.clientDetails.client.idaList = self.agentsList;
				// enable add software where there is at least one agent pending.
				self.showAddSoftware = self.isFileStorageServer ? self.agentsList.length < 2 : self.agentsList.length < 3;
			}
		});

		//		if ($stateParams.clientGroupName) {
		//			self.isAgentsSupported = true;
		//		} else {
		//			self.isNasSubclientsSupported = true;
		//
		//			nasClientFactory
		//				.renderNasSubclients($stateParams.clientId, $stateParams.applicationId ? $stateParams.applicationId : 0)
		//				.then(function() {
		//					self.nasSubclientList = nasClientFactory.nasSubclientsList;
		//				});
		//
		//			self.idaEntity = {
		//				applicationId: AppTypes.NAS
		//			};
		//		}

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		var gridOptions = angular.extend(globalGridOptions, {
			data: self.isNasSubclientsSupported ? 'nasSubclientList' : 'agentsList',
			showGridFooter: true,
			columnDefs: self.isNasSubclientsSupported ? nasClientFactory.nasSubclientColDef : nasClientFactory.nasAgentColDef,
			onRegisterApi: function(gridApi) {
				self.refreshGrid = () => {
					gridApi.core.notifyDataChange(uiGridConstants.dataChange.ALL);
				};
			}
		});

		self.getRootPath = function(applicationId) {
			return acBrowseUtils.getRootPathForBrowse(applicationId);
		};

		self.showBackupOptions = function(subclientEntity, hideFullBackupLevel) {
			var subclntEntity = {
				clientId: parseInt(subclientEntity.clientId),
				applicationId: parseInt(subclientEntity.applicationId),
				instanceId: parseInt(subclientEntity.instanceId),
				backupsetId: parseInt(subclientEntity.backupsetId),
				subclientId: parseInt(subclientEntity.subclientId)
			};
			var subclientEntityType = 'SUBCLIENT_ENTITY';
			backupOptionsFactory.showBackupOptions(subclientEntityType, subclntEntity, null, hideFullBackupLevel).then(
				function(job) {
					$log.info('backup started');
				},
				function(jobRunning, resp) {
					if (!jobRunning) {
						$log.error('backup failed: status=', status, ', data=', resp);
					}
				}
			);
		};

		self.deleteSubclient = function(subclientEntity) {
			nasClientFactory.deleteSubclient(subclientEntity);
		};

		self.reconfigureAgent = function(clientId, applicationId) {
			agentFactory.reconfigureAgent(clientId, applicationId, function() {
				self.licenseMap[applicationId] = true;
				self.refreshGrid();
			});
		};

		self.releaseAgentLicense = function(clientId, applicationId) {
			agentFactory.releaseAgentLicense(clientId, applicationId, function() {
				self.licenseMap[applicationId] = false;
				self.refreshGrid();
			});
		};

		self.gridOptions = {
			cvGridTitle: self.isAgentsSupported
				? cvLoc('label.networkStore.protocols')
				: self.isNasSubclientsSupported
				? cvLoc('heading.Subclients')
				: '',
			cvIsPageTitle: false,
			cvTableName: 'clientDetailsTable',
			cvSearchFields: ['idaEntity.appName'],
			cvAppScope: self,
			gridOptions: globalGridOptions
		};

		// Create NAS subclient
		self.createNASSubclient = function() {
			if (self.idaEntity.applicationId) {
				nasFactory.createNasSubclient({
					clientInfo: self.clientDetails,
					agentsList: self.agentsList
				});

				return;
			}
			$log.warn('Not implemented for applicationId:' + self.agentDetails.idaEntity.applicationId);
		};

		if (self.isNasSubclientsSupported) {
			self.gridOptions.cvPageLinks = [
				{
					label: cvLoc('action.subclientCreation'),
					onclick: self.createNASSubclient
					//show : "allowSubclientCreation"
				}
			];

			self.gridOptions.cvSearchFields = [
				'subClientEntity.subclientName',
				'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName'
			];
		} else {
			self.gridOptions.cvSearchFields = ['idaEntity.appName'];
		}

		// ######## Subclient Details End ########

		// ######## Bread Crums Start ########
		var breadCrumbs = [];

		if (self.clientId) {
			breadCrumbs.push({
				title: cvLoc('label.nav.servers'),
				link: '#/fsServers'
			});
		}

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		// ######## Bread Crums ########

		self.showJobs = function() {
			var params = {
				serverId: self.clientId,
				serverName: self.clientDetails.client.clientEntity.clientName,
				activeJobs: 0
			};
			$state.go('jobs', params);
		};

		self.openAddSoftwareDialog = function() {
			nasFactory.openNasPushInstall(self.clientDetails, self.planEntity);
		};

		self.manageSnapSettings = function() {
			nasClientFactory.manageSnapSettings().then(function() {
				self.snapEnabledStatusInfo = nasClientFactory.getSnapEnabledStatusInfo();
			});
		};

		self.isGeneratePackageEnabled = generatePackageFactory.isGeneratePackageEnabled;

		self.showGeneratePackageDialog = generatePackageFactory.showGeneratePackageDialog;

		self.openReleaseLicenseDialog = releaseLicenseFactory.openReleaseLicenseDialog;

		self.reconfigureClient = reconfigureClientFactory.reconfigureClient;

		self.showEditUser = function() {
			nasClientFactory.openUserEditModal(self.clientDetails).result.then(function(data) {
				if (data) {
					let userCredentials = _.get(self.clientDetails, 'pseudoClientInfo.userCredentials');
					let userSavedCredentials = _.get(self.clientDetails, 'pseudoClientInfo.userSavedCredentials');
					let pseudoClientInfo = {};
					if (userCredentials.userName) {
						self.impersonateUser.userName = userCredentials.userName;
						userCredentials.password = cvUtil.getBytes(userCredentials.password);
						pseudoClientInfo.userCredentials = userCredentials;
					} else {
						self.impersonateUser.userName = userSavedCredentials.credentialName;
						pseudoClientInfo.userSavedCredentials = userSavedCredentials;
					}

					var clientPropertiesRequest = {
						clientProperties: {
							pseudoClientInfo: pseudoClientInfo
						}
					};

					return clientService.updatePseudoClientProperties(
						self.clientDetails.client.clientEntity.clientId,
						clientPropertiesRequest
					);
				}
			});
		};

		self.addArray = function() {
			let clientType = NAS_CONSTANTS.NAS;
			let vendorType = cvUtil.lookupEnumConstant(self.vendorType, 'value');
			let selectedVendor = {
				name: self.vendorName,
				id: parseInt(vendorType)
			};

			let arrayInfo = {
				arrayName: {
					name: _.get(self.clientDetails, 'client.clientEntity.hostName')
				}
			};

			let modalInstance = nasFactory.addArray({
				vendor: selectedVendor,
				clientType: clientType,
				clientId: self.clientDetails.client.clientEntity.clientId,
				planId: _.get(self, 'planEntity.planId'),
				autoSave: true,
				arrayInfo: arrayInfo
			});

			modalInstance.result.then(function(arrayInfo) {
				nasService.refreshCache(self.clientDetails.client.clientEntity.clientId, 0).success(function() {
					$state.forceReload();
				});
			});
		};
	}
];

nasMod.controller(controllers);

export default nasMod;
