import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/services/subclients.svc.js';
import 'storage/js/services/storage.svc.js';
import 'adminConsole/js/controllers/backupSets.ctrl.js';
import 'adminConsole/js/controllers/fsSubclientContentDetails.ctrl.js';
import 'dlo/js/services/profile.svc.js';
import 'modules/nas/js/controllers/nasSubclientDetails.ctrl.js';
import 'modules/nas/js/controllers/nasClientDetails.ctrl.js';
import 'modules/nas/js/factory/nas.factory.js';
import 'modules/nas/js/services/nas.svc.js';

import { acAppNasModule } from 'common/js/modules';
var nasMod = acAppNasModule;

var controllers = {};

controllers.addNasClientController = [
	'$log',
	'$state',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'nasService',
	'$uibModalInstance',
	'cvToaster',
	'nasFactory',
	'cvNavigationFactory',
	function(
		$log,
		$state,
		$stateParams,
		cvLoc,
		cvUtil,
		nasService,
		$modalInstance,
		cvToaster,
		nasFactory,
		cvNavigationFactory
	) {
		var self = this;

		self.nasServer = {
			clientIdId: 0,
			clientName: '',
			hostName: '',
			vendor: '',
			unixIda: false,
			disableUnixIda: false,
			windowsIda: false,
			disableWindowsIda: false,
			nasIda: false,
			disableNasIda: false,
			ndmpLogin: '',
			ndmpPassword: '',
			ndmpPort: 10000,
			//selectedProxy : {},
			detectMAList: [],
			detectMa: undefined
		};

		self.renderDetectMA = function() {
			// Detect MA
			self.detectMADropDownMsg = cvLoc('label.loading');

			if (self.nasServer.nasIda && !self.nasServer.disableNasIda) {
				nasService
					.getNasProxyList(0, 64, 5, 2)
					.success(function(data) {
						self.nasServer.detectMAList = data;
						self.detectMADropDownMsg = cvLoc('label.selectDetectMa');
					})
					.error(function(e) {
						self.detectMADropDownMsg = cvLoc('error.loadingDetectMa');
					});
			}
		};

		// Construct AddNASFilerRequest
		self.validateInputFields = function() {
			self.emptyServerMsg();

			var bValidInput = true;
			self.showSelectBackupTypeHelpText = false;
			self.showEnterNdmpLoginHelpText = false;
			self.showEnterNdmpPassHelpText = false;
			self.selectEnterNasVendorHelpText = false;
			self.selectHostNameHelpText = false;
			self.selectClientNameHelpText = false;

			if (!(self.nasServer.unixIda || self.nasServer.windowsIda || self.nasServer.nasIda)) {
				self.showSelectBackupTypeHelpText = true;
				bValidInput = false;
			}

			// Validate Server Details
			if (self.nasServer.nasIda) {
				if (!self.nasServer.ndmpLogin) {
					self.showEnterNdmpLoginHelpText = true;
					bValidInput = false;
				}

				if (!self.nasServer.ndmpPassword) {
					self.showEnterNdmpPassHelpText = true;
					bValidInput = false;
				}
			}

			if (!self.nasServer.hostName) {
				self.selectHostNameHelpText = true;
				bValidInput = false;
			}
			if (!self.nasServer.clientName) {
				self.selectClientNameHelpText = true;
				bValidInput = false;
			}

			return bValidInput;
		};

		self.successCallBack = function(data) {
			if (localStorage) {
				localStorage.setItem('cacheRefreshFlag', 'true');
				localStorage.setItem('fsServerAdded', 'true');
			}

			if (_.has(data, 'response.entity.clientId')) {
				cvNavigationFactory.redirectToDetailsPage(cvNavigationFactory.DETAILS_STATENAMES.NAS_CLIENT_DETAILS, {
					clientId: data.response.entity.clientId
				});
			} else {
				if ($state.current.name !== cvNavigationFactory.LIST_STATENAMES.FS_SERVER) {
					cvNavigationFactory.redirectToListPage(cvNavigationFactory.LIST_STATENAMES.FS_SERVER);
				} else {
					$state.forceReload();
				}
			}
		};

		self.addNasServer = function() {
			if (!self.validateInputFields()) {
				return;
			}

			var ndmpServerDetails = {
				ndmpServerHostName: self.nasServer.hostName,
				ndmpServerClientName: self.nasServer.clientName,
				ndmpCredentials: {
					password: cvUtil.getBytes(self.nasServer.ndmpPassword),
					userName: self.nasServer.ndmpLogin
				}
			};

			var detectMediaAgent = {
				_type_: '11',
				mediaAgentId: self.nasServer.detectMa ? JSON.parse(self.nasServer.detectMa).clientId : 0,
				mediaAgentName: self.nasServer.detectMa ? JSON.parse(self.nasServer.detectMa).clientName : ''
			};

			var detectNDMPSrvReq = {
				ndmpServerDetails: ndmpServerDetails,
				detectMediaAgent: detectMediaAgent,
				listenPort: self.nasServer.ndmpPort.toString()
			};

			var nasClientProperties = {
				ndmpServerDetails: ndmpServerDetails,
				detectMediaAgent: detectMediaAgent,
				listenPort: self.nasServer.ndmpPort.toString()
			};

			var createPseudoClientReq = {
				clientInfo: {},
				entity: {
					clientId: '0',
					clientName: self.nasServer.clientName,
					hostName: self.nasServer.hostName
				}
			};

			if (self.nasServer.nasIda) {
				var nasTurboFSCreateReq = {
					turboNASproperties: {}
				};

				if (self.nasServer.unixIda && self.nasServer.windowsIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '3';
				} else if (self.nasServer.unixIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '2';
				} else if (self.nasServer.windowsIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '1';
				}

				var AddNASFileServerRequest = {
					clientId: '0',
					listenPort: self.nasServer.ndmpPort.toString(),
					vendorType: self.nasServer.vendor
				};

				createPseudoClientReq.clientInfo.clientType = '2';
				createPseudoClientReq.clientInfo.nasClientProperties = nasClientProperties;
				AddNASFileServerRequest.createPseudoClientReq = createPseudoClientReq;
				AddNASFileServerRequest.detectNDMPSrvReq = detectNDMPSrvReq;
				if (self.nasServer.unixIda || self.nasServer.windowsIda) {
					AddNASFileServerRequest.nasTurboFSCreateReq = nasTurboFSCreateReq;
				}

				nasService
					.createNASClient(JSON.stringify(AddNASFileServerRequest))
					.success(function(data) {
						if (data.errorCode === 0) {
							cvToaster.showSuccessMessage({
								message: data.createPseudoClientResp.response.entity.clientName + cvLoc('toast.nasServerCreated')
							});
							$modalInstance.dismiss();
							self.successCallBack(data);
						} else {
							self.addServerMsg(data.errorMessage, 'error');
						}
					})
					.error(function(e) {
						self.addServerMsg(e, 'error');
					})
					.then(function() {});
			} else {
				createPseudoClientReq.clientInfo.clientType = '18';

				if (self.nasServer.unixIda && !self.nasServer.windowsIda) {
					createPseudoClientReq.clientInfo.nonNDMPClientProperties = {
						osType: '2'
					};
				} else if (self.nasServer.windowsIda && !self.nasServer.unixIda) {
					createPseudoClientReq.clientInfo.nonNDMPClientProperties = {
						osType: '1'
					};
				}

				nasService
					.createNetworkShareClient(JSON.stringify(createPseudoClientReq))
					.success(function(data) {
						if (data.response.errorCode == 0) {
							cvToaster.showSuccessMessage({
								message: data.response.entity.clientName + ' Networkshare client created successfully'
							});
						}
						self.successCallBack(data);
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							message: e
						});
						$modalInstance.dismiss();
					})
					.then(function() {
						$modalInstance.dismiss();
					});
			}

			// For Any client with NAS IDA send this request
		};

		self.emptyServerMsg = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};
		};

		self.addServerMsg = function(messageTxt, typeTxt) {
			self.serverMessage = {
				message: messageTxt,
				type: typeTxt
			};
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};
	}
];

controllers.addIDAToNasClient = [
	'$log',
	'$state',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'nasService',
	'$uibModalInstance',
	'cvToaster',
	'addIdaParams',
	'AppTypesUtil',
	'nasClientFactory',
	function(
		$log,
		$state,
		$stateParams,
		cvLoc,
		cvUtil,
		nasService,
		$modalInstance,
		cvToaster,
		addIdaParams,
		AppTypesUtil,
		nasClientFactory
	) {
		var self = this;

		self.nasServer = {
			clientId: 0,
			clientName: '',
			hostName: '',
			vendor: '',
			unixIda: false,
			disableUnixIda: false,
			windowsIda: false,
			disableWindowsIda: false,
			nasIda: false,
			disableNasIda: false,
			ndmpLogin: '',
			ndmpPassword: '',
			ndmpPort: 10000,
			detectMAList: [],
			detectMa: undefined,
			isNutanixClient: false
		};

		self.renderDetectMA = function() {
			// Detect MA
			self.detectMADropDownMsg = cvLoc('label.loading');

			if (self.nasServer.nasIda && !self.nasServer.disableNasIda) {
				nasService
					.getNasProxyList(0, 64, 5, 2)
					.success(function(data) {
						self.nasServer.detectMAList = data;
						self.detectMADropDownMsg = cvLoc('label.selectDetectMa');
					})
					.error(function() {
						self.detectMADropDownMsg = cvLoc('error.loadingDetectMa');
					});
			}
		};

		if (typeof addIdaParams != undefined) {
			self.nasServer.clientId = addIdaParams.client.clientEntity.clientId;
			self.nasServer.clientName = addIdaParams.client.clientEntity.clientName;
			self.nasServer.disableClientName = true;
			self.nasServer.hostName = addIdaParams.client.clientEntity.hostName;
			self.nasServer.clientEntity = addIdaParams.client.clientEntity;
			self.nasServer.isNutanixClient = addIdaParams.pseudoClientInfo.clientAppType === 'NUTANIX_AFS';

			if (addIdaParams.client) {
				nasClientFactory.getAgentsList(addIdaParams.client.clientEntity.clientId).then(function() {
					addIdaParams.client.idaList = nasClientFactory.agentsList;

					addIdaParams.client.idaList.forEach(function(item) {
						if (AppTypesUtil.isNASAgent(item.idaEntity.applicationId)) {
							self.nasServer.nasIda = true;
							self.nasServer.disableNasIda = true;
						} else if (AppTypesUtil.isWindowsFileSystem(item.idaEntity.applicationId)) {
							self.nasServer.windowsIda = true;
							self.nasServer.disableWindowsIda = true;
						} else if (AppTypesUtil.isUnixFileSystem(item.idaEntity.applicationId)) {
							self.nasServer.unixIda = true;
							self.nasServer.disableUnixIda = true;
						}
						return item;
					});
				});
			}
		}

		// Construct AddNASFilerRequest
		self.validateInputFields = function() {
			self.emptyServerMsg();

			var bValidInput = true;
			self.showSelectBackupTypeHelpText = false;
			self.showEnterNdmpLoginHelpText = false;
			self.showEnterNdmpPassHelpText = false;
			self.selectEnterNasVendorHelpText = false;
			self.selectEnterNasVendorHelpText = false;
			self.selectHostNameHelpText = false;
			self.selectClientNameHelpText = false;

			if (!(self.nasServer.unixIda || self.nasServer.windowsIda || self.nasServer.nasIda)) {
				self.showSelectBackupTypeHelpText = true;
				bValidInput = false;
			}

			// Validate Server Details
			if (self.nasServer.nasIda && !self.nasServer.disableNasIda) {
				if (!self.nasServer.ndmpLogin) {
					self.showEnterNdmpLoginHelpText = true;
					bValidInput = false;
				}

				if (!self.nasServer.ndmpPassword) {
					self.showEnterNdmpPassHelpText = true;
					bValidInput = false;
				}
			}

			if (!self.nasServer.hostName) {
				self.selectHostNameHelpText = true;
				bValidInput = false;
			}

			return bValidInput;
		};

		self.addNasServer = function() {
			if (!self.validateInputFields()) {
				return;
			}

			var ndmpServerDetails = {
				ndmpServerHostName: self.nasServer.hostName,
				ndmpServerClientName: self.nasServer.clientName,
				ndmpCredentials: {
					password: cvUtil.getBytes(self.nasServer.ndmpPassword),
					userName: self.nasServer.ndmpLogin
				}
			};

			var detectMediaAgent = {
				_type_: '11',
				mediaAgentId: self.nasServer.detectMa ? JSON.parse(self.nasServer.detectMa).clientId : 0,
				mediaAgentName: self.nasServer.detectMa ? JSON.parse(self.nasServer.detectMa).clientName : ''
			};

			var detectNDMPSrvReq = {
				ndmpServerDetails: ndmpServerDetails,
				detectMediaAgent: detectMediaAgent,
				listenPort: self.nasServer.ndmpPort.toString()
			};

			var nasClientProperties = {
				ndmpServerDetails: ndmpServerDetails,
				detectMediaAgent: detectMediaAgent,
				listenPort: self.nasServer.ndmpPort.toString()
			};

			var createPseudoClientReq = {
				clientInfo: {},
				entity: {
					clientId: self.nasServer.clientId,
					clientName: self.nasServer.clientName
				}
			};

			if (self.nasServer.nasIda && !self.nasServer.disableNasIda) {
				var nasTurboFSCreateReq = {
					turboNASproperties: {}
				};

				if (self.nasServer.unixIda && self.nasServer.windowsIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '3';
				} else if (self.nasServer.unixIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '2';
				} else if (self.nasServer.windowsIda) {
					nasTurboFSCreateReq.turboNASproperties.osType = '1';
				}

				var AddNASFileServerRequest = {
					clientId: self.nasServer.clientId,
					listenPort: self.nasServer.ndmpPort.toString(),
					vendorType: self.nasServer.vendor
				};

				createPseudoClientReq.clientInfo.clientType = '2';
				createPseudoClientReq.clientInfo.nasClientProperties = nasClientProperties;
				AddNASFileServerRequest.createPseudoClientReq = createPseudoClientReq;
				AddNASFileServerRequest.detectNDMPSrvReq = detectNDMPSrvReq;
				AddNASFileServerRequest.nasTurboFSCreateReq = nasTurboFSCreateReq;

				nasService
					.createNASClient(JSON.stringify(AddNASFileServerRequest))
					.success(function(data) {
						if (data.errorCode === 0) {
							cvToaster.showSuccessMessage({
								message:
									data.createPseudoClientResp.response.entity.clientName + ' Networkshare client created successfully'
							});
							$state.forceReload();
							$modalInstance.dismiss();
						} else {
							cvToaster.showErrorMessage({
								message: data.errorMessage ? data.errorMessage : cvLoc('error.createNasClient')
							});
						}
					})
					.error(function(e) {
						cvToaster.showErrorMessage({
							message: e
						});
						$modalInstance.dismiss();
					})
					.then(function() {});
			} else {
				if (self.nasServer.windowsIda && !self.nasServer.disableWindowsIda) {
					self
						.addNetworkShareIda(self.nasServer.clientId, self.nasServer.clientName, self.nasServer.hostName, '1')
						.then(function() {
							if (self.nasServer.unixIda && !self.nasServer.disableUnixIda) {
								self
									.addNetworkShareIda(self.nasServer.clientId, self.nasServer.clientName, self.nasServer.hostName, '2')
									.then(function() {
										$state.forceReload();
									});
							} else {
								$state.forceReload();
							}
						});
				} else if (self.nasServer.unixIda && !self.nasServer.disableUnixIda) {
					self
						.addNetworkShareIda(self.nasServer.clientId, self.nasServer.clientName, self.nasServer.hostName, '2')
						.then(function() {
							$state.forceReload();
						});
				}
			}
		};

		self.addNetworkShareIda = function(clientId, clientName, hostName, osType) {
			var NasTurboFScreateReq = {
				client: {
					clientId: clientId,
					clientName: clientName,
					hostName: hostName
				},
				turboNASproperties: {
					osType: osType
				}
			};

			return nasService
				.addNetworkShareIda(JSON.stringify(NasTurboFScreateReq))
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: data.errorMessage
					});
					$modalInstance.dismiss();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						message: e
					});
					$modalInstance.dismiss();
				});
		};

		self.emptyServerMsg = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};
		};

		self.addServerMsg = function(messageTxt, typeTxt) {
			self.serverMessage = {
				message: messageTxt,
				type: typeTxt
			};
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};
	}
];

controllers.addNasSubclientController = [
	'$log',
	'$state',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'nasService',
	'$uibModal',
	'$uibModalInstance',
	'cvToaster',
	'nasSubclientFactory',
	'clientInfo',
	'agentsList',
	'agentInfo',
	'profileService',
	'fsSubclientContent',
	'AppTypesUtil',
	'backupSetFactory',
	'storageService',
	'subclientService',
	'ENTITY_TYPES',
	'AppTypes',
	'nasFactory',
	function(
		$log,
		$state,
		$stateParams,
		cvLoc,
		cvUtil,
		nasService,
		$modal,
		$modalInstance,
		cvToaster,
		nasSubclientFactory,
		clientInfo,
		agentsList,
		agentInfo,
		profileService,
		fsSubclientContent,
		AppTypesUtil,
		backupSetFactory,
		storageService,
		subclientService,
		ENTITY_TYPES,
		AppTypes,
		nasFactory
	) {
		var self = this;

		self.subclientInfo = {
			selectedPlan: null,
			clientName: '',
			clientId: 0,
			backupsetId: 0,
			backupsetName: '',
			instanceId: 0,
			subclientName: '',
			description: '',
			enableBackup: true,
			iDataAgent: '',
			content: [],
			storagePoliciesList: [],
			storagePolicy: null,
			logStoragePolicy: null,
			agentInfo: {
				applicationId: 0,
				agentType: {
					backupsetSupported: false,
					instanceSupported: false
				}
			},
			backupSystemState: false,
			contentPaths: '',
			backupTypeList: [],
			proxyMaList: [],
			selectedProxyMA: undefined,
			content: {}
		};
		self.tabControls = {};
		self.localLang = cvUtil.getIStevenLocLabels();
		self.planList = [];
		self.backupTypeList = [];
		var storagePoliciesLoaded = false;

		var doInit = true;
		self.subclientInfo.content = fsSubclientContent.getDetailedContentEntityList(doInit);

		if (clientInfo && agentsList) {
			self.clientInfo = clientInfo;
			self.clientId = clientInfo.client.clientEntity.clientId;
			self.subclientInfo.clientId = clientInfo.client.clientEntity.clientId;
			self.subclientInfo.clientName = clientInfo.client.clientEntity.clientName;

			agentsList.forEach(function(item) {
				if (item.idaEntity.applicationId == AppTypes.NAS) {
					self.backupTypeList.push({
						name: 'NDMP',
						id: AppTypes.NAS
					});
				} else if (item.idaEntity.applicationId == AppTypes.UNIX_FILESYSTEM) {
					self.backupTypeList.push({
						name: 'NFS',
						id: AppTypes.UNIX_FILESYSTEM
					});
				} else if (item.idaEntity.applicationId == AppTypes.WINDOWS_FILESYSTEM) {
					self.backupTypeList.push({
						name: 'CIFS',
						id: AppTypes.WINDOWS_FILESYSTEM
					});
				}
			});
		} else if (agentInfo) {
			self.agentInfo = agentInfo;
			self.clientId = agentInfo.idaEntity.clientId;
			self.subclientInfo.clientId = agentInfo.idaEntity.clientId;
			self.subclientInfo.clientName = agentInfo.idaEntity.clientName;

			if (agentInfo.idaEntity.applicationId == AppTypes.NAS) {
				self.backupTypeList.push({
					name: 'NDMP',
					id: AppTypes.NAS
				});
			} else if (agentInfo.idaEntity.applicationId == AppTypes.WINDOWS_FILESYSTEM) {
				self.backupTypeList.push({
					name: 'CIFS',
					id: AppTypes.WINDOWS_FILESYSTEM
				});
			} else if (agentInfo.idaEntity.applicationId == AppTypes.UNIX_FILESYSTEM) {
				self.backupTypeList.push({
					name: 'NFS',
					id: AppTypes.UNIX_FILESYSTEM
				});
			}
		}

		self.loadStoragePolicy = function() {
			storageService
				.getStoragePoliciesList()
				.success(function(storagePolicies) {
					self.subclientInfo.storagePoliciesList = storagePolicies;
					storagePoliciesLoaded = true;
					self.emptyServerMsg();
				})
				.error(function(errorReason) {
					$log.error(errorReason);

					self.addServerMsg(cvLoc('generic_error'), 'error');
				});
		};

		self.backupTypeChanged = function() {
			// Get Default backup Set for
			self.planDropDownMsg = cvLoc('label.loading');

			nasSubclientFactory.getDefaultBackupSet(self.clientId, self.subclientInfo.backupType).then(function() {
				self.subclientInfo.backupsetId = nasSubclientFactory.defaultBackupSet.backupsetId;
				self.subclientInfo.backupsetName = nasSubclientFactory.defaultBackupSet.backupsetName;
				self.subclientInfo.iDataAgent = nasSubclientFactory.defaultBackupSet.appName;
				self.subclientInfo.applicationId = nasSubclientFactory.defaultBackupSet.applicationId;
				self.subclientInfo.agentInfo.applicationId = nasSubclientFactory.defaultBackupSet.applicationId;

				nasService
					.getEligiblePlansForNASSubClient()
					.success(function(data) {
						self.serverMessage = cvUtil.emptyMsg();
						if (data.length > 0) {
							self.planList = data;
							self.planDropDownMsg = cvLoc('label.selectPlan');
						} else {
							self.serverMessage = cvUtil.errMsgLoc('error.noProfiles');
							self.planDropDownMsg = cvUtil.errMsgLoc('error.noProfiles').message;
						}
					})
					.error(function(e) {
						self.serverMessage = cvUtil.errMsg(e);
					});

				if (nasSubclientFactory.defaultBackupSet.backupsetId === undefined) {
					self.addServerMsg(cvLoc('generic_error'), 'error');

					$log.error('backupsetId is not defined');
					return;
				}

				self.contentOptions = {
					clientId: self.subclientInfo.clientId,
					applicationId: self.subclientInfo.applicationId,
					backupSetId: self.subclientInfo.backupsetId,
					isForSubclientPolicy: false,
					forNewSubclientCreation: true,
					subclientDetails: {
						subClientEntity: {
							clientId: self.subclientInfo.clientId,
							applicationId: self.subclientInfo.applicationId
						},
						fsSubClientProp: {
							enableNetworkShareAutoMount: self.isNetworkShareSubclient(),
							backupDataAccessNodes: self.subclientInfo.selectedProxyMA
								? [
										{
											clientId: JSON.parse(self.subclientInfo.selectedProxyMA).clientId,
											clientName: JSON.parse(self.subclientInfo.selectedProxyMA).clientName
										}
								  ]
								: undefined
						}
					}
				};

				self.loadStoragePolicy();
			});

			// Clear Content fields
			self.subclientInfo.contentPaths = '';

			// Detect MA
			self.proxyMADropDownMsg = cvLoc('label.loading');

			if (self.subclientInfo.backupType) {
				if (AppTypesUtil.isNASAgent(self.subclientInfo.backupType)) {
					self.appType = '64';
					self.clusterType = '5';
					self.requestType = '2';
				} else if (AppTypesUtil.isUnixFileSystem(self.subclientInfo.backupType)) {
					self.appType = '64';
					self.clusterType = '4';
					self.requestType = '1';
				} else {
					self.appType = '64';
					self.clusterType = '5';
					self.requestType = '1';
				}

				nasService
					.getNasProxyList(0, self.appType, self.clusterType, self.requestType)
					.success(function(data) {
						self.subclientInfo.proxyMaList = data;
						self.proxyMADropDownMsg = cvLoc('label.selectProxyMa');
					})
					.error(function() {
						self.proxyMADropDownMsg = cvLoc('error.loadingProxyNode');
					});
			}
		};

		self.proxyChanged = () => {
			self.clientIdForProxy = self.subclientInfo.selectedProxyMA
				? JSON.parse(self.subclientInfo.selectedProxyMA).clientId
				: -1;
		};

		self.getContentForSubclientCreation = function() {
			var contentOfPathType = [],
				contentOfExcludePathType = [],
				contentOfIncludePathType = [];
			for (
				var iterator = 0, length = self.subclientInfo.content.contentEntities.length;
				iterator < length;
				iterator++
			) {
				const contentEntity = self.subclientInfo.content.contentEntities[iterator];
				if (contentEntity.type == 0 && !contentEntity.isReadOnly) {
					//path
					contentOfPathType.push(self.subclientInfo.content.contentEntities[iterator].path);
				} else if (contentEntity.type == 1 && !contentEntity.isReadOnly) {
					//ExcludePath
					contentOfExcludePathType.push(self.subclientInfo.content.contentEntities[iterator].path);
				} else if (contentEntity.type == 2 && !contentEntity.isReadOnly) {
					//IncludePath
					contentOfIncludePathType.push(self.subclientInfo.content.contentEntities[iterator].path);
				}
			}
			return [contentOfPathType, contentOfExcludePathType, contentOfIncludePathType];
		};

		self.emptyServerMsg = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};
		};

		self.addServerMsg = function(messageTxt, typeTxt) {
			self.serverMessage = {
				message: messageTxt,
				type: typeTxt
			};
		};

		self.addContent = function() {
			self.emptyServerMsg();
			fsSubclientContent.manageFSSubclientContentDetails(self.clientId, self.subclientInfo.backupType);
		};

		self.cancel = function() {
			$modalInstance.dismiss();
		};

		self.validateInputFields = function() {
			var bValidInput = true;
			self.showEnterSubclientNameHelpText = false;
			self.showSelectBackupTypeHelpText = false;
			self.showCifsLoginHelpText = false;
			self.showCifsPasswordHelpText = false;
			self.showCifsDomainHelpText = false;
			self.showSelectPlanHelpText = false;
			self.showEnterContentHelpText = false;
			self.showProxyHelpText = false;

			self.emptyServerMsg();

			// Validate SubClient Name
			if (!self.subclientInfo.subclientName || self.subclientInfo.subclientName.trim().length === 0) {
				//self.addServerMsg("Enter Valid Subclient Name",'error');
				self.showEnterSubclientNameHelpText = true;
				bValidInput = false;
			}

			// Validating Backup Plan
			if (!self.subclientInfo.applicationId || !self.subclientInfo.backupType) {
				self.showSelectBackupTypeHelpText = true;

				bValidInput = false;
			}

			/*
			 * //validating CIFS credentials if (self.subclientInfo.backupType != "13") {
			 *
			 * if (!self.subclientInfo.selectedProxyMA) { self.showProxyHelpText = true; bValidInput = false; } }
			 * //validating CIFS credentials if (self.subclientInfo.backupType == AppTypes.WINDOWS_FILESYSTEM) {
			 *
			 * if (!self.subclientInfo.cifsLogin || self.subclientInfo.cifsLogin.trim().length === 0) {
			 *
			 * self.showCifsLoginHelpText = true; bValidInput = false; }
			 *
			 * if (!self.subclientInfo.cifsPassword || self.subclientInfo.cifsPassword.trim().length === 0) {
			 *
			 * self.showCifsPasswordHelpText = true; bValidInput = false; } }
			 */
			// Validate Plan
			if (!self.subclientInfo.selectedPlan) {
				self.showSelectPlanHelpText = true;
				bValidInput = false;
			}

			// validating content
			var content = self.getContentForSubclientCreation();
			if (content == undefined || content.length == 0 || content[0].length == 0) {
				self.showEnterContentHelpText = true;
				bValidInput = false;
			}

			// Validating Fields for subClientEntity,
			if (
				!self.subclientInfo.clientId ||
				!self.subclientInfo.clientName ||
				!self.subclientInfo.backupsetId ||
				!self.subclientInfo.backupsetName
			) {
				//self.addServerMsg('Validation failed', 'error');
				//bValidInput = false;
			}

			return bValidInput;
		};

		self.resetContentValidation = function() {
			self.showEnterContentHelpText = false;
		};

		self.isNetworkShareSubclient = function() {
			return (
				AppTypesUtil.isUnixFileSystem(self.subclientInfo.backupType) ||
				AppTypesUtil.isWindowsFileSystem(self.subclientInfo.backupType)
			);
		};

		self.browseClient = function() {
			self.nasParams = {
				appId: self.subclientInfo.backupType
			};

			// NFS && CIFS browse
			if (self.isNetworkShareSubclient()) {
				self.nasParams.enableAutomountBrowse = true;
				self.scInfo = {
					subClientEntity: {
						applicationId: self.subclientInfo.backupType,
						clientId: self.clientId
					},
					impersonateUser: {
						userName: self.subclientInfo.cifsLogin,
						password: self.subclientInfo.cifsPassword
					},
					selectedProxyMA: self.subclientInfo.selectedProxyMA
				};

				var autoMountModalInstance = nasFactory.openNetworkShareAutoMountBrowse({
					subclientInfo: self.scInfo
				});

				autoMountModalInstance.result.then(function(result) {
					self.nasParams.interfacePath = result.interfacePath;
					self.nasParams.proxy = result.proxyMA;
					self.nasParams.userName = result.userName;
					self.nasParams.password = result.password;
					self.nasParams.enableAutomountBrowse = true;
					self.subclientInfo.cifsPassword = result.password;
					self.subclientInfo.cifsLogin = result.userName;

					self.doMachineBrowse();
					autoMountModalInstance.dismiss();
				});
			} else {
				self.doMachineBrowse();
			}
		};

		self.doMachineBrowse = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							clientId: self.clientId,
							useNasBrowse: true,
							foldersOnly: false,
							selectMultiple: true,
							nasBrowseOptions: self.nasParams
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					console.log(result);
					self.subclientInfo.contentPaths = (self.subclientInfo.contentPaths + '\n' + result.paths.join('\n')).trim();
					self.showEnterContentHelpText = false;
				},
				function() {
					$log.debug('Cancel clicked');
				}
			);
		};

		self.createSubclient = function() {
			if (!self.validateInputFields()) {
				return;
			}

			// Populate subclient Data

			var subClientEntity = {
				clientId: self.subclientInfo.clientId,
				clientName: self.subclientInfo.clientName,
				applicationId: self.subclientInfo.agentInfo.applicationId,
				instanceId: undefined,
				instanceName: undefined,
				subclientName: self.subclientInfo.subclientName,
				backupsetId: self.subclientInfo.backupsetId,
				backupsetName: self.subclientInfo.backupsetName
			};

			// Populate Content for Subclient

			var content = self.getContentForSubclientCreation();

			// validating Content
			if (content === undefined || content.length === 0 || content[0].length === 0) {
				self.serverMessage = {
					message: cvLoc('error.addContent'),
					type: 'error'
				};
				self.tabControls.selectTab(1);
				return;
			}

			// Populate SubclientInfo
			var scInfo = {};
			var fsSubClientProp = {};
			// fsSubClientProp.backupSystemState =
			// self.subclientInfo.backupSystemState;
			scInfo.fsSubClientProp = fsSubClientProp;
			var credentials = self.contentOptions.getUserCredentials();

			if (self.subclientInfo.backupType == AppTypes.WINDOWS_FILESYSTEM) {
				scInfo.impersonateUser = credentials;
			}

			let storageDeviceOptions = {
				networkAgents: 2
			};

			var scCommonProperties = {
				description: '',
				enableBackup: true,
				impersonateUserCredentialinfo: credentials.impersonateUserCredentialinfo,
				storageDevice: storageDeviceOptions
			};

			// For NDMP, set the default number of streams.
			if (AppTypesUtil.isNASAgent(self.subclientInfo.backupType)) {
				scCommonProperties.numberOfBackupStreams = 4;
				// Must NOT set allowMultipleDataReaders - that is defaulted in the backend based on vendor and model
			} else {
				// The backend AppIdInterfaceDB.cpp first properly defaults numberOfBackupStreams to 0, the incorrectly defaults it to 4
				// For now keep passing 0 here since the changes are least regressive.
				// 0 means the agent figures out the best number of streams - so it is important for performance.
				scCommonProperties.numberOfBackupStreams = 0;
				scCommonProperties.allowMultipleDataReaders = true;
			}

			let prepostData = self.getPrepostData();
			scCommonProperties.prepostProcess = _.get(prepostData, 'scInfo.commonProperties.prepostProcess', {});

			scInfo = {
				commonProperties: scCommonProperties,
				fsSubClientProp: self.subclientInfo.selectedProxyMA
					? {
							backupConfiguration: {
								backupDataAccessNodes: [
									{
										clientId: JSON.parse(self.subclientInfo.selectedProxyMA).clientId,
										clientName: JSON.parse(self.subclientInfo.selectedProxyMA).clientName
									}
								]
							},
							enableNetworkShareAutoMount: self.isAutomountContentAdded()
					  }
					: undefined
				// Populate Plan
			};
			var planId = null;
			planId = self.subclientInfo.selectedPlan;

			// Log
			$log.log('Creating new subclient.');

			// Submit the request
			nasService
				.createNasSubclient({
					subClientEntity: JSON.stringify(subClientEntity),
					subclientInfo: angular.toJson(scInfo),
					content: JSON.stringify(content),
					planId: planId
				})
				.success(function(successData) {
					$state.forceReload();
					$modalInstance.dismiss();
				})
				.error(function(errorMessage) {
					if (errorMessage !== null) {
						$log.error(errorMessage);
						self.addServerMsg(errorMessage, 'error');
					}
				})
				.then(function() {});
		};

		self.isAutomountContentAdded = function() {
			if (AppTypesUtil.isWindowsFileSystem(self.subclientInfo.backupType)) {
				return true;
			} else if (AppTypesUtil.isUnixFileSystem(self.subclientInfo.backupType)) {
				if (cvUtil.objectContainsNestedProperty('self.subclientInfo.content.contentEntities', self)) {
					let contentEntities = self.subclientInfo.content.contentEntities;
					if (
						contentEntities !== null &&
						_.find(
							contentEntities,
							function isMountPath(value) {
								return value.path.indexOf(':') > -1;
							},
							0
						) !== undefined
					) {
						return true;
					}
				}
			}
			return false;
		};

		self.setPrepostGetterFunction = getPrepostData => {
			self.getPrepostData = getPrepostData;
		};
	}
];

nasMod.controller(controllers);

export default nasMod;
