import { acAppNasModule } from 'common/js/modules';

class EditAccessnodeModalController {
	constructor(cvLoc, accessnodeoptions, $uibModalInstance, cvUtil, nasFactory) {
		this.cvLoc = cvLoc;
		this.accessnodeoptions = accessnodeoptions;
		this.$modalInstance = $uibModalInstance;
		this.cvUtil = cvUtil;
		this.nasFactory = nasFactory;

		// Removing unnecessary attributes as soon as the modal is initialized
		this._filterAccessnodeAttributes();

		this.accessnodedropdownoption = { ...accessnodeoptions };
		// do not show the access nodes as selected in the dropdown when inherited from Agent
		if (this.accessnodedropdownoption && this.accessnodedropdownoption.inheritedFromAgent) {
			this.accessnodedropdownoption.backupDataAccessNodes = [];
		}
		this.selectedAccessnodes = this.accessnodedropdownoption.backupDataAccessNodes || [];
		this.dismissModal = this.$modalInstance.dismiss;
		this.editAccessnodeModalMessage = this.cvUtil.emptyMsg();
		this.accessnodedropdownoption.showHelpText =
			!this.accessnodedropdownoption.accessnodeRequired && this.selectedAccessnodes.length == 0;
		this.accessnodedropdownoption.onError = error => {
			this.editAccessnodeModalMessage = this.cvUtil.errMsgWrapper(error);
		};

		this.accessnodedropdownoption.successFn = backupDataAccessNodes => {
			this.selectedAccessnodes = backupDataAccessNodes;
		};
	}

	saveAccessnodes() {
		this.editAccessnodeModalMessage = this.cvUtil.emptyMsg();

		if (this.accessnodedropdownoption.accessnodeRequired && _.isEmpty(this.selectedAccessnodes)) {
			// Do not save if its a required field
			this.accessnodedropdownoption.showerror = true;
			return;
		}

		if (_.isFunction(this.accessnodeoptions.successFn)) {
			this.accessnodeoptions.successFn(this.selectedAccessnodes).then(
				() => {
					this.accessnodeoptions.backupDataAccessNodes = this.selectedAccessnodes;

					if (this.selectedAccessnodes.length > 0 && this.accessnodedropdownoption.inheritedFromAgent) {
						this.accessnodeoptions.inheritedFromAgent = false;
					}

					// when there are agent level access node selections
					if (
						this.selectedAccessnodes.length === 0 &&
						this.accessnodedropdownoption.backupDataAccessNodesFronAgent &&
						this.accessnodedropdownoption.backupDataAccessNodesFronAgent.length > 0
					) {
						this.accessnodeoptions.inheritedFromAgent = true;
						this.accessnodeoptions.backupDataAccessNodes = this.accessnodedropdownoption.backupDataAccessNodesFronAgent;
					}

					this.$modalInstance.close();
				},
				error => {
					this.editAccessnodeModalMessage = this.cvUtil.errMsgWrapper(error);
				}
			);
		} else {
			this.accessnodeoptions.backupDataAccessNodes = this.selectedAccessnodes;
			this.$modalInstance.close();
			console.warn('successFn not implemented in accessnodeoptions');
		}
	}

	_filterAccessnodeAttributes() {
		this.accessnodeoptions.backupDataAccessNodes = this.nasFactory.filterAccessnodeAttributes(
			this.accessnodeoptions.backupDataAccessNodes
		);
	}
}

EditAccessnodeModalController.$inject = ['cvLoc', 'accessnodeoptions', '$uibModalInstance', 'cvUtil', 'nasFactory'];

acAppNasModule.controller('editAccessnodeModalController', EditAccessnodeModalController);

export default acAppNasModule;
