import 'modules/snapArrays/js/services/snapArray.svc.js';
import { acAppClientModule } from 'common/js/modules';
import { NAS_CONSTANTS } from 'modules/nas/js/constants';

/**
 *
 */

export class createArrayController {
	constructor(nasFactory, cvLoc, $modalInstance, snapArrayService, params, cvUtil) {
		this.cvUtil = cvUtil;
		this.snapArrayService = snapArrayService;
		this.nasFactory = nasFactory;
		this.cvLoc = cvLoc;
		this.modalInstance = $modalInstance;
		this.requiredPropertiesPath = ['arrayInfo.arrayName.name', 'arrayInfo.userPswd.userName', 'arrayPassword'];
		this.errorMessage = {};
		this.preview = {};
		this.requiredProperties = {};
		this.showErrors = false;
		this.clientType = params.clientType;
		this.params = params;
		this.showControlHost = false;
		this.showPreview = false;
		this.arrayPassword = '';

		if (this.params.clientType === NAS_CONSTANTS.NAS) {
			this.vendorList = [];
			this.vendorList = this.nasFactory
				.getVendorList()
				.filter(
					vendor => vendor.serverType === NAS_CONSTANTS.NAS && vendor.clientAppTypeName !== NAS_CONSTANTS.GENERIC
				);
			this.vendorListLabel = {
				nothingSelected: this.cvLoc('label.vendor.selectVendorType')
			};

			if (this.params.vendor && this.params.vendor.id && this.params.vendor.id !== 10) {
				let vendor = _.find(this.vendorList, { vendorType: this.params.vendor.id });
				vendor.selected = true;
				this.selectedVendor = [vendor];
				this.updateControlHostVisibility();
			}
		}

		this.arrayInfo = {
			arrayName: {
				name: '',
				id: 0
			},
			userPswd: {
				password: '',
				userName: ''
			},
			vendor: params.vendor,
			ctrlHostName: params.clientType === NAS_CONSTANTS.NAS ? '' : undefined
		};

		if (this.params.arrayInfo) {
			this.arrayInfo = { ...this.arrayInfo, ...this.params.arrayInfo };
			this.arrayPassword = Base64.decode(this.arrayInfo.userPswd.password);
		}

		if (params.vendor.name === NAS_CONSTANTS.DELL_EMC_ISILON) {
			this.showControlHost = true;
			if (!this.arrayInfo.ctrlHostName) {
				this.arrayInfo.ctrlHostName = '';
			}
		}

		this.arrayNameLabel = cvLoc('label.ArrayName');
		this.headingLabel = this.cvLoc('action.add');
		this.userLabel = this.cvLoc('label.UserName');
		this.arrayNamPlaceholderText = '';
		if (this.params.clientType === NAS_CONSTANTS.NUTANIX) {
			this.arrayNameLabel = cvLoc('label.fileServerHost');
			this.headingLabel = this.cvLoc('label.addNutanixFileServer');
			this.userLabel = this.cvLoc('label.nutanixUser');
			this.arrayNamPlaceholderText = this.cvLoc('label.errorFQDN');
		}
	}

	updateControlHostVisibility() {
		if (this.selectedVendor[0].clientAppTypeName !== NAS_CONSTANTS.NETAPP) {
			this.showControlHost = true;
			this.requiredPropertiesPath.push('arrayInfo.ctrlHostName');
		} else {
			this.showControlHost = false;
			this.requiredPropertiesPath = this.requiredPropertiesPath.filter(function(item) {
				return item !== 'arrayInfo.ctrlHostName';
			});
		}
	}

	validateHostName() {
		this.showHostNameFQDNError = this.nasFactory.isIpAddress(this.arrayInfo.arrayName.name, this.params.clientType);
	}

	validateArrayInfo() {
		let self = this;
		let validateProperty = function(prop) {
			let isValid = true;
			self.requiredProperties[prop] = false;

			if (!_.get(self, prop)) {
				self.requiredProperties[prop] = true;
				isValid = false;
			}
			return isValid;
		};

		let valid = true;
		for (var prop of self.requiredPropertiesPath) {
			valid = validateProperty(prop) && valid;
		}

		self.validateHostName();
		valid = valid && !self.showHostNameFQDNError;

		if (self.params.clientType === NAS_CONSTANTS.NAS && self.selectedVendor.length === 0) {
			valid = false;
		}

		return valid;
	}

	updateVendor() {
		let vendor = this.selectedVendor[0];
		this.arrayInfo.vendor = {
			name: vendor.vendorName,
			id: vendor.vendorType
		};

		this.updateControlHostVisibility(this.arrayInfo.vendor);
	}

	addArray(preview) {
		let self = this;
		this.showErrors = false;
		this.showPreview = false;
		self.errorMessage = {};
		self.previewMessage = {};
		if (!this.validateArrayInfo()) {
			this.showErrors = true;
			return;
		}

		let request = {
			assocType: 3,
			info: self.arrayInfo,
			planId: self.params.planId,
			selectedVendor: this.selectedVendor
		};

		request.info.userPswd.password = self.arrayPassword ? btoa(self.arrayPassword) : '';

		if (this.params.clientId) {
			request.clientId = this.params.clientId;
		}

		if (preview) {
			request.flags = 1; // when flag is set to 1, the array will not be saved and only used for validating the array connection nd knowing the version.
		}

		let jsonRequest = JSON.stringify(request);

		// If it is Nutanix or Array preview for NAS. Delay the save for NAS as adding the array will create a deconfigured client with NDMP protocol.
		if (preview || self.params.autoSave) {
			this.snapArrayService
				.createArray(jsonRequest)
				.success(data => {
					if (data.errorCode === 0) {
						if (preview) {
							self.previewMessage.message += ' ' + self.cvLoc('label.arrayVersionIs');
							self.previewMessage = self.cvUtil.infoMsg(self.cvLoc('label.arrayPreviewSuccess'));
							if (data.errorMessage) {
								self.previewMessage.message += ' ' + data.errorMessage;
							}
						} else {
							self.modalInstance.close(self.arrayInfo.arrayName.name);
						}
					} else {
						self.errorMessage = self.cvUtil.errMsg(data.errorMessage);
					}
				})
				.error(e => {
					self.errorMessage = self.cvUtil.errMsg(e.errorMessage);
				});
		} else {
			self.modalInstance.close(request);
		}
	}

	cancel() {
		this.modalInstance.dismiss();
	}
}
createArrayController.$inject = ['nasFactory', 'cvLoc', '$uibModalInstance', 'snapArrayService', 'params', 'cvUtil'];
acAppClientModule.controller('createArrayController', createArrayController);
