export const NAS_CONSTANTS = {
	NUTANIX: 'NUTANIX',
	NUTANIX_AFS: 'NUTANIX_AFS',
	QUMULO: 'QUMULO',
	NAS: 'NAS',
	NUTANIX_LABEL: 'Nutanix',
	QUMULO_LABEL: 'Qumulo',
	NAS_LABEL: 'Nas',
	CIFS: 'CIFS',
	NFS: 'NFS',
	NDMP: 'NDMP',
	GPFS: 'GPFS',
	WINDOWSACCOUNT: 'WINDOWSACCOUNT', // filter to show windows credentials for CIFS impersonation
	HUAWEI: 'HUAWEI',
	UNITY: 'UNITY',
	CELERRA_VNX: 'CELERRA_VNX',
	ISILON: 'ISILON',
	NETAPP: 'NETAPP',
	WINDOWS: 'windows',
	LINUX: 'linux',
	DELL_EMC_ISILON: 'Dell EMC Isilon',
	GENERIC: 'GENERIC',
	GLUSTERFS: 'GLUSTERFS',
	LUSTREFS: 'LUSTREFS',
	GENERIC_NDMP_SERVER: 'Generic_NDMP_Server',
	GENERIC_FILER_OS_ID: 19
};

export const CLIENT_INFO = {
	NAS: {
		clientType: 2 // NAS
	},
	NUTANIX: {
		clientType: 18, // Non-ndmp-client
		clientAppType: 2 //Nutanix
	},
	QUMULO: {
		clientType: 18, // Non-ndmp-client
		clientAppType: 10, // Qumulo
		userCredentials: {}
	}
};

export const PROTOCOLS = {
	NAS: [33, 29, 13],
	NUTANIX: [33, 29],
	QUMULO: [33, 29]
};

export const SUPPORTED_SNAP_VENDORS = ['Network_Appliance', 'DellEmcUnity', 'Isilon', 'HuaweiNas', 'BlueArc'];

export const SUPPORTED_SNAP_OS_IDS = [16, 17, 29];
