<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.mySql"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sybase"></cv:cvMessages>
</script>

<script type="text/ng-template"  id="sybaseRestoreOptions.html">
	<div class="form-group" data-ng-if="sybaseRestore.isRefreshEnabled">
		<label class="col-xs-12 col-sm-4" for="serverStatus">
			<cv:msg key="label.ServerState" bundle="sybase"/>
		</label>
		<label class="col-xs-12 col-sm-6">
			{{sybaseRestore.serverStatus}}
		</label>
		<label class="col-xs-12 col-sm-2">
			<a href="" data-ng-click="sybaseRestore.refreshServerStatus()">
				<span class="glyphicon glyphicon-refresh pull-right"
						title='<cv:msg key="action.refresh" bundle="collections" />'>
				</span>
			</a>
		</label>
	</div>

	<div class="form-group">
		<div class="col-xs-12">
			<input type="checkbox" id="recoverDatabases" name="recoverDatabases" data-ng-model="sybaseRestore.restoreData.uiRecoverDatabase"/>
			<label for="recoverDatabases">
				<cv:msg key="label.RecoverDatabases" bundle="sybase" />
			</label>
		</div>
	</div>

	<cv-hardware-revert
		snap-backup-enabled="sybaseRestore.snapBackupEnabled"
		is-inplace-restore="sybaseRestore.restoreData.isInPlaceRestore"
		entity="sybaseRestore.entity"
		proxy-client="sybaseRestore.restoreData.proxyClient"
		hardware-revert="sybaseRestore.restoreData.hardwareRevert"
		label-class="'col-xs-12 col-sm-4'"
		select-class="'col-xs-12 col-sm-8'">
	</cv-hardware-revert>

	<cv-sybase-redirect-path-component data-ng-if="deviceList"
		data-ng-init="sybaseRedirectPaths.initData()">
	</cv-sybase-redirect-path-component>

	<div class="global-options remove-border-padding padding-top-10">
		<cv-alert-me selected="false" text="
			<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>">
		</cv-alert-me>
	</div>
</script>

<script type="text/ng-template"  id="destinationClientTemplate.html">
	<div data-ng-if="sybaseRestore.tabControls.getCurrentTabId() === '1'" class="form-group padding-top-20 margin-bottom-10">
		<label class="col-xs-12 col-sm-4" for="destinationClient">
			<cv:msg key="label.DestinationClient" bundle="saphana"/>
		</label>
		<div class="col-xs-12 col-sm-8">
			<cv-isteven-single-select id-name="destinationclient"
								input-model="sybaseRestore.restoreData.destinationClients"
								binding-model="sybaseRestore.restoreData.destinationClient"
								track-field="clientId"
								label="displayName"
								tick-property="selected"
								on-change="sybaseRestore.updateInstcesModel(sybaseRestore.restoreData.destinationClient.clientId)"
								place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
								help-text='<cv:msg key="error.DestinationClient" bundle="restore"/>'
								required = "true">
			</cv-isteven-single-select>
		</div>
	</div>
</script>

<div class="modal-header">
	<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
</div>
<form name="restoreForm" class="bootstrap-wrapper form-horizontal modal-margin" novalidate autocomplete="off" data-cv-submit="sybaseRestore.doRestore()">
		<div id="modern-tab" class="tab-3">
			<cv-tabset-component control='sybaseRestore.tabControls' default-tab="'owner'">
			<!-- TAB 1 : In place -->
			<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
				help-text='<cv:msg key="label.sybaseInPlaceHelp" bundle="sybase" />'
				data-ng-selected="sybaseRestore.onTabChanged()">
				  <div data-ng-if="sybaseRestore.tabControls.getCurrentTabId() === '0'" >
					<div class="form-group padding-top-20">
						<label class="col-xs-12 col-sm-4" for="destinationServer">
							<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
						</label>
						<label class="col-xs-12 col-sm-8 label-as-input">
							<a target="_blank" ng-href="#clientDetails/{{sybaseRestore.entity.clientId}}">{{sybaseRestore.entity.displayName}}</a>
						</label>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-sm-4" for="destinationInstance">
							<cv:msg key="label.destInstance" bundle="oracle"/>
						</label>
						<label class="col-xs-12 col-sm-8 label-as-input">
							<a target="_blank" ng-href="#databaseDetails/{{sybaseRestore.entity.instanceId}}">{{sybaseRestore.entity.instanceName}}</a>
						</label>
					</div>
				<div data-ng-include="'sybaseRestoreOptions.html'"> </div>
				</div>
			</cv-tab>
			<!-- TAB 2 : out of place -->
			<cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />'
				help-text='<cv:msg key="label.sybaseOutOfPlaceHelp" bundle="sybase" />'
				data-ng-selected="sybaseRestore.onTabChanged()">
				<div data-ng-if="sybaseRestore.tabControls.getCurrentTabId() === '1'" >
					<div data-ng-include="'destinationClientTemplate.html'"> </div>

					<div class="form-group">
	                    <label class="col-xs-12 col-sm-4" for="destinationDatabase">
	                        <cv:msg key="label.destinationInstance" bundle="saphana"/>
	                    </label>
	                    <div class="col-xs-12 col-sm-8">
							<cv-isteven-single-select id-name="destinationDatabase"
									input-model="sybaseRestore.restoreData.destinationInstances"
									binding-model="sybaseRestore.restoreData.destinationInstance"
									on-change="sybaseRestore.refreshServerStatus()"
									track-field="instanceId"
									label="instanceName"
									tick-property="selected"
									disable-property="disabled"
									place-holder='<cv:msg key="placeholder.DestinationDatabase" bundle="saphana"/>'
									help-text='<cv:msg key="error.DestinationInstance" bundle="restore"/>'
									data-ng-required = "sybaseRestore.restoreData.isOutOfPlaceRestore()">
							</cv-isteven-single-select>
	                    </div>
	                </div>

					<div data-ng-include="'sybaseRestoreOptions.html'"> </div>
				</div>
			</cv-tab>
			<!-- TAB 3 : Restore to disk -->
			<cv-tab tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
				help-text='<cv:msg key="label.RestoreToDiskHelp" bundle="sybase" />'
				data-ng-selected="sybaseRestore.onTabChanged()">
				<div data-ng-if="sybaseRestore.tabControls.getCurrentTabId() === '2'" >
					<cv-db-restore-to-disk-component
						db-restore-to-disk-data="sybaseRestore.restoreData"
						entity="sybaseRestore.entity">
					</cv-db-restore-to-disk-component>
				</div>
			</cv-tab>
			</cv-tabset-component>
		</div>
		<div class="modal-footer">
			<button id="sybaseRestoreOptionsModal_button_#2461" class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				type="button" data-ng-click="sybaseRestore.closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sybaseRestoreOptionsModal_button_#9659" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="Submit" bundle="messages" />
			</button>
		</div>
</form>