<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<div class="form-group" data-ng-if="deviceList">
				<uib-accordion close-others="false" class="text-left">
					<div uib-accordion-group data-is-open="sybaseRedirectPaths.openAccordian">
						<uib-accordion-heading>
						<cv:msg key="header.redirectOptions" bundle="sybase"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sybaseRedirectPaths.openAccordian, 'glyphicon-chevron-right': !sybaseRedirectPaths.openAccordian}"></i>
						</uib-accordion-heading>

						<div class="form-group">
							<label class="col-xs-12 col-sm-4"><cv:msg key="label.databaseDevices" bundle="sybase"/></label>
							<label class="col-xs-12 col-sm-1"></label>
							<label class="col-xs-12 col-sm-4"><cv:msg key="label.deviceDetails" bundle="sybase"/></label>
							<label class="col-xs-12 col-sm-3">
								<a title="Redirect" data-ng-click="sybaseRedirectPaths.showFindAndReplaceDialog()"><cv:msg key="label.findAndReplace" bundle="oracle"/></a>
							</label>
						</div>

						<div class="row">
							<div class="col-xs-12 col-sm-4">
								<div class="local-options padding-top-0">
									<ul class="vm-full-restore-list width-auto">
										<li data-ng-repeat="sqlDbDeviceItem in deviceList">
											<a class="btn" data-ng-click="sybaseRedirectPaths.displayDbRestoreOptions(sqlDbDeviceItem)" title="{{sqlDbDeviceItem.dbItem.databaseName}}"><b>{{sqlDbDeviceItem.dbItem.databaseName}}</b></a>
											<ul>
												<li data-ng-repeat="sybDevice in sqlDbDeviceItem.sybDevices">
													<a class="btn" data-ng-click="sybaseRedirectPaths.displaySqlDeviceRestoreOptions(sqlDbDeviceItem, sybDevice)" title="{{sybDevice.logName}}"
												data-ng-class="{'selected-value': (sybDevice.logName == sybaseRedirectPaths.selecteDeviceItem.logName) && (sqlDbDeviceItem.dbItem.databaseName == sybaseRedirectPaths.selecteDeviceDBItem.dbItem.databaseName)}">{{sybDevice.logName}}
											</a>
												</li>
											</ul>

										</li>
									</ul>
								</div>
							</div>
							<div class="col-xs-12 col-sm-1"></div>
							<div class="col-xs-12 col-sm-7" data-ng-if="sybaseRedirectPaths.selecteDeviceItem">
									<div class="form-group">
					                    <label class="col-xs-12 col-sm-4" for="databaseName">
					                        <cv:msg key="label.targetDB" bundle="sybase"/>
					                    </label>
					                    <div class="col-xs-12 col-sm-8" title="{{sybaseRedirectPaths.selecteDeviceDBItem.dbItem.targetDB}}">
					                        <input type="text" name="databaseName" id="databaseName" data-ng-model="sybaseRedirectPaths.selecteDeviceDBItem.dbItem.targetDB" required />
					                    </div>
					                </div>
					                <div class="form-group">
					                    <label class="col-xs-12 col-sm-4" for="logName">
					                        <cv:msg key="label.deviceName" bundle="sybase"/>
					                    </label>
					                    <div class="col-xs-12 col-sm-8" title="{{sybaseRedirectPaths.selecteDeviceItem.targetLogName}}">
					                        <input type="text" name="logName" id="logName" data-ng-model="sybaseRedirectPaths.selecteDeviceItem.targetLogName"
					                        	data-ng-change="sybaseRedirectPaths.updateDeviceNames()"/>
					                    </div>
					                </div>
					                <div class="form-group">
					                    <label class="col-xs-12 col-sm-4" for="physicalPath">
					                        <cv:msg key="label.physicalPath" bundle="sybase"/>
					                    </label>
					                    <div class="col-xs-12 col-sm-8" title="{{sybaseRedirectPaths.selecteDeviceItem.phyName}}">
					                         <input type="text" name="physicalPath" id="physicalPath" data-ng-model="sybaseRedirectPaths.selecteDeviceItem.phyName">
					                    </div>
					                </div>
					                <div class="form-group">
					                    <label class="col-xs-12 col-sm-4" for="deviceSize">
					                        <cv:msg key="label.deviceSize" bundle="sybase"/>
					                    </label>
					                    <div class="col-xs-12 col-sm-8" title="{{sybaseRedirectPaths.selecteDeviceItem.size | capacity}}">
					                         <input type="text" name="deviceSize" id="deviceSize" data-ng-model="sybaseRedirectPaths.selecteDeviceItem.size">
					                    </div>
					                </div>
							</div>
						</div>
					</div>
				</uib-accordion>
</div>
