<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.events"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-if="!editDialog">
		<cv:msg key="label.createSQLInstance" bundle="sqlserver" />
	</h1>
	<h1 data-ng-if="editDialog">
		<cv:msg key="label.editSQLServerInstance" bundle="sqlserver" />
	</h1>
</div>
<div data-ng-if="!editDialog"
	class="col-xs-12 col-sm-12 clouddb-info-banner margin-top-10">
	<a href="" data-ng-click="openCloudDbDialog()">
		<cv:msg key="label.clickToAddCloudDB" bundle="dbs" />
	</a>
</div>
<span class="server-message {{serverMessage.type}}"
	data-ng-bind="serverMessage.message"></span>
<div class="bootstrap-wrapper form-horizontal">
	<form name="addSqlServerForm"
		data-cv-submit="createSqlServerInstance()" novalidate
		autocomplete="off">
		<div class="modal-margin bootstrap-wrapper padding-bottom-0">
			<div class="form-group" data-ng-if="addInstance">
				<label class="col-xs-12 col-lg-5" for="hostName">
					<cv:msg key="label.clientName" bundle="clients" />
				</label>
				<div class="col-xs-12 col-lg-7"
					data-ng-disabled="editDialog || (clientSelection.selectedClients.length > 0 && !instanceLoaded)">
					<cv-client-picker
						selected-clients="clientSelection.selectedClients"
						exclude-pseudo-clients="true"
						valide-client-selection="clientSelection.valideClientSelection"
						selection-changed="clientSelection.selectionChanged(clientEntity)"
						app-id=81 select-none-by-default="true"></cv-client-picker>
					<span class="help-block"
						data-ng-if="cv.addSqlServerForm.getAttempted() && !clientSelection.valideClientSelection">
						<cv:msg key="option.clientName" bundle="clients" />
					</span>
				</div>
			</div>
			<div class="form-group" data-ng-disabled="!instanceLoaded">
				<label class="col-sm-5">
					<cv:msg key="label.sqlServerInstance" bundle="clients" />
				</label>
				<div class="col-sm-7">
					<label data-ng-if="editDialog"
						data-ng-bind="sqlserverInfo.instanceName"></label>
					<span data-ng-if="!editDialog">
						<cv-editable-select cv-model="servers.selectedUnconfiguredServer"
							dropdown-options="unconfiguredServers"
							dropdown-item-label="servername" on-change="clearServerMessage()"
							dropdown-place-holder="<cv:msg key="label.selectInstance" bundle="sqlserver"/>">
						</cv-editable-select>
					</span>
					<span class="help-block" data-ng-if="inputAlertFlags.instanceName">
						<cv:msg key="error.instanceName" bundle="sqlserver" />
					</span>
				</div>
			</div>

			<div class="form-group margin-bottom-20">
				<label class="col-sm-5 margin-top-10" for="plan">
					<cv:msg key="label.profile" bundle="profiles" />
				</label>
				<div class="col-sm-7" data-ng-disabled="!profileList">
					<cv-plan-summary-dropdown input-model="profileList"
						id="sqlcreateInstance_planSummarySelection"
						output-model="selectedProfileList" item-label="'name'"
						button-label="'name'" tick-property="'selected'"
						translation="localLang" group-property="'msGroup'"
						helper-elements="'filter'" selection-mode="'single'"
						on-close="planChanged()"> </cv-plan-summary-dropdown>

					<span class="help-block"
						data-ng-if="inputAlertFlags.plan">
						<cv:msg key="placeholder.selectPlan" bundle="profiles" />
					</span>
				</div>
			</div>
		</div>

		<uib-accordion close-others="false" class="text-left">
		<div uib-accordion-group is-open="openAccordion"
			class="panel form-panel-holder" data-scroll-to-when-open>

			<uib-accordion-heading> <cv-help-text
				help-label="<cv:msg key="label.sqlServerAccount" bundle="sqlserver" />"
				help-text="'<cv:msg key="info.sqlServerAccount" bundle="sqlserver" />'"></cv-help-text>
			<i class="float-right glyphicon"
				data-ng-class="{'glyphicon-chevron-down': openAccordion, 'glyphicon-chevron-right': !openAccordion}"></i>
			</uib-accordion-heading>

			<div class="form-group"
				data-ng-click="sqlserverInfo.overrideGlobalAuthentication = !sqlserverInfo.overrideGlobalAuthentication">
				<div class="col-xs-12 col-md-5 col-lg-12">
					<toggle-control id="toggle"
						status="sqlserverInfo.overrideGlobalAuthentication ? 'enabled-activity' : 'disabled-activity'"></toggle-control>
					&nbsp;
					<cv:msg key="label.overrideHigherLevelsSettings" bundle="sqlserver" />
				</div>
			</div>

			<div class="form-group"
				data-ng-if="sqlserverInfo.overrideGlobalAuthentication">
				<span class="col-sm-5">
					<label class="radio">
						<input type="radio" id="uselocalSystemAccount"
							name="uselocalSystemUser" value="1" class="localAccount"
							data-ng-model="sqlserverInfo.useLocalSystemAccount">
						<cv:msg key="label.useLocalSystemAccount" bundle="sqlserver" />
					</label>
				</span>
				<span class="col-sm-7">
					<label class="radio">
						<input type="radio" id="uselocalSystemAccountImp"
							name="uselocalSystemUser" value="2" class="localAccount"
							data-ng-model="sqlserverInfo.useLocalSystemAccount">
						<cv:msg key="label.impersonateUser" bundle="sqlserver" />
					</label>
				</span>
			</div>
			<div class="panel-body">
				<div class="form-group"
					data-ng-if="sqlserverInfo.overrideGlobalAuthentication && sqlserverInfo.useLocalSystemAccount == '2'">
					<label class="col-sm-5">
						<cv:msg key="label.userName" bundle="servers" />
					</label>
					<span class="col-sm-7">
						<input type="text" name="username"
							data-ng-model="sqlserverInfo.username"
							data-ng-change="userNameChanged()"
							data-ng-required="!sqlserverInfo.useLocalSystemAccount == '1'" />
						<span class="help-block" data-ng-if="inputAlertFlags.username">
							<cv:msg key="error.userName" bundle="users" />
						</span>
					</span>
				</div>
				<div class="form-group"
					data-ng-if="sqlserverInfo.overrideGlobalAuthentication && sqlserverInfo.useLocalSystemAccount == '2'">
					<label class="col-sm-5">
						<cv:msg key="label.password" bundle="servers" />
					</label>
					<span class="col-sm-7">
						<input type="password" name="password"
							data-ng-model="sqlserverInfo.password"
							data-ng-change="passwordChanged()"
							placeholder="{{passwordPlaceholder}}"
							data-ng-required="!sqlserverInfo.useLocalSystemAccount == '1'" />
						<span class="help-block" data-ng-if="inputAlertFlags.password">
							<cv:msg key="error.password" bundle="users" />
						</span>
					</span>
				</div>
			</div>
			</div>
		</uib-accordion>

		<div class="form-group" data-ng-if="isAzure || isAmazon">
			<label class="col-xs-12 col-sm-12">
				<cv:msg key="title.connectionDetails" bundle="cloudStorageApp" />
			</label>
		</div>
		<div class="form-group" data-ng-if="isAmazon">
			<label class="col-xs-12 col-sm-5 padding-left-30" for="s3BucketName">
				<cv:msg key="label.s3bucketName" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-md-7">
				<input type="text" id="s3BucketName" name="s3BucketName"
					data-ng-required="true" data-ng-model="sqlserverInfo.s3BucketName" />
				<span class="help-block"
					data-ng-if="cv.addSqlServerForm.needsAttention(addSqlServerForm.s3BucketName);">
					<cv:msg key="error.s3bucketName" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="form-group " data-ng-if="isAzure">
			<label class="col-xs-12 col-sm-5 padding-left-30"
				for="azureStorageConnectionString">
				<cv:msg key="label.azureStorageConnectionString" bundle="sqlserver" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<textarea class="textarea" id="azureStorageConnectionString"
					name="azureStorageConnectionString" data-ng-required="true"
					data-ng-model="sqlserverInfo.azureStorageConnectionString"
					data-ng-change="inputAlertFlags.azureStorageConnectionString = !sqlserverInfo.azureStorageConnectionString || sqlserverInfo.azureStorageConnectionString.length <= 0"></textarea>
				<span class="help-block"
					data-ng-if="inputAlertFlags.azureStorageConnectionString">
					<cv:msg key="error.azureStorageConnectionString" bundle="sqlserver" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="isAzure || isAmazon">
			<label class="col-xs-12 col-sm-5 padding-left-30" for="cloudUserName">
				<cv:msg key="label.userName" bundle="servers" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="text" id="cloudUserName" name="cloudUserName" required
					data-ng-model="sqlserverInfo.cloudUserName" />
				<span class="help-block"
					data-ng-if="cv.addSqlServerForm.needsAttention(addSqlServerForm.cloudUserName);">
					<cv:msg key="error.userName" bundle="users" />
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="isAzure || isAmazon">
			<label class="col-xs-12 col-sm-5 padding-left-30" for="cloudPassword">
				<cv:msg key="label.password" bundle="servers" />
			</label>
			<div class="col-xs-12 col-sm-7">
				<input type="password" id="cloudPassword" name="cloudPassword"
					data-ng-required="true" autocomplete="new-password"
					data-ng-model="sqlserverInfo.cloudPassword"
					placeholder="{{passwordPlaceholder}}"
					data-ng-required="!editDialog" />
				<span class="help-block"
					data-ng-if="cv.addSqlServerForm.needsAttention(addSqlServerForm.cloudPassword);">
					<cv:msg key="error.password" bundle="users" />
				</span>
			</div>
		</div>

		<div class="modal-footer">
			<button id="sqlCreateInstance_button_#1211" type="button"
				class="btn btn-default cvBusyOnAjax setup-btn--hidden"
				data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sqlCreateInstance_button_#7895" type="submit"
				class="btn btn-primary cvBusyOnAjax"
				data-ng-disabled="(editDialog && !sqlserverInfo.instanceName) || (!editDialog && !servers.selectedUnconfiguredServer.servername)">
				<cv:msg key="Add" bundle="messages" />
			</button>
		</div>
	</form>
</div>