<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content backup-options">
	<!-- <p class="setupInfo"><fmt:message key="label.setupInfo" /></p> -->
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<form name="backupForm" data-cv-submit="startBackup()" >
	<span data-ng-show="!backupMsg">
		<div class="global-options remove-border-padding">
			<label><cv:msg key="label.backupLevel" bundle="servers"/></label>
		</div>
		<div class="global-options remove-border-padding form-panel-holder">
			<label class="element-indent-class">
				<input type="radio" ng-model="backupType" value="FULL">
				<cv:msg key="option.full" bundle="schedule" />
			</label>
			<label class="element-indent-class" data-ng-show=showTransactionLogOption>
				<input type="radio" ng-model="backupType" value="TRANSACTION_LOG">
				<cv:msg key="option.transactionlog" bundle="schedule" />
			</label>
			<label class="element-indent-class" data-ng-show=showDifferentialOption>
				<input type="radio" ng-model="backupType" value="DIFFERENTIAL">
				<cv:msg key="option.differential" bundle="schedule" />
			</label>

			<label class="element-indent-class" data-ng-show="isSyntheticFullSupported">
				<input type="radio" ng-model="backupType" value="SYNTHETIC_FULL">
				<cv:msg key="option.synthfull" bundle="schedule"/>
			</label>
		</div>
	</span>
	<div class="button-container">
		<button id="sqlBackupOptions_button_#0813" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button>
		<button id="sqlBackupOptions_button_#2762" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button>
		<button id="sqlBackupOptions_button_#5515" type="submit" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" ><cv:msg key="OK" bundle="messages"/></button>
	</div>
	</form>
</div>