<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
 		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
 		<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 data-ng-hide="editDialog"><cv:msg key="action.CreateInstance" bundle="saphana" /> </h1>
	<h1 data-ng-show="editDialog"><cv:msg key="action.EditInstance" bundle="saphana" /> </h1>
</div>
<div class="setup-content" data-ng-init="loadData()">	
			<!-- Code to show error color on invalid input -->		
			<style>
			input.ng-invalid.ng-dirty {
				background-color: #FFDFFF
			}
			</style>
			
<span class="{{serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
	<section>
		<form name="addHanaServer" novalidate autocomplete="off">
<fmt:bundle basename="localization.saphana"> 
						
						<label for="databaseName"><fmt:message key="label.DatabaseName"/>
						 <input type="text" data-ng-required=true name="databaseName" data-ng-model="instance.instanceName"
							placeholder="<fmt:message key="placeholder.DatabaseName"/>" data-ng-change="inputAlertFlags.databaseName=false;inputAlertFlags.duplicateDatabaseName=false"/>
						<span class="help-block" data-ng-show="inputAlertFlags.databaseName"><fmt:message key="error.DatabaseName" /></span>
						<span class="help-block" data-ng-show="inputAlertFlags.duplicateDatabaseName"><cv:msg key="error.duplicateInstanceName" bundle="sqlserver"/></span>
						</label>
						
						<label for="databaseNumber"><fmt:message key="label.DatabaseNumber"/>
						 <input type="text" data-ng-required name="databaseNumber" data-ng-model="instanceDetails.saphanaInstance.dbInstanceNumber"
						 	placeholder="<fmt:message key="placeholder.DatabaseNumber"/>" data-ng-change="inputAlertFlags.databaseNumber=false"/>
						<span class="help-block" data-ng-show="inputAlertFlags.databaseNumber"><fmt:message key="error.DatabaseNumber" /></span>
						</label>
						
						<label for="osUsername"><fmt:message key="label.OsUsername"/>
						 <input type="text" data-ng-required name="osUsername" data-ng-model="instanceDetails.saphanaInstance.SAPHANAUser.userName"
							placeholder="<fmt:message key="placeholder.OsUsername"/>" data-ng-change="inputAlertFlags.osUsername=false"/>
						<span class="help-block" data-ng-show="inputAlertFlags.osUsername"><fmt:message key="error.OsUsername" /></span>
						</label>
						
						<label for="primaryHanaServer" class="select-label"><fmt:message key="label.PrimaryHanaServer"/>
						<select id="primaryHanaServer" name="primaryHanaServer"  data-ng-model="primaryServer.clientId" 
									data-ng-change="inputAlertFlags.primaryHanaServer=false" data-ng-options="sp.clientId as sp.clientName for sp in databaseInstances | orderBy:'clientName'">
							<option value=""><fmt:message key="placeholder.PrimaryHanaServer"/></option>
						</select>
						<span class="help-block" data-ng-show="inputAlertFlags.primaryHanaServer"><fmt:message key="error.PrimaryHanaServer" /></span>
						</label>
						<label for="hdbSqlLocation"><fmt:message key="label.HdbSqlLocation"/>
						 <input type="text" data-ng-required name="hdbSqlLocation" data-ng-model="instanceDetails.saphanaInstance.hdbsqlLocationDirectory"
							placeholder="<fmt:message key="placeholder.HdbSqlLocation"/>" data-ng-change="inputAlertFlags.hdbSqlLocation=false"/>
						<span class="help-block" data-ng-show="inputAlertFlags.hdbSqlLocation"><fmt:message key="error.HdbSqlLocation" /></span>
						</label>
						
						
						<label>
							<div class="setup-content backup-options remove-border-padding"	style="padding: 0px;">
								<input type="radio" data-ng-value="true" data-ng-model="instanceDetails.saphanaInstance.isUsehdbStoreKey" data-ng-change="inputAlertFlags.dbUsername=false;inputAlertFlags.dbPassword=false">
								<fmt:message key="label.HdbStorekey" />
								<input style="float: right; width: 60%; line-height: 1.4;"
									type="text" name="hdbStorekey" data-ng-model="instanceDetails.saphanaInstance.hdbuserstorekey"
									placeholder="<fmt:message key="placeholder.HdbStorekey"/>"
									data-ng-disabled="!instanceDetails.saphanaInstance.isUsehdbStoreKey"
									data-ng-required="instanceDetails.saphanaInstance.isUsehdbStoreKey" 
									data-ng-change="inputAlertFlags.hdbStorekey=false"/>
							</div>
							<span class="help-block" data-ng-show="inputAlertFlags.hdbStorekey"><fmt:message key="error.HdbStorekey" /></span>
						</label>
						
						<label>
							<div class="setup-content backup-options remove-border-padding" style="padding: 0px;">
								<input type="radio" ng-value="false" data-ng-model="instanceDetails.saphanaInstance.isUsehdbStoreKey" data-ng-change="inputAlertFlags.hdbStorekey=false">
								<fmt:message key="label.DbUsername" />
								<input type="text" style="float: right; width: 60%; line-height: 1.4;"
									name="dbUsername" data-ng-model="instanceDetails.saphanaInstance.dbUser.userName" placeholder="<fmt:message key="placeholder.DbUsername"/>"
									data-ng-required="!instanceDetails.saphanaInstance.isUsehdbStoreKey" data-ng-disabled="instanceDetails.saphanaInstance.isUsehdbStoreKey" 
									data-ng-change="inputAlertFlags.dbUsername=false"/>
							</div>
							<span class="help-block" data-ng-show="inputAlertFlags.dbUsername"><fmt:message key="error.DbUsername" /></span>
						</label>
						
						<label for="dbPassword"><span style="padding-left: 20px;"><fmt:message key="label.DbPassword"/></span>
						 <input type="password" name="dbPassword" data-ng-model="instanceDetails.saphanaInstance.dbUser.password" data-ng-required="!instanceDetails.saphanaInstance.isUsehdbStoreKey"
							placeholder="<fmt:message key="placeholder.DbPassword"/>" data-ng-change="inputAlertFlags.dbPassword=false" data-ng-disabled="instanceDetails.saphanaInstance.isUsehdbStoreKey"/>
						<span class="help-block" data-ng-show="inputAlertFlags.dbPassword"><fmt:message key="error.DbPassword" /></span>
						</label>
					
		<div class="button-container" >
			<button id="saphanaCreateInstance_button_#5844" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="saphanaCreateInstance_button_#7616" type="submit" data-ng-show="operationType!=OPERATION_TYPE.EDIT_INSTANCE" class="btn btn-primary cvBusyOnAjax"  data-ng-click="submitData()"><cv:msg key="Add" bundle="messages" /></button> 
			<button id="saphanaCreateInstance_button_#2623" type="submit" data-ng-show="operationType==OPERATION_TYPE.EDIT_INSTANCE" class="btn btn-primary cvBusyOnAjax"  data-ng-click="submitData()" ng-clock><cv:msg key="Save" bundle="messages" /></button> 
		</div>
		</fmt:bundle>
		</form>
	</section>
</div>
