<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 data-ng-show="!sapOInst.isEdit"><cv:msg key="label.createSapOInstance" bundle="oracle"/> </h1>
		<h1 data-ng-show="sapOInst.isEdit"><cv:msg key="pageHeader.editServer" bundle="oracle"/> </h1>
	</div>
	<form name="sapOInstanceForm" class="form-horizontal" novalidate data-cv-submit="sapOInst.submit()" autocomplete="off">
		<span class="{{sapOInst.serverMessage.type}}" data-ng-bind="sapOInst.serverMessage.message"></span>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" >
					<label class="col-xs-12 col-lg-5" for="hostName">
						<cv:msg key="label.clientName" bundle="clients"/>
					</label>
					<div class="col-xs-12 col-lg-7" data-ng-if="!sapOInst.isEdit">
						<cv-client-picker select-none-by-default="true" selected-clients="sapOInst.selectedClients" valide-client-selection="sapOInst.validClientSelection" selection-changed="sapOInst.clientSelectionChanged(clientEntity)" app-id="{{sapOInst.AppTypes.SAP_FOR_ORACLE}}"  ></cv-client-picker>
						<span class="help-block" data-ng-show="cv.sapOInstanceForm.getAttempted() && !sapOInst.validClientSelection" >
							<cv:msg key="option.clientName" bundle="clients"/>
						</span>
					</div>
					<label class="col-xs-12 col-sm-7 label-as-input" data-ng-if="sapOInst.isEdit">
						{{sapOInst.entity.clientName}}
					</label>
				</div>


				<div data-ng-show="sapOInst.entity.clientName">
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="instanceName">
						<cv:msg key="label.oracleSid" bundle="oracle"/>
					</label>
					<div class="col-xs-12 col-lg-7">
						<input type="text" id="instanceName" name="instanceName"
							data-ng-model="sapOInst.model.instanceName" required/>
						<span class="help-block" data-ng-show="cv.sapOInstanceForm.needsAttention(sapOInstanceForm.instanceName)" >
							<cv:msg key="error.oracleSid" bundle="oracle"/>
						</span>
					</div>
				</div>

				<cv-entity-plan-policy-select data-cv-model="sapOInst.planPolicyModel"
					data-cv-app-id="sapOInst.AppTypes.SAP_FOR_ORACLE" data-cv-client-id="'0'" data-cv-wrapper-class="'form-group'"
					no-bootstrap-wrapper-class="true"
					data-cv-label-class="'col-xs-12 col-sm-5'" data-cv-select-class="'col-xs-12 col-sm-7'"
					submit-attempted="sapOInst.submitAttempted"
					required-field="!sapOInst.savedPlanId"
					cv-hide-policy-toggle-option="true">
				</cv-entity-plan-policy-select>



				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="oracleHome">
						<cv:msg key="label.oracleHome" bundle="oracle"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="oracleHome" name="oracleHome" data-ng-required="true" data-ng-model="sapOInst.model.oracleHome"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{sapOInst.entity.clientId}}' result-function="oraHomeResultFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.sapOInstanceForm.needsAttention(sapOInstanceForm.oracleHome);" >
							<cv:msg key="error.oracleHome" bundle="oracle"/>
						</span>
					</div>
				</div>


				<div class="form-group">
					<label class="col-xs-12 col-lg-12" >
						<cv:msg key="label.ConnectionString" bundle="oracle" />
					</label>
				</div>
				<div class="form-group connection-string">
					<input id="dbUserName" name="dbUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>' data-ng-model="sapOInst.model.userName" data-ng-change="sapOInst.validateConnectString()">
					<label for="dbPassword" > / </label>
					<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>' data-ng-model="sapOInst.model.password" data-ng-change="sapOInst.validateConnectString()">
					<label for="dbPassword"> @ </label>
					<input id="dbInstanceName" name="dbInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>' data-ng-model="sapOInst.model.domainName" data-ng-change="sapOInst.validateConnectString()">
					<span class="help-block ng-hide" data-ng-show="cv.sapOInstanceForm.getAttempted() &&  !sapOInst.isConnectValidate">
						<cv:msg key="error.connectString" bundle="oracle"/>
					</span>
				</div>

				<div class="form-group" >
					<div class="col-xs-12">
						<toggle-control status="sapOInst.model.useSapSecureStore" data-ng-click="sapOInst.model.useSapSecureStore = !sapOInst.model.useSapSecureStore"></toggle-control>
						<label><cv:msg key='label.useSapSecureStore' bundle='oracle'/></label>
					</div>
				</div>

				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="sapDataHome">
						<cv:msg key="label.sapDataHome" bundle="oracle"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="sapDataHome" name="sapDataHome" data-ng-required="true" data-ng-model="sapOInst.model.sapDataHome"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{sapOInst.entity.clientId}}' result-function="sapDataHomeResultFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.sapOInstanceForm.needsAttention(sapOInstanceForm.sapDataHome);" >
							<cv:msg key="error.sapDataHome" bundle="oracle"/>
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-5" for="sapExePath">
						<cv:msg key="label.sapExePath" bundle="oracle"/>
					</label>
					<div  class="col-xs-12 col-lg-7">
						<div class="input-group">
							<input type="text" id="sapExePath" name="sapExePath" data-ng-required="true" data-ng-model="sapOInst.model.sapExePath"/>
							<span class="input-group-btn">
								<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{sapOInst.entity.clientId}}' result-function="sapExePathResultFunction"/>
							</span>
						</div>
						<span class="help-block" data-ng-show="cv.sapOInstanceForm.needsAttention(sapOInstanceForm.sapExePath);" >
							<cv:msg key="error.sapExePath" bundle="oracle"/>
						</span>
					</div>
				</div>
				<uib-accordion  data-ng-if="!sapOInst.isUnixClient" close-others="true" class="text-left" data-ng-init="sapOInst.accordionOpen = (sapOInst.model.osUserName || sapOInst.model.osUserPassword)">
					<div uib-accordion-group data-is-open="sapOInst.accordionOpen">
						<uib-accordion-heading>
						<cv:msg key="label.advanced" bundle="clients"/>
						<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': sapOInst.accordionOpen, 'glyphicon-chevron-right': !sapOInst.accordionOpen}"></i>
						</uib-accordion-heading>
						<div class="form-group">
							<label class="col-xs-12 col-lg-5" for="osUserName">
								<cv:msg key="label.osUserName" bundle="oracle"/>
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
							</label>
							<div class="col-xs-12 col-lg-7">
								<input type="text" id="osUserName" name="osUserName" data-ng-model="sapOInst.model.osUserName" />
							</div>
						</div>
						<div class="form-group" >
							<label class="col-xs-12 col-lg-5" for="osUserPassword">
								<cv:msg key="label.osPassword" bundle="oracle"/>
								<span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
							</label>
							<div class="col-xs-12 col-lg-7">
								<input type="password" id="osUserPassword" name="osUserPassword" data-ng-model="sapOInst.model.osUserPassword" />
							</div>
						</div>
				    </div>
				</uib-accordion>
				</div>
			</div>
		</div>
		<div class="modal-footer">
	  		<button id="sapOInstanceForm_cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="sapOInst.cancel()">
	  			<cv:msg key="Cancel" bundle="messages"/>
  			</button>
	  		<button id="sapOInstanceForm_submit" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="sapOInst.submitAttempted = true;">
	  			<span data-ng-show="!sapOInst.isEdit" > <cv:msg key="Add" bundle="messages"/> </span>
	  			<span data-ng-show="sapOInst.isEdit" > <cv:msg key="Save" bundle="messages"/> </span>
	  		</button>
		</div>
	</form>
</div>

