<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
<div data-ng-init="rightGrid=['col-xs-12', 'col-lg-7']"></div>
<div class="bootstrap-wrapper">
	<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2': racCD.isPage}">

		<form name="racCreateDatabase" novalidate class="form-horizontal" autocomplete="off" data-cv-submit="racCD.submit()">
				<div data-ng-class="{'page-header': racCD.isPage, 'modal-header':!racCD.isPage}">
							<h1 data-ng-hide="racCD.isEdit"><cv:msg key="pageHeader.createRacServer" bundle="oracle"/></h1>
							<h1 data-ng-show="racCD.isEdit"><cv:msg key="pageHeader.editServer" bundle="oracle"/> </h1>
				</div>
				<span class="serverMessage {{racCD.serverMessage.type}}" data-ng-bind="racCD.serverMessage.message"></span>

				<div class="panel">
					<div class="panel-body">

						<div class="form-group" data-ng-if="racCD.clientCreationDone || !racCD.entity.clientId" data-ng-disabled="racCD.entity.clientId">
							<div class="col-xs-12">
								<toggle-control status="racCD.model.newServer==true?'enabled-activity':'disabled-activity'"
		              				data-ng-click="racCD.model.newServer = !racCD.model.newServer"
		              				data-title="<cv:msg key="label.createARacCluster" bundle="oracle"/>">
		           				</toggle-control>
								<label for="newServer">
									<cv:msg key="label.createARacCluster" bundle="oracle"/>
								</label>
							</div>
						</div>

						<div class="form-group" data-ng-if="racCD.clientCreationDone || !racCD.entity.clientId" data-ng-disabled="racCD.entity.clientId">
							<label data-ng-class="leftGrid" for="hostName">
								<cv:msg key="label.racClusterName" bundle="oracle"/>
							</label>
							<div data-ng-if="!racCD.model.newServer" data-ng-class="rightGrid"  >
								<cv-client-picker nothing-selected-loc-key="label.selectClusterName" select-none-by-default="true" selected-clients="racCD.clientSelection.selectedClients" valide-client-selection="racCD.clientSelection.valideClientSelection" selection-changed="racCD.clientSelection.selectionChanged(clientEntity)" app-id="80"  ></cv-client-picker>
								<span class="help-block" data-ng-show="cv.racCreateDatabase.getAttempted() && !racCD.clientSelection.valideClientSelection" >
									<cv:msg key="label.selectClusterName" bundle="oracle"/>
								</span>
							</div>
							<div data-ng-if="racCD.model.newServer" data-ng-class="rightGrid">
								<input name="newServerName" type="text" data-ng-model="racCD.model.newServerName" required data-ng-blur="racCD.isClientSelectionValide()"/>
								<span class="help-block" data-ng-show="cv.racCreateDatabase.needsAttention(racCreateDatabase.newServerName) || racCD.showServerNameError" >
									<span data-ng-hide="racCD.showServerNameError"> <cv:msg key="error.dbServerName" bundle="dbs" /> </span>
									<span data-ng-show="racCD.showServerNameError" data-ng-bind="racCD.showServerNameMesage"></span>
								</span>
							</div>
						</div>

						<div class="form-group">
							<label data-ng-class="leftGrid" for="instanceName">
								<cv:msg key="label.dbName" bundle="oracle"/>
							</label>
							<div data-ng-class="rightGrid" >
								<input type="text" id="instanceName" name="instanceName"
									data-ng-model="racCD.model.instanceName" required/>
								<span class="help-block" data-ng-show="cv.racCreateDatabase.needsAttention(racCreateDatabase.instanceName)" >
									<cv:msg key="error.dbName" bundle="oracle"/>
								</span>
							</div>
						</div>

						<div class="form-group" >

							<label data-ng-class="leftGrid" for="plan">
								<cv:msg key="label.profile" bundle="profiles"/>
							</label>

<%-- 							<div data-ng-class="rightGrid">
								<select id="plan" name="plan"
											data-ng-model="racCD.model.planId"
											data-ng-options="profile.planSummary.plan.planId as profile.planSummary.plan.planName for profile in racCD.profileList | orderBy: 'planSummary.plan.planName'"
											required>
											<option value=""><cv:msg key="placeholder.selectPlan" bundle="profiles"/></option>
								</select>
								<span class="help-block" data-ng-show="cv.racCreateDatabase.needsAttention(racCreateDatabase.plan)">
									<cv:msg key="error.selectPlan" bundle="profiles"/>
								</span>
							</div> --%>
							<div data-ng-class="rightGrid" data-ng-init="racCD.initAfterLocalization()">
								<isteven-multi-select id="racCreateDatabase_isteven-multi-select_#4818"
									input-model="racCD.profileList"
									output-model="racCD.model.selectedProfileList"
									button-label="name"
									item-label="name"
									translation="racCD.localLang"
									tick-property="selected"
									class="isteven-multi-select user-group-select"
									selection-mode="single"
									helper-elements="filter"
									on-close="racCD.parseIStevenOutput()"
									group-property="msGroup">
								</isteven-multi-select>
								<span class="help-block" data-ng-show="cv.racCreateDatabase.getAttempted() && racCD.showPlanError"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
							</div>
						</div>


						<%-- <div class="form-group">
							<div class="col-xs-12">
								<input id="useCatalog" name="useCatalog" type="checkbox" data-ng-model="racCD.model.useCatalog" >
								<label  for="useCatalog">
									<cv:msg key="label.useCatalog" bundle="oracle" />
								</label>
							</div>
						</div> --%>
						<div class="form-group" >
							<div class="col-xs-12">
								<toggle-control status=racCD.model.useCatalog true-property="1" data-ng-click="racCD.model.useCatalog = !racCD.model.useCatalog"></toggle-control>
								<!-- <input type="checkbox" name="showSelected" id="showSelected" data-ng-model="editSECtrl.enableSnapshot" /> -->
								<label><cv:msg key='label.useCatalog' bundle='oracle'/></label>
							</div>
						</div>

						<div class="form-group connection-string" data-ng-show="racCD.model.useCatalog">
								<input class="userName" id="catalogUserName" name="catalogUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>'
								data-ng-model="racCD.model.catalogConnect.userName" data-ng-change="racCD.validateCatalogString()">
							<label for="catalogPassword" >
								/
							</label>
								<input class="password" id="catalogPassword" name="catalogPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>'
								data-ng-model="racCD.model.catalogConnect.passwordTxt" data-ng-change="racCD.validateCatalogString()">
							<label for="catalogInstanceName">
								 @
							 </label>
								<input class="instance"  id="catalogInstanceName" name="catalogInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>'
								data-ng-model="racCD.model.catalogConnect.domainName" data-ng-change="racCD.validateCatalogString()">
							<span class="help-block" data-ng-show="racCD.isCatalogInvalidate">
								<cv:msg key="error.catalogConnect" bundle="oracle"/>
							</span>
						</div>
						<div class="form-group" data-ng-if="!racCD.isEdit">
							<div class="col-xs-12">
							    <cv-rac-manage-instances entity="racCD.entity" instances="racCD.racInstances">
							    </cv-rac-manage-instances>
							</div>
						</div>
						<div class="clearfix"></div>
					</div>
				</div>
				<div data-ng-class="{'text-right': racCD.isPage, 'modal-footer':!racCD.isPage}">
			  		<button id="racCreateDatabase_button_#3848" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="racCD.cancel()">
			  			<cv:msg key="Cancel" bundle="messages"/>
		  			</button>
			  		<button id="racCreateDatabase_button_#9850" type="submit" class="btn btn-primary cvBusyOnAjax" >
			  			<span> <cv:msg key="OK" bundle="messages"/> </span>
			  		</button>
				</div>
		</form>

	</div>
</div>

