<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
<div data-ng-init="rightGrid=['col-xs-12', 'col-lg-7']"></div>
<div class="bootstrap-wrapper">

		<form name="racAddInstance" class="form-horizontal" novalidate autocomplete="off" data-cv-submit="racAI.submit()">
				<div class="modal-header">
							<h1 data-ng-hide="racAI.isEdit"><cv:msg key="label.addRacInstance" bundle="oracle"/></h1>
							<h1 data-ng-show="racAI.isEdit"><cv:msg key="label.editRacInstance" bundle="oracle"/> </h1>
				</div>
				<span class="serverMessage {{racAI.serverMessage.type}}" data-ng-bind="racAI.serverMessage.message"></span>

			<div class="panel">
				<div class="panel-body">
					<div class="form-group">
						<label data-ng-class="leftGrid" for="hostName">
							<cv:msg key="label.clientName" bundle="clients"/>
						</label>
						<div data-ng-class="rightGrid" class="text-overflow-allowed" data-ng-disabled="racAI.isEdit">
							<div class="input-group" >
								<cv-client-picker select-none-by-default="true" default-client-id="{{racAI.clientSelection.defaultClientId}}" selected-clients="racAI.clientSelection.selectedClients" valide-client-selection="racAI.clientSelection.valideClientSelection" selection-changed="racAI.clientSelection.selectionChanged(clientEntity)" app-id="22"  exclude-pseudo-clients="true"></cv-client-picker>
								<span class="input-group-btn" >
									<a class="btn btn-ternary rounded-border-radius" data-ng-click="racAI.openAddNewHostDialog()" title="<cv:msg key="pageHeader.addServer" bundle="dbs"/>">
										<span class="k-icon k-i-plus font-size-page-title"> </span>
									</a>
								</span>
							</div>
							<span class="help-block" data-ng-show="cv.racAddInstance.getAttempted() && !racAI.clientSelection.valideClientSelection" >
								<cv:msg key="option.clientName" bundle="clients"/>
							</span>
						</div>
					</div>
					<div class="form-group">
						<label data-ng-class="leftGrid" for="hostName">
							<cv:msg key="label.oracleSid" bundle="oracle"/>
						</label>
						<div data-ng-class="rightGrid" data-ng-disabled="racAI.isEdit">
							<input type="text" id="instanceName" name="instanceName"
								data-ng-model="racAI.model.oracleSid" required/>
							<span class="help-block" data-ng-show="cv.racAddInstance.needsAttention(racAddInstance.instanceName);" >
								<cv:msg key="error.oracleSid" bundle="oracle"/>
							</span>
						</div>
					</div>
					<div class="form-group">
						<label data-ng-class="leftGrid" for="oracleHome">
							<cv:msg key="label.oracleHome" bundle="oracle"/>
						</label>
						<div  data-ng-class="rightGrid">
							<div class="input-group">
								<input type="text" id="oracleHome" name="oracleHome" data-ng-required="true" data-ng-model="racAI.model.oracleHome"/>
								<span class="input-group-btn">
									<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
										client-id='{{racAI.clientSelection.selectedClients[0].clientId}}' result-function="racAI.oraHomeResultFunction"/>
								</span>
							</div>
							<span class="help-block" data-ng-show="cv.racAddInstance.needsAttention(racAddInstance.oracleHome);" >
								<cv:msg key="error.oracleHome" bundle="oracle"/>
							</span>
						</div>
					</div>

					<div class="form-group">
						<label class="col-xs-12" >
							<cv:msg key="label.ConnectionString" bundle="oracle" />
						</label>
					</div>
					<div class="form-group connection-string">
						<input id="dbUserName" name="dbUserName" type="text" placeholder='<cv:msg key="label.userName" bundle="users"/>' data-ng-model="racAI.model.userName" data-ng-change="racAI.validateConnectString()">
						<label for="dbPassword" > / </label>
						<input id="dbPassword" name="dbPassword" type="password" placeholder='<cv:msg key="label.password" bundle="users"/>' data-ng-model="racAI.model.passwordTxt" data-ng-change="racAI.validateConnectString()">
						<label for="dbPassword"> @ </label>
						<input id="dbInstanceName" name="dbInstanceName" type="text" placeholder='<cv:msg key="label.serviceName" bundle="oracle"/>' data-ng-model="racAI.model.domainName" data-ng-change="racAI.validateConnectString()">
						<span class="help-block ng-hide" data-ng-show="racAI.isConnectInvalidate">
							<cv:msg key="error.connectString" bundle="oracle"/>
						</span>
					</div>


					</div>
				</div>

					<uib-accordion  close-others="true" class="text-left" data-ng-init="accordionOpen = (racAI.model.osUserName || racAI.model.osUserPassword || racAI.model.tnsAdminFolder)">
						<div uib-accordion-group data-is-open="accordionOpen">
							<uib-accordion-heading>
							<cv:msg key="label.otherSettings" bundle="clients"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionOpen, 'glyphicon-chevron-right': !accordionOpen}"></i>
							</uib-accordion-heading>
							<div class="form-group">
								<label data-ng-class="leftGrid" for="osUserName">
									<cv:msg key="label.osUserName" bundle="oracle"/>
								</label>
								<div data-ng-class="rightGrid">
									<input type="text" id="osUserName" name="osUserName"
									data-ng-model="racAI.model.osUserName" placeholder="<cv:msg key="label.optional" bundle="oracle"/>" />
									<span class="help-block" data-ng-show="cv.racAddInstance.needsAttention(racAddInstance.osUserName);" >
										<cv:msg key="error.osUserName" bundle="oracle"/>
									</span>
								</div>
							</div>
							<div class="form-group" data-ng-if="racAI.isUnixClient === false">
								<label data-ng-class="leftGrid" for="osUserPassword">
									<cv:msg key="label.osPassword" bundle="oracle"/>
								</label>
								<div data-ng-class="rightGrid">
									<input type="password" id="osUserPassword" name="osUserPassword"
									data-ng-model="racAI.model.osUserPassword" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
									<span class="help-block" data-ng-show="cv.racAddInstance.needsAttention(racAddInstance.osUserPassword);" >
										<cv:msg key="error.osUserPassword" bundle="oracle"/>
									</span>
								</div>
							</div>

							<div class="form-group">
								<label data-ng-class="leftGrid" for="tnsAdminFolder">
									<cv:msg key="label.tnsAdminFolder" bundle="oracle"/>

								</label>
								<div  data-ng-class="rightGrid">
									<div class="input-group">
										<input type="text" id="tnsAdminFolder" name="tnsAdminFolder" data-ng-model="racAI.model.tnsAdminFolder" placeholder="<cv:msg key="label.optional" bundle="oracle"/>"/>
										<span class="input-group-btn">
											<cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>'
												client-id='{{racAI.clientSelection.selectedClients[0].clientId}}' result-function="racAI.tnsAdminFolderResultFunction"/>
										</span>
									</div>
									<span class="help-block" data-ng-show="cv.racAddInstance.needsAttention(racAddInstance.tnsAdminFolder);" >
										<cv:msg key="error.tnsAdminFolder" bundle="oracle"/>
									</span>
								</div>
							</div>
					    </div>
					</uib-accordion>

				<div class="modal-footer">
			  		<button id="racAddInstance_button_#3324" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="racAI.cancel()">
			  			<cv:msg key="Cancel" bundle="messages"/>
		  			</button>
			  		<button id="racAddInstance_button_#0122" type="submit" class="btn btn-primary cvBusyOnAjax" >
			  			<span> <cv:msg key="OK" bundle="messages"/> </span>
			  		</button>
				</div>
		</form>

</div>

