<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="startServerTemplate.html">
	<div class="form-group" data-ng-if="pgRestore.restoreType > 0">
	    <div class="col-xs-12 col-sm-12">
	        <input type="checkbox" id="startServer" name="startServer" data-ng-model="pgRestore.restoreData.postgresRstOption.startServer"/>
	        <label for="startServer">
	            <cv:msg key="label.StartServer" bundle="postgres"/>
	        </label>
	    </div>
	</div>
</script>
<script type="text/ng-template"  id="destinationClientTemplate.html">
		<div class="form-group padding-top-20 margin-bottom-10">
              <label class="col-xs-12 col-sm-4" for="destinationClient">
                  <cv:msg key="label.DestinationClient" bundle="saphana"/>
              </label>
              <div class="col-xs-12 col-sm-8">
                  <!--<select id="destinationclient" name="destinationclient" data-ng-model="pgRestore.restoreData.destinationClient.clientId" data-ng-options="sp.clientId as sp.clientName for sp in pgRestore.restoreData.destinationClients|orderBy:'clientName'" data-ng-change="pgRestore.updateInstcesModel(pgRestore.restoreData.destinationClient.clientId)" data-ng-required="true">
                      <option value="">
                          <cv:msg key="placeholder.DestinationClient" bundle="saphana"/>
                      </option>
                  </select>
                  <span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationclient)">
                      <cv:msg key="error.DestinationClient" bundle="restore"/>
                  </span> -->
				 	<cv-isteven-single-select id-name="destinationclient"
								input-model="pgRestore.restoreData.destinationClients"
								binding-model="pgRestore.restoreData.destinationClient"
								track-field="clientId"
								label="displayName"
								tick-property="selected"
								on-change="pgRestore.updateInstcesModel(pgRestore.restoreData.destinationClient.clientId)"
								place-holder='<cv:msg key="placeholder.DestinationClient" bundle="saphana"/>'
								help-text='<cv:msg key="error.DestinationClient" bundle="restore"/>'
								required = "true">
					</cv-isteven-single-select>
              </div>
        </div>
</script>

<script type="text/ng-template"  id="snapTemplate.html">
	<cv-hardware-revert
		snap-backup-enabled="pgRestore.snapBackupEnabled"
		is-inplace-restore="pgRestore.restoreData.isInplaceRestore"
		entity="pgRestore.entity"
		proxy-client="pgRestore.restoreData.proxyClient"
		hardware-revert="pgRestore.restoreData.hardwareRevert"
		label-class="'col-xs-12 col-sm-4'"
		select-class="'col-xs-12 col-sm-8'">
	</cv-hardware-revert>
</script>

<div class="modal-header">
	<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
</div>
<form name="restoreForm" class="bootstrap-wrapper form-horizontal modal-margin" novalidate autocomplete="off" data-cv-submit="pgRestore.doRestore()">
    	<div id="modern-tab" class="{{pgRestore.tabStyle}}">
			<cv-tabset-component control='pgRestore.tabControls' default-tab="'owner'">
			<!-- TAB 1 : In place -->
			<cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />'
				help-text='<cv:msg key="label.postgreSQLInPlaceHelp" bundle="postgres" />'
				data-ng-selected="pgRestore.onTabChanged()">
					<div class="form-group padding-top-20">
						<label class="col-xs-12 col-sm-4" for="destinationServer">
							<cv:msg key="label.oracleVmDestinationServer" bundle="restore"/>
						</label>
						<label class="col-xs-12 col-sm-8 label-as-input">
							<a target="_blank" ng-href="#clientDetails/{{pgRestore.entity.clientId}}">{{pgRestore.entity.displayName}}</a>
						</label>
					</div>
					<div class="form-group">
						<label class="col-xs-12 col-sm-4" for="destinationInstance">
							<cv:msg key="label.destInstance" bundle="oracle"/>
						</label>
						<label class="col-xs-12 col-sm-8 label-as-input">
							<a target="_blank" ng-href="#databaseDetails/{{pgRestore.entity.instanceId}}">{{pgRestore.entity.instanceName}}</a>
						</label>
					</div>
				<div data-ng-include="'startServerTemplate.html'"> </div>
				<div data-ng-include="'snapTemplate.html'"> </div>
				<div class="global-options remove-border-padding padding-top-10">
				<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
			</cv-tab>
			<!-- TAB 2 : out of place -->
			<cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />'
				help-text='<cv:msg key="label.postgreSQLOutOfPlaceHelp" bundle="postgres" />'
				data-ng-selected="pgRestore.onTabChanged()">
					<div data-ng-include="'destinationClientTemplate.html'"> </div>
					<div class="form-group">
	                    <label class="col-xs-12 col-sm-4" for="destinationDatabase">
	                        <cv:msg key="label.destinationInstance" bundle="saphana"/>
	                    </label>
	                    <div class="col-xs-12 col-sm-8">
	                        <!-- <select id="destinationDatabase" name="destinationDatabase"
	                        	data-ng-model="pgRestore.restoreData.destinationInstance.instanceId"
	                        	data-ng-options="ins.instance.instanceId as ins.instance.instanceName disable when pgRestore.shouldDisableInstance(ins.instance.instanceId) for ins in pgRestore.restoreData.destinationInstances|orderBy:'instance.instanceName'"
	                        	data-ng-change="pgRestore.setInstanceInfo(pgRestore.restoreData.destinationInstance.instanceId)" data-ng-required="pgRestore.tabControls.getCurrentTabId() ===1"">
	                            <option value="">
	                                <cv:msg key="placeholder.DestinationDatabase" bundle="saphana"/>
	                            </option>
	                        </select>
	                        <span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.destinationDatabase)">
	                            <cv:msg key="error.DestinationInstance" bundle="restore"/>
	                        </span> -->
							<cv-isteven-single-select id-name="destinationDatabase"
									input-model="pgRestore.restoreData.destinationInstances"
									binding-model="pgRestore.restoreData.destinationInstance"
									track-field="instanceId"
									label="instanceName"
									tick-property="selected"
									disable-property="disabled"
									place-holder='<cv:msg key="placeholder.destinationInstance" bundle="saphana"/>'
									help-text='<cv:msg key="error.DestinationInstance" bundle="restore"/>'
									required = "pgRestore.tabControls.getCurrentTabId() ==1">
							</cv-isteven-single-select>
	                    </div>
	                </div>
					<div data-ng-include="'startServerTemplate.html'"> </div>
					<div data-ng-include="'snapTemplate.html'"> </div>
					<div class="global-options remove-border-padding padding-top-10"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
			</cv-tab>
			<!-- TAB 3 : Restore to disk -->
			<cv-tab tabname="<cv:msg key="label.rtdRestore" bundle="restore" />"
				help-text='<cv:msg key="label.restoreToDiskHelp" bundle="postgres" />'
				data-ng-selected="pgRestore.onTabChanged()" data-ng-if="pgRestore.isRestoreToDiskSupported">
				<div data-ng-include="'destinationClientTemplate.html'"> </div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-4">
						<label for="DestinationFolder"> <cv:msg key="label.DestinationFolder" bundle="mySql" /></label>
					</div>
					<div class="col-xs-12 col-sm-8">
						<div class="input-group"
							title="{{pgRestore.restoreData.mySqlRstOption.temporaryStagingLocation}}">
							<input type="text" name="DestinationFolder" id="DestinationFolder"
								data-ng-model="pgRestore.restoreData.path"
								data-ng-required="pgRestore.tabControls.getCurrentTabId() ==2" />
							<span class="input-group-btn" data-ng-disabled="pgRestore.isDisableBrowse()"> <cv-machine-browse
									button-label='<cv:msg key="label.browse" bundle="restore"/>'
									client-id='{{pgRestore.restoreData.destinationClient.clientId}}'
									result-function="pgRestore.browseResultFunction" />
							</span>
						</div>
						<span class="help-block"
							data-ng-show="cv.restoreForm.needsAttention(restoreForm.DestinationFolder)">
							<cv:msg key="error.DestinationFolder" bundle="mySql" />
						</span>
					</div>
				</div>
				<div>
					<div class="form-group">
						<div class="col-xs-12">
							<toggle-control status="pgRestore.impersonateEnabledStatus" data-ng-click="pgRestore.toggleImpersonation()"></toggle-control>
							<label>	<cv:msg key='label.impersonateUser' bundle='restore'/>
								<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
							</label>
						</div>
					</div>
					<div class="panel-body padding-top-5" data-ng-if="pgRestore.restoreData.useImpersonation">
						<div class="form-group">
							<label class="col-xs-12 col-sm-4"><cv:msg key="label.username" bundle="restore" /> </label>
							<div class="col-xs-12 col-sm-8">
								<input type="text" name="impersonateUserName"
									data-ng-model="pgRestore.restoreData.impersonateUserName"
									data-ng-required="pgRestore.restoreData.useImpersonation" />
								<span class="help-block" data-ng-show="pgRestore.restoreData.useImpersonation && cv.restoreForm.needsAttention(restoreForm.impersonateUserName)">
									<cv:msg key="error.userNameRequired" bundle="restore" />
								</span>
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-sm-4"><cv:msg key="label.password" bundle="restore" /> </label>
							<div class="col-xs-12 col-sm-8">
								<input type="password" name="impersonatePassword"
									data-ng-model="pgRestore.restoreData.impersonatePassword"
									data-ng-required="pgRestore.restoreData.useImpersonation" />
								<span class="help-block" data-ng-show="pgRestore.restoreData.useImpersonation && cv.restoreForm.needsAttention(restoreForm.impersonatePassword)">
										<cv:msg key="error.uncPasswordRequired" bundle="restore" />
								</span>
							</div>
						</div>
					</div>
				</div>
				<div class="form-group">
                    <div class="col-xs-12">
                        <input type="checkbox" id="transactionLogs" name="transactionLogs" data-ng-model="pgRestore.restoreData.dbLogOnlyRestore"/>
                        <label for="transactionLogs">
                            <cv:msg key="label.transactionLogs"	bundle="postgres" />
                        </label>
                    </div>
               	</div>
			</cv-tab>
   		</cv-tabset-component>
		</div>
        <div class="modal-footer">
            <button id="postgresRestoreOptionsModal_button_#2419" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="pgRestore.closeModal()">
                <cv:msg key="Cancel" bundle="messages"/>
            </button>
            <button id="postgresRestoreOptionsModal_button_#7422" type="submit" class="btn btn-primary cvBusyOnAjax">
                <cv:msg key="Submit" bundle="messages"/>
            </button>
        </div>
</form>
