<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.postgres"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
	<div   data-ng-if="pgInstance.addInstance" class="col-xs-12 col-sm-12 clouddb-info-banner">
		<a  href="" data-ng-click="pgInstance.openCloudDbDialog()"><cv:msg key="label.clickToAddCloudDB" bundle="dbs" /></a>
	</div>

	<span class="{{pgInstance.serverMessage.type}}" data-ng-bind="pgInstance.serverMessage.message"></span>
	<form name="addPostgreSQLInstance" novalidate autocomplete="off" data-cv-submit="pgInstance.submitData()" data-cv-validate="pgInstance.validateInputs(addPostgreSQLInstance)">


	            	<div class="form-group margin-top-25" data-ng-if="pgInstance.addInstance">
						<label class="col-xs-12 col-sm-5" for="hostName">
							<cv:msg key="label.clientName" bundle="clients"/>
						</label>
						<div class="col-xs-12 col-sm-7 text-overflow-allowed" data-ng-disabled="apgInstance.editDialog">
							<cv-client-picker selected-clients="pgInstance.clientSelection.selectedClients" valide-client-selection="pgInstance.clientSelection.valideClientSelection" selection-changed="pgInstance.clientSelection.selectionChanged(clientEntity)"  app-id="125" exclude-pseudo-clients="true" ></cv-client-picker>
							<span class="help-block" data-ng-show="cv.addPostgreSQLInstance.getAttempted() && !pgInstance.clientSelection.valideClientSelection" >
								<cv:msg key="option.clientName" bundle="clients"/>
							</span>
						</div>
					</div>
	                <div class="form-group padding-bottom-10">
	                    <label class="col-xs-12 col-sm-5" for="databaseName">
	                        <cv:msg key="label.DatabaseName" bundle="saphana"/>
	                    </label>
	                    <div class="col-xs-12 col-sm-7">
	                        <input type="text" name="databaseName" data-ng-model="pgInstance.newInstanceName" data-ng-required="true"/>
	                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.databaseName)">
	                            <cv:msg key="error.instanceName" bundle="sqlserver"/>
	                        </span>
	                    </div>
	                </div>
               		<div class="form-group">
						<label class="col-xs-12 col-sm-5" for="plan">
							<cv:msg key="label.profile" bundle="profiles"/>
						</label>
						<div class="col-xs-12 col-sm-7" data-ng-if="pgInstance.profileList">
							<cv-plan-summary-dropdown
								id="planSummarySelection"
								input-model="pgInstance.profileList"
								output-model="pgInstance.selectedProfileList"
								item-label="'name'"
								button-label="'name'"
								tick-property="'selected'"
								translation="pgInstance.localLang"
								group-property="'msGroup'"
								helper-elements="'filter'"
								selection-mode="'single'"
								on-close="pgInstance.parseIStevenOutput()">
							</cv-plan-summary-dropdown>
							<span class="help-block" data-ng-show="cv.addPostgreSQLInstance.getAttempted() && pgInstance.showPlanError"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
						</div>
					</div>

					<uib-accordion close-others="false" class="text-left">
						<div uib-accordion-group data-is-open="pgInstance.openAccordian1">
							<uib-accordion-heading>
							<cv:msg key="title.connectionDetails" bundle="cloudStorageApp"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': pgInstance.openAccordian1, 'glyphicon-chevron-right': !pgInstance.openAccordian1}"></i>
							</uib-accordion-heading>
							<div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="dbUsername">
			                        <cv:msg key="label.hanaDBUsername" bundle="saphana"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="dbUsername" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.SAUser.userName" data-ng-required="true" />
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.dbUsername)">
			                            <cv:msg key="error.DbUsername" bundle="saphana"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="dbPassword">
			                        <cv:msg key="label.DbPassword" bundle="saphana"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="password" name="dbPassword" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.SAUser.password"
			                        placeholder='{{ pgInstance.edit ? "<cv:msg key="placeholder.editUserPassword" bundle="users" />" : "" }}'  data-ng-required="!pgInstance.edit" />
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.dbPassword)">
			                            <cv:msg key="error.DbPassword" bundle="saphana"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group" data-ng-if="pgInstance.isUnixClient">
			                    <label class="col-xs-12 col-sm-5" for="osUsername">
			                        <cv:msg key="label.UnixUsername" bundle="mySql"/>
			                        <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="osUsername" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.osUser.userName"/>
			                    </div>
			                </div>
					        <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="port">
			                        <cv:msg key="label.Port" bundle="postgres"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="port" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.port" data-ng-required="true"/>
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.port)">
			                            <cv:msg key="error.Port" bundle="postgres"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="maintenanceDB">
			                        <cv:msg key="label.MaintenanceDB" bundle="postgres"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <input type="text" name="maintenanceDB" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.MaintainenceDB" data-ng-required="true"/>
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.maintenanceDB)">
			                            <cv:msg key="error.MaintenanceDB" bundle="postgres"/>
			                        </span>
			                    </div>
			                </div>
						</div>
						<div uib-accordion-group data-is-open="pgInstance.openAccordian2">
							<uib-accordion-heading>
							<cv:msg key="label.paths" bundle="postgres"/>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': pgInstance.openAccordian2, 'glyphicon-chevron-right': !pgInstance.openAccordian2}"></i>
							</uib-accordion-heading>
							<div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="BinaryDirectory">
			                        <cv:msg key="label.BinaryDirectory" bundle="postgres"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{pgInstance.instanceDetails.postGreSQLInstance.BinaryDirectory}}">
			                            <input type="text" name="BinaryDirectory" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.BinaryDirectory" data-ng-required="true"/>
			                            <span class="input-group-btn">
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{pgInstance.instance.clientId}}' result-function="pgInstance.binBrowseResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.BinaryDirectory)">
			                            <cv:msg key="error.BinaryDirectory" bundle="postgres"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="LibDirectory">
			                        <cv:msg key="label.LibDirectory" bundle="postgres"/>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{pgInstance.instanceDetails.postGreSQLInstance.LibDirectory}}">
			                            <input type="text" name="LibDirectory" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.LibDirectory" data-ng-required="true"/>
			                            <span class="input-group-btn">
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{pgInstance.instance.clientId}}' result-function="pgInstance.libBrowseResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                        <span class="help-block" data-ng-show="cv.addPostgreSQLInstance.needsAttention(addPostgreSQLInstance.LibDirectory)">
			                            <cv:msg key="error.LibDirectory" bundle="postgres"/>
			                        </span>
			                    </div>
			                </div>
			                <div class="form-group">
			                    <label class="col-xs-12 col-sm-5" for="ArchiveLogDirectory">
			                        <cv:msg key="label.ArchiveLogDirectory" bundle="postgres"/>
			                        <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions" /></span>
			                    </label>
			                    <div class="col-xs-12 col-sm-7">
			                        <div class="input-group" title="{{pgInstance.instanceDetails.postGreSQLInstance.ArchiveLogDirectory}}">
			                            <input type="text" name="ArchiveLogDirectory" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.ArchiveLogDirectory" data-ng-required="false"/>
			                            <span class="input-group-btn" >
			                                <cv-machine-browse button-label='<cv:msg key="label.browse" bundle="restore"/>' client-id='{{pgInstance.instance.clientId}}' result-function="pgInstance.archiveBrowseResuleFunction" can-create-folder="false"/>
			                            </span>
			                        </div>
			                    </div>
			                </div>
	                	</div>
					</uib-accordion>
					<div class="form-group" data-ng-show="pgInstance.edit">
	                    <div class="col-xs-12">
	                        <input type="checkbox" id="archiveDelete" name="archiveDelete" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.ArchiveDelete"/>
	                        <label for="archiveDelete">
	                            <cv:msg key="label.ArchiveDelete" bundle="postgres"/>
	                        </label>
	                    </div>
	                </div>
	       			<!-- Standby Settings -->
					<div data-ng-show="pgInstance.isStandbySettingApplicable()">
						<div class="form-group">
							<div class="col-xs-12">
								<toggle-control status="pgInstance.standbyEnabledStatus" data-ng-click="pgInstance.toggleStandbyEnabledStatus()"></toggle-control>
								<label><cv:msg key='label.EnableStandbyBackup' bundle='postgres'/></label>
							</div>
						</div>
						<div class="panel-body" data-ng-if="pgInstance.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled">
							<div class="form-group">
								<label class="col-xs-12 col-sm-5" for="standbyInstance" data-ng-hide="!pgInstance.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled">
									<cv:msg key="label.standbyInstance" bundle="postgres" />
								</label>
								<div class="col-xs-12 col-sm-7" data-ng-init="pgInstance.initAfterLocalization1()">
									<isteven-multi-select id="postgresCreateInstance_isteven-multi-select_#3258"
										input-model="pgInstance.standbyInstances"
										output-model="pgInstance.selectedStandbyList"
										button-label="name"
										item-label="name"
										translation="pgInstance.localLang1"
										tick-property="selected"
										class="isteven-multi-select user-group-select"
										selection-mode="single"
										helper-elements="filter"
										on-close="pgInstance.parseIStevenOutput1()"
										group-property="msGroup">
									</isteven-multi-select>
									<span class="help-block" data-ng-show="cv.addPostgreSQLInstance.getAttempted() && pgInstance.instanceDetails.postGreSQLInstance.standbyOptions.isStandbyEnabled && pgInstance.showStandbyError"><cv:msg key="placeholder.ProxyInstance" bundle="mySql" /></span>
								</div>
							</div>
							<div class="form-group">
								<div class="col-xs-12">
									<input id="useMasterForDataBkp" class="" type="checkbox" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.standbyOptions.useMasterForDataBkp"
									/>
									<label for="useMasterForDataBkp"><cv:msg key="label.UseMasterForData" bundle="postgres" /></label>
								</div>
							</div>
							<div class="form-group">
								<div class="col-xs-12">
									<input id="useMasterForLogBkp" class="" type="checkbox" data-ng-model="pgInstance.instanceDetails.postGreSQLInstance.standbyOptions.useMasterForLogBkp"
									/>
									<label for="useMasterForLogBkp"><cv:msg key="label.UserMasterForLog" bundle="postgres" /></label>
								</div>
							</div>
						</div>
					</div>
	        <div class="modal-footer">
	            <button id="postgresCreateInstance_button_#7972" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="pgInstance.closeDialogBox()">
	                <cv:msg key="Cancel" bundle="messages"/>
	            </button>
	            <button id="postgresCreateInstance_button_#3589" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="!pgInstance.edit" >
	            	<cv:msg key="Add" bundle="messages" />
	            </button>
				<button id="postgresCreateInstance_button_#1178" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-show="pgInstance.edit" >
					<cv:msg key="Save" bundle="messages" />
				</button>
	        </div>
    </form>
